/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraEmailTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.matcher.MimeMessageMatchers;
import com.atlassian.jira.functest.rule.MailTest;
import com.atlassian.jira.permission.ProjectPermissions;
import java.io.IOException;
import java.util.Collection;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.EMAIL, Category.FIELDS})
@LoginAs(user="admin")
@MailTest
public class TestCustomFieldNotifications
extends BaseJiraEmailTest {
    private static final String ISSUE_COMMENT = "If it bleeds we can kill it!";
    private static final String SUBJECT = "[JIRATEST] (HSP-1) Dude";

    @Test
    @Restore(value="TestCustomFieldNotifications.xml")
    public void testCFNotifications() throws InterruptedException, MessagingException, IOException {
        this.navigation.userProfile().changeNotifyMyChanges(true);
        this.navigation.issue().addComment("HSP-1", ISSUE_COMMENT, null);
        Collection<MimeMessage> mails = this.mailHelper.flushMailQueueAndWait(6);
        Assert.assertThat(mails, (Matcher)Matchers.hasItem(this.addressSubjectContentMatcher("user@example.com", SUBJECT, ISSUE_COMMENT)));
        Assert.assertThat(mails, (Matcher)Matchers.hasItem(this.addressSubjectContentMatcher("multiuser@example.com", SUBJECT, ISSUE_COMMENT)));
        Assert.assertThat(mails, (Matcher)Matchers.hasItem(this.addressSubjectContentMatcher("singlegroup@example.com", SUBJECT, ISSUE_COMMENT)));
        Assert.assertThat(mails, (Matcher)Matchers.hasItem(this.addressSubjectContentMatcher("multigroup@example.com", SUBJECT, ISSUE_COMMENT)));
        Assert.assertThat(mails, (Matcher)Matchers.hasItem(this.addressSubjectContentMatcher("admin@example.com", SUBJECT, ISSUE_COMMENT)));
        Assert.assertThat(mails, (Matcher)Matchers.hasItem(this.addressSubjectContentMatcher("fred@example.com", SUBJECT, ISSUE_COMMENT)));
    }

    private Matcher<MimeMessage> addressSubjectContentMatcher(String address, String subject, String content) {
        return Matchers.allOf(MimeMessageMatchers.withRecipientEqualTo(address), MimeMessageMatchers.withSubjectEqualTo(subject), MimeMessageMatchers.containsString(content));
    }

    @Test
    @Restore(value="TestCustomFieldNotifications.xml")
    public void testCFNotificationsPublicIssue() throws InterruptedException, MessagingException, IOException {
        this.navigation.userProfile().changeNotifyMyChanges(true);
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.BROWSE_PROJECTS);
        this.navigation.issue().addComment("HSP-1", ISSUE_COMMENT, null);
        Collection<MimeMessage> mails = this.mailHelper.flushMailQueueAndWait(7);
        Assert.assertThat(mails, (Matcher)Matchers.hasItem(this.addressSubjectContentMatcher("user@example.com", SUBJECT, ISSUE_COMMENT)));
        Assert.assertThat(mails, (Matcher)Matchers.hasItem(this.addressSubjectContentMatcher("multiuser@example.com", SUBJECT, ISSUE_COMMENT)));
        Assert.assertThat(mails, (Matcher)Matchers.hasItem(this.addressSubjectContentMatcher("singlegroup@example.com", SUBJECT, ISSUE_COMMENT)));
        Assert.assertThat(mails, (Matcher)Matchers.hasItem(this.addressSubjectContentMatcher("multigroup@example.com", SUBJECT, ISSUE_COMMENT)));
        Assert.assertThat(mails, (Matcher)Matchers.hasItem(this.addressSubjectContentMatcher("admin@example.com", SUBJECT, ISSUE_COMMENT)));
        Assert.assertThat(mails, (Matcher)Matchers.hasItem(this.addressSubjectContentMatcher("fred@example.com", SUBJECT, ISSUE_COMMENT)));
        Assert.assertThat(mails, (Matcher)Matchers.hasItem(this.addressSubjectContentMatcher("johnson@example.com", SUBJECT, ISSUE_COMMENT)));
    }

    @Test
    @Restore(value="TestInvalidCustomFieldNotifications.xml")
    public void testDeletedCFDoesntCauseErrors() throws InterruptedException, IOException, MessagingException {
        this.navigation.userProfile().changeNotifyMyChanges(true);
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.BROWSE_PROJECTS);
        this.navigation.issue().addComment("HSP-1", ISSUE_COMMENT, null);
        Collection<MimeMessage> mails = this.mailHelper.flushMailQueueAndWait(3);
        Assert.assertThat(mails, (Matcher)Matchers.hasItem(this.addressSubjectContentMatcher("admin@example.com", SUBJECT, ISSUE_COMMENT)));
        Assert.assertThat(mails, (Matcher)Matchers.hasItem(this.addressSubjectContentMatcher("fred@example.com", SUBJECT, ISSUE_COMMENT)));
        Assert.assertThat(mails, (Matcher)Matchers.hasItem(this.addressSubjectContentMatcher("johnson@example.com", SUBJECT, ISSUE_COMMENT)));
    }
}

