/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.backdoor.ApplicationRoleControl;
import com.atlassian.jira.functest.framework.page.ViewIssuePage;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.webtests.EmailBaseFuncTestCase;
import com.atlassian.jira.webtests.JIRAServerSetup;
import com.atlassian.jira.webtests.LicenseKeys;
import com.google.common.collect.ImmutableList;
import com.jayway.awaitility.Awaitility;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.mail.Flags;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.EMAIL})
@LoginAs(user="admin")
public class TestHandlers
extends EmailBaseFuncTestCase {
    private static final int MAILBOX_PROCESSING_TIMEOUT = 20;
    private static final String NEW_USER_NAME = "freddie@example.com";
    private static final String EXISTING_USER_NAME = "fred@example.com";
    private static final String INCOMING_EMAIL = "admin@example.com";
    private static final String ISSUE_SUMMARY = "the monkeys escaped";
    private static final String OTHER_ISSUE_SUMMARY = "boiling eggs";
    @Inject
    private Administration administration;

    @Test
    public void testPortsNotInService() {
        this.backdoor.restoreBlankInstance();
        this.configureAndStartMailServers(INCOMING_EMAIL, "PRE", JIRAServerSetup.SMTP, JIRAServerSetup.IMAP, JIRAServerSetup.POP3);
        this.setupPopService();
        this.tester.assertTextNotPresent("port:</strong> " + this.mailService.getPop3Port());
        this.setupImapService();
        this.tester.assertTextNotPresent("port:</strong> " + this.mailService.getImapPort());
    }

    @Test
    public void testCreateIssueFromEmail() throws Exception {
        this.backdoor.restoreBlankInstance();
        this.configureMailAndSendMessage(EXISTING_USER_NAME);
        this.processIncomingMail();
        ViewIssuePage viewIssuePage = this.navigation.issue().viewIssue("MKY-1");
        Assert.assertEquals((Object)"Fred Normal", (Object)viewIssuePage.getReporter());
    }

    @Test
    public void testImapMarkSeen() throws MessagingException {
        this.backdoor.restoreBlankInstance();
        int issueCountBefore = this.backdoor.search().getSearch((SearchRequest)new SearchRequest().jql((String)"")).issues.size();
        this.configureMailAndSendMessage(EXISTING_USER_NAME, true);
        this.sendMail(EXISTING_USER_NAME, "second email", "second email body");
        MimeMessage[] messagesBeforeProcessing = this.mailService.getReceivedMessages();
        MatcherAssert.assertThat((Object)messagesBeforeProcessing, (Matcher)Matchers.arrayWithSize((int)2));
        Assert.assertFalse((boolean)messagesBeforeProcessing[0].getFlags().contains(Flags.Flag.SEEN));
        Assert.assertFalse((boolean)messagesBeforeProcessing[1].getFlags().contains(Flags.Flag.SEEN));
        messagesBeforeProcessing[0].setFlag(Flags.Flag.SEEN, true);
        this.processIncomingMailExpectMailsSeen(2L);
        Awaitility.await((String)"one issue should be created by the email handler").atMost(10L, TimeUnit.SECONDS).until(() -> this.backdoor.search().getSearch((SearchRequest)new SearchRequest().jql((String)"")).issues.size(), Matchers.equalTo((Object)(issueCountBefore + 1)));
        MimeMessage[] messagesAfterProcessing = this.mailService.getReceivedMessages();
        MatcherAssert.assertThat((Object)messagesAfterProcessing, (Matcher)Matchers.arrayWithSize((int)2));
        Assert.assertTrue((boolean)messagesAfterProcessing[0].getFlags().contains(Flags.Flag.SEEN));
        Assert.assertTrue((boolean)messagesAfterProcessing[1].getFlags().contains(Flags.Flag.SEEN));
    }

    @Test
    public void testMailHandlerShouldRespectApplicationAccess() throws Exception {
        this.backdoor.restoreBlankInstance(LicenseKeys.CORE_AND_TEST_ROLES_DC);
        ApplicationRoleControl roleClient = this.backdoor.applicationRoles();
        roleClient.putRoleWithDefaultsSelectedByDefault("jira-core", false, (Iterable<String>)ImmutableList.of((Object)"jira-users"), (Iterable<String>)ImmutableList.of((Object)"jira-users"));
        roleClient.putRoleWithDefaultsSelectedByDefault("jira-func-test", true, (Iterable<String>)ImmutableList.of((Object)"jira-developers"), (Iterable<String>)ImmutableList.of((Object)"jira-developers"));
        ApplicationRoleControl.ApplicationRoleBean testRole = roleClient.getRole("jira-func-test");
        this.addCreatePermissionToGroup("jira-developers");
        this.configureMailAndSendMessage(NEW_USER_NAME);
        this.processIncomingMail();
        List<String> expectedGroups = testRole.getDefaultGroups();
        List actualGroups = (List)testRole.getDefaultGroups().stream().filter(groupName -> this.backdoor.usersAndGroups().isUserInGroup(NEW_USER_NAME, groupName)).collect(CollectorsUtil.toImmutableList());
        Assert.assertEquals((String)"User was added to default app default groups", expectedGroups, (Object)actualGroups);
        Assert.assertFalse((String)"User was not added to non default app default groups", (boolean)this.backdoor.usersAndGroups().isUserInGroup(NEW_USER_NAME, "jira-users"));
        this.flushMailQueueAndWait(1);
    }

    @Test
    public void testMailHandlerShouldCreateIssueWhenNonDefaultAppLicenseExceeded() throws Exception {
        this.backdoor.restoreBlankInstance(LicenseKeys.CORE_AND_TEST_ROLES_DC);
        ApplicationRoleControl roleClient = this.backdoor.applicationRoles();
        roleClient.putRoleWithDefaultsSelectedByDefault("jira-core", false, (Iterable<String>)ImmutableList.of((Object)"jira-users"), (Iterable<String>)ImmutableList.of((Object)"jira-users"));
        this.backdoor.usersAndGroups().addUsersWithGroup("user", "User", 3, "jira-users");
        roleClient.putRoleWithDefaultsSelectedByDefault("jira-func-test", true, (Iterable<String>)ImmutableList.of((Object)"jira-developers"), (Iterable<String>)ImmutableList.of((Object)"jira-developers"));
        this.addCreatePermissionToGroup("jira-developers");
        this.configureMailAndSendMessage(NEW_USER_NAME);
        this.processIncomingMail();
        Assert.assertTrue((String)"User was created", (boolean)this.backdoor.usersAndGroups().userExists(NEW_USER_NAME));
        Assert.assertNotNull((String)"Issue was created", (Object)this.getIssue(ISSUE_SUMMARY));
        this.flushMailQueueAndWait(1);
    }

    @Test
    public void testMailHandlerShouldNotCreateIssueWhenDefaultAppLicenseExceeded() throws Exception {
        this.backdoor.restoreBlankInstance(LicenseKeys.CORE_AND_TEST_ROLES_DC);
        ApplicationRoleControl roleClient = this.backdoor.applicationRoles();
        roleClient.putRoleWithDefaultsSelectedByDefault("jira-core", false, (Iterable<String>)ImmutableList.of((Object)"jira-users"), (Iterable<String>)ImmutableList.of((Object)"jira-users"));
        roleClient.putRoleWithDefaultsSelectedByDefault("jira-func-test", true, (Iterable<String>)ImmutableList.of((Object)"jira-developers"), (Iterable<String>)ImmutableList.of((Object)"jira-developers"));
        this.backdoor.usersAndGroups().addUsersWithGroup("dev", "Developer", 3, "jira-developers");
        this.addCreatePermissionToGroup("jira-developers");
        this.configureMailAndSendMessage(NEW_USER_NAME);
        this.sendMail(EXISTING_USER_NAME, OTHER_ISSUE_SUMMARY, "nothing");
        this.runProcessingService();
        this.waitUntilInboxClear(1);
        Assert.assertFalse((String)"User was not created", (boolean)this.backdoor.usersAndGroups().userExists(NEW_USER_NAME));
        Assert.assertNull((String)"Issue was not created", (Object)this.getIssue(ISSUE_SUMMARY));
        Assert.assertNotNull((String)"Other issue was created", (Object)this.getIssue(OTHER_ISSUE_SUMMARY));
        this.flushMailQueueAndWait(1);
    }

    private Issue getIssue(String issueSummary) {
        return this.backdoor.search().postSearch((SearchRequest)new SearchRequest().jql((String)String.format((String)"summary ~ \"%s\"", (Object[])new Object[]{issueSummary}))).issues.stream().findFirst().orElse(null);
    }

    private void processIncomingMail() throws Exception {
        this.runProcessingService();
        this.waitUntilInboxClear(0);
    }

    private void processIncomingMailExpectMailsSeen(long expectedMessageCount) {
        this.runProcessingService();
        this.waitUntilInboxSeen(expectedMessageCount);
    }

    private void runProcessingService() {
        long serviceId = this.administration.services().goTo().getIdForServiceName("imap");
        this.administration.utilities().runServiceNow(serviceId);
    }

    private void configureMailAndSendMessage(String sender) {
        this.configureMailAndSendMessage(sender, false);
    }

    private void configureMailAndSendMessage(String sender, boolean markAsSeen) {
        this.configureAndStartMailServers(INCOMING_EMAIL, "PRE", JIRAServerSetup.SMTP, JIRAServerSetup.IMAP);
        this.mailService.addUser(INCOMING_EMAIL, "admin", "admin");
        this.setupImapService(markAsSeen);
        this.sendMail(sender, ISSUE_SUMMARY, "aarrrgh!");
    }

    private void sendMail(String sender, String subject, String body) {
        this.mailService.sendTextMessage(INCOMING_EMAIL, sender, subject, body);
        this.flushMailQueue();
    }

    private void waitUntilInboxClear(int expectedMessageCount) throws Exception {
        Awaitility.await().atMost(20L, TimeUnit.SECONDS).until(() -> this.mailService.getUserInbox(INCOMING_EMAIL).getMessageCount(), Matchers.equalTo((Object)expectedMessageCount));
    }

    private void waitUntilInboxSeen(long expectedMessageCount) {
        Awaitility.await().atMost(20L, TimeUnit.SECONDS).until(() -> (long)this.mailService.getUserInbox(INCOMING_EMAIL).getMessages().size() == expectedMessageCount && this.mailService.getUserInbox(INCOMING_EMAIL).getUnseenCount() == 0);
    }

    private void addCreatePermissionToGroup(String group) {
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.CREATE_ISSUES, group);
    }
}

