/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.MailTest;
import com.atlassian.jira.issue.changehistory.metadata.HistoryMetadata;
import com.atlassian.jira.issue.changehistory.metadata.HistoryMetadataParticipant;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.IssueUpdateRequest;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.TransitionsClient;
import com.atlassian.jira.webtests.EmailBaseFuncTestCase;
import com.icegreen.greenmail.util.GreenMailUtil;
import java.util.List;
import javax.inject.Inject;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.EMAIL})
@Restore(value="TestIssueNotificationsCurrentAssignee.xml")
@MailTest
@LoginAs(user="admin")
public class TestHistoryMetadataNotifications
extends EmailBaseFuncTestCase {
    public static final int START_PROGRESS_TRANSITION_ID = 4;
    public static final int STOP_PROGRESS_TRANSITION_ID = 301;
    public static final int RESOLVE_TRANSITION_ID = 5;
    public static final int REOPEN_TRANSITION_ID = 3;
    public static final int CLOSE_TRANSITION_ID = 2;
    private final HistoryMetadata metadataWIthRawDescription = this.createMetdata().emailDescriptionKey("nonexistant.description.key.xxxxx").emailDescription("custom description").build();
    private final HistoryMetadataParticipant.HistoryMetadataParticipantBuilder actor = HistoryMetadataParticipant.builder((String)"<b>actor</b>", (String)"actorType").displayName("<b>Bitbucket</b> User").url("http://bitbucket.org");
    private final HistoryMetadata metadataWithActor = this.createMetdata().actor(this.actor.build()).build();
    private final HistoryMetadata metadataWithActorKey = this.createMetdata().actor(this.actor.displayNameKey("reference.changehistory.customemaildescription.cause").build()).cause(HistoryMetadataParticipant.builder((String)"review", (String)"review").build()).build();
    private IssueClient issueClient;
    private TransitionsClient transitionsClient;
    @Inject
    private Administration administration;

    @Before
    public void setupTests() {
        this.configureAndStartSmtpServerWithNotify();
        this.administration.generalConfiguration().setAllowUnassignedIssues(true);
        this.administration.generalConfiguration().setBaseUrl(this.environmentData.getBaseUrl().toString());
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.environmentData);
        this.transitionsClient = new TransitionsClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    public void testUpdateWithCustomDescription() throws Exception {
        this.updateSummary("COW-1", "custom description", this.metadataWIthRawDescription);
        this.updateSummary("COW-2", "custom description key", this.createMetdata().build());
        this.flushMailQueueAndWait(3);
        List<MimeMessage> emails = this.getMessagesForRecipient("admin@example.com");
        this.assertEmailBodyContainsLine(emails.get(0), ".*Administrator.*updated.*an issue.*custom description.*");
        this.assertEmailBodyContainsLine(emails.get(1), ".*Automated transition updated an issue - triggered by.*Administrator.*RemoteSystem.*pull request #1.*");
    }

    @Test
    public void testUpdateWithCustomDescriptionInTextFormat() throws Exception {
        this.backdoor.userProfile().changeUserNotificationType("admin", "text");
        this.updateSummary("COW-1", "custom description", this.metadataWIthRawDescription);
        this.updateSummary("COW-2", "custom description key", this.createMetdata().build());
        this.updateSummary("COW-3", "plain update", null);
        this.flushMailQueueAndWait(4);
        List<MimeMessage> emails = this.getMessagesForRecipient("admin@example.com");
        this.assertEmailBodyContainsLine(emails.get(0), "Administrator updated COW-1: custom description");
        this.assertEmailBodyContainsLine(emails.get(1), "Automated transition updated an issue - triggered by Administrator's RemoteSystem pull request #1");
        this.assertEmailBodyContainsLine(emails.get(2), "Administrator updated COW-3:");
    }

    @Test
    public void testTransitionWithCustomActor() throws Exception {
        this.transitionsClient = (TransitionsClient)this.transitionsClient.anonymous();
        this.transition("COW-1", this.metadataWithActor, 4);
        this.transition("COW-2", this.metadataWithActorKey, 4);
        this.flushMailQueueAndWait(3);
        List<MimeMessage> emails = this.getMessagesForRecipient("admin@example.com");
        this.assertEmailBodyContainsLine(emails.get(0), ".*Automated transition updated an issue - triggered by <a href=\"http://bitbucket.org\".*&lt;b&gt;Bitbucket&lt;/b&gt; User</a>'s RemoteSystem pull request #1.*", ".*Change By:.*", ".*<a href=\"http://bitbucket.org\".*&lt;b&gt;Bitbucket&lt;/b&gt; User</a>.*");
        this.assertEmailBodyContainsLine(emails.get(1), ".*Automated transition updated an issue - triggered by <a href=\"http://bitbucket.org\".*pull request &lt;b&gt;actor&lt;/b&gt;</a>'s RemoteSystem review.*", ".*Change By:.*", ".*a href=\"http://bitbucket.org\".*pull request &lt;b&gt;actor&lt;/b&gt;</a>.*");
    }

    @Test
    public void testTransitionWithCustomActorTextFormat() throws Exception {
        this.backdoor.userProfile().changeUserNotificationType("admin", "text");
        this.transitionsClient = (TransitionsClient)this.transitionsClient.anonymous();
        this.transition("COW-1", this.metadataWithActor, 4);
        this.transition("COW-2", this.metadataWithActorKey, 4);
        this.transition("COW-1", this.metadataWithActor, 301);
        this.transition("COW-1", this.metadataWithActor, 5);
        this.transition("COW-1", this.metadataWithActor, 3);
        this.transition("COW-1", this.metadataWithActor, 2);
        this.transitionsClient = (TransitionsClient)this.transitionsClient.loginAs("admin");
        this.transition("COW-3", this.metadataWithActor, 2);
        this.flushMailQueueAndWait(12);
        List<MimeMessage> emails = this.getMessagesForRecipient("admin@example.com");
        this.assertEmailReceivedWithBodyContainingLine(5, emails, "Automated transition updated an issue - triggered by Bitbucket\\s+User's RemoteSystem pull request #1");
        this.assertEmailReceivedWithBodyContainingLine(1, emails, "Automated transition updated an issue - triggered by pull request\\s+actor's RemoteSystem review");
        this.assertEmailReceivedWithBodyContainingLine(1, emails, "Automated transition updated an issue - triggered by Administrator's RemoteSystem pull request #1");
        Assert.assertEquals((String)"Emails received", (long)7L, (long)emails.size());
    }

    @Test
    public void testTransitionIssueTextFormat() throws Exception {
        this.backdoor.userProfile().changeUserNotificationType("admin", "text");
        this.transition("COW-1", null, 4);
        this.transition("COW-1", null, 301);
        this.transition("COW-1", null, 5);
        this.transition("COW-1", null, 3);
        this.transition("COW-1", null, 2);
        this.flushMailQueueAndWait(10);
        List<MimeMessage> emails = this.getMessagesForRecipient("admin@example.com");
        emails.stream().map(email -> GreenMailUtil.getBody((Part)email).trim().replaceAll("\\n", "\\\\n").replaceAll("\\r", "\\\\r") + "\n").forEach(System.out::println);
        this.assertEmailReceivedWithBodyContainingLine(1, emails, "Work on COW-1 started by Administrator.");
        this.assertEmailReceivedWithBodyContainingLine(1, emails, "Work on COW-1 stopped by Administrator.");
        this.assertEmailReceivedWithBodyContainingLine(1, emails, "Administrator resolved COW-1.");
        this.assertEmailReceivedWithBodyContainingLine(1, emails, "Administrator reopened COW-1.");
        this.assertEmailReceivedWithBodyContainingLine(1, emails, "Administrator closed COW-1.");
        Assert.assertEquals((String)"Emails received", (long)5L, (long)emails.size());
    }

    private void transition(String issueKey, HistoryMetadata metadataWithActor, int transitionId) {
        this.transitionsClient.postResponse(issueKey, new IssueUpdateRequest().transition(ResourceRef.withId((String)Integer.valueOf(transitionId).toString())).historyMetadata(metadataWithActor));
    }

    private HistoryMetadata.HistoryMetadataBuilder createMetdata() {
        return HistoryMetadata.builder((String)"test").cause(HistoryMetadataParticipant.builder((String)"#1", (String)"causetype").displayNameKey("reference.changehistory.customemaildescription.cause").build()).generator(HistoryMetadataParticipant.builder((String)"RemoteSystem", (String)"systemtype").build()).emailDescriptionKey("reference.changehistory.customemaildescription");
    }

    private void updateSummary(String issueKey, String summary, HistoryMetadata metadata) {
        this.issueClient.update(issueKey, new IssueUpdateRequest().fields(new IssueFields().summary(summary)).historyMetadata(metadata));
    }
}

