/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.admin.DefaultIssueEvents;
import com.atlassian.jira.functest.framework.admin.NotificationSchemes;
import com.atlassian.jira.functest.framework.admin.NotificationType;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.EmailBaseFuncTestCase;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.mail.internet.MimeMessage;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.EMAIL, Category.ISSUES})
@LoginAs(user="admin")
@Restore(value="TestIssueNotificationsWithCustomFields.xml")
public class TestIssueDeleteNotifications
extends EmailBaseFuncTestCase {
    private static final String HENRY_FORD_EMAIL = "Henry.Ford@example.com";
    private static final String HENRY_FORD_USERNAME = "henry.ford";
    private static final String USER_CF_ID = "customfield_10000";
    private static final String MULTI_USER_CF_ID = "customfield_10001";
    private static final String GROUP_CF_ID = "customfield_10002";
    private static final String MULTI_GROUP_CF_ID = "customfield_10003";
    private static final String TEST_GROUP_ONE = "to-notify-1";
    private static final String TEST_GROUP_TWO = "to-notify-2";
    @Inject
    private Administration administration;

    @Test
    public void testAllWatchersNotifiedOfIssueDeletion() throws Exception {
        this.configureAndStartSmtpServerWithNotify();
        ((NotificationSchemes)this.administration.notificationSchemes().goTo()).addNotificationScheme("Test scheme", "Test description").addNotificationsForEvent(DefaultIssueEvents.ISSUE_DELETED.eventId(), NotificationType.ALL_WATCHERS);
        this.administration.project().associateNotificationScheme("COW", "Test scheme");
        String issueKey = this.navigation.issue().createIssue("COW", "Bug", "Notification test");
        this.navigation.issue().addWatchers(issueKey, "admin", HENRY_FORD_USERNAME);
        this.navigation.issue().deleteIssue(issueKey);
        this.flushMailQueueAndWait(2);
        this.assertGotDeleteIssueMessages(issueKey, "admin@stuff.com.com", HENRY_FORD_EMAIL);
    }

    @Test
    public void testUserFromUserCustomFieldNotifiedOfIssueDeletion() throws Exception {
        this.configureAndStartSmtpServer();
        ((NotificationSchemes)this.administration.notificationSchemes().goTo()).addNotificationScheme("Test scheme", "Test description").addNotificationsForEvent(DefaultIssueEvents.ISSUE_DELETED.eventId(), NotificationType.USER_CUSTOM_FIELD_VALUE, USER_CF_ID);
        this.administration.project().associateNotificationScheme("COW", "Test scheme");
        String issueKey = this.navigation.issue().createIssue("COW", "Bug", "Notification test", (Map<String, String[]>)ImmutableMap.of((Object)USER_CF_ID, (Object)new String[]{"bob"}));
        this.navigation.issue().deleteIssue(issueKey);
        this.flushMailQueueAndWait(1);
        this.assertGotDeleteIssueMessages(issueKey, "bob@stuff.com.com");
    }

    @Test
    public void testUsersFromMultiUserCustomFieldNotifiedOfIssueDeletion() throws Exception {
        this.configureAndStartSmtpServer();
        ((NotificationSchemes)this.administration.notificationSchemes().goTo()).addNotificationScheme("Test scheme", "Test description").addNotificationsForEvent(DefaultIssueEvents.ISSUE_DELETED.eventId(), NotificationType.USER_CUSTOM_FIELD_VALUE, MULTI_USER_CF_ID);
        this.administration.project().associateNotificationScheme("COW", "Test scheme");
        String issueKey = this.navigation.issue().createIssue("COW", "Bug", "Notification test", (Map<String, String[]>)ImmutableMap.of((Object)MULTI_USER_CF_ID, (Object)new String[]{"bob,fred"}));
        this.navigation.issue().deleteIssue(issueKey);
        this.flushMailQueueAndWait(2);
        this.assertGotDeleteIssueMessages(issueKey, "bob@stuff.com.com", "fred@example.com");
    }

    @Test
    public void testUsersFromGroupCustomFieldNotifiedOfIssueDeletion() throws Exception {
        this.configureAndStartSmtpServer();
        ((NotificationSchemes)this.administration.notificationSchemes().goTo()).addNotificationScheme("Test scheme", "Test description").addNotificationsForEvent(DefaultIssueEvents.ISSUE_DELETED.eventId(), NotificationType.GROUP_CUSTOM_FIELD_VALUE, GROUP_CF_ID);
        this.administration.project().associateNotificationScheme("COW", "Test scheme");
        this.setUpGroups();
        String issueKey = this.navigation.issue().createIssue("COW", "Bug", "Notification test", (Map<String, String[]>)ImmutableMap.of((Object)GROUP_CF_ID, (Object)new String[]{TEST_GROUP_ONE}));
        this.navigation.issue().deleteIssue(issueKey);
        this.flushMailQueueAndWait(2);
        this.assertGotDeleteIssueMessages(issueKey, "bob@stuff.com.com", "fred@example.com");
    }

    @Test
    public void testUsersFromMultiGroupCustomFieldNotifiedOfIssueDeletion() throws Exception {
        this.configureAndStartSmtpServer();
        ((NotificationSchemes)this.administration.notificationSchemes().goTo()).addNotificationScheme("Test scheme", "Test description").addNotificationsForEvent(DefaultIssueEvents.ISSUE_DELETED.eventId(), NotificationType.GROUP_CUSTOM_FIELD_VALUE, MULTI_GROUP_CF_ID);
        this.administration.project().associateNotificationScheme("COW", "Test scheme");
        this.setUpGroups();
        String issueKey = this.navigation.issue().createIssue("COW", "Bug", "Notification test", (Map<String, String[]>)ImmutableMap.of((Object)MULTI_GROUP_CF_ID, (Object)new String[]{TEST_GROUP_ONE, TEST_GROUP_TWO}));
        this.navigation.issue().deleteIssue(issueKey);
        this.flushMailQueueAndWait(3);
        this.assertGotDeleteIssueMessages(issueKey, "bob@stuff.com.com", "fred@example.com", HENRY_FORD_EMAIL);
    }

    private void setUpGroups() {
        this.backdoor.usersAndGroups().addGroup(TEST_GROUP_ONE);
        this.backdoor.usersAndGroups().addUserToGroup("bob", TEST_GROUP_ONE);
        this.backdoor.usersAndGroups().addUserToGroup("fred", TEST_GROUP_ONE);
        this.backdoor.usersAndGroups().addGroup(TEST_GROUP_TWO);
        this.backdoor.usersAndGroups().addUserToGroup("bob", TEST_GROUP_TWO);
        this.backdoor.usersAndGroups().addUserToGroup(HENRY_FORD_USERNAME, TEST_GROUP_TWO);
    }

    private void assertGotDeleteIssueMessages(String deletedIssueKey, String ... emails) throws Exception {
        Assert.assertEquals((long)emails.length, (long)this.mailService.getReceivedMessages().length);
        for (String username : emails) {
            List<MimeMessage> received = this.getMessagesForRecipient(username);
            Assert.assertEquals((String)("Unexpected number of messages for " + username), (long)1L, (long)received.size());
            MimeMessage message = received.get(0);
            String subject = message.getSubject();
            String expectedPhrase = String.format("(%s)", deletedIssueKey);
            Assert.assertTrue((String)("Subject '" + subject + "' does not contain expected expected phrase: " + expectedPhrase), (boolean)subject.contains(expectedPhrase));
            this.assertEmailBodyContains(message, "deleted");
        }
    }
}

