/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.EMAIL})
@LoginAs(user="admin")
public class TestMailServer
extends BaseJiraFuncTest {
    protected static final String FIELD_NAME = "name";
    protected static final String FIELD_FROM = "from";
    protected static final String FIELD_PREFIX = "prefix";
    protected static final String FIELD_SERVER_NAME = "serverName";
    protected static final String FIELD_AUTHENTICATION_METHOD = "authenticationMethod";
    protected static final String FIELD_USERNAME = "username";
    protected static final String FIELD_PASSWORD = "password";
    protected static final String FIELD_PORT = "port";
    protected static final String FIELD_AUTH_TYPE = "authenticationMethod";
    protected static final String VALUE_NAME_SMTP = "name SMTP";
    protected static final String VALUE_NAME_POP = "name POP";
    protected static final String VALUE_FROM = "from@atlassian.com";
    protected static final String VALUE_PREFIX = "prefix";
    protected static final String VALUE_SERVER_NAME = "server name";
    protected static final String VALUE_USERNAME = "username";
    protected static final String VALUE_PASSWORD = "password";
    protected static final String TITLE_SMTP_MAIL_SERVERS = "<h3 class=\"formtitle\">SMTP Mail Server</h3>";
    protected static final String TITLE_ADD_SMTP_MAIL_SERVER = "<h3 class=\"formtitle\">Add SMTP Mail Server</h3>";
    protected static final String TITLE_POP_MAIL_SERVERS = "<h3>Mail servers</h3>";
    protected static final String TITLE_ADD_POP_MAIL_SERVER = "<h3 class=\"formtitle\">Add mail server</h3>";
    protected static final String TITLE_DELETE_MAIL_SERVER = "<h3 class=\"formtitle\">Delete Mail Server</h3>";
    protected static final String TITLE_SUPPORT_REQUEST = "<h3 class=\"formtitle\">Support Request</h3>";
    protected static final String TITLE_SEND_EMAIL = "<h3 class=\"formtitle\">Send email</h3>";
    protected static final String TITLE_MAIL_QUEUE = "<h3 class=\"formtitle\">Mail queue</h3>";
    protected static final String LINK_TEXT_CONFIG_NEW_SMTP = "Configure new SMTP mail server";
    protected static final String LINK_TEXT_CONFIG_NEW_POP = "Add mail server";
    protected static final String LINK_DELETE_SMTP = "deleteSMTP";
    protected static final String LABEL_NO_SMTP_SUPPORT_REQUEST_PART_ONE = "<span class=\"note\">Note</span>: To send a support request you need to";
    protected static final String LABEL_NO_SMTP_SUPPORT_REQUEST_PART_TWO = "configure</a> a mail server.";
    protected static final String LABEL_NO_SMTP_SEND_EMAIL_PART_ONE = "To send email you need to";
    protected static final String LABEL_NO_SMTP_SEND_EMAIL_PART_TWO = "configure</a> a mail server.";
    protected static final String LABEL_NO_SMTP_MAIL_QUEUE_PART_ONE = "There is no default ";
    protected static final String LABEL_NO_SMTP_MAIL_QUEUE_PART_TWO = "mail server</a>, so mails will not be sent.";
    protected static final String LABEL_NO_POP_MAIL_SERVER = "You do not currently have any servers configured.";
    protected static final String BUTTON_CANCEL = "cancelButton";
    protected static final String BUTTON_ADD = "Add";
    protected static final String BUTTON_SAVE = "Save";
    protected static final String BUTTON_DELETE = "Delete";
    protected static final String ERROR_SPECIFY_SERVER = "Enter a name for the server.";
    protected static final String ERROR_SPECIFY_ADDRESS = "You must specify a valid from address";
    protected static final String ERROR_SPECIFY_PREFIX = "You must specify an email prefix";
    protected static final String ERROR_SPECIFY_SERVER_DETAILS = "You must specify a host name or a JNDI location";
    protected static final String ERROR_SPECIFY_SERVER_LOCATION = "Enter a valid hostname of the server";
    protected static final String ERROR_SPECIFY_USERNAME = "Enter a valid username";
    protected static final String ERROR_SPECIFY_PASSWORD = "You must specify a password";
    protected static final String ERROR_SPECIFY_AUTHORIZATION_METHOD = "Enter a valid authentication method";
    private static final String BUTTON_UPDATE = "Update";
    private static final String ERROR_ILLEGAL_PORT = "SMTP port must be a number between 0 and 65535";
    private static final String TEST_EXISTING_MAIL_SERVER_ID = "sendTestEmail";
    private static final String VALUE_AUTH_METHOD = "password";
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testPOPServerConfiguration() {
        this.backdoor.restoreBlankInstance();
        this.configureNewPOPServer();
        this.checkPOPServerExists();
        this.deletePOPServer();
    }

    @Test
    public void testSMTPServerConfiguration() {
        this.backdoor.restoreBlankInstance();
        this.validateSMTPForm();
        this.configureNewSMTPServer();
        this.checkSMTPServerExists();
        this.deleteSMTPServer();
        this.checkNoSMTPServer();
    }

    private void validateSMTPForm() {
        this.logger.log((Object)"Mail Server - Validating empty form for new SMTP mail server setup");
        this.navigation.gotoAdminSection(Navigation.AdminSection.OUTGOING_MAIL);
        this.tester.assertTextPresent(TITLE_SMTP_MAIL_SERVERS);
        if (this.tester.getDialog().isLinkPresent(LINK_DELETE_SMTP)) {
            this.tester.clickLink(LINK_DELETE_SMTP);
            this.tester.assertTextPresent(TITLE_DELETE_MAIL_SERVER);
            this.tester.assertTextPresent("Are you sure you want to delete");
            this.tester.submit(BUTTON_DELETE);
            this.assertions.assertNodeByIdDoesNotExist(TEST_EXISTING_MAIL_SERVER_ID);
        }
        this.tester.clickLinkWithText(LINK_TEXT_CONFIG_NEW_SMTP);
        this.tester.assertTextPresent(TITLE_ADD_SMTP_MAIL_SERVER);
        this.tester.submit(BUTTON_ADD);
        this.tester.assertTextPresent(ERROR_SPECIFY_SERVER);
        this.tester.assertTextPresent(ERROR_SPECIFY_ADDRESS);
        this.tester.assertTextPresent(ERROR_SPECIFY_PREFIX);
        this.tester.setFormElement(FIELD_NAME, VALUE_NAME_SMTP);
        this.tester.setFormElement(FIELD_FROM, VALUE_FROM);
        this.tester.setFormElement("prefix", "prefix");
        this.tester.submit(BUTTON_ADD);
        this.tester.assertTextPresent(ERROR_SPECIFY_SERVER_DETAILS);
        this.tester.setFormElement(FIELD_SERVER_NAME, VALUE_SERVER_NAME);
        this.tester.setFormElement("username", "username");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement(FIELD_PORT, String.valueOf(65536));
        this.tester.submit(BUTTON_ADD);
        this.tester.assertTextPresent(ERROR_ILLEGAL_PORT);
        this.tester.submit(BUTTON_ADD);
        this.tester.assertTextPresent(ERROR_ILLEGAL_PORT);
        this.tester.setFormElement(FIELD_PORT, String.valueOf(-1));
        this.tester.submit(BUTTON_ADD);
        this.tester.assertTextPresent(ERROR_ILLEGAL_PORT);
    }

    private void configureNewSMTPServer() {
        this.logger.log((Object)"Mail Server - Configuring a new SMTP mail server");
        this.navigation.gotoAdminSection(Navigation.AdminSection.OUTGOING_MAIL);
        this.tester.assertTextPresent(TITLE_SMTP_MAIL_SERVERS);
        this.tester.clickLinkWithText(LINK_TEXT_CONFIG_NEW_SMTP);
        this.tester.assertTextPresent(TITLE_ADD_SMTP_MAIL_SERVER);
        this.tester.setFormElement("authenticationMethod", "password");
        this.tester.setFormElement(FIELD_NAME, VALUE_NAME_SMTP);
        this.tester.setFormElement(FIELD_FROM, VALUE_FROM);
        this.tester.setFormElement("prefix", "prefix");
        this.tester.setFormElement(FIELD_SERVER_NAME, VALUE_SERVER_NAME);
        this.tester.setFormElement("username", "username");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement(FIELD_PORT, String.valueOf(65535));
        this.tester.submit(BUTTON_ADD);
        this.tester.assertTextPresent(TITLE_SMTP_MAIL_SERVERS);
        this.tester.assertTextPresent(VALUE_NAME_SMTP);
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"From:", VALUE_FROM, "Prefix:", "prefix", "Host:", VALUE_SERVER_NAME, "SMTP Port:", String.valueOf(65535), "Username:", "username"});
        this.tester.assertLinkNotPresentWithText(LINK_TEXT_CONFIG_NEW_SMTP);
        String deleteLink = this.tester.getDialog().getElement(LINK_DELETE_SMTP).getAttribute("href");
        String editId = "edit_" + StringUtils.substringAfter((String)deleteLink, (String)"id=");
        this.tester.clickLink(editId);
        this.tester.setFormElement(FIELD_PORT, String.valueOf(0));
        this.tester.setFormElement("password", "password");
        this.tester.submit(BUTTON_UPDATE);
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"SMTP Port:", "0"});
    }

    private void checkSMTPServerExists() {
        this.logger.log((Object)"Mail Server - Checking labels when a SMTP server is setup");
        this.navigation.gotoAdminSection(Navigation.AdminSection.OUTGOING_MAIL);
        this.tester.assertLinkNotPresentWithText(LINK_TEXT_CONFIG_NEW_SMTP);
        this.navigation.gotoAdminSection(Navigation.AdminSection.SEND_EMAIL);
        this.tester.assertTextPresent(TITLE_SEND_EMAIL);
        this.tester.assertTextNotPresent(LABEL_NO_SMTP_SEND_EMAIL_PART_ONE);
        this.tester.assertTextNotPresent("configure</a> a mail server.");
        this.navigation.gotoAdminSection(Navigation.AdminSection.MAIL_QUEUE);
        this.tester.assertTextPresent(TITLE_MAIL_QUEUE);
        this.tester.assertTextNotPresent(LABEL_NO_SMTP_MAIL_QUEUE_PART_ONE);
        this.tester.assertTextNotPresent(LABEL_NO_SMTP_MAIL_QUEUE_PART_TWO);
    }

    private void deleteSMTPServer() {
        this.logger.log((Object)"Mail Server - Deleting the SMTP server");
        this.navigation.gotoAdminSection(Navigation.AdminSection.OUTGOING_MAIL);
        this.tester.assertTextPresent(TITLE_SMTP_MAIL_SERVERS);
        this.assertions.assertNodeByIdExists(TEST_EXISTING_MAIL_SERVER_ID);
        this.tester.clickLink(LINK_DELETE_SMTP);
        this.tester.assertTextPresent(TITLE_DELETE_MAIL_SERVER);
        this.tester.assertTextPresent("Are you sure you want to delete <b>name SMTP</b>?");
        this.tester.submit(BUTTON_DELETE);
        this.assertions.assertNodeByIdDoesNotExist(TEST_EXISTING_MAIL_SERVER_ID);
        this.tester.assertLinkPresentWithText(LINK_TEXT_CONFIG_NEW_SMTP);
    }

    private void checkNoSMTPServer() {
        this.logger.log((Object)"Mail Server - Checking labels when a SMTP server is NOT setup");
        this.navigation.gotoAdminSection(Navigation.AdminSection.OUTGOING_MAIL);
        this.assertions.assertNodeByIdDoesNotExist(TEST_EXISTING_MAIL_SERVER_ID);
        this.tester.assertLinkPresentWithText(LINK_TEXT_CONFIG_NEW_SMTP);
        this.navigation.gotoAdminSection(Navigation.AdminSection.SEND_EMAIL);
        this.tester.assertTextPresent(TITLE_SEND_EMAIL);
        this.tester.assertTextPresent(LABEL_NO_SMTP_SEND_EMAIL_PART_ONE);
        this.tester.assertTextPresent("configure</a> a mail server.");
        this.navigation.gotoAdminSection(Navigation.AdminSection.MAIL_QUEUE);
        this.tester.assertTextPresent(TITLE_MAIL_QUEUE);
        this.tester.assertTextPresent(LABEL_NO_SMTP_MAIL_QUEUE_PART_ONE);
        this.tester.assertTextPresent(LABEL_NO_SMTP_MAIL_QUEUE_PART_TWO);
    }

    @Test
    public void testValidatePOPForm() {
        this.logger.log((Object)"Mail Server - Validayting empty form for new POP mail server setup");
        this.backdoor.restoreBlankInstance();
        this.navigation.gotoAdminSection(Navigation.AdminSection.INCOMING_MAIL);
        this.tester.assertTextPresent(TITLE_POP_MAIL_SERVERS);
        this.tester.clickLinkWithText(LINK_TEXT_CONFIG_NEW_POP);
        this.tester.assertTextPresent(TITLE_ADD_POP_MAIL_SERVER);
        this.tester.submit(BUTTON_SAVE);
        this.tester.assertTextPresent(ERROR_SPECIFY_SERVER);
        this.tester.assertTextPresent(ERROR_SPECIFY_SERVER_LOCATION);
        this.tester.assertTextPresent(ERROR_SPECIFY_USERNAME);
        this.tester.assertTextPresent(ERROR_SPECIFY_AUTHORIZATION_METHOD);
        this.tester.setFormElement(FIELD_NAME, VALUE_NAME_POP);
        this.tester.setFormElement(FIELD_SERVER_NAME, VALUE_SERVER_NAME);
        this.tester.setFormElement("username", "username");
        this.tester.setFormElement("password", "password");
        this.tester.clickLink(BUTTON_CANCEL);
    }

    private void configureNewPOPServer() {
        this.administration.restoreBlankInstance();
        this.logger.log((Object)"Mail Server - Configuring a new POP mail server");
        this.navigation.gotoAdminSection(Navigation.AdminSection.INCOMING_MAIL);
        this.tester.assertTextPresent(TITLE_POP_MAIL_SERVERS);
        this.configurePopServer(VALUE_NAME_POP, VALUE_SERVER_NAME, "110", "username", "password");
        this.tester.assertTextPresent(TITLE_POP_MAIL_SERVERS);
        this.tester.assertTextPresent(VALUE_NAME_POP);
        this.textAssertions.assertTextPresent(this.locator.page(), "Host: server name");
        this.textAssertions.assertTextPresent(this.locator.page(), "Username: username");
        this.tester.clickLinkWithText(LINK_TEXT_CONFIG_NEW_POP);
    }

    private void checkPOPServerExists() {
        this.logger.log((Object)"Mail Server - Checking labels when a POP server is setup");
        this.navigation.gotoAdminSection(Navigation.AdminSection.INCOMING_MAIL);
        this.tester.assertTextNotPresent(LABEL_NO_POP_MAIL_SERVER);
    }

    private void deletePOPServer() {
        this.logger.log((Object)"Mail Server - Deleting the POP server");
        this.navigation.gotoAdminSection(Navigation.AdminSection.INCOMING_MAIL);
        this.tester.assertTextPresent(TITLE_POP_MAIL_SERVERS);
        this.tester.clickLink("delete-pop-10000");
        this.tester.assertTextPresent(TITLE_DELETE_MAIL_SERVER);
        this.tester.assertTextPresent("Are you sure you want to delete <b>name POP</b>?");
        this.tester.submit(BUTTON_DELETE);
        this.tester.assertTextPresent(LABEL_NO_POP_MAIL_SERVER);
        this.tester.assertLinkPresentWithText(LINK_TEXT_CONFIG_NEW_POP);
    }

    @Test
    public void testNoPOPServer() {
        this.backdoor.restoreBlankInstance();
        this.logger.log((Object)"Mail Server - Checking labels when a POP server is NOT setup");
        this.navigation.gotoAdminSection(Navigation.AdminSection.INCOMING_MAIL);
        this.tester.assertTextPresent(LABEL_NO_POP_MAIL_SERVER);
        this.tester.assertLinkPresentWithText(LINK_TEXT_CONFIG_NEW_POP);
    }

    @Test
    public void testPortSetOnUpdatePopServer() {
        this.backdoor.restoreBlankInstance();
        this.navigation.gotoAdminSection(Navigation.AdminSection.INCOMING_MAIL);
        this.configurePopServer(VALUE_NAME_POP, VALUE_SERVER_NAME, "222", "username", "password");
        this.tester.clickLink("edit-pop-10000");
        this.tester.assertFormElementEquals(FIELD_PORT, "222");
    }

    private void configurePopServer(String name, String hostName, String port, String username, String password) {
        this.tester.clickLinkWithText(LINK_TEXT_CONFIG_NEW_POP);
        this.tester.assertTextPresent(TITLE_ADD_POP_MAIL_SERVER);
        this.tester.setFormElement(FIELD_NAME, name);
        this.tester.setFormElement(FIELD_SERVER_NAME, hostName);
        this.tester.setFormElement(FIELD_PORT, port);
        this.tester.setFormElement("authenticationMethod", "password");
        this.tester.setFormElement("username", username);
        this.tester.setFormElement("password", password);
        this.tester.submit(BUTTON_SAVE);
    }
}

