/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreDataCenterInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.BeforeBuildRule;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.testkit.client.ServicesControl;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.webtests.EmailBaseFuncTestCase;
import com.icegreen.greenmail.store.FolderException;
import java.io.IOException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.EMAIL})
@LoginAs(user="admin")
@Restore(value="TestMentions.xml")
public class TestMentions
extends EmailBaseFuncTestCase {
    private static final String ISSUE_KEY_1 = "HSP-1";
    private static final String ISSUE_KEY_2 = "HSP-4";
    public static final String ADMIN = "admin";
    public static final String I_THINK_BOB_SHOULD_HAVE_A_LOOK_AT_THIS = "I think [~bob] should have a look at this!";
    public static final String MENTIONED = "mentioned";
    public static final String I_THINK_ADMIN_SHOULD_HAVE_A_LOOK_AT_THIS = "I think [~admin] should have a look at this!";
    public static final String BOB_EXAMPLE_COM = "bob@example.com";
    public static final String BOB_BROWN = "Bob Brown";
    public static final String HOMOSAPIEN = "homosapien";
    public static final String TEST_ISSUE = "This is a first test issue";
    public static final String DESCRIPTION = "description";
    public static final String I_JUST_MENTIONED_YOU = "I just mentioned you";

    @Before
    public void setUp() {
        this.configureAndStartSmtpServerWithNotify();
        this.mailService.addUser("admin@example.com", ADMIN, ADMIN);
        this.mailService.addUser(BOB_EXAMPLE_COM, "bob", "bob");
        this.mailService.addUser("fred@example.com", "fred", "fred");
        this.backdoor.userProfile().changeUserNotificationType(ADMIN, "text");
    }

    @Test
    public void testSendMentions() throws InterruptedException, MessagingException, IOException, FolderException {
        this.navigation.issue().addComment(ISSUE_KEY_1, I_THINK_BOB_SHOULD_HAVE_A_LOOK_AT_THIS);
        this.flushMailQueueAndWait(2);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        Assert.assertEquals((long)2L, (long)mimeMessages.length);
        MimeMessage mimeMessage = this.getMentionMail(mimeMessages);
        this.assertEmailToEquals(mimeMessage, BOB_EXAMPLE_COM);
        this.assertEmailSubjectEquals(mimeMessage, this.expectedEmailSubject(ISSUE_KEY_1));
        this.assertEmailBodyContains(mimeMessage, BOB_BROWN);
        this.assertEmailBodyContains(mimeMessage, "should have a look at this");
        this.navigation.issue().addComment(ISSUE_KEY_1, "This is a test comment for [~admin].");
        this.flushMailQueueAndWait(1);
        this.mailService.removeAllReceivedMessages();
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.EDIT_ALL_COMMENTS, "jira-administrators");
        this.navigation.issue().viewIssue(ISSUE_KEY_1);
        this.tester.clickLink("edit_comment_10201");
        this.tester.setFormElement("comment", "I think [~admin] should have a look at this! [~bob] why don't you check this out too?");
        this.tester.submit();
        this.flushMailQueueAndWait(2);
        mimeMessages = this.mailService.getReceivedMessages();
        Assert.assertEquals((long)2L, (long)mimeMessages.length);
        mimeMessage = this.getMentionMail(mimeMessages);
        this.assertEmailToEquals(mimeMessage, BOB_EXAMPLE_COM);
        this.assertEmailSubjectEquals(mimeMessage, this.expectedEmailSubject(ISSUE_KEY_1));
        this.assertEmailBodyContains(mimeMessage, BOB_BROWN);
        this.assertEmailBodyContains(mimeMessage, "why don't you check this out too?");
    }

    @Test
    public void testSendMentionsOnlySendsOneEmail() throws InterruptedException, MessagingException, IOException {
        this.navigation.issue().addComment(ISSUE_KEY_1, I_THINK_ADMIN_SHOULD_HAVE_A_LOOK_AT_THIS);
        this.flushMailQueueAndWait(1);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        Assert.assertEquals((long)1L, (long)mimeMessages.length);
        MimeMessage mimeMessage = this.getMentionMail(mimeMessages);
        Assert.assertNotNull((Object)mimeMessage);
        this.assertEmailBodyContains(mimeMessage, "Administrator mentioned you on HSP-1");
        this.assertEmailBodyDoesntContain(mimeMessage, "commented");
    }

    @Test
    @BeforeBuildRule.BeforeBuild(buildNumber=9110000)
    public void testNoMentionsSentForUserWithoutBrowseUsersPermission() throws InterruptedException, MessagingException {
        this.navigation.logout();
        this.navigation.login("bob");
        this.navigation.userProfile().changeAutowatch(false);
        this.navigation.issue().addComment(ISSUE_KEY_1, I_THINK_ADMIN_SHOULD_HAVE_A_LOOK_AT_THIS);
        this.navigation.logout();
        this.navigation.login(ADMIN);
        this.flushMailQueueAndWait(1);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        Assert.assertEquals((long)1L, (long)mimeMessages.length);
        Assert.assertFalse((boolean)mimeMessages[0].getSubject().contains(MENTIONED));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=9110000)
    @RestoreDataCenterInstance(value="TestMentions.xml")
    public void testMentionsSentForUserWithoutBrowseUsersPermission() throws InterruptedException, MessagingException {
        this.navigation.logout();
        this.navigation.login("bob");
        this.navigation.userProfile().changeAutowatch(false);
        this.navigation.issue().addComment(ISSUE_KEY_1, I_THINK_ADMIN_SHOULD_HAVE_A_LOOK_AT_THIS);
        this.navigation.logout();
        this.navigation.login(ADMIN);
        this.flushMailQueueAndWait(1);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        Assert.assertEquals((long)1L, (long)mimeMessages.length);
        Assert.assertTrue((boolean)mimeMessages[0].getSubject().contains(MENTIONED));
    }

    @Test
    public void testNoMentionsSentForUserWithoutBrowseIssuePermission() throws InterruptedException, MessagingException {
        this.navigation.issue().addComment(ISSUE_KEY_1, "I think [~fred] should have a look at this!");
        this.flushMailQueueAndWait(1);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        Assert.assertEquals((long)1L, (long)mimeMessages.length);
        Assert.assertFalse((boolean)mimeMessages[0].getSubject().contains(MENTIONED));
    }

    @Test
    public void testSendHtmlMention() throws InterruptedException, MessagingException, IOException {
        this.navigation.issue().addComment(ISSUE_KEY_1, I_THINK_BOB_SHOULD_HAVE_A_LOOK_AT_THIS);
        this.flushMailQueueAndWait(2);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        Assert.assertEquals((long)2L, (long)mimeMessages.length);
        MimeMessage mimeMessage = this.getMentionMail(mimeMessages);
        this.assertEmailSubjectEquals(mimeMessage, this.expectedEmailSubject(ISSUE_KEY_1));
        this.assertEmailBodyContains(mimeMessage, "Bob Brown</a>");
        this.assertEmailBodyContains(mimeMessage, "<strong>mentioned you</strong> on");
    }

    @Test
    public void testSendMentionForDescription() throws InterruptedException, MessagingException, IOException, FolderException {
        String issueKey = this.navigation.issue().createIssue(HOMOSAPIEN, "Bug", TEST_ISSUE, MapBuilder.newBuilder().add(DESCRIPTION, new String[]{"Hello [~admin]. I created this! Hi [~bob] I just mentioned you!"}).toMap());
        this.flushMailQueueAndWait(2);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        Assert.assertEquals((long)2L, (long)mimeMessages.length);
        this.assertEmailSubjectEquals(mimeMessages[0], this.expectedEmailSubject(issueKey));
        this.assertEmailBodyContains(mimeMessages[0], I_JUST_MENTIONED_YOU);
        this.assertEmailBodyContains(mimeMessages[0], "[~bob]");
        this.assertEmailSubjectEquals(mimeMessages[1], this.expectedEmailSubject(issueKey));
        this.assertEmailBodyContains(mimeMessages[1], I_JUST_MENTIONED_YOU);
        this.assertEmailBodyContains(mimeMessages[1], BOB_BROWN);
        this.navigation.issue().createIssue(HOMOSAPIEN, "Bug", TEST_ISSUE, MapBuilder.newBuilder().add(DESCRIPTION, new String[]{"Hello [~admin]. I created this!"}).toMap());
        this.flushMailQueueAndWait(1);
        this.mailService.removeAllReceivedMessages();
        issueKey = this.navigation.issue().createIssue(HOMOSAPIEN, "Bug", TEST_ISSUE, MapBuilder.newBuilder().add(DESCRIPTION, new String[]{"Hello [~admin]. I created this! Hi [~bob] I just mentioned you!"}).toMap());
        ((ServicesControl)this.backdoor.services().anonymous()).runService(10000L);
        boolean receivedAllMail = this.mailService.waitForIncomingMessage(2);
        Assert.assertTrue((String)"Emails are sent", (boolean)receivedAllMail);
        mimeMessages = this.mailService.getReceivedMessages();
        Assert.assertEquals((long)2L, (long)mimeMessages.length);
        this.assertEmailSubjectEquals(mimeMessages[0], this.expectedEmailSubject(issueKey));
        this.assertEmailBodyContains(mimeMessages[0], I_JUST_MENTIONED_YOU);
        this.assertEmailBodyContains(mimeMessages[0], "[~bob]");
        this.assertEmailSubjectEquals(mimeMessages[1], this.expectedEmailSubject(issueKey));
        this.assertEmailBodyContains(mimeMessages[1], I_JUST_MENTIONED_YOU);
        this.assertEmailBodyContains(mimeMessages[1], BOB_BROWN);
        this.mailService.removeAllReceivedMessages();
        this.navigation.issue().gotoEditIssue(ISSUE_KEY_2);
        this.tester.setFormElement(DESCRIPTION, "Hello [~admin]. I created this! Hey [~bob] you are in the description too now!");
        this.tester.submit();
        this.flushMailQueueAndWait(2);
        mimeMessages = this.mailService.getReceivedMessages();
        Assert.assertEquals((long)2L, (long)mimeMessages.length);
        MimeMessage mimeMessage = this.getMentionMail(mimeMessages);
        this.assertEmailToEquals(mimeMessage, BOB_EXAMPLE_COM);
        this.assertEmailSubjectEquals(mimeMessage, this.expectedEmailSubject(ISSUE_KEY_2));
        this.assertEmailBodyContains(mimeMessage, "you are in the description too now!");
        this.assertEmailBodyContains(mimeMessage, BOB_BROWN);
    }

    private String expectedEmailSubject(String issueKey) {
        return "[JIRATEST] Administrator mentioned you on " + issueKey + " (Jira)";
    }

    @Test
    public void testEmailUserLinkWhenMentionedInIssueComment() throws Exception {
        this.navigation.issue().addComment(ISSUE_KEY_1, "This is me mentioning [~bob]");
        String baseUrl = this.backdoor.getTestkit().applicationProperties().getString("jira.baseurl");
        this.flushMailQueueAndWait(2);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        Assert.assertEquals((long)2L, (long)mimeMessages.length);
        MimeMessage mimeMessage = this.getMentionMail(mimeMessages);
        this.assertEmailBodyContains(mimeMessage, String.format("href=\"%s/secure/ViewProfile.jspa?name=bob\"", baseUrl));
    }

    @Test
    public void testEmailUserOnceWhenWatchingAndMentioned() throws Exception {
        this.navigation.issue().addWatchers(ISSUE_KEY_1, "bob");
        this.navigation.issue().addComment(ISSUE_KEY_1, "This is me mentioning [~bob]");
        this.flushMailQueueAndWait(2);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        Assert.assertEquals((long)2L, (long)mimeMessages.length);
    }

    private MimeMessage getMentionMail(MimeMessage[] mimeMessages) throws MessagingException {
        for (MimeMessage mimeMessage : mimeMessages) {
            if (!mimeMessage.getSubject().contains(MENTIONED)) continue;
            return mimeMessage;
        }
        return null;
    }
}

