/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.AbstractSubscriptionEmailTest;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.mail.internet.MimeMessage;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.EMAIL})
@Restore(value="TestSubscriptionsWithTimeZones.xml")
@LoginAs(user="admin")
public class TestSubscriptionsWithTimeZones
extends AbstractSubscriptionEmailTest {
    String BERLIN_EMAIL = "berlin@stuff.com.com";
    String SYDNEY_EMAIL = "sydney@stuff.com.com";
    @Inject
    private Administration administration;

    @Before
    public void setUpMailServer() {
        this.configureAndStartSmtpServer();
    }

    @Before
    public void setUpTimeZone() {
        this.administration.generalConfiguration().setDefaultUserTimeZone("Australia/Sydney");
    }

    @Test
    public void testUsersInSameGroupButDifferentTimeZones() throws Exception {
        AbstractSubscriptionEmailTest.FilterConfig filterResultsForAdminUser = new AbstractSubscriptionEmailTest.FilterConfig("Filter with DateTimeCF", null, "ProjectTwo", "TWO", 1, 1){

            @Override
            public Iterator<Integer> getIssueIterator() {
                return Lists.newArrayList((Object[])new Integer[]{1}).iterator();
            }
        };
        AbstractSubscriptionEmailTest.FilterConfig filterResultsForBerlinUser = new AbstractSubscriptionEmailTest.FilterConfig("Filter with DateTimeCF", null, "ProjectTwo", "TWO", 1, 1){

            @Override
            public Iterator<Integer> getIssueIterator() {
                return Lists.newArrayList((Object[])new Integer[]{1}).iterator();
            }
        };
        AbstractSubscriptionEmailTest.FilterConfig filterResultsForSydneyUser = new AbstractSubscriptionEmailTest.FilterConfig("Filter with DateTimeCF", null, "ProjectTwo", "TWO", 2, 2){

            @Override
            public Iterator<Integer> getIssueIterator() {
                return Lists.newArrayList((Object[])new Integer[]{2, 1}).iterator();
            }
        };
        this.subscribeToFilterAndRun(filterResultsForAdminUser, "jira-administrators");
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.flushMailQueueAndWait(3);
        List<MimeMessage> adminEmail = this.getMessagesForRecipient("admin@stuff.com.com");
        Assert.assertThat((Object)adminEmail.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.assertTextMessageValid(adminEmail.get(0), filterResultsForAdminUser, "jiratest@atlassian.com", "admin@stuff.com.com", "admin");
        List<MimeMessage> berlinEmail = this.getMessagesForRecipient(this.BERLIN_EMAIL);
        Assert.assertThat((Object)berlinEmail.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.assertTextMessageValid(berlinEmail.get(0), filterResultsForBerlinUser, "jiratest@atlassian.com", this.BERLIN_EMAIL, "admin");
        List<MimeMessage> sydneyEmail = this.getMessagesForRecipient(this.SYDNEY_EMAIL);
        Assert.assertThat((Object)sydneyEmail.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.assertTextMessageValid(sydneyEmail.get(0), filterResultsForSydneyUser, "jiratest@atlassian.com", this.SYDNEY_EMAIL, "admin");
    }
}

