/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.jira.functest.framework.BaseJiraEmailTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.MailTest;
import com.icegreen.greenmail.util.GreenMailUtil;
import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.EMAIL})
@RestoreBlankInstance
public class TestUserSignup
extends BaseJiraEmailTest {
    private static final String FULL_NAME = "full name";
    private static final String SECRET_PASSWORD = "secretpassword";
    private static final String USER1 = "user1";
    private static final String USER1_EMAIL = "user1@example.com";
    private static final String USER2 = "user2";
    private static final String USER2_EMAIL = "user2@example.org";
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Test
    @MailTest
    public void testUserSignup() throws InterruptedException, MessagingException, IOException {
        this.signupAs(USER1, USER1_EMAIL);
        this.assertSignupEmail(this.flushAndGetLastMessage(), USER1, USER1_EMAIL);
        this.signupAs(USER2, USER2_EMAIL);
        this.assertSignupEmail(this.flushAndGetLastMessage(), USER2, USER2_EMAIL);
    }

    private MimeMessage flushAndGetLastMessage() throws InterruptedException {
        Optional<MimeMessage> message = this.mailHelper.flushMailQueueAndWait(1).stream().findFirst();
        this.backdoor.outgoingMailControl().clearMessages();
        return message.get();
    }

    private void assertSignupEmail(MimeMessage message, String userName, String emailAddress) throws MessagingException, IOException {
        String toAddr = message.getHeader("To", "XXX");
        String body = GreenMailUtil.getBody((Part)message);
        this.textAssertions.assertTextSequence(toAddr, emailAddress, new String[0]);
        this.textAssertions.assertTextSequence(body, "Username:", userName);
        this.textAssertions.assertTextSequence(body, "Email:", emailAddress);
        this.textAssertions.assertTextSequence(body, "Full Name:", userName + FULL_NAME);
        this.textAssertions.assertTextNotPresent(body, SECRET_PASSWORD);
    }

    private void signupAs(String userName, String emailAddress) {
        this.navigation.logout();
        this.tester.gotoPage("secure/Signup!default.jspa");
        this.tester.setFormElement("username", userName);
        this.tester.setFormElement("password", SECRET_PASSWORD);
        this.tester.setFormElement("fullname", userName + FULL_NAME);
        this.tester.setFormElement("email", emailAddress);
        this.tester.submit();
        this.assertions.assertNodeHasText(this.locator.css("#content .aui-message.aui-message-success"), "You have successfully signed up. If you forget your password, you can request a new one.");
        this.navigation.gotoPage("/");
    }
}

