/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.fields;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.testkit.client.PermissionSchemesControl;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import java.net.URL;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.FIELDS})
@LoginAs(user="admin")
public class TestAssigneeField
extends BaseJiraFuncTest {
    private final long projectId = 10000L;
    private long issueId;
    private long permissionSchemeId;
    @Inject
    private FuncTestLogger logger;

    @Before
    public void setUpTest() {
        this.backdoor.restoreBlankInstance();
        this.backdoor.usersAndGroups().addUsers("user", "User ", 50);
        this.backdoor.usersAndGroups().addUsersWithGroup("d", "Dev ", 50, "jira-developers");
        PermissionSchemesControl permissionSchemes = this.backdoor.permissionSchemes();
        this.permissionSchemeId = permissionSchemes.copyDefaultScheme("Admin-Only Scheme");
        permissionSchemes.replaceGroupPermissions(this.permissionSchemeId, ProjectPermissions.ASSIGNABLE_USER, "jira-developers");
        this.backdoor.project().setPermissionScheme(10000L, this.permissionSchemeId);
        IssueCreateResponse createResponse = this.backdoor.issues().createIssue(10000L, "Issue 1", "d5");
        String issueKey = createResponse.key();
        this.issueId = Long.parseLong(createResponse.id());
        for (int i = 10; i < 20; ++i) {
            this.backdoor.issues().assignIssue(issueKey, "d" + i);
        }
        this.logger.log((Object)"Logging in d42 developer");
        this.navigation.login("d42", "d42");
        this.logger.log((Object)"Ready for testing");
    }

    @Test
    public void testAssigneePickerVisibility() throws Exception {
        this.navigation.issue().gotoEditIssue(this.issueId);
        this.assertions.assertNodeExists("//select[@id='assignee']");
        this.backdoor.permissionSchemes().removeGroupPermission(this.permissionSchemeId, ProjectPermissions.ASSIGN_ISSUES, "jira-developers");
        try {
            this.navigation.issue().gotoEditIssue(this.issueId);
            this.assertions.assertNodeDoesNotExist("//select[@id='assignee']");
        }
        finally {
            this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(this.permissionSchemeId), ProjectPermissions.ASSIGN_ISSUES, "jira-developers");
        }
    }

    @Test
    public void testAssigneeNotAlteredIfNoPermission() throws Exception {
        this.backdoor.generalConfiguration().disallowUnassignedIssues();
        this.backdoor.permissionSchemes().removeGroupPermission(this.permissionSchemeId, ProjectPermissions.ASSIGN_ISSUES, "jira-developers");
        try {
            this.navigation.issue().gotoEditIssue(this.issueId);
            this.tester.setWorkingForm("issue-edit");
            this.tester.submit();
            Assert.assertTrue((boolean)this.getUrl().getPath().endsWith("/browse/HSP-1"));
            this.assertions.assertNodeExists(this.assigneeLocator("d19"));
        }
        finally {
            this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(this.permissionSchemeId), ProjectPermissions.ASSIGN_ISSUES, "jira-developers");
        }
    }

    @Test
    public void testAssigneeSetToAutomaticIfNoPermission() throws Exception {
        this.backdoor.project().setProjectDefaultAssignee(10000L, true);
        IssueCreateResponse response = this.backdoor.issues().createIssue(10000L, "Auto-assign to admin", null);
        this.navigation.issue().gotoIssue(response.key());
        this.assertions.assertNodeExists(this.assigneeLocator("admin"));
        this.backdoor.project().setProjectLead(10000L, "d36");
        response = this.backdoor.issues().createIssue(10000L, "Should be auto-assigned to d36", null);
        this.navigation.issue().gotoIssue(response.key());
        this.assertions.assertNodeExists(this.assigneeLocator("d36"));
    }

    private String assigneeLocator(String user) {
        return "//*[@id='assignee-val']/*[@rel='" + user + "']";
    }

    private URL getUrl() {
        return this.tester.getTestContext().getWebClient().getCurrentPage().getURL();
    }
}

