/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.fields;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.IssueTableAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.beans.CustomFieldConfig;
import com.atlassian.jira.testkit.client.IssueTypeControl;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.testkit.client.restclient.SearchResult;
import java.util.Arrays;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.FIELDS})
@LoginAs(user="admin")
public class TestCustomFieldSearcherVisibility
extends BaseJiraFuncTest {
    @Inject
    private IssueTableAssertions issueTableAssertions;
    @Inject
    private Administration administration;

    @Test
    public void testJRA_16356() {
        this.administration.restoreData("TestCustomFieldSearcherVisibility.xml");
        this.issueTableAssertions.assertSearchersPresent("DatePickerCF", "TextCF");
        this.hideCustomFields();
        this.issueTableAssertions.assertSearchersNotPresent("DatePickerCF", "TextCF");
    }

    @Test
    public void testCustomDatePickerFieldHidingViaConfigurationScheme() {
        this.hideAndSearchCustomField("CustDP", "CustDP > 2018-09-01 AND CustDP < 2018-10-01");
    }

    @Test
    public void testCustomDateTimeFieldHidingViaConfigurationScheme() {
        this.hideAndSearchCustomField("CustDT", "CustDT > 2018-09-01 AND CustDT < 2018-10-01");
    }

    private void hideAndSearchCustomField(String fieldName, String searchJql) {
        this.administration.restoreData("TestCustomFieldSearcherVisibility_ViaProjectContexts.xml");
        SearchResult sr = this.backdoor.search().postSearch(new SearchRequest().jql(searchJql));
        Assert.assertEquals((long)1L, (long)sr.issues.size());
        Assert.assertEquals((Object)"UNO-1", (Object)((Issue)sr.issues.get((int)0)).key);
        String numericCustomFieldId = this.numericCustomFieldIdFromName(fieldName);
        String[] projectUnoId = new String[]{Long.toString(this.backdoor.project().getProjectId("UNO"))};
        String[] onlyImprovements = this.findIssueTypeIds(it -> it.getName().equalsIgnoreCase("improvement"));
        CustomFieldConfig customFieldConfigWithProjectContext = (CustomFieldConfig)this.backdoor.customFields().getCustomField("customfield_" + numericCustomFieldId, true).getConfig().get(1);
        this.backdoor.fieldConfigScheme().updateFieldConfigScheme("customfield_" + numericCustomFieldId, customFieldConfigWithProjectContext.getId(), null, Arrays.asList(projectUnoId), Arrays.asList(onlyImprovements));
        this.administration.reIndex();
        SearchResult postIndexSearch = this.backdoor.search().postSearch(new SearchRequest().jql(searchJql));
        Assert.assertEquals((long)0L, (long)postIndexSearch.issues.size());
    }

    private String numericCustomFieldIdFromName(String fieldName) {
        return this.backdoor.customFields().getCustomFields().stream().filter(cf -> cf.name.equalsIgnoreCase(fieldName)).map(cf -> cf.id).map(id -> id.substring(id.indexOf("_") + 1)).findFirst().get();
    }

    private String[] findIssueTypeIds(Predicate<IssueTypeControl.IssueType> matching) {
        return (String[])this.backdoor.issueType().getIssueTypes().stream().filter(matching::test).map(it -> it.getId()).toArray(String[]::new);
    }

    private void hideCustomFields() {
        this.administration.fieldConfigurations().defaultFieldConfiguration().hideFields("DatePickerCF");
        this.administration.fieldConfigurations().defaultFieldConfiguration().hideFields("TextCF");
    }
}

