/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.fields;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.FuncTestRestClient;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.ReferencePluginConstants;
import java.util.Collections;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REFERENCE_PLUGIN, Category.REST})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestCustomFieldTypeVersionedRepresentations
extends BaseJiraFuncTest {
    public static final String VERSIONED_REPRESENTATIONS = "versionedRepresentations";
    private static final String REF_CUSTOM_FIELD_NAME = "test";
    private final Object customFieldValue = "test value";
    @Inject
    FuncTestRestClient funcTestRestClient;
    private String customFieldKey;
    private String issueKey;
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.plugins().referencePlugin().enable();
        this.customFieldKey = this.backdoor.customFields().createCustomField(REF_CUSTOM_FIELD_NAME, "", ReferencePluginConstants.MULTI_REST_RESPRESENTATION_KEY, null);
        this.backdoor.screens().addFieldToScreen("Default Screen", REF_CUSTOM_FIELD_NAME);
        this.issueKey = this.navigation.issue().createIssue("homosapien", "Bug", "Test summary", Collections.singletonMap(this.customFieldKey, new String[]{(String)this.customFieldValue}));
    }

    @Test
    public void testVersionedRepresentations() throws Exception {
        JSONObject representations = this.getJsonRepresentations("rest/api/2/issue/" + this.issueKey + "?expand=" + VERSIONED_REPRESENTATIONS);
        MatcherAssert.assertThat((Object)representations, (Matcher)Matchers.is((Object)this.getVersionedRepresentations()));
    }

    @Test
    public void testVersionedRepresentationsAreInSelectedField() throws Exception {
        JSONObject representations = this.getJsonRepresentations("rest/api/2/issue/" + this.issueKey + "?expand=" + VERSIONED_REPRESENTATIONS + "&fields=" + this.customFieldKey);
        MatcherAssert.assertThat((Object)representations, (Matcher)Matchers.is((Object)this.getVersionedRepresentations()));
    }

    @Test
    public void testVersionedRepresentationsAreInSearch() throws JSONException {
        JSONObject json = this.funcTestRestClient.getJSON("rest/api/2/search?expand=versionedRepresentations&jql=key=" + this.issueKey, new String[0]);
        JSONObject representations = json.getJSONArray("issues").getJSONObject(0).getJSONObject(VERSIONED_REPRESENTATIONS).getJSONObject(this.customFieldKey);
        MatcherAssert.assertThat((Object)representations, (Matcher)Matchers.is((Object)this.getVersionedRepresentations()));
    }

    private JSONObject getJsonRepresentations(String url) throws JSONException {
        JSONObject json = this.funcTestRestClient.getJSON(url, new String[0]);
        return json.getJSONObject(VERSIONED_REPRESENTATIONS).getJSONObject(this.customFieldKey);
    }

    private JSONObject getVersionedRepresentations() throws JSONException {
        return new JSONObject().put("1", this.customFieldValue).put("2", new JSONObject().put("value", this.customFieldValue)).put("3", new JSONObject().put("value", this.customFieldValue).put("type", "custom_text"));
    }
}

