/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.fields;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.BulkOperations;
import com.atlassian.jira.functest.framework.FieldLayoutSchemes;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.admin.CustomFields;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.webtests.util.BidiUtils;
import com.meterware.httpunit.HttpUnitOptions;
import java.util.Collections;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.FIELDS})
@RestoreBlankInstance
@LoginAs(user="admin")
public class TestFieldRenderers
extends BaseJiraFuncTest {
    private static final String CUSTOM_FIELD_NAME_TEXT_FIELD = "Custom Field Text Field";
    private static final String CUSTOM_FIELD_NAME_TEXT_AREA_FIELD = "Custom Field Text Area Field";
    private static final String DEFAULT_FIELD_CONFIGURATION = "Default Field Configuration";
    private static final String CUSTOM_FIELD_CONFIGURATION = "Renderer Custom Field Configuration";
    private static final String WIKI_STYLE_RENDERER = "Wiki Style Renderer";
    private static final String DEFAULT_TEXT_RENDERER = "Default Text Renderer";
    private static final String CUSTOM_FIELD_CONFIGURATION_SCHEME = "Renderer Custom Field Configuration Scheme";
    private static final String PROJECT_DOG = "Canine";
    private static final String PROJECT_DOG_KEY = "DOG";
    private static final String OTHER_PROJECT = "Renderer Test Project";
    private static final String OTHER_PROJECT_KEY = "OTH";
    private static final String HTML_CODE = "<b>testWikiRendererBadLink</b>";
    private static final String COMMENT_FIELD_ID = "comment";
    private static final String DESCRIPTION_ID = "description";
    private static final String ENVIRONMENT_ID = "environment";
    private String issueKey;
    private String textAreaCustomFieldId;
    private String textCustomFieldId;
    private long projectId;
    @Inject
    private FieldLayoutSchemes fieldLayoutSchemes;
    @Inject
    private FuncTestLogger logger;
    @Inject
    private BulkOperations bulkOperations;
    @Inject
    private Administration administration;

    @Before
    public void setUp() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.projectId = this.administration.project().addProject(PROJECT_DOG, PROJECT_DOG_KEY, "admin");
        this.setFieldConfigurationFieldToRenderer(DEFAULT_FIELD_CONFIGURATION, COMMENT_FIELD_ID, WIKI_STYLE_RENDERER);
        this.setFieldConfigurationFieldToRenderer(DEFAULT_FIELD_CONFIGURATION, DESCRIPTION_ID, WIKI_STYLE_RENDERER);
        this.setFieldConfigurationFieldToRenderer(DEFAULT_FIELD_CONFIGURATION, ENVIRONMENT_ID, WIKI_STYLE_RENDERER);
        this.textAreaCustomFieldId = CustomFields.numericCfId(this.backdoor.customFields().createCustomField(CUSTOM_FIELD_NAME_TEXT_AREA_FIELD, "", CustomFields.builtInCustomFieldKey("textarea"), null));
        this.textCustomFieldId = CustomFields.numericCfId(this.backdoor.customFields().createCustomField(CUSTOM_FIELD_NAME_TEXT_FIELD, "", CustomFields.builtInCustomFieldKey("textfield"), null));
        this.addFieldsToFieldScreen("Workflow Screen", new String[]{CUSTOM_FIELD_NAME_TEXT_AREA_FIELD, CUSTOM_FIELD_NAME_TEXT_FIELD});
        this.addFieldsToFieldScreen("Default Screen", new String[]{CUSTOM_FIELD_NAME_TEXT_AREA_FIELD, CUSTOM_FIELD_NAME_TEXT_FIELD});
        this.addFieldsToFieldScreen("Resolve Issue Screen", new String[]{CUSTOM_FIELD_NAME_TEXT_AREA_FIELD, CUSTOM_FIELD_NAME_TEXT_FIELD});
        this.setFieldConfigurationFieldToRenderer(DEFAULT_FIELD_CONFIGURATION, "customfield_" + this.textAreaCustomFieldId, WIKI_STYLE_RENDERER);
        this.setFieldConfigurationFieldToRenderer(DEFAULT_FIELD_CONFIGURATION, "customfield_" + this.textCustomFieldId, WIKI_STYLE_RENDERER);
        this.navigation.gotoAdminSection(Navigation.AdminSection.FIELD_CONFIGURATION);
        this.tester.clickLink("copy-Default Field Configuration");
        this.tester.setFormElement("fieldLayoutName", CUSTOM_FIELD_CONFIGURATION);
        this.tester.submit("Copy");
        this.issueKey = this.backdoor.issues().createIssue(PROJECT_DOG_KEY, "This is a test issue", "admin", "Major", "Bug").key();
        this.backdoor.issues().setIssueFields(this.issueKey, new IssueFields().environment("test environment").description("description for this is a test issue"));
        this.administration.attachments().enable();
        this.administration.addGlobalPermission(GlobalPermissionKey.BULK_CHANGE, "jira-users");
    }

    @Test
    public void testFieldRenderers() {
        this.logger.log((Object)"-- begin testFieldRenderers");
        this._testWikiRendererVisible();
        this._testRendererConfiguration();
        this._testRendererPluginConfiguration();
        this._testRendererWithBulkOperations();
        this._testRendererAlternativeViews();
        this._testWikiRendererBadLink();
        this._testWikiRendererBadMacro();
        this.logger.log((Object)"-- end   testFieldRenderers");
    }

    @Test
    public void testWikiRendererBidiEscape() {
        String content = String.format("{code}%1$s{code}{noformat}%1$s{noformat}", BidiUtils.getBidis());
        this.navigation.issue().gotoIssue(this.issueKey);
        this.tester.clickLink("edit-issue");
        this.tester.setFormElement(DESCRIPTION_ID, content);
        this.tester.submit("Update");
        this.tester.assertTextPresent(BidiUtils.getCodePanelWithEscapedBidis() + BidiUtils.getNoFormatPanelWithEscapedBidis());
    }

    @Test
    public void testWikiRendererBidiNotEscaped() {
        this.backdoor.darkFeatures().disableForSite(BidiUtils.BIDI_ESCAPING);
        String content = String.format("{code}%1$s{code}{noformat}%1$s{noformat}", BidiUtils.getBidis());
        this.navigation.issue().gotoIssue(this.issueKey);
        this.tester.clickLink("edit-issue");
        this.tester.setFormElement(DESCRIPTION_ID, content);
        this.tester.submit("Update");
        this.tester.assertTextPresent(BidiUtils.getCodePanelWithUnescapedBidis() + BidiUtils.getNoFormatPanelWithUnescapedBidis());
    }

    public void _testRendererAlternativeViews() {
        this._testRendererRssView();
        this._testIssueNavigatorColumnView();
    }

    public void _testIssueNavigatorColumnView() {
        try {
            this.navigation.issue().gotoIssue(this.issueKey);
            this.tester.clickLink("edit-issue");
            this.tester.setFormElement(DESCRIPTION_ID, "{color:blue}blue functional test text{color}");
            this.tester.submit("Update");
            this.tester.assertTextPresent("<font color=\"blue\">blue functional test text</font>");
            this.backdoor.columnControl().addLoggedInUserColumns(Collections.singletonList(DESCRIPTION_ID));
            this.navigation.issueNavigator().displayAllIssues();
            this.tester.assertTextPresent("<font color=\"blue\">blue functional test text</font>");
        }
        finally {
            this.backdoor.columnControl().restoreLoggedInUserColumns();
        }
    }

    public void _testRendererRssView() {
        this.logger.log((Object)"--- begin testRendererRssView");
        try {
            this.navigation.issue().gotoIssue(this.issueKey);
            this.tester.clickLink("edit-issue");
            this.tester.setFormElement(DESCRIPTION_ID, "{color:blue}blue functional test text{color}");
            this.tester.submit("Update");
            this.tester.assertTextPresent("<font color=\"blue\">blue functional test text</font>");
            this.tester.clickLinkWithText("XML");
            this.tester.assertTextPresent("&lt;font color=&quot;blue&quot;&gt;blue functional test text&lt;/font&gt;");
        }
        finally {
            this.tester.beginAt("/secure/Dashboard.jspa");
        }
        try {
            this.tester.gotoPage("/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?jqlQuery=&tempMax=1000");
            this.tester.assertTextPresent("&lt;font color=&quot;blue&quot;&gt;blue functional test text&lt;/font&gt;");
        }
        finally {
            this.tester.beginAt("/secure/Dashboard.jspa");
        }
        this.logger.log((Object)"--- end   testRendererRssView");
    }

    public void _testRendererWithBulkOperations() {
        this._testBulkEditWithSameRendererType();
        this._testBulkOperationsWithDifferentRendererTypes();
    }

    public void _testBulkOperationsWithDifferentRendererTypes() {
        String otherProjectIssueKey = null;
        try {
            this.administration.fieldConfigurationSchemes().addFieldConfigurationScheme(CUSTOM_FIELD_CONFIGURATION_SCHEME, "random description");
            this.fieldLayoutSchemes.addFieldLayoutScheme(CUSTOM_FIELD_CONFIGURATION_SCHEME, "random description");
            this.administration.project().addProject(OTHER_PROJECT, OTHER_PROJECT_KEY, "admin");
            this.associatedSchemeWithConfiguration(CUSTOM_FIELD_CONFIGURATION_SCHEME, CUSTOM_FIELD_CONFIGURATION);
            this.fieldLayoutSchemes.associateFieldLayoutScheme(OTHER_PROJECT_KEY, CUSTOM_FIELD_CONFIGURATION_SCHEME);
            this.setFieldConfigurationFieldToRenderer(CUSTOM_FIELD_CONFIGURATION, "customfield_" + this.textAreaCustomFieldId, DEFAULT_TEXT_RENDERER);
            this.setFieldConfigurationFieldToRenderer(DEFAULT_FIELD_CONFIGURATION, "customfield_" + this.textAreaCustomFieldId, WIKI_STYLE_RENDERER);
            this.setFieldConfigurationFieldToRenderer(CUSTOM_FIELD_CONFIGURATION, "customfield_" + this.textCustomFieldId, DEFAULT_TEXT_RENDERER);
            this.setFieldConfigurationFieldToRenderer(DEFAULT_FIELD_CONFIGURATION, "customfield_" + this.textCustomFieldId, WIKI_STYLE_RENDERER);
            otherProjectIssueKey = this.backdoor.issues().createIssue(OTHER_PROJECT_KEY, "This is a test issue", "admin", "Major", "Bug").key();
            this.backdoor.issues().setIssueFields(otherProjectIssueKey, new IssueFields().environment("test environment").description("description for this is a test issue").customField(Long.decode(this.textAreaCustomFieldId), (Object)"testValue"));
            this._testBulkEditWithDifferentRendererTypes();
            this._testBulkMoveWithDifferentRendererTypes();
            if (otherProjectIssueKey != null) {
                this.navigation.issue().deleteIssue(otherProjectIssueKey);
            }
            if (this.administration.project().projectWithKeyExists(OTHER_PROJECT_KEY)) {
                this.fieldLayoutSchemes.associateWithDefaultFieldLayout(OTHER_PROJECT_KEY);
                this.administration.project().deleteProject(OTHER_PROJECT);
            }
            this.fieldLayoutSchemes.deleteFieldLayoutScheme(CUSTOM_FIELD_CONFIGURATION_SCHEME);
        }
        catch (Throwable throwable) {
            if (otherProjectIssueKey != null) {
                this.navigation.issue().deleteIssue(otherProjectIssueKey);
            }
            if (this.administration.project().projectWithKeyExists(OTHER_PROJECT_KEY)) {
                this.fieldLayoutSchemes.associateWithDefaultFieldLayout(OTHER_PROJECT_KEY);
                this.administration.project().deleteProject(OTHER_PROJECT);
            }
            this.fieldLayoutSchemes.deleteFieldLayoutScheme(CUSTOM_FIELD_CONFIGURATION_SCHEME);
            throw throwable;
        }
    }

    private void associatedSchemeWithConfiguration(String schemeName, String fieldConfigurationName) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_FIELDS);
        this.tester.clickLinkWithText(schemeName);
        this.tester.clickLink("edit_fieldlayoutschemeentity");
        this.tester.selectOption("fieldConfigurationId", fieldConfigurationName);
        this.tester.submit("Update");
    }

    public void _testBulkMoveWithDifferentRendererTypes() {
        this.logger.log((Object)"--- begin testBulkMoveWithDifferentRendererTypes");
        try {
            this.navigation.issueNavigator().displayAllIssues();
            this.bulkOperations.bulkChangeIncludeAllPages();
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.bulkOperations.bulkChangeChooseIssuesAll();
            this.bulkOperations.isStepChooseOperation();
            this.bulkOperations.chooseOperationBulkMove();
            this.navigation.issue().selectProject(PROJECT_DOG, this.projectId + "_1_pid");
            this.tester.checkCheckbox("sameAsBulkEditBean", this.projectId + "_1_");
            this.navigation.clickOnNext();
            this.tester.assertTextPresent("warning-Custom Field Text Area Field");
            this.tester.assertTextNotPresent("warning-Custom Field Text Field");
            this.bulkOperations.bulkChangeCancel();
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
        this.logger.log((Object)"--- end   testBulkMoveWithDifferentRendererTypes");
    }

    public void _testBulkEditWithDifferentRendererTypes() {
        this.logger.log((Object)"--- begin testBulkEditWithDifferentRendererTypes");
        try {
            this.navigation.issueNavigator().displayAllIssues();
            this.bulkOperations.bulkChangeIncludeAllPages();
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.bulkOperations.bulkChangeChooseIssuesAll();
            this.bulkOperations.isStepChooseOperation();
            this.bulkOperations.bulkChangeChooseOperationEdit();
            this.tester.assertTextPresent("This field has inconsistent renderer types for the project(s) of the selected issues.");
            this.bulkOperations.bulkChangeCancel();
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
        this.logger.log((Object)"--- end   testBulkEditWithDifferentRendererTypes");
    }

    public void _testBulkEditWithSameRendererType() {
        this.logger.log((Object)"--- begin testBulkEditWithSameRendererType");
        try {
            this.navigation.issueNavigator().displayAllIssues();
            this.bulkOperations.bulkChangeIncludeAllPages();
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.bulkOperations.bulkChangeChooseIssuesAll();
            this.bulkOperations.isStepChooseOperation();
            this.bulkOperations.bulkChangeChooseOperationEdit();
            this.validateWikiRendererForField("customfield_" + this.textAreaCustomFieldId, CUSTOM_FIELD_NAME_TEXT_AREA_FIELD, this.issueKey);
            this.validateWikiRendererForField("customfield_" + this.textCustomFieldId, CUSTOM_FIELD_NAME_TEXT_FIELD, this.issueKey);
            this.bulkOperations.bulkChangeCancel();
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
        this.logger.log((Object)"--- end   testBulkEditWithSameRendererType");
    }

    private void _testRendererPluginConfiguration() {
        this._testTextRendererDoesNotAllowDisable();
        this._testWikiRendererDisabled();
        this._testWikiRendererMacroDisabled();
    }

    public void _testWikiRendererMacroDisabled() {
        this.logger.log((Object)"--- begin testWikiRendererMacroDisabled");
        try {
            this.navigation.issue().gotoIssue(this.issueKey);
            this.tester.clickLink("edit-issue");
            this.tester.setFormElement(DESCRIPTION_ID, "{color:blue}blue functional test text{color}");
            this.tester.submit("Update");
            this.tester.assertTextPresent("<font color=\"blue\">blue functional test text</font>");
            this.administration.plugins().disablePluginModule("com.atlassian.jira.plugin.system.renderers.wiki.macros", "com.atlassian.jira.plugin.system.renderers.wiki.macros:color");
            this.navigation.issue().gotoIssue(this.issueKey);
            this.tester.assertTextPresent("{color:blue}blue functional test text{color}");
        }
        finally {
            this.administration.plugins().enablePluginModule("com.atlassian.jira.plugin.system.renderers.wiki.macros", "com.atlassian.jira.plugin.system.renderers.wiki.macros:color");
        }
        this.logger.log((Object)"--- end   testWikiRendererMacroDisabled");
    }

    public void _testTextRendererDoesNotAllowDisable() {
        this.logger.log((Object)"--- begin _testTextRendererDoesNotAllowDisable");
        Assert.assertFalse((boolean)this.administration.plugins().canDisablePluginModule("com.atlassian.jira.plugin.system.jirarenderers", "com.atlassian.jira.plugin.system.jirarenderers:jira-text-renderer"));
        this.logger.log((Object)"--- end   _testTextRendererDoesNotAllowDisable");
    }

    public void _testWikiRendererDisabled() {
        this.logger.log((Object)"--- begin testWikiRendererDisabled");
        this.administration.plugins().disablePluginModule("com.atlassian.jira.plugin.system.jirarenderers", "com.atlassian.jira.plugin.system.jirarenderers:atlassian-wiki-renderer");
        this.navigation.issue().gotoIssue(this.issueKey);
        this.tester.clickLink("edit-issue");
        this.validateNoWikiRendererForField(DESCRIPTION_ID, "Description", this.issueKey);
        this.tester.assertTextPresent("This field is configured to use the \"atlassian-wiki-renderer\" which is not currently available, using \"Default Text Renderer\" instead.");
        this.administration.plugins().enablePluginModule("com.atlassian.jira.plugin.system.jirarenderers", "com.atlassian.jira.plugin.system.jirarenderers:atlassian-wiki-renderer");
        this.logger.log((Object)"--- end   testWikiRendererDisabled");
    }

    public void _testRendererConfiguration() {
        this._testRendererConfigurationWarningMessage();
        this._testRendererConfigurationChangeRendererType();
        this._testCustomLayoutRendererConfiguration();
    }

    public void _testCustomLayoutRendererConfiguration() {
        this.logger.log((Object)"--- begin testCustomLayoutRendererConfiguration");
        this.setFieldConfigurationFieldToRenderer(CUSTOM_FIELD_CONFIGURATION, DESCRIPTION_ID, WIKI_STYLE_RENDERER, true);
        this.setFieldConfigurationFieldToRenderer(CUSTOM_FIELD_CONFIGURATION, DESCRIPTION_ID, DEFAULT_TEXT_RENDERER, true);
        this.logger.log((Object)"--- end   testCustomLayoutRendererConfiguration");
    }

    public void _testRendererConfigurationChangeRendererType() {
        this.logger.log((Object)"--- begin testRendererConfigurationChangeRendererType");
        try {
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.setFieldConfigurationFieldToRenderer(DEFAULT_FIELD_CONFIGURATION, COMMENT_FIELD_ID, DEFAULT_TEXT_RENDERER);
            this.navigation.issue().gotoIssue(this.issueKey);
            this.validateNoWikiRendererForField(COMMENT_FIELD_ID, "Comment", this.issueKey);
            this.setFieldConfigurationFieldToRenderer(DEFAULT_FIELD_CONFIGURATION, COMMENT_FIELD_ID, WIKI_STYLE_RENDERER);
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
        this.logger.log((Object)"--- end   testRendererConfigurationChangeRendererType");
    }

    public void _testRendererConfigurationWarningMessage() {
        this.logger.log((Object)"--- begin testRendererConfigurationWarningMessage");
        this.gotoFieldLayoutConfiguration(DEFAULT_FIELD_CONFIGURATION);
        this.tester.clickLink("renderer_description");
        this.tester.assertTextPresent("Edit Field Renderer");
        this.tester.assertTextPresent("A renderer determines how the value of a field will be displayed within the system.");
        this.logger.log((Object)"--- end   testRendererConfigurationWarningMessage");
    }

    public void _testWikiPreview() {
        this.logger.log((Object)"--- begin testWikiPreview");
        try {
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.navigation.issue().gotoIssue(this.issueKey);
            this.tester.clickLink("edit-issue");
            this.tester.setFormElement(DESCRIPTION_ID, ":)");
            this.tester.clickLink("description-preview_link");
            this.tester.assertTextPresent("<p><img class=\"emoticon\" src=\"http://localhost:8080/images/icons/emoticons/smile.gif\" alt=\"\" align=\"middle\" border=\"0\" height=\"20\" width=\"20\"></p>");
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
        this.logger.log((Object)"--- end   testWikiPreview");
    }

    public void _testWikiRendererVisible() {
        this._testWikiRendererVisibleOnViewIssue();
        this._testWikiRendererVisibleOnEditIssue();
        this._testWikiRendererVisibleOnCreateIssue();
        this._testWikiRendererVisibleOnAssignIssue();
        this._testWikiRendererVisibleOnAttachFile();
        this._testWikiRendererVisibleOnLinkIssue();
    }

    public void _testWikiRendererVisibleOnLinkIssue() {
        this.logger.log((Object)"--- begin testWikiRendererVisibleOnLinkIssue");
        try {
            this.createIssueLinkType();
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.navigation.issue().gotoIssue(this.issueKey);
            this.tester.clickLink("link-issue");
            this.validateWikiRendererForField(COMMENT_FIELD_ID, "Comment", this.issueKey);
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
            this.administration.issueLinking().disable();
        }
        this.logger.log((Object)"--- end   testWikiRendererVisibleOnLinkIssue");
    }

    public void _testWikiRendererVisibleOnAssignIssue() {
        this.logger.log((Object)"--- begin testWikiRendererVisibleOnAttachFile");
        try {
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.navigation.issue().gotoIssue(this.issueKey);
            this.tester.clickLink("assign-issue");
            this.validateWikiRendererForField(COMMENT_FIELD_ID, "Comment", this.issueKey);
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
        this.logger.log((Object)"--- end   testWikiRendererVisibleOnAttachFile");
    }

    public void _testWikiRendererVisibleOnAttachFile() {
        this.logger.log((Object)"--- begin testWikiRendererVisibleOnAssignIssue");
        try {
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.navigation.issue().gotoIssue(this.issueKey);
            this.tester.clickLink("attach-file");
            this.validateWikiRendererForField(COMMENT_FIELD_ID, "Comment", this.issueKey);
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
        this.logger.log((Object)"--- end   testWikiRendererVisibleOnAssignIssue");
    }

    public void _testWikiRendererVisibleOnCreateIssue() {
        this.logger.log((Object)"--- begin testWikiRendererVisibleOnCreateIssue");
        try {
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.navigation.issue().goToCreateIssueForm(PROJECT_DOG, "Bug");
            this.tester.assertTextPresent("CreateIssueDetails.jspa");
            this.validateWikiRendererForField(DESCRIPTION_ID, "Description", "");
            this.validateWikiRendererForField(ENVIRONMENT_ID, "Environment", "");
            this.validateWikiRendererForField("customfield_" + this.textAreaCustomFieldId, CUSTOM_FIELD_NAME_TEXT_AREA_FIELD, "");
            this.validateWikiRendererForField("customfield_" + this.textCustomFieldId, CUSTOM_FIELD_NAME_TEXT_FIELD, "");
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
        this.logger.log((Object)"--- end   testWikiRendererVisibleOnCreateIssue");
    }

    public void _testWikiRendererVisibleOnEditIssue() {
        this.logger.log((Object)"--- begin testWikiRendererVisibleOnEditIssue");
        try {
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.navigation.issue().gotoIssue(this.issueKey);
            this.tester.clickLink("edit-issue");
            this.validateWikiRendererForField(COMMENT_FIELD_ID, "Comment", this.issueKey);
            this.validateWikiRendererForField(DESCRIPTION_ID, "Description", this.issueKey);
            this.validateWikiRendererForField(ENVIRONMENT_ID, "Environment", this.issueKey);
            this.validateWikiRendererForField("customfield_" + this.textAreaCustomFieldId, CUSTOM_FIELD_NAME_TEXT_AREA_FIELD, this.issueKey);
            this.validateWikiRendererForField("customfield_" + this.textCustomFieldId, CUSTOM_FIELD_NAME_TEXT_FIELD, this.issueKey);
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
        this.logger.log((Object)"--- end   testWikiRendererVisibleOnEditIssue");
    }

    public void _testWikiRendererVisibleOnViewIssue() {
        this.logger.log((Object)"--- begin testWikiRendererVisibleOnViewIssue");
        try {
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.navigation.issue().gotoIssue(this.issueKey);
            this.validateWikiRendererForField(COMMENT_FIELD_ID, "Comment", this.issueKey);
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
        this.logger.log((Object)"--- end   testWikiRendererVisibleOnViewIssue");
    }

    public void _testWikiRendererBadLink() {
        this.assertValidIssueDescription("[<b>testWikiRendererBadLink</b>|http://www.google.com/]", HTML_CODE);
        this.assertValidIssueDescription("[<b>testWikiRendererBadLink</b>]", HTML_CODE);
    }

    public void _testWikiRendererBadMacro() {
        this.assertValidIssueDescription("{code}<b>testWikiRendererBadLink</b>{code}", HTML_CODE);
        this.assertValidIssueDescription("{noSuchMacro}<b>testWikiRendererBadLink</b>{noSuchMacro}", HTML_CODE);
        try {
            this.administration.plugins().disablePluginModule("com.atlassian.jira.plugin.system.renderers.wiki.macros", "com.atlassian.jira.plugin.system.renderers.wiki.macros:color");
            this.assertValidIssueDescription("{color:orange}<b>testWikiRendererBadLink</b>{color:orange}", HTML_CODE);
        }
        finally {
            this.administration.plugins().enablePluginModule("com.atlassian.jira.plugin.system.renderers.wiki.macros", "com.atlassian.jira.plugin.system.renderers.wiki.macros:color");
        }
    }

    private void assertValidIssueDescription(String descriptionToEnter, String assertNotPresent) {
        String issueKey = this.backdoor.issues().createIssue(PROJECT_DOG_KEY, "testing cross site scripting", "admin", "Major", "Bug").key();
        this.backdoor.issues().setIssueFields(issueKey, new IssueFields().description(descriptionToEnter));
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.assertTextNotPresent(assertNotPresent);
    }

    private void createIssueLinkType() {
        this.administration.issueLinking().enable();
        this.tester.setFormElement("name", "Duplicate");
        this.tester.setFormElement("outward", "is a duplicate of");
        this.tester.setFormElement("inward", "duplicates");
        this.tester.submit();
    }

    private void validateNoWikiRendererForField(String field, String fieldDisplayName, String issueKey) {
        this.tester.assertTextNotPresent("<dd>" + field + "-preview_link</dd>");
        this.tester.assertTextNotPresent("<dd>" + fieldDisplayName + "</dd>");
        this.tester.assertTextNotPresent("<dd>" + issueKey + "</dd>");
    }

    private void validateWikiRendererForField(String field, String fieldDisplayName, String issueKey) {
        this.tester.assertTextPresent("<dd>" + field + "-preview_link</dd>");
        this.tester.assertTextPresent("<dd>" + fieldDisplayName + "</dd>");
        this.tester.assertTextPresent("<dd>" + issueKey + "</dd>");
    }

    public void setFieldConfigurationFieldToRenderer(String configuration, String fieldId, String renderer) {
        this.setFieldConfigurationFieldToRenderer(configuration, fieldId, renderer, false);
    }

    public void setFieldConfigurationFieldToRenderer(String configuration, String fieldId, String renderer, boolean assertWarningNotPresent) {
        this.gotoFieldLayoutConfiguration(configuration);
        this.tester.clickLink("renderer_" + fieldId);
        this.tester.assertTextPresent("Edit Field Renderer");
        this.tester.selectOption("selectedRendererType", renderer);
        if (assertWarningNotPresent) {
            this.tester.assertTextNotPresent("Changing the renderer will effect the display of all ");
        }
        this.tester.submit("Update");
        this.tester.assertTextPresent("Edit Field Renderer Confirmation");
        this.tester.assertTextPresent(renderer);
        this.tester.submit("Update");
        this.logger.log((Object)("Set " + fieldId + " to renderer type " + renderer + " in the " + configuration + " configuration."));
    }

    public void gotoFieldLayoutConfiguration(String configuration) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.FIELD_CONFIGURATION);
        this.tester.clickLink("configure-" + configuration);
        this.tester.assertTextPresent(configuration);
    }

    public void addFieldsToFieldScreen(String screenName, String[] fieldNames) {
        for (String fieldName : fieldNames) {
            this.backdoor.screens().addFieldToScreen(screenName, fieldName);
        }
    }
}

