/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.fields;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.FIELDS, Category.ISSUE_TYPES, Category.SCREENS})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestIssueTypeScreenScheme
extends BaseJiraFuncTest {
    @Test
    public void testAssociatingIssueTypeScreenSchemeToProject() {
        String ISSUE_TYPE_SCREEN_SCHEME_NAME = "New Issue Type Screen Type";
        Long newScreenId = this.backdoor.screens().copy("1", "name", "description");
        Long screenSchemeId = this.backdoor.screenSchemeControl().create("New Screen Scheme", newScreenId);
        Long issueTypeScreenSchemeId = this.backdoor.issueTypeScreenSchemes().createScheme("New Issue Type Screen Type", "description", screenSchemeId);
        this.backdoor.project().setIssueTypeScreenScheme(10001L, issueTypeScreenSchemeId);
        this.navigation.gotoPage(Navigation.AdminSection.ISSUE_TYPE_SCREEN_SCHEME.getUrl());
        String schemeName = this.tester.getDialog().getWebTableBySummaryOrId("issue-type-screen-schemes-table").getCellAsText(2, 0).trim();
        String projectList = this.tester.getDialog().getWebTableBySummaryOrId("issue-type-screen-schemes-table").getCellAsText(2, 1).trim();
        Assert.assertTrue((boolean)schemeName.contains("New Issue Type Screen Type"));
        Assert.assertTrue((boolean)projectList.contains("monkey"));
    }
}

