/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.fields;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.FIELDS})
@RestoreBlankInstance
public class TestLinkResolvers
extends BaseJiraFuncTest {
    private static final String RENDERER_ENDPOINT = "/rest/api/1.0/render";
    private static final String REQUEST_JSON_CONTENT = "{\"rendererType\":\"atlassian-wiki-renderer\",\"unrenderedMarkup\":\"[~root] \\n[~admin] \\n[~fred] \\n[~nonexisting] \\n[#anchor] \\n[#<img/>] \\n[MKY-1] \\n[NEP-1]\",\"forWysiwyg\":true,\"issueKey\":null}";
    private static final String ADMIN_PROFILE_LINK = "<a href=\"%JIRA_BASE_URL%/secure/ViewProfile.jspa?name=admin\" class=\"user-hover\" rel=\"admin\">Administrator</a> <br/>\n";
    private static final String FRED_LINK_PROFILE = "<a href=\"%JIRA_BASE_URL%/secure/ViewProfile.jspa?name=fred\" class=\"user-hover\" rel=\"fred\">Fred Normal</a> <br/>\n";
    private static final String HIDDEN_ADMIN_PROFILE_LINK = "<a href=\"%JIRA_BASE_URL%/secure/ViewProfile.jspa?name=admin\" class=\"user-hover\" rel=\"admin\">admin</a> <br/>\n";
    private static final String HIDDEN_FRED_LINK_PROFILE = "<a href=\"%JIRA_BASE_URL%/secure/ViewProfile.jspa?name=fred\" class=\"user-hover\" rel=\"fred\">fred</a> <br/>\n";
    private static final String LINK_TO_NOT_EXISTING_PROFILE = "<a href=\"%JIRA_BASE_URL%/secure/ViewProfile.jspa?name=nonexisting\" class=\"user-hover\" rel=\"nonexisting\">nonexisting</a> <br/>\n";
    private static final String LINK_TO_NOT_EXISTING_ROOT_PROFILE = "<p><a href=\"%JIRA_BASE_URL%/secure/ViewProfile.jspa?name=root\" class=\"user-hover\" rel=\"root\">root</a> <br/>\n";
    private static final String ERROR_FOR_NOT_EXISTING_PROFILE = "<span class=\"error\">&#91;~nonexisting&#93;</span> <br/>\n";
    private static final String ERROR_FOR_NOT_EXISTING_ROOT_PROFILE = "<p><span class=\"error\">&#91;~root&#93;</span> <br/>\n";
    private static final String ANCHOR_LINK = "<a href=\"#anchor\" target=\"_blank\" rel=\"noopener\">anchor</a> <br/>\n";
    private static final String ANCHOR_HTML_ESCAPED_LINK = "<a href=\"#&lt;img/&gt;\" target=\"_blank\" rel=\"noopener\">&lt;img/&gt;</a> <br/>\n";
    private static final String ISSUE_LINK = "<a href=\"%JIRA_BASE_URL%/browse/MKY-1\" title=\"Sample issue\" class=\"issue-link\" data-issue-key=\"MKY-1\">MKY-1</a> <br/>\n";
    private static final String ERROR_FOR_NOT_VISIBLE_ISSUE = "<span class=\"error\">&#91;MKY-1&#93;</span> <br/>\n";
    private static final String ERROR_FOR_NOT_EXISTING_ISSUE = "<span class=\"error\">&#91;NEP-1&#93;</span></p>";
    private static final String EXPECTED_RESPONSE_FOR_ADMIN = "<p><span class=\"error\">&#91;~root&#93;</span> <br/>\n<a href=\"%JIRA_BASE_URL%/secure/ViewProfile.jspa?name=admin\" class=\"user-hover\" rel=\"admin\">Administrator</a> <br/>\n<a href=\"%JIRA_BASE_URL%/secure/ViewProfile.jspa?name=fred\" class=\"user-hover\" rel=\"fred\">Fred Normal</a> <br/>\n<span class=\"error\">&#91;~nonexisting&#93;</span> <br/>\n<a href=\"#anchor\" target=\"_blank\" rel=\"noopener\">anchor</a> <br/>\n<a href=\"#&lt;img/&gt;\" target=\"_blank\" rel=\"noopener\">&lt;img/&gt;</a> <br/>\n<a href=\"%JIRA_BASE_URL%/browse/MKY-1\" title=\"Sample issue\" class=\"issue-link\" data-issue-key=\"MKY-1\">MKY-1</a> <br/>\n<span class=\"error\">&#91;NEP-1&#93;</span></p>";
    private static final String EXPECTED_RESPONSE_FOR_NORMAL_USER = "<p><a href=\"%JIRA_BASE_URL%/secure/ViewProfile.jspa?name=root\" class=\"user-hover\" rel=\"root\">root</a> <br/>\n<a href=\"%JIRA_BASE_URL%/secure/ViewProfile.jspa?name=admin\" class=\"user-hover\" rel=\"admin\">Administrator</a> <br/>\n<a href=\"%JIRA_BASE_URL%/secure/ViewProfile.jspa?name=fred\" class=\"user-hover\" rel=\"fred\">Fred Normal</a> <br/>\n<a href=\"%JIRA_BASE_URL%/secure/ViewProfile.jspa?name=nonexisting\" class=\"user-hover\" rel=\"nonexisting\">nonexisting</a> <br/>\n<a href=\"#anchor\" target=\"_blank\" rel=\"noopener\">anchor</a> <br/>\n<a href=\"#&lt;img/&gt;\" target=\"_blank\" rel=\"noopener\">&lt;img/&gt;</a> <br/>\n<a href=\"%JIRA_BASE_URL%/browse/MKY-1\" title=\"Sample issue\" class=\"issue-link\" data-issue-key=\"MKY-1\">MKY-1</a> <br/>\n<span class=\"error\">&#91;NEP-1&#93;</span></p>";
    private static final String EXPECTED_RESPONSE_FOR_ANONYMOUS = "<p><a href=\"%JIRA_BASE_URL%/secure/ViewProfile.jspa?name=root\" class=\"user-hover\" rel=\"root\">root</a> <br/>\n<a href=\"%JIRA_BASE_URL%/secure/ViewProfile.jspa?name=admin\" class=\"user-hover\" rel=\"admin\">admin</a> <br/>\n<a href=\"%JIRA_BASE_URL%/secure/ViewProfile.jspa?name=fred\" class=\"user-hover\" rel=\"fred\">fred</a> <br/>\n<a href=\"%JIRA_BASE_URL%/secure/ViewProfile.jspa?name=nonexisting\" class=\"user-hover\" rel=\"nonexisting\">nonexisting</a> <br/>\n<a href=\"#anchor\" target=\"_blank\" rel=\"noopener\">anchor</a> <br/>\n<a href=\"#&lt;img/&gt;\" target=\"_blank\" rel=\"noopener\">&lt;img/&gt;</a> <br/>\n<span class=\"error\">&#91;MKY-1&#93;</span> <br/>\n<span class=\"error\">&#91;NEP-1&#93;</span></p>";
    private HttpClient httpClient;
    private String rendererEndpointUrl;

    @Before
    public void setUp() {
        this.backdoor.issues().createIssue("MKY", "Sample issue");
        this.httpClient = new HttpClient();
        this.rendererEndpointUrl = this.environmentData.getBaseUrl().toString() + RENDERER_ENDPOINT;
    }

    @Test
    public void testLinkResolversForUserWithBrowseUsersPermission() throws IOException {
        this.httpClient.getParams().setAuthenticationPreemptive(true);
        this.httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        this.assertRendererReturnsExceptedHtml(EXPECTED_RESPONSE_FOR_ADMIN);
    }

    private void assertRendererReturnsExceptedHtml(String expectedResponse) throws IOException {
        PostMethod postMethod = new PostMethod(this.rendererEndpointUrl);
        postMethod.setRequestEntity((RequestEntity)new StringRequestEntity(REQUEST_JSON_CONTENT, "application/json", StandardCharsets.UTF_8.toString()));
        int resultCode = this.httpClient.executeMethod((HttpMethod)postMethod);
        String responseBody = postMethod.getResponseBodyAsString();
        Assert.assertEquals((long)200L, (long)resultCode);
        Assert.assertEquals((Object)this.populateBaseUrl(expectedResponse), (Object)responseBody);
    }

    private String populateBaseUrl(String response) {
        return response.replace("%JIRA_BASE_URL%", this.environmentData.getBaseUrl().toString());
    }

    @Test
    public void testLinkResolversForLoggedInUserWithoutBrowseUsersPermission() throws IOException {
        this.httpClient.getParams().setAuthenticationPreemptive(true);
        this.httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials("fred", "fred"));
        this.assertRendererReturnsExceptedHtml(EXPECTED_RESPONSE_FOR_NORMAL_USER);
    }

    @Test
    public void testLinkResolversForAnonymousUser() throws IOException {
        this.assertRendererReturnsExceptedHtml(EXPECTED_RESPONSE_FOR_ANONYMOUS);
    }
}

