/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.FuncTestRestClient;
import com.atlassian.jira.functest.framework.FunctTestConstants;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.Parser;
import com.atlassian.jira.functest.framework.admin.user.DeleteUserPage;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.parser.filter.FilterItem;
import com.atlassian.jira.functest.framework.parser.filter.FilterList;
import com.atlassian.jira.functest.framework.parser.filter.WebTestSharePermission;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.util.SlowTest;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.FILTERS})
public class TestFavouriteAndMyFilters
extends BaseJiraFuncTest {
    private static final String PAGE_NAVIGATION = ".aui-page-panel-nav > .vertical.tabs";
    private static final String DELETE_FILTER_PATH = "secure/DeleteFilter!default.jspa?filterId=";
    private static final String RETURN_URL_PARAM = "&returnUrl=ManageFilters.jspa";
    private static final String MANAGE_FILTERS = "secure/ManageFilters.jspa";
    private static final String FILTER_TABLE_XPATH = "//ul[@id='filter_type_table']/li";
    private static final String DELETE = "Delete";
    private static final String FAVOURITE = "Favourite";
    private static final String AUTHOR = "Author";
    private static final List<WebTestSharePermission> GLOBAL_SHARE = ImmutableList.of((Object)new WebTestSharePermission("global", null, null));
    private static final List<WebTestSharePermission> GROUP_DEVELOPERS_SHARE = ImmutableList.of((Object)new WebTestSharePermission("group", "jira-developers", null));
    private static final String JOE = "joe";
    private static final String ADMIN_LONG = "admin (admin)";
    private static final String JOE_LONG = "joe (joe)";
    private static final String NOBODY = "nobody";
    private static final String NOBODY_LONG = "nobody (nobody)";
    private static final List<String> NO_OPERATIONS = Collections.emptyList();
    private static final List<String> OPERATIONS = ImmutableList.of((Object)"Edit", (Object)"Delete");
    static final FilterItem FILTER_10000 = new FilterItem(10000L, "All", "", "admin (admin)", Collections.emptyList(), false, 1L, OPERATIONS, 0L);
    static final FilterItem FILTER_10001 = new FilterItem(10001L, "All My", "yadayada", "joe (joe)", GLOBAL_SHARE, true, 2L, OPERATIONS, 3L);
    static final FilterItem FILTER_10010 = new FilterItem(10010L, "Nick", "", "admin (admin)", GLOBAL_SHARE, false, 4L, OPERATIONS, 0L);
    static final FilterItem FILTER_10020 = new FilterItem(10020L, "New Features", "", "admin (admin)", GROUP_DEVELOPERS_SHARE, true, 0L, OPERATIONS, 1L);
    static final FilterItem FILTER_10030 = new FilterItem(10030L, "Nobody's All", "Yadyayda", "nobody (nobody)", Collections.emptyList(), true, 0L, OPERATIONS, 1L);
    static final FilterItem FILTER_10040 = new FilterItem(10040L, "Something", "Yadyayda", "admin (admin)", Collections.emptyList(), false, 0L, OPERATIONS, 0L);
    @Inject
    public FuncTestRestClient restRule;
    @Inject
    private Parser parse;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestDeleteUserForFiltersAndSubscriptions.xml");
        this.backdoor.darkFeatures().enableForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
    }

    @After
    public void cleanUp() {
        this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=9110000)
    public void testStickyTabs() {
        this.navigation.login("admin", "admin");
        this.tester.gotoPage(MANAGE_FILTERS);
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText(FILTER_TABLE_XPATH, FAVOURITE);
        this.navigation.manageFilters().myFilters();
        this.tester.assertTextPresent("My");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText(FILTER_TABLE_XPATH, "My");
        this.tester.gotoPage(MANAGE_FILTERS);
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText(FILTER_TABLE_XPATH, "My");
        this.navigation.manageFilters().goToDefault();
        this.tester.assertTextPresent(FAVOURITE);
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText(FILTER_TABLE_XPATH, FAVOURITE);
        this.tester.gotoPage(MANAGE_FILTERS);
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText(FILTER_TABLE_XPATH, FAVOURITE);
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=9110000)
    public void testOperations() {
        this.testInitAnonymousScreen();
        this.testInitNobodyScreen();
        this.testInitJoeScreen();
        this.testInitAdminScreen();
        this.administration.removeGlobalPermission(GlobalPermissionKey.CREATE_SHARED_OBJECTS, "jira-users");
        this.testInitAnonymousScreen();
        this.testInitAdminScreen();
        this.testInitNobodyScreen();
        this.navigation.login(JOE, JOE);
        this.navigation.manageFilters().goToDefault();
        FilterList filters = this.parse.filter().parseFilterList("mf_favourites");
        List<FilterItem> filterList = filters.getFilterItems();
        FilterItem filterItem = this.noFavCount(this.setSubCount(this.setFavCount(FILTER_10001, 3), 2));
        ImmutableList compareList = ImmutableList.of((Object)filterItem);
        Assert.assertEquals((Object)compareList, filterList);
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=9110000)
    public void testDeleteUser() {
        this.testInitAnonymousScreen();
        this.testInitAdminScreen();
        this.testInitJoeScreen();
        this.testInitNobodyScreen();
        this.navigation.login("admin", "admin");
        this.testDeleteConfirm("admin", 2, 0);
        this.testDeleteConfirm(JOE, 1, 1);
        this.testDeleteConfirm(NOBODY, 0, 0);
        this.tester.submit(DELETE);
        this.testJoeScreenAfterNobodyDelete();
        this.navigation.manageFilters().addFavourite(10010);
        this.testAdminScreenAfterNobodyDelete();
        this.testAnonymousScreenAfterNobodyDelete();
        this.navigation.login("admin", "admin");
        this.navigation.manageFilters().removeFavourite(10001);
        this.navigation.manageFilters().allFilters();
        FilterList filters = this.parse.filter().parseFilterList("mf_browse");
        ImmutableList compareList = ImmutableList.of((Object)this.setSubCount(this.setFavCount(this.noOps(this.makeNotFav(FILTER_10000)), 0), 1), (Object)this.setSubCount(this.setFavCount(this.noOps(this.makeNotFav(FILTER_10001)), 1), 2), (Object)this.setSubCount(this.setFavCount(this.noOps(FILTER_10020), 1), 0), (Object)this.setSubCount(this.setFavCount(this.noOps(FILTER_10010), 1), 4), (Object)this.setSubCount(this.setFavCount(this.noOps(FILTER_10040), 0), 0));
        Assert.assertEquals((Object)compareList, filters.getFilterItems());
        this.testDeleteConfirm(JOE, 1, 0);
        this.tester.submit(DELETE);
        this.testAdminScreenAfterJoeDelete();
        this.testAnonymousScreenAfterJoeDelete();
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=9110000)
    public void testDeleteFilter() {
        this.testInitAnonymousScreen();
        this.testInitAdminScreen();
        this.testInitJoeScreen();
        this.testInitNobodyScreen();
        this.testDeleteFilterPermission(10020L);
        this.navigation.login(NOBODY, NOBODY);
        this.testDeleteFilterPermission(10020L);
        this.navigation.login("admin", "admin");
        this.testDeleteFilterConfirm(10020L, 0L, 0L);
        this.navigation.login(JOE, JOE);
        this.testDeleteFilterConfirm(10001L, 2L, 2L);
        this.navigation.manageFilters().goToDefault();
        Assert.assertTrue((boolean)this.parse.filter().parseFilterList("mf_favourites").isEmpty());
        this.navigation.manageFilters().myFilters();
        Assert.assertTrue((boolean)this.parse.filter().parseFilterList("mf_owned").isEmpty());
        this.testDeleteFilterPermission(10000L);
        this.navigation.login("admin", "admin");
        this.navigation.manageFilters().goToDefault();
        this.textAssertions.assertTextNotPresent(this.locator.page(), "All My");
        this.navigation.logout();
        this.navigation.manageFilters().goToDefault();
        this.checkAnonymousScreen(Collections.singletonList(this.noAuthor(this.noOps(this.setSubCount(FILTER_10010, 0)))));
        this.navigation.login("admin", "admin");
        this.testDeleteFilterConfirm(10010L, 0L, 4L);
        this.checkAnonymousScreen(null);
        this.textAssertions.assertTextPresent(this.locator.page(), "Your search criteria did not match any filters.");
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=9110000)
    public void shouldNotShowDeleteButtonWhenFilterDeletionVerifierCheckIsInvalid() {
        this.testInitAdminScreen();
        this.tester.gotoPage("secure/DeleteFilter!default.jspa?filterId=10040&returnUrl=ManageFilters.jspa");
        this.tester.assertButtonNotPresent(DELETE);
    }

    @Test
    @SlowTest
    public void testRestEndpointWithLargeGroups() throws IOException, SAXException, JSONException {
        this.administration.restoreData("TestUserBrowser35kUsersTwoDirectories.xml");
        WebResponse webResponse = this.restRule.GET("rest/api/2/filter/favourite");
        Assert.assertEquals((long)webResponse.getResponseCode(), (long)200L);
        webResponse.getText();
        JSONArray array = new JSONArray(webResponse.getText());
        Assert.assertEquals((long)array.length(), (long)2L);
        MatcherAssert.assertThat((Object)ImmutableSet.of((Object)array.getJSONObject(0).getString("name"), (Object)array.getJSONObject(1).getString("name")), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"test", "test f"}));
    }

    private void testDeleteFilterPermission(long filterId) {
        this.tester.gotoPage(DELETE_FILTER_PATH + filterId);
        this.textAssertions.assertTextPresent(this.locator.page(), "You do not have permission to delete this filter or this filter may not exist.");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "Users who have nominated this filter as a favourite");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "Subscriptions attached to this filter");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "Deleting this filter will delete all the subscriptions");
        this.tester.assertButtonNotPresent(DELETE);
    }

    private void testDeleteFilterConfirm(long filterId, long favouriteCount, long subscriptionCount) {
        this.tester.gotoPage(DELETE_FILTER_PATH + filterId + RETURN_URL_PARAM);
        WebPageLocator webPageLocator = new WebPageLocator(this.tester);
        ArrayList<String> messages = new ArrayList<String>();
        if (subscriptionCount == 1L) {
            messages.add("This filter has a subscriber");
        } else if (subscriptionCount > 1L) {
            messages.add("This filter has " + subscriptionCount + " subscribers");
        } else {
            this.textAssertions.assertTextNotPresent(webPageLocator, "subscriber");
        }
        if (favouriteCount == 1L) {
            messages.add("This filter is marked by someone as a favourite");
        } else if (favouriteCount > 1L) {
            messages.add("This filter is marked by " + favouriteCount + " people as a favourite");
        } else {
            this.textAssertions.assertTextNotPresent(webPageLocator, "as a favourite");
        }
        if (!messages.isEmpty()) {
            this.textAssertions.assertTextSequence(webPageLocator, messages.toArray(new String[messages.size()]));
        }
        this.tester.submit(DELETE);
    }

    private void testDeleteConfirm(String user, int shared, int favs) {
        this.navigation.gotoAdmin();
        DeleteUserPage deleteUserPage = this.navigation.gotoPageWithParams(DeleteUserPage.class, DeleteUserPage.generateDeleteQueryParameters(user));
        MatcherAssert.assertThat((Object)deleteUserPage.getNumberFromWarningFieldNamed(DeleteUserPage.SHARED_FILTERS), (Matcher)Matchers.equalTo((Object)("" + shared)));
        MatcherAssert.assertThat((Object)deleteUserPage.getNumberFromWarningFieldNamedNoLink(DeleteUserPage.FAVORITED_FILTERS), (Matcher)Matchers.equalTo((Object)("" + favs)));
    }

    private void checkAnonymousScreen(List<FilterItem> expectedFilters) {
        this.navigation.logout();
        this.navigation.manageFilters().goToDefault();
        this.textAssertions.assertTextPresent(this.locator.css(PAGE_NAVIGATION), "Search");
        this.textAssertions.assertTextPresent(this.locator.css(PAGE_NAVIGATION), "Popular");
        this.textAssertions.assertTextNotPresent(this.locator.css(PAGE_NAVIGATION), FAVOURITE);
        this.textAssertions.assertTextNotPresent(this.locator.css(PAGE_NAVIGATION), "My");
        this.navigation.manageFilters().allFilters();
        FilterList filterList = this.parse.filter().parseFilterList("mf_browse");
        List<FilterItem> actualFilters = null;
        if (filterList != null) {
            actualFilters = filterList.getFilterItems();
        }
        Assert.assertEquals(expectedFilters, actualFilters);
        Assert.assertNull((Object)this.parse.filter().parseFilterList("mf_favourites"));
        Assert.assertNull((Object)this.parse.filter().parseFilterList("mf_owned"));
    }

    private void testInitAnonymousScreen() {
        ImmutableList compareList = ImmutableList.of((Object)this.noAuthor(this.noOps(this.makeNotFav(this.setSubCount(FILTER_10001, 0)))), (Object)this.noAuthor(this.noOps(this.setSubCount(FILTER_10010, 0))));
        this.checkAnonymousScreen((List<FilterItem>)compareList);
    }

    private void testAnonymousScreenAfterNobodyDelete() {
        ImmutableList compareList = ImmutableList.of((Object)this.noAuthor(this.noOps(this.makeNotFav(this.setFavCount(this.setSubCount(FILTER_10001, 0), 2)))), (Object)this.noAuthor(this.noOps(this.setFavCount(this.setSubCount(FILTER_10010, 0), 1))));
        this.checkAnonymousScreen((List<FilterItem>)compareList);
    }

    private void testAnonymousScreenAfterJoeDelete() {
        ImmutableList compareList = ImmutableList.of((Object)this.noAuthor(this.noOps(this.setFavCount(this.setSubCount(FILTER_10010, 0), 0))));
        this.checkAnonymousScreen((List<FilterItem>)compareList);
    }

    private void testInitNobodyScreen() {
        this.navigation.login(NOBODY, NOBODY);
        this.navigation.manageFilters().goToDefault();
        FilterList filters = this.parse.filter().parseFilterList("mf_favourites");
        List<FilterItem> filterList = filters.getFilterItems();
        ArrayList<FilterItem> compareList = new ArrayList<FilterItem>();
        compareList.add(this.noFavCount(this.setSubCount(this.noOps(FILTER_10001), 0)));
        compareList.add(this.noFavCount(FILTER_10030));
        Assert.assertEquals(compareList, filterList);
        this.navigation.manageFilters().myFilters();
        filters = this.parse.filter().parseFilterList("mf_owned");
        compareList = new ArrayList();
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10030)));
        Assert.assertEquals(compareList, filters.getFilterItems());
        this.navigation.manageFilters().allFilters();
        filters = this.parse.filter().parseFilterList("mf_browse");
        filterList = filters.getFilterItems();
        compareList = new ArrayList();
        compareList.add(this.setSubCount(this.noOps(FILTER_10001), 0));
        compareList.add(this.noOps(this.makeNotFav(FILTER_10020)));
        compareList.add(this.setSubCount(this.noOps(FILTER_10010), 2));
        compareList.add(this.noOps(FILTER_10030));
        Assert.assertEquals(compareList, filterList);
    }

    private FilterItem setSubCount(FilterItem filter, int count) {
        FilterItem filterItem1 = filter.cloneFilter();
        filterItem1.setSubscriptions(count);
        return filterItem1;
    }

    private FilterItem makeNotFav(FilterItem filter) {
        FilterItem filterItem1 = filter.cloneFilter();
        filterItem1.setFav(false);
        return filterItem1;
    }

    private FilterItem setFavCount(FilterItem filter, int count) {
        FilterItem item = filter.cloneFilter();
        item.setFavCount(count);
        return item;
    }

    private FilterItem noFavCount(FilterItem filter) {
        FilterItem item = filter.cloneFilter();
        item.setFavCount(0L);
        return item;
    }

    private FilterItem noOps(FilterItem filter) {
        FilterItem filterItem = filter.cloneFilter();
        filterItem.setOperations(NO_OPERATIONS);
        return filterItem;
    }

    private FilterItem noAuthor(FilterItem filter) {
        FilterItem filterItem = filter.cloneFilter();
        filterItem.setAuthor(null);
        return filterItem;
    }

    private void testInitJoeScreen() {
        this.navigation.login(JOE, JOE);
        this.navigation.manageFilters().goToDefault();
        FilterList filters = this.parse.filter().parseFilterList("mf_favourites");
        List<FilterItem> filterList = filters.getFilterItems();
        ArrayList<FilterItem> compareList = new ArrayList<FilterItem>();
        compareList.add(this.noFavCount(FILTER_10001));
        Assert.assertEquals(compareList, filterList);
        this.navigation.manageFilters().myFilters();
        filters = this.parse.filter().parseFilterList("mf_owned");
        filterList = filters.getFilterItems();
        compareList = new ArrayList();
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10001)));
        Assert.assertEquals(compareList, filterList);
        this.navigation.manageFilters().allFilters();
        filters = this.parse.filter().parseFilterList("mf_browse");
        filterList = filters.getFilterItems();
        compareList = new ArrayList();
        compareList.add(this.noOps(FILTER_10001));
        compareList.add(this.noOps(this.setSubCount(FILTER_10010, 2)));
        Assert.assertEquals(compareList, filterList);
    }

    private void testInitAdminScreen() {
        this.navigation.login("admin", "admin");
        this.navigation.manageFilters().goToDefault();
        FilterList filters = this.parse.filter().parseFilterList("mf_favourites");
        List<FilterItem> filterList = filters.getFilterItems();
        ArrayList<FilterItem> compareList = new ArrayList<FilterItem>();
        compareList.add(this.noFavCount(this.setSubCount(FILTER_10001, 2)));
        compareList.add(this.noFavCount(FILTER_10020));
        Assert.assertEquals(compareList, filterList);
        this.navigation.manageFilters().myFilters();
        filters = this.parse.filter().parseFilterList("mf_owned");
        Assert.assertFalse((boolean)filters.containsColumn(AUTHOR));
        filterList = filters.getFilterItems();
        compareList = new ArrayList();
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10000)));
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10020)));
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10010)));
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10040)));
        Assert.assertEquals(compareList, filterList);
        this.navigation.manageFilters().allFilters();
        filters = this.parse.filter().parseFilterList("mf_browse");
        filterList = filters.getFilterItems();
        compareList = new ArrayList();
        compareList.add(this.noOps(FILTER_10000));
        compareList.add(this.setSubCount(this.noOps(FILTER_10001), 2));
        compareList.add(this.noOps(FILTER_10020));
        compareList.add(this.noOps(FILTER_10010));
        compareList.add(this.noOps(FILTER_10040));
        Assert.assertEquals(compareList, filterList);
    }

    private void testAdminScreenAfterNobodyDelete() {
        this.navigation.login("admin", "admin");
        this.navigation.manageFilters().goToDefault();
        FilterList filters = this.parse.filter().parseFilterList("mf_favourites");
        List<FilterItem> filterList = filters.getFilterItems();
        ArrayList<FilterItem> compareList = new ArrayList<FilterItem>();
        compareList.add(this.noFavCount(this.setSubCount(FILTER_10001, 2)));
        compareList.add(this.noFavCount(FILTER_10020));
        Assert.assertEquals(compareList, filterList);
        this.navigation.manageFilters().myFilters();
        filters = this.parse.filter().parseFilterList("mf_owned");
        Assert.assertFalse((boolean)filters.containsColumn(AUTHOR));
        filterList = filters.getFilterItems();
        compareList = new ArrayList();
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10000)));
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10020)));
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10010)));
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10040)));
        Assert.assertEquals(compareList, filterList);
        this.navigation.manageFilters().allFilters();
        filters = this.parse.filter().parseFilterList("mf_browse");
        filterList = filters.getFilterItems();
        compareList = new ArrayList();
        compareList.add(this.noOps(FILTER_10000));
        compareList.add(this.setFavCount(this.setSubCount(this.noOps(FILTER_10001), 2), 2));
        compareList.add(this.noOps(FILTER_10020));
        compareList.add(this.setFavCount(this.noOps(FILTER_10010), 1));
        compareList.add(this.noOps(FILTER_10040));
        Assert.assertEquals(compareList, filterList);
    }

    private void testAdminScreenAfterJoeDelete() {
        this.navigation.login("admin", "admin");
        this.navigation.manageFilters().goToDefault();
        FilterList filters = this.parse.filter().parseFilterList("mf_favourites");
        List<FilterItem> filterList = filters.getFilterItems();
        ArrayList<FilterItem> compareList = new ArrayList<FilterItem>();
        compareList.add(this.noFavCount(FILTER_10020));
        Assert.assertEquals(compareList, filterList);
        this.navigation.manageFilters().myFilters();
        filters = this.parse.filter().parseFilterList("mf_owned");
        Assert.assertFalse((boolean)filters.containsColumn(AUTHOR));
        filterList = filters.getFilterItems();
        compareList = new ArrayList();
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10000)));
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10020)));
        compareList.add(this.noFavCount(this.setSubCount(this.noAuthor(FILTER_10010), 3)));
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10040)));
        Assert.assertEquals(compareList, filterList);
        this.navigation.manageFilters().allFilters();
        filters = this.parse.filter().parseFilterList("mf_browse");
        filterList = filters.getFilterItems();
        compareList = new ArrayList();
        compareList.add(this.noOps(FILTER_10000));
        compareList.add(this.noOps(FILTER_10020));
        compareList.add(this.noOps(this.setSubCount(FILTER_10010, 3)));
        compareList.add(this.noOps(FILTER_10040));
        Assert.assertEquals(compareList, filterList);
    }

    private void testJoeScreenAfterNobodyDelete() {
        this.navigation.login(JOE, JOE);
        this.navigation.manageFilters().goToDefault();
        FilterList filters = this.parse.filter().parseFilterList("mf_favourites");
        List<FilterItem> filterList = filters.getFilterItems();
        ArrayList<FilterItem> compareList = new ArrayList<FilterItem>();
        compareList.add(this.noFavCount(FILTER_10001));
        Assert.assertEquals(compareList, filterList);
        this.navigation.manageFilters().myFilters();
        filters = this.parse.filter().parseFilterList("mf_owned");
        filterList = filters.getFilterItems();
        compareList = new ArrayList();
        compareList.add(this.noFavCount(this.noAuthor(FILTER_10001)));
        Assert.assertEquals(compareList, filterList);
        this.navigation.manageFilters().allFilters();
        filters = this.parse.filter().parseFilterList("mf_browse");
        filterList = filters.getFilterItems();
        compareList = new ArrayList();
        compareList.add(this.setFavCount(this.noOps(FILTER_10001), 2));
        compareList.add(this.noOps(this.setSubCount(FILTER_10010, 2)));
        Assert.assertEquals(compareList, filterList);
    }
}

