/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.FILTERS})
@LoginAs(user="admin")
public class TestFilterHoldsItsSorting
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestFilterHoldsItsSorting.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    @Test
    public void testThatItHoldsItSorting() {
        this.navigation.issueNavigator().loadFilter(10000L);
        this.assertNavigatorKeyOrder(new String[]{"HSP-2", "HSP-4", "HSP-1", "HSP-3"});
        this.tester.gotoPage("issues/?jql=ORDER%20BY%20issuekey%20ASC");
        this.assertNavigatorKeyOrder(new String[]{"HSP-1", "HSP-2", "HSP-3", "HSP-4"});
        this.navigation.issueNavigator().loadFilter(10000L);
        this.assertNavigatorKeyOrder(new String[]{"HSP-2", "HSP-4", "HSP-1", "HSP-3"});
    }

    private void assertNavigatorKeyOrder(String[] issueKeys) {
        TableLocator tableLocator = new TableLocator(this.tester, "issuetable");
        for (int i = 0; i < issueKeys.length; ++i) {
            String key = issueKeys[i];
            Assert.assertTrue((boolean)this.contains(tableLocator.getTable().getCellAsText(i + 1, 1), key));
        }
    }

    private boolean contains(String cellAsText, String s) {
        return !StringUtils.isBlank((CharSequence)cellAsText) && cellAsText.contains(s);
    }
}

