/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.HttpUnitOptions;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
@LoginAs(user="admin")
public class TestFilterPageNavigation
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.restoreData("sharedfilters/SharedFiltersBase.xml");
        HttpUnitOptions.setScriptingEnabled((boolean)true);
    }

    public void tearDownTest() {
        HttpUnitOptions.setScriptingEnabled((boolean)false);
    }

    @Test
    public void testBasicNavigationPage() throws Exception {
        this.tester.gotoPage("secure/ManageFilters.jspa");
        this.tester.clickLink("edit_filter_10000");
        this.pressCancel();
        this.assertOnManageFiltersPage();
        this.tester.clickLink("edit_filter_10000");
        this.tester.setWorkingForm("edit-entity");
        this.tester.setFormElement("filterName", "Nothing in The Session Filter");
        this.tester.submit("Save");
        this.assertOnManageFiltersPage();
        this.tester.clickLink("edit_filter_10000");
        this.pressCancel();
        this.assertOnManageFiltersPage();
        this.tester.clickLink("edit_filter_10000");
        this.tester.setWorkingForm("edit-entity");
        this.tester.setFormElement("filterName", "Now Its In The Session Filter");
        this.tester.submit("Save");
        this.assertOnManageFiltersPage();
        this.tester.clickLink("filterlink_10000");
        this.tester.gotoPage("secure/EditFilter!default.jspa");
        this.pressCancel();
        this.assertOnIssueNavPage("Now Its In The Session Filter");
        this.tester.gotoPage("secure/EditFilter!default.jspa");
        this.tester.setWorkingForm("edit-entity");
        this.tester.setFormElement("filterName", "Now has New Name");
        this.tester.submit("Save");
        this.assertOnIssueNavPage("Now has New Name");
        this.tester.gotoPage("secure/ManageFilters.jspa");
        this.tester.clickLinkWithText("Delete");
        this.tester.clickLinkWithText("Cancel");
        this.assertOnManageFiltersPage();
    }

    @Test
    public void testEditValidationFailures() throws Exception {
        this.tester.gotoPage("secure/ManageFilters.jspa");
        this.tester.clickLink("edit_filter_10000");
        this.pressCancel();
        this.assertOnManageFiltersPage();
        this.tester.clickLink("edit_filter_10000");
        this.tester.setWorkingForm("edit-entity");
        this.tester.setFormElement("filterName", "");
        this.tester.submit("Save");
        this.pressCancel();
        this.assertOnManageFiltersPage();
        this.tester.clickLink("edit_filter_10000");
        this.pressCancel();
        this.assertOnManageFiltersPage();
        this.tester.clickLink("edit_filter_10000");
        this.tester.setWorkingForm("edit-entity");
        this.tester.setFormElement("filterName", "");
        this.tester.submit("Save");
        this.pressCancel();
        this.assertOnManageFiltersPage();
        this.tester.clickLink("edit_filter_10000");
        this.tester.setWorkingForm("edit-entity");
        this.tester.setFormElement("filterName", "Now Its In The Session Filter");
        this.tester.submit("Save");
        this.assertOnManageFiltersPage();
        this.tester.clickLink("filterlink_10000");
        this.tester.gotoPage("secure/EditFilter!default.jspa");
        this.pressCancel();
        this.assertOnIssueNavPage("Now Its In The Session Filter");
        this.tester.gotoPage("secure/EditFilter!default.jspa");
        this.tester.setWorkingForm("edit-entity");
        this.tester.setFormElement("filterName", "");
        this.tester.submit("Save");
        this.tester.setWorkingForm("edit-entity");
        this.tester.setFormElement("filterName", "Now has New Name");
        this.tester.submit("Save");
        this.assertOnIssueNavPage("Now has New Name");
    }

    private void assertOnIssueNavPage(String pageName) {
        this.tester.gotoPage("/rest/api/2/filter/10000");
        this.tester.assertTextPresent(pageName);
    }

    private void assertOnManageFiltersPage() {
        CssLocator mfLocator = new CssLocator(this.tester, "#content > header h1");
        Assert.assertEquals((Object)"Manage Filters", (Object)mfLocator.getText());
    }

    private void pressCancel() {
        Assert.assertTrue((String)"Scripting must be enabled in the HttpUnit for cancel to work correctly", (boolean)HttpUnitOptions.isScriptingEnabled());
        this.tester.setWorkingForm("edit-entity");
        this.tester.clickLink("edit-entity-cancel");
    }
}

