/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Parser;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.parser.filter.FilterItem;
import com.atlassian.jira.functest.framework.parser.filter.FilterList;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.dom.DomKit;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.webtests.ztests.filter.TestFavouriteAndMyFilters;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

@WebTest(value={Category.FUNC_TEST, Category.FILTERS})
@LoginAs(user="admin")
public class TestFilterPicker
extends BaseJiraFuncTest {
    private static final String SEARCH = "Search";
    private static final String POPULAR = "Popular";
    private static final String FAVOURITE = "Favourite";
    private static final String PROJECT_KEY_PROJECT_LEAD = "Project Key Project Lead";
    private static final String PARENTHESISED_ADMIN = " (admin)";
    private static final String CATEGORY = "Category";
    private static final String PROJECT = "Project";
    private static final String PROJECT_LEAD = "Project Lead";
    private static final String KEY = "Key";
    @Inject
    private Parser parse;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreBlankInstance();
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    @Test
    public void testNoSearchYet() {
        this.navigation.filterPickerPopup().searchFilters();
        this.navigation.filterPickerPopup().findFilters("zz");
        this.tester.assertTextPresent("Your search criteria did not match any filters.");
    }

    @Test
    public void testTabStickinessNotStandard() {
        this.navigation.filterPickerPopup().goToDefault();
        this.assertTabState(SEARCH, POPULAR, FAVOURITE);
        this.navigation.manageFilters().goToDefault();
        this.backdoor.filters().createFilter("", "Vic 20", true);
        this.navigation.filterPickerPopup().goToDefault();
        this.assertTabState(FAVOURITE, SEARCH, POPULAR);
        this.navigation.filterPickerPopup().popularFilters();
        this.assertTabState(POPULAR, FAVOURITE, SEARCH);
        this.navigation.filterPickerPopup().searchFilters();
        this.assertTabState(SEARCH, POPULAR, FAVOURITE);
        this.assertTabNavigation(SEARCH, FAVOURITE, POPULAR);
        this.assertTabNavigation(FAVOURITE, POPULAR, SEARCH);
        this.assertTabNavigation(POPULAR, SEARCH, FAVOURITE);
        this.assertTabNavigation(SEARCH, POPULAR, FAVOURITE);
        this.assertTabNavigation(POPULAR, FAVOURITE, SEARCH);
        this.assertTabNavigation(FAVOURITE, SEARCH, POPULAR);
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=9110000)
    public void testFilterViews() {
        this.administration.restoreData("TestDeleteUserForFiltersAndSubscriptions.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.login("admin", "admin");
        this.navigation.filterPickerPopup().goToDefault();
        List<FilterItem> expectedFavourites = this.navigation.filterPickerPopup().sanitiseFavouriteFilterItems((List<FilterItem>)ImmutableList.of((Object)TestFavouriteAndMyFilters.FILTER_10001, (Object)TestFavouriteAndMyFilters.FILTER_10020));
        FilterList filters = this.parse.filter().parseFilterList("mf_favourites");
        List<FilterItem> filterList = filters.getFilterItems();
        Assert.assertEquals(expectedFavourites, filterList);
        this.navigation.filterPickerPopup().popularFilters();
        List<FilterItem> expectedPopulars = this.navigation.filterPickerPopup().sanitiseSearchFilterItems((List<FilterItem>)ImmutableList.of((Object)TestFavouriteAndMyFilters.FILTER_10001, (Object)TestFavouriteAndMyFilters.FILTER_10020, (Object)TestFavouriteAndMyFilters.FILTER_10000, (Object)TestFavouriteAndMyFilters.FILTER_10010, (Object)TestFavouriteAndMyFilters.FILTER_10040));
        filters = this.parse.filter().parseFilterList("mf_popular");
        filterList = filters.getFilterItems();
        Assert.assertEquals(expectedPopulars, filterList);
        List<FilterItem> compareList = this.navigation.filterPickerPopup().sanitiseSearchFilterItems((List<FilterItem>)ImmutableList.of((Object)TestFavouriteAndMyFilters.FILTER_10000, (Object)TestFavouriteAndMyFilters.FILTER_10001, (Object)TestFavouriteAndMyFilters.FILTER_10020, (Object)TestFavouriteAndMyFilters.FILTER_10010, (Object)TestFavouriteAndMyFilters.FILTER_10040));
        this.navigation.filterPickerPopup().allFilters();
        filters = this.parse.filter().parseFilterList("mf_browse");
        filterList = filters.getFilterItems();
        Assert.assertEquals(compareList, filterList);
    }

    private void assertTabNavigation(String currentlyOnTab, String navigateToTab, String notOnTab) {
        this.assertTabState(currentlyOnTab, navigateToTab, notOnTab);
        this.tester.clickLinkWithText(navigateToTab);
        this.assertTabState(navigateToTab, currentlyOnTab, notOnTab);
    }

    @Test
    public void testNoOperationsColumnsPresent() {
        this.navigation.manageFilters().goToDefault();
        this.backdoor.filters().createFilter("", "metafilter", true);
        this.navigation.filterPickerPopup().goToDefault();
        this.tester.assertTextInElement("jira", "metafilter");
        this.tester.assertTextNotInElement("jira", "Operations");
        this.tester.assertTextNotInElement("jira", "Subscriptions");
        this.tester.assertTextNotInElement("jira", "Edit");
        this.tester.assertTextNotInElement("jira", "Delete");
        this.tester.assertTextNotInElement("jira", "Columns");
    }

    @Test
    public void testAnonymousUser() {
        this.navigation.logout();
        this.navigation.filterPickerPopup().goToDefault();
        this.tester.assertTextPresent("emember my login on this computer");
        this.tester.assertTextPresent("sername");
        this.tester.assertTextPresent("assword");
        this.tester.assertTextPresent("Log In");
    }

    private void assertTabState(String onTab, String notOn1, String notOn2) {
        this.tester.assertTextPresent(onTab);
        this.tester.assertLinkNotPresentWithText(onTab);
        this.tester.assertLinkPresentWithText(notOn1);
        this.tester.assertLinkPresentWithText(notOn2);
        this.tester.assertTextNotInElement("jira", "My");
    }

    @Test
    public void testProjectTabNonEnterprise() {
        this.navigation.filterPickerPopup().projects();
        String[] expectedNoCatRows = new String[]{PROJECT_KEY_PROJECT_LEAD, "homosapien project for homosapiens HSP Administrator (admin)", "monkey project for monkeys MKY Administrator (admin)"};
        this.assertTableRows(expectedNoCatRows, "//table[@id='nocat_projects']//tr");
        this.tester.assertTextNotInElement("jira", CATEGORY);
    }

    @Test
    public void testProjectTabCategories() {
        this.administration.restoreData("TestFilterPickerManyProjectsInCategories.xml");
        this.navigation.filterPickerPopup().projects();
        WebPageLocator pageLocator = new WebPageLocator(this.tester);
        this.textAssertions.assertTextSequence(pageLocator.getHTML(), new String[]{"Projects", CATEGORY, ":", "sideview", PROJECT, KEY, PROJECT_LEAD, CATEGORY, ":", "topdown", PROJECT, KEY, PROJECT_LEAD, PROJECT, KEY, PROJECT_LEAD});
        String[] expectedSideViewRows = new String[]{"Category : sideview", PROJECT_KEY_PROJECT_LEAD, "Dig Dug DIG Administrator (admin)", "Moon Patrol Jump your six-wheeled buggy over ditches & rocks and shoot stuff for points. MNP Administrator (admin)", "Space Invaders SPV Administrator (admin)"};
        this.assertTableRows(expectedSideViewRows, "//table[@id='cat_10011_projects']//tr");
        String[] expectedTopDownRows = new String[]{"Category : topdown", PROJECT_KEY_PROJECT_LEAD, "Ladybug LDB Administrator (admin)", "Pacman Eat power pills. PAC Administrator (admin)"};
        this.assertTableRows(expectedTopDownRows, "//table[@id='cat_10010_projects']//tr");
        String[] expectedNoCatRows = new String[]{PROJECT_KEY_PROJECT_LEAD, "Star Wars classic vector game STAR Administrator (admin)"};
        this.assertTableRows(expectedNoCatRows, "//table[@id='nocat_projects']//tr");
        XPathLocator cancelButtonLocator = new XPathLocator(this.tester, "//button[@onclick='window.close();']");
        Assert.assertEquals((Object)"Cancel", (Object)((Text)cancelButtonLocator.getNode().getFirstChild()).getData());
    }

    @Test
    public void testNoProjects() {
        this.administration.restoreData("EmptyJira.xml");
        this.navigation.filterPickerPopup().projects();
        this.tester.assertTextNotInElement("jira", "AMIGO");
        this.tester.assertTextNotInElement("jira", CATEGORY);
        this.tester.assertTextPresent("You don't have any projects yet");
    }

    private void assertTableRows(String[] expectedRows, String xpathToTableRows) {
        XPathLocator rows = new XPathLocator(this.tester, xpathToTableRows);
        Node[] nodes = rows.getNodes();
        this.assertNodesAsText(expectedRows, nodes);
    }

    private void assertNodesAsText(String[] strings, Node[] trs) {
        for (int i = 0; i < strings.length; ++i) {
            if (i >= trs.length) {
                Assert.fail((String)("ran out of nodes to check at position " + i));
            }
            Assert.assertEquals((Object)strings[i], (Object)DomKit.getCollapsedText(trs[i]));
        }
        if (trs.length > strings.length) {
            Assert.fail((String)"leftover nodes");
        }
    }
}

