/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Parser;
import com.atlassian.jira.functest.framework.admin.user.DeleteUserPage;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.navigation.FilterNavigation;
import com.atlassian.jira.functest.framework.parser.filter.FilterItem;
import com.atlassian.jira.functest.framework.parser.filter.FilterList;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.List;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.FILTERS})
@LoginAs(user="admin")
public class TestFilterRelatedEntitiesDelete
extends BaseJiraFuncTest {
    @Inject
    private Parser parse;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreData("sharedfilters/TestFilterRelatedEntitiesDelete.xml");
    }

    @Test
    public void testEntityDelete() {
        FilterNavigation filterNavigation = this.navigation.manageFilters();
        this.tester.gotoPage("secure/admin/user/DeleteGroup!default.jspa?name=group_delete_me");
        this.tester.submit("Delete");
        filterNavigation.myFilters();
        FilterList filterList = this.parse.filter().parseFilterList("mf_owned");
        this.assertFilterSharingIsPrivate(filterList, "shared with group");
        this.tester.gotoPage("secure/project/DeleteProjectRole!default.jspa?id=10003");
        this.textAssertions.assertTextPresent(new WebPageLocator(this.tester), "role_delete_me");
        this.tester.submit("Delete");
        filterNavigation.myFilters();
        filterList = this.parse.filter().parseFilterList("mf_owned");
        this.assertFilterSharingIsPrivate(filterList, "shared  with project role");
        this.administration.project().deleteProject(10001L);
        filterNavigation.myFilters();
        filterList = this.parse.filter().parseFilterList("mf_owned");
        this.assertFilterSharingIsPrivate(filterList, "shared with project");
    }

    @Test
    public void testUserDelete() throws Exception {
        FilterNavigation filterNavigation = this.navigation.manageFilters();
        filterNavigation.goToDefault();
        this.assertFilterIsInList(this.parse.filter().parseFilterList("mf_favourites"), "shared by user_can_share_filters");
        this.navigation.gotoAdmin();
        DeleteUserPage deleteUserPage = this.navigation.gotoPageWithParams(DeleteUserPage.class, DeleteUserPage.generateDeleteQueryParameters("user_can_share_filters"));
        deleteUserPage.clickDeleteUser();
        filterNavigation.goToDefault();
        this.assertFilterIsNotInList(this.parse.filter().parseFilterList("mf_favourites"), "shared by user_can_share_filters");
    }

    private void assertFilterSharingIsPrivate(FilterList filterList, String filterName) {
        List<FilterItem> filterItems = filterList.getFilterItems();
        for (FilterItem filterItem : filterItems) {
            String name = filterItem.getName();
            if (!name.equals(filterName)) continue;
            List sharing = filterItem.getSharing();
            Assert.assertEquals((long)0L, (long)sharing.size());
            return;
        }
        Assert.fail((String)("Couldnt find named fitler in list : " + filterName));
    }

    private void assertFilterIsNotInList(FilterList filterList, String filterName) {
        List<FilterItem> filterItems = filterList.getFilterItems();
        for (FilterItem filterItem : filterItems) {
            if (!filterItem.getName().equals(filterName)) continue;
            Assert.fail((String)("This filter '" + filterName + "' should not exist in the filter list"));
        }
    }

    private void assertFilterIsInList(FilterList filterList, String filterName) {
        List<FilterItem> filterItems = filterList.getFilterItems();
        for (FilterItem filterItem : filterItems) {
            if (!filterItem.getName().equals(filterName)) continue;
            return;
        }
        Assert.fail((String)("Failed to find filter in list : " + filterName));
    }
}

