/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.Parser;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.navigation.FilterNavigation;
import com.atlassian.jira.functest.framework.parser.filter.FilterItem;
import com.atlassian.jira.functest.framework.parser.filter.WebTestSharePermission;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.collections.Closure;
import org.apache.commons.lang3.StringUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.FILTERS})
public class TestSearchFilters
extends BaseJiraFuncTest {
    private static final String[] SORT_COL_NAMES = new String[]{"Name", "Popularity", "Owner"};
    private static final String[] SORT_COL_NAMES_ANONYMOUS = new String[]{"Name", "Popularity"};
    private static final String[] SORT_PARAM_VALUES = new String[]{"name", "favcount", "owner"};
    private static final int[] SORT_TD_OFFSETS = new int[]{1, 5, 2};
    private static final int[] SORT_TD_OFFSETS_ANONYMOUS = new int[]{1, 4};
    private static final boolean[] SORT_DEFAULT_SORTING = new boolean[]{true, false, true};
    private static final Logger log = LoggerFactory.getLogger(TestSearchFilters.class);
    private static final int DEV_ID_1 = 10040;
    private static final List<WebTestSharePermission> GLOBAL_SHARE = ImmutableList.of((Object)new WebTestSharePermission("global", null, null));
    private static final String DEVELOPER_THE_GREAT = "developer the great and wise (developer)";
    private static final String ADMINISTRATOR_ADMIN = "Administrator (admin)";
    private static final String SEARCH_TABLE_ID = "mf_browse";
    private static final DecimalFormat ZEROZERO_FORMAT = new DecimalFormat("00");
    private static final String PREVIOUS = "<< Previous";
    private static final String NEXT = "Next >>";
    private static final String DEVELOPER_FILTER = "developer filter";
    private List<FilterItem> expectedList;
    private List<FilterItem> actualList;
    private String currentUserName;
    private FilterNavigation[] filterNavigationScreen;
    @Inject
    private Parser parse;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.currentUserName = "admin";
        this.filterNavigationScreen = new FilterNavigation[]{this.navigation.manageFilters(), this.navigation.filterPickerPopup()};
    }

    @After
    public void tearDownTest() {
        this.currentUserName = null;
        this.actualList = null;
        this.expectedList = null;
        this.filterNavigationScreen = null;
    }

    @Test
    public void testInitialScreenAppearance() {
        for (FilterNavigation aFilterNavigationScreen : this.filterNavigationScreen) {
            this.testInitialScreenAppearance(aFilterNavigationScreen);
        }
    }

    @Test
    public void testNoSearchYet() {
        this.login(this.currentUserName);
        for (FilterNavigation aFilterNavigationScreen : this.filterNavigationScreen) {
            this.testNoSearchYet(aFilterNavigationScreen);
        }
    }

    @Test
    public void testBasicNameSearch() {
        for (FilterNavigation aFilterNavigationScreen : this.filterNavigationScreen) {
            this.testBasicNameSearch(aFilterNavigationScreen);
        }
    }

    @Test
    public void testBasicPaging() {
        for (FilterNavigation aFilterNavigationScreen : this.filterNavigationScreen) {
            this.testBasicPaging(aFilterNavigationScreen);
        }
    }

    @Test
    public void testMultiPageSort() throws Exception {
        for (FilterNavigation aFilterNavigationScreen : this.filterNavigationScreen) {
            this.testMultiPageSort(aFilterNavigationScreen);
        }
    }

    @Test
    public void testBasicSorting() {
        for (FilterNavigation aFilterNavigationScreen : this.filterNavigationScreen) {
            this.testBasicSorting(aFilterNavigationScreen);
        }
    }

    @Test
    public void testSortingByUserName() {
        for (FilterNavigation aFilterNavigationScreen : this.filterNavigationScreen) {
            this.testSortingByUserName(aFilterNavigationScreen);
        }
    }

    public void testInitialScreenAppearance(FilterNavigation filterNavigation) {
        this.administration.restoreData("BaseProfessionalFilters.xml");
        filterNavigation.searchFilters();
        this.assertInputSearchFormHasThisShape("");
        this.submitSimpleSearch("", filterNavigation);
        this.submitSimpleSearch("cat", filterNavigation);
        this.submitSimpleSearch("dog", filterNavigation);
    }

    public void testNoSearchYet(FilterNavigation filterNavigation) {
        this.administration.restoreBlankInstance();
        filterNavigation.searchFilters();
        this.submitSimpleSearch("zz", filterNavigation);
        this.tester.assertTextPresent("Your search criteria did not match any filters.");
    }

    @Test
    public void testXss() {
        for (FilterNavigation navigation : this.filterNavigationScreen) {
            this.testXss(navigation);
        }
    }

    @Test
    public void testOwnerInputVisibility() {
        this.administration.restoreData("BaseProfessionalFilters.xml");
        this.login(null);
        this.navigation.manageFilters().searchFilters();
        this.textAssertions.assertTextNotPresent(this.xPathLocator("//form[@id='filterSearchForm']"), "Owner");
        Assert.assertFalse((boolean)this.xPathLocator("//form[@id='filterSearchForm']//*[@name='searchOwnerUserName']").hasNodes());
        this.login("fred");
        this.navigation.manageFilters().searchFilters();
        this.textAssertions.assertTextNotPresent(this.xPathLocator("//form[@id='filterSearchForm']"), "Owner");
        Assert.assertFalse((boolean)this.xPathLocator("//form[@id='filterSearchForm']//*[@name='searchOwnerUserName']").hasNodes());
        this.login("admin");
        this.navigation.manageFilters().searchFilters();
        this.textAssertions.assertTextPresent(this.xPathLocator("//form[@id='filterSearchForm']"), "Owner");
        Assert.assertTrue((boolean)this.xPathLocator("//form[@id='filterSearchForm']//*[@name='searchOwnerUserName']").hasNodes());
    }

    public void testXss(FilterNavigation filterNavigation) {
        log.info("doing testXss with " + filterNavigation);
        this.navigation.gotoDashboard();
        this.administration.restoreData("BaseProfessionalFiltersWithXSS.xml");
        filterNavigation.searchFilters();
        String baseURL = filterNavigation.getActionBaseUrl() + "?filterView=search&searchName=&searchOwnerUserName=&searchShareType=&groupShare=&projectShare=&roleShare=&Search=Search";
        String url = StringUtils.replace((String)baseURL, (String)"searchShareType=&", (String)"searchShareType=group&");
        url = StringUtils.replace((String)url, (String)"groupShare=&", (String)"groupShare=<script>alert('XSSGroup')</script>&");
        this.tester.gotoPage(url);
        this.actualList = this.parse.filter().parseFilterList(SEARCH_TABLE_ID).getFilterItems();
        List<Object> expectedFilters = Lists.newArrayList();
        WebTestSharePermission groupShare = new WebTestSharePermission("group", "<script>alert('XSSGroup')</script>", null);
        FilterItem groupFilterItem = new FilterItem(10040L, "xss group filter", "", ADMINISTRATOR_ADMIN, Collections.singletonList(groupShare), true, 0L, null, 1L);
        expectedFilters.add(groupFilterItem);
        expectedFilters = filterNavigation.sanitiseSearchFilterItems((List<FilterItem>)expectedFilters);
        this.assertions.assertEquals("Filter List is wrongo", expectedFilters, this.actualList);
        url = StringUtils.replace((String)baseURL, (String)"searchShareType=&", (String)"searchShareType=project&");
        url = StringUtils.replace((String)url, (String)"projectShare=&", (String)"projectShare=10000&");
        url = StringUtils.replace((String)url, (String)"roleShare=&", (String)"roleShare=10020&");
        this.tester.gotoPage(url);
        this.actualList = this.parse.filter().parseFilterList(SEARCH_TABLE_ID).getFilterItems();
        WebTestSharePermission roleShare = new WebTestSharePermission("project", "homosapien", "<script>alert('XSSRole')</script>");
        expectedFilters = Lists.newArrayList();
        FilterItem roleFilterItem = new FilterItem(10041L, "xss project role filter", "", ADMINISTRATOR_ADMIN, (List<WebTestSharePermission>)ImmutableList.of((Object)roleShare), true, 0L, null, 1L);
        expectedFilters.add(roleFilterItem);
        expectedFilters = filterNavigation.sanitiseSearchFilterItems(expectedFilters);
        this.assertions.assertEquals("Filter list is wrong", expectedFilters, this.actualList);
    }

    public void testBasicNameSearch(FilterNavigation filterNavigation) {
        this.administration.restoreData("BaseProfessionalFilters.xml");
        Closure basicNameSearchTest1 = userNameObj -> {
            this.login(userNameObj);
            this.navigation.manageFilters().searchFilters();
            this.submitSimpleSearch("z", filterNavigation);
            this.expectedList = ImmutableList.of((Object)this.newFI('z'));
            this.assertFilterItemLists();
            this.submitSimpleSearch("b", filterNavigation);
            this.expectedList = ImmutableList.of((Object)this.newFI('b'));
            this.assertFilterItemLists();
            this.submitSimpleSearch("the evil zurg", filterNavigation);
            this.assertInputSearchFormHasThisShape("the evil zurg");
            Assert.assertNull((String)"Should have found nothing", (Object)this.parse.filter().parseFilterList(SEARCH_TABLE_ID));
            this.submitSimpleSearch("b m w", filterNavigation);
            this.expectedList = ImmutableList.of((Object)this.newFI('b'), (Object)this.newFI('m'), (Object)this.newFI('w'));
            this.assertFilterItemLists();
        };
        basicNameSearchTest1.execute(null);
        basicNameSearchTest1.execute((Object)"admin");
        this.administration.restoreData("BaseProfessionalFiltersWithDeveloper.xml");
        AtomicBoolean favFlag = new AtomicBoolean(false);
        AtomicBoolean devFavFlag = new AtomicBoolean(false);
        Closure basicNameSearchTest2 = userNameObj -> {
            this.login(userNameObj);
            this.navigation.manageFilters().searchFilters();
            this.submitSimpleSearch("b d* m z", filterNavigation);
            boolean isFav = favFlag.get();
            boolean isDevFav = devFavFlag.get();
            this.expectedList = ImmutableList.of((Object)this.newFI('b').setFav(isFav), (Object)this.newFI('d').setFav(isFav), (Object)this.newFI(10040L, DEVELOPER_FILTER, DEVELOPER_THE_GREAT).setFav(isDevFav), (Object)this.newFI('m').setFav(isFav), (Object)this.newFI('z').setFav(isFav));
            this.assertFilterItemLists();
        };
        favFlag.set(false);
        devFavFlag.set(false);
        basicNameSearchTest2.execute(null);
        favFlag.set(false);
        devFavFlag.set(true);
        basicNameSearchTest2.execute((Object)"developer");
        favFlag.set(true);
        devFavFlag.set(false);
        basicNameSearchTest2.execute((Object)"admin");
    }

    public void testBasicPaging(FilterNavigation filterNavigation) {
        this.navigation.gotoDashboard();
        this.administration.restoreData("BaseProfessionalFilters.xml");
        Closure basicPagingTest = userNameObj -> {
            this.login(userNameObj);
            this.navigation.manageFilters().searchFilters();
            this.submitSimpleSearch("", filterNavigation);
            this.expectedList = this.buildExpectedList('a', 't');
            this.assertFilterItemLists();
            String pageURL = this.assertSinglePagingLinksPresent(1, 2, NEXT, "1 - 20 of 26", "");
            this.tester.gotoPage(pageURL);
            this.expectedList = this.buildExpectedList('u', 'z');
            this.assertFilterItemLists();
            pageURL = this.assertSinglePagingLinksPresent(0, 2, PREVIOUS, "21 - 26 of 26", "");
            this.tester.gotoPage(pageURL);
            this.expectedList = this.buildExpectedList('a', 't');
            this.assertFilterItemLists();
            pageURL = this.assertSinglePagingLinksPresent(1, 2, NEXT, "1 - 20 of 26", "");
            this.tester.gotoPage(pageURL);
            this.expectedList = this.buildExpectedList('u', 'z');
            this.assertFilterItemLists();
            this.assertSinglePagingLinksPresent(0, 2, PREVIOUS, "21 - 26 of 26", "");
        };
        basicPagingTest.execute(null);
        basicPagingTest.execute((Object)"admin");
    }

    public void testMultiPageSort(FilterNavigation filterNavigation) throws Exception {
        this.administration.restoreData("BaseProfessionalFiltersWithDeveloperZFilters.xml");
        Closure multiPageSortTest = userNameObj -> {
            this.login(userNameObj);
            this.navigation.manageFilters().searchFilters();
            this.submitSimpleSearch("", filterNavigation);
            this.expectedList = this.buildExpectedList('a', 't');
            this.assertFilterItemLists();
            this.assertSinglePagingLinksPresent(1, 2, NEXT, "1 - 20 of 45", "");
            this.tester.clickLinkWithText(NEXT);
            this.expectedList = this.buildExpectedList('u', 'z');
            this.addDeveloperZSeriesFilters(this.expectedList, 0, 13);
            this.assertFilterItemLists();
            this.assertDualPagingLinksPresent(2, 2, "21 - 40 of 45", "", "");
            this.tester.clickLinkWithText(NEXT);
            this.expectedList = Lists.newArrayList();
            this.addDeveloperZSeriesFilters(this.expectedList, 14, 18);
            this.assertFilterItemLists();
            this.assertSinglePagingLinksPresent(1, 2, PREVIOUS, "41 - 45 of 45", "");
            this.tester.clickLinkWithText(PREVIOUS);
            this.expectedList = this.buildExpectedList('u', 'z');
            this.addDeveloperZSeriesFilters(this.expectedList, 0, 13);
            this.assertFilterItemLists();
            this.assertDualPagingLinksPresent(2, 2, "21 - 40 of 45", "", "");
            this.tester.clickLinkWithText(PREVIOUS);
            this.expectedList = this.buildExpectedList('a', 't');
            this.assertFilterItemLists();
            this.assertSinglePagingLinksPresent(1, 2, NEXT, "1 - 20 of 45", "");
        };
        multiPageSortTest.execute(null);
        multiPageSortTest.execute((Object)"admin");
    }

    public void testBasicSorting(FilterNavigation filterNavigation) {
        this.navigation.gotoDashboard();
        this.administration.restoreData("BaseProfessionalFilters.xml");
        this.navigation.manageFilters().searchFilters();
        this.submitSimpleSearch("", filterNavigation);
        this.expectedList = this.buildExpectedList('a', 't');
        this.assertFilterItemLists();
        String sortURL = this.assertSortUrls("Name", false, "");
        Assert.assertNotNull((Object)sortURL);
        this.tester.gotoPage(sortURL);
        this.expectedList = this.buildExpectedList('z', 'g');
        this.assertFilterItemLists();
        sortURL = this.assertSortUrls("Name", true, "");
        Assert.assertNotNull((Object)sortURL);
        sortURL = this.getSortURL("Owner");
        Assert.assertNotNull((Object)sortURL);
        this.tester.gotoPage(sortURL);
        this.expectedList = this.buildExpectedList('a', 't');
        this.assertFilterItemLists();
        sortURL = this.assertSortUrls("Owner", false, "");
        Assert.assertNotNull((Object)sortURL);
        this.tester.gotoPage(sortURL);
        this.expectedList = this.buildExpectedList('a', 't');
        this.assertFilterItemLists();
        sortURL = this.assertSortUrls("Author", true, "");
        Assert.assertNotNull((Object)sortURL);
        sortURL = this.getSortURL("Popularity");
        Assert.assertNotNull((Object)sortURL);
        this.tester.gotoPage(sortURL);
        this.expectedList = this.buildExpectedList('a', 't');
        this.assertFilterItemLists();
        sortURL = this.assertSortUrls("Popularity", true, "");
        Assert.assertNotNull((Object)sortURL);
        this.tester.gotoPage(sortURL);
        this.expectedList = this.buildExpectedList('a', 't');
        this.assertFilterItemLists();
        sortURL = this.assertSortUrls("Popularity", false, "");
        Assert.assertNotNull((Object)sortURL);
        this.navigation.manageFilters().removeFavourite(this.getEntityId('a'));
        this.navigation.manageFilters().searchFilters();
        this.submitSimpleSearch("", filterNavigation);
        sortURL = this.getSortURL("Popularity");
        Assert.assertNotNull((Object)sortURL);
        this.tester.gotoPage(sortURL);
        this.tester.gotoPage(sortURL);
        this.expectedList = this.buildExpectedList('b', 'u');
        this.assertFilterItemLists();
        this.tester.clickLinkWithText(NEXT);
        ImmutableList suffixList = ImmutableList.of((Object)this.newFI('a').setFav(false).setFavCount(0L));
        this.expectedList = this.buildExpectedList(null, 'v', 'z', (List<FilterItem>)suffixList);
        this.assertFilterItemLists();
        this.tester.clickLinkWithText(PREVIOUS);
        this.expectedList = this.buildExpectedList('b', 'u');
        this.assertFilterItemLists();
        sortURL = this.getSortURL("Popularity");
        Assert.assertNotNull((Object)sortURL);
        this.tester.gotoPage(sortURL);
        ImmutableList prependList = ImmutableList.of((Object)this.newFI('a').setFav(false).setFavCount(0L));
        this.expectedList = this.buildExpectedList((List<FilterItem>)prependList, 'b', 't', null);
        this.assertFilterItemLists();
        this.tester.clickLinkWithText(NEXT);
        this.expectedList = this.buildExpectedList('u', 'z');
        this.assertFilterItemLists();
    }

    public void testSortingByUserName(FilterNavigation filterNavigation) {
        this.navigation.gotoDashboard();
        this.administration.restoreData("BaseProfessionalFiltersWithDeveloper.xml");
        Closure sortingByUserNameTest1 = userNameObj -> {
            this.login(userNameObj);
            this.navigation.manageFilters().searchFilters();
            this.submitSimpleSearch("", filterNavigation);
            FilterItem developerFI = this.newFI(10040L, DEVELOPER_FILTER, DEVELOPER_THE_GREAT).setFav(false);
            this.expectedList = this.buildExpectedList('a', 'd');
            this.expectedList.add(developerFI);
            this.expectedList.addAll(this.buildExpectedList('e', 's'));
            this.assertFilterItemLists();
            String sortURL = this.assertSortUrls("Name", false, "");
            Assert.assertNotNull((Object)sortURL);
            sortURL = this.getSortURL("Owner");
            this.tester.gotoPage(sortURL);
            this.expectedList = this.buildExpectedList('a', 't');
            this.assertFilterItemLists();
            this.tester.clickLinkWithText(NEXT);
            this.expectedList = this.buildExpectedList('u', 'z');
            this.expectedList.add(developerFI);
            this.assertFilterItemLists();
            sortURL = this.getSortURL("Owner");
            this.tester.gotoPage(sortURL);
            this.expectedList = Lists.newArrayList();
            this.expectedList.add(developerFI);
            this.expectedList.addAll(this.buildExpectedList('a', 's'));
            this.assertFilterItemLists();
        };
        sortingByUserNameTest1.execute((Object)"admin");
    }

    @Test
    public void testDummyXmlResponse() throws IOException, ParserConfigurationException, SAXException, TransformerException {
        this.administration.restoreData("TestSearchRequestURLHandler.xml");
        this.navigation.login("fred", "fred");
        String searchURL = "/sr/jira.issueviews:searchrequest-xml/10000/SearchRequest-10000.xml?tempMax=1000";
        this.tester.gotoPage(searchURL);
        String responseText = this.tester.getDialog().getResponseText();
        Document doc = XMLUnit.buildControlDocument((String)responseText);
        XMLAssert.assertXpathExists((String)"/rss/channel/build-info", (Document)doc);
        XMLAssert.assertXpathExists((String)"/rss/channel/build-info/version", (Document)doc);
        XMLAssert.assertXpathExists((String)"/rss/channel/build-info/build-number", (Document)doc);
        XMLAssert.assertXpathExists((String)"/rss/channel/build-info/build-date", (Document)doc);
    }

    private void assertDualPagingLinksPresent(int expectedNextPageOffset, int expectedLinks, String expectedXOfY, String searchName, String searchOwnerUserName) {
        int i;
        XPathLocator pageLocator = this.xPathLocator("//div[@class='pagination aui-item']/a/span[text() = 'Next >>']");
        Assert.assertEquals((long)expectedLinks, (long)pageLocator.getNodes().length);
        for (i = 0; i < expectedLinks; ++i) {
            Assert.assertEquals((Object)NEXT, (Object)pageLocator.getText(pageLocator.getNodes()[i]));
        }
        pageLocator = this.xPathLocator("//div[@class='pagination aui-item']/a/span[text() = '<< Previous']");
        Assert.assertEquals((long)expectedLinks, (long)pageLocator.getNodes().length);
        for (i = 0; i < expectedLinks; ++i) {
            Assert.assertEquals((Object)PREVIOUS, (Object)pageLocator.getText(pageLocator.getNodes()[i]));
        }
        pageLocator = this.xPathLocator("//div[@class='pagination aui-item']/span");
        Assert.assertEquals((long)expectedLinks, (long)pageLocator.getNodes().length);
        for (i = 0; i < expectedLinks; ++i) {
            String actualXOfY = pageLocator.getText(pageLocator.getNodes()[i]);
            Assert.assertEquals((Object)expectedXOfY, (Object)actualXOfY);
        }
        this.assertSortUrls("Name", false, searchName);
        pageLocator = this.xPathLocator("//div[@class='pagination aui-item']/a[contains(@class, 'icon-next')]/@href");
        Assert.assertEquals((long)expectedLinks, (long)pageLocator.getNodes().length);
        for (i = 0; i < expectedLinks; ++i) {
            String hrefUrl = pageLocator.getText(pageLocator.getNodes()[i]);
            Assert.assertNotNull((Object)hrefUrl);
            Assert.assertTrue((boolean)hrefUrl.contains("&filterView=search"));
            Assert.assertTrue((String)("Next URL does not have right page offset : " + expectedNextPageOffset), (boolean)hrefUrl.contains("&pagingOffset=" + expectedNextPageOffset));
            Assert.assertTrue((boolean)hrefUrl.contains("&pagingOffset=" + expectedNextPageOffset));
            Assert.assertTrue((boolean)hrefUrl.contains("&searchName=" + searchName + "&"));
            Assert.assertTrue((boolean)hrefUrl.contains("&searchOwnerUserName=" + searchOwnerUserName + "&"));
        }
        pageLocator = this.xPathLocator("//div[@class='pagination aui-item']/a[contains(@class, 'icon-previous')]/@href");
        Assert.assertEquals((long)expectedLinks, (long)pageLocator.getNodes().length);
        int expectedPrevOffset = expectedNextPageOffset - 2;
        for (int i2 = 0; i2 < expectedLinks; ++i2) {
            String hrefUrl = pageLocator.getText(pageLocator.getNodes()[i2]);
            Assert.assertNotNull((Object)hrefUrl);
            Assert.assertTrue((boolean)hrefUrl.contains("&filterView=search"));
            Assert.assertTrue((String)("Previous URL does not have right page offset : " + expectedPrevOffset), (boolean)hrefUrl.contains("&pagingOffset=" + expectedPrevOffset));
            Assert.assertTrue((boolean)hrefUrl.contains("&searchName=" + searchName + "&"));
            Assert.assertTrue((boolean)hrefUrl.contains("&searchOwnerUserName=" + searchOwnerUserName + "&"));
        }
    }

    private String assertSinglePagingLinksPresent(int expectedPageOffset, int expectedLinks, String expectedLinkText, String expectedXOfY, String searchName) {
        int i;
        String returnURL = "/this/will/fail/unless/it/changes";
        XPathLocator pageLocator = this.xPathLocator("//div[@class='pagination aui-item']//a");
        Assert.assertEquals((long)expectedLinks, (long)pageLocator.getNodes().length);
        for (i = 0; i < expectedLinks; ++i) {
            Assert.assertEquals((Object)expectedLinkText, (Object)pageLocator.getText(pageLocator.getNodes()[i]));
        }
        pageLocator = this.xPathLocator("//div[@class='pagination aui-item']/span");
        Assert.assertEquals((long)expectedLinks, (long)pageLocator.getNodes().length);
        for (i = 0; i < expectedLinks; ++i) {
            Assert.assertEquals((Object)expectedXOfY, (Object)pageLocator.getText(pageLocator.getNodes()[i]));
        }
        this.assertSortUrls("Name", false, searchName);
        pageLocator = this.xPathLocator("//div[@class='pagination aui-item']//a/@href");
        Assert.assertEquals((long)expectedLinks, (long)pageLocator.getNodes().length);
        for (i = 0; i < expectedLinks; ++i) {
            String hrefUrl;
            returnURL = hrefUrl = pageLocator.getText(pageLocator.getNodes()[i]);
            Assert.assertNotNull((Object)hrefUrl);
            Assert.assertTrue((boolean)hrefUrl.contains("&filterView=search"));
            Assert.assertTrue((String)("Does not have expected pagingOffset : " + expectedPageOffset), (boolean)hrefUrl.contains("&pagingOffset=" + expectedPageOffset));
            Assert.assertTrue((boolean)hrefUrl.contains("&searchName=" + searchName + "&"));
        }
        return returnURL;
    }

    private String getSortURL(String selectedColumnName) {
        int offset = 0;
        for (int i = 0; i < SORT_COL_NAMES.length; ++i) {
            if (!SORT_COL_NAMES[i].equalsIgnoreCase(selectedColumnName)) continue;
            offset = SORT_TD_OFFSETS[i];
            break;
        }
        XPathLocator colNameLocator = this.xPathLocator("//table[@id='mf_browse']/thead/tr/th[" + offset + "]/a");
        Assert.assertEquals((Object)selectedColumnName, (Object)colNameLocator.getText());
        return ((Element)colNameLocator.getNode()).getAttribute("href");
    }

    private String assertSortUrls(String selectedColumnName, boolean selectedSortAscending, String searchName) {
        int[] tdOffsets;
        String[] columnNames;
        String returnURL = "/this/will/fail/unless/set";
        if (this.currentUserName != null) {
            columnNames = SORT_COL_NAMES;
            tdOffsets = SORT_TD_OFFSETS;
        } else {
            columnNames = SORT_COL_NAMES_ANONYMOUS;
            tdOffsets = SORT_TD_OFFSETS_ANONYMOUS;
        }
        for (int i = 0; i < columnNames.length; ++i) {
            String columnName = columnNames[i];
            XPathLocator colNameLocator = this.xPathLocator("//table[@id='mf_browse']/thead/tr/th[" + tdOffsets[i] + "]/a");
            Assert.assertEquals((Object)columnName, (Object)colNameLocator.getText());
            String hrefUrl = ((Element)colNameLocator.getNode()).getAttribute("href");
            Assert.assertNotNull((Object)hrefUrl);
            this.textAssertions.assertTextPresent(hrefUrl, "filterView=search");
            this.textAssertions.assertTextPresent(hrefUrl, "pagingOffset=0");
            this.textAssertions.assertTextPresent(hrefUrl, "pagingOffset=0");
            this.textAssertions.assertTextPresent(hrefUrl, "searchName=" + searchName + "&");
            this.textAssertions.assertTextPresent(hrefUrl, "sortColumn=" + SORT_PARAM_VALUES[i]);
            if (columnName.equalsIgnoreCase(selectedColumnName)) {
                this.textAssertions.assertTextPresent(hrefUrl, "sortAscending=" + selectedSortAscending);
                returnURL = hrefUrl;
                continue;
            }
            this.textAssertions.assertTextPresent(hrefUrl, "sortAscending=" + SORT_DEFAULT_SORTING[i]);
        }
        return returnURL;
    }

    private List<FilterItem> buildExpectedList(char startC, char endCInclusive) {
        return this.buildExpectedList(null, startC, endCInclusive, null);
    }

    private List<FilterItem> buildExpectedList(List<FilterItem> prependList, char startC, char endCInclusive, List<FilterItem> suffixList) {
        ArrayList finalList = Lists.newArrayList();
        if (prependList != null) {
            finalList.addAll(prependList);
        }
        ArrayList expectedList = Lists.newArrayList();
        int sC = startC;
        int eC = endCInclusive;
        if (startC > endCInclusive) {
            sC = endCInclusive;
            eC = startC;
        }
        for (int i = sC; i <= eC; ++i) {
            expectedList.add(this.newFI((char)i));
        }
        if (startC > endCInclusive) {
            Collections.reverse(expectedList);
        }
        finalList.addAll(expectedList);
        if (suffixList != null) {
            finalList.addAll(suffixList);
        }
        return finalList;
    }

    private void submitSimpleSearch(String searchName, FilterNavigation filterNavigation) {
        filterNavigation.findFilters(searchName);
        this.assertInputSearchFormHasThisShape(searchName);
    }

    private void assertInputSearchFormHasThisShape(String searchName) {
        this.textAssertions.assertTextPresent(this.xPathLocator("//form[@id='filterSearchForm']"), "Search");
        Assert.assertTrue((boolean)this.xPathLocator("//form[@id='filterSearchForm']//input[@name='searchName']").hasNodes());
        Assert.assertEquals((Object)searchName, (Object)this.tester.getDialog().getFormParameterValue("searchName"));
        if (this.currentUserName != null) {
            this.textAssertions.assertTextPresent(this.xPathLocator("//form[@id='filterSearchForm']"), "Owner");
            Assert.assertTrue((boolean)this.xPathLocator("//form[@id='filterSearchForm']//*[@name='searchOwnerUserName']").hasNodes());
            Assert.assertTrue((boolean)this.xPathLocator("//form[@id='filterSearchForm']//select[@name='searchShareType']").hasNodes());
            Assert.assertTrue((boolean)this.xPathLocator("//form[@id='filterSearchForm']//select[@name='groupShare']").hasNodes());
            Assert.assertTrue((boolean)this.xPathLocator("//form[@id='filterSearchForm']//select[@name='projectShare']").hasNodes());
            Assert.assertTrue((boolean)this.xPathLocator("//form[@id='filterSearchForm']//select[@name='roleShare']").hasNodes());
        }
        Assert.assertTrue((String)"Submit button is present", (boolean)this.xPathLocator("//form[@id='filterSearchForm']//button[@name='Search'] | //form[@id='filterSearchForm']//input[@name='Search']").hasNodes());
    }

    private void assertFilterItemLists() {
        this.actualList = this.parse.filter().parseFilterList(SEARCH_TABLE_ID).getFilterItems();
        if (this.expectedList == null || this.actualList == null) {
            Assert.assertTrue((String)"If one filter list is null they both should be", (this.actualList == null && this.expectedList == null ? 1 : 0) != 0);
            return;
        }
        Assert.assertEquals((String)"The filter lists should have the same size", (long)this.expectedList.size(), (long)this.actualList.size());
        if (this.currentUserName == null) {
            for (FilterItem filterItem : this.expectedList) {
                filterItem.setNoAuthor();
                filterItem.setFav(false);
            }
        }
        int index = 0;
        for (FilterItem expectedFI : this.expectedList) {
            FilterItem actualFI = this.actualList.get(index++);
            Assert.assertEquals((String)"The FilterItems are not equal", (Object)expectedFI, (Object)actualFI);
        }
    }

    private int getEntityId(char filterName) {
        return 10005 + Math.abs(97 - filterName);
    }

    private XPathLocator xPathLocator(String xpathStr) {
        return new XPathLocator(this.tester, xpathStr);
    }

    private FilterItem newFI(long filterId, String filterName, String authorName) {
        return new FilterItem(filterId, filterName, "", authorName, GLOBAL_SHARE, Boolean.TRUE, 0L, null, 1L);
    }

    private FilterItem newFI(char filterName) {
        return this.newFI(filterName, ADMINISTRATOR_ADMIN, Boolean.TRUE);
    }

    private FilterItem newFI(char filterName, String authorName, Boolean isFavourited) {
        Long id = this.getEntityId(filterName);
        return new FilterItem(id, Character.toString(filterName), "", authorName, GLOBAL_SHARE, isFavourited, 0L, null, 1L);
    }

    private void addDeveloperZSeriesFilters(List<FilterItem> expectedList, int startFilterNum, int endFilterNumInclusive) {
        for (int i = startFilterNum; i <= endFilterNumInclusive; ++i) {
            String filterName = "z" + ZEROZERO_FORMAT.format(i);
            long id = 10040 + i;
            expectedList.add(this.newFI(id, filterName, DEVELOPER_THE_GREAT).setFav(false));
        }
    }

    private void login(Object userNameObj) {
        this.logout();
        if (userNameObj != null) {
            this.currentUserName = String.valueOf(userNameObj);
            this.navigation.login(this.currentUserName, this.currentUserName);
        }
    }

    private void logout() {
        this.navigation.logout();
        this.currentUserName = null;
    }
}

