/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter.edit;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.IssueTableAssertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.navigator.IssueTypeCondition;
import com.atlassian.jira.functest.framework.navigator.NavigatorSearch;
import com.atlassian.jira.functest.framework.navigator.NavigatorSearchBuilder;
import com.atlassian.jira.functest.framework.sharing.GroupTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.SharedEntityInfo;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermissionUtils;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.util.json.JSONException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Before;

@WebTest(value={Category.FUNC_TEST, Category.FILTERS})
@LoginAs(user="admin")
public abstract class TestEditFilter
extends BaseJiraFuncTest {
    private static final Pattern FILTER_PATTERN = Pattern.compile("filter=(\\d+)");
    static final String NO_SHARE_USER = "user_cant_share_filters";
    static final String SHARE_USER = "user_can_share_filters";
    static final int GROUP_FILTER_ID = 10020;
    static final SharedEntityInfo GROUP_FILTER_INFO = new SharedEntityInfo("Group Removed Search", "A search where the group share will be removed.", true, null);
    static final int PROJECT_FILTER_ID = 10021;
    static final SharedEntityInfo PROJECT_FILTER_INFO = new SharedEntityInfo("Browse permission Removed", "A search where the browse permission has been removed.", true, null);
    static final int ROLE_FILTER_ID = 10022;
    static final SharedEntityInfo ROLE_FILTER_INFO = new SharedEntityInfo("Remove From Role Filter", null, true, null);
    static final int REMOVE_FILTER_ID = 10023;
    static final SharedEntityInfo REMOVE_FILTER_INFO = new SharedEntityInfo("Remove Share Permission", null, true, null);
    static final int MULTIPLE_FILTER_ID = 10024;
    static final SharedEntityInfo MULTIPLE_FILTER_INFO = new SharedEntityInfo("Multiple Invalid Shares", null, true, null);
    static final long SHARED_FILTER_ID = 10030L;
    static final String EDITOR = "editor_by_jira_developers_group";
    static final NavigatorSearch SHARE_SEARCH;
    static final NavigatorSearch NOSHARE_SEARCH;
    static final GroupTestSharingPermission GROUP_SHARE;
    @Inject
    private IssueTableAssertions issueTableAssertions;
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;
    @Inject
    TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreData(this.getRestoreDataXmlName());
    }

    long editFilter(long id, String name, String description, boolean favourite, Set<? extends TestSharingPermission> permissions) {
        this.editFilterNoId(id, name, description, favourite, permissions);
        return this.getFilterIdAfterEdit();
    }

    long editFilter(long id, SharedEntityInfo info, Set<? extends TestSharingPermission> permissions) {
        return this.editFilter(id, info.getName(), info.getDescription(), info.isFavourite(), permissions);
    }

    void editFilterNoId(long id, SharedEntityInfo info, Set<? extends TestSharingPermission> permissions) {
        this.editFilterNoId(id, info.getName(), info.getDescription(), info.isFavourite(), permissions);
    }

    void editFilterNoId(long id, String name, String description, boolean favourite, Set<? extends TestSharingPermission> permissions) {
        this.tester.gotoPage(this.createEditUrl(id, name, description, favourite, permissions));
    }

    private String createEditUrl(long id, String name, String description, boolean favourite, Set<? extends TestSharingPermission> permissions) {
        StringBuilder buffer = new StringBuilder("secure/EditFilter.jspa?submit=Save&filterId=" + id);
        if (!StringUtils.isBlank((CharSequence)name)) {
            buffer.append("&filterName=").append(this.encode(name));
        }
        if (!StringUtils.isBlank((CharSequence)description)) {
            buffer.append("&filterDescription=").append(this.encode(description));
        }
        if (permissions != null) {
            buffer.append("&shareValues=").append(this.encode(TestSharingPermissionUtils.createJsonString(permissions)));
        }
        buffer.append("&favourite=").append(String.valueOf(favourite));
        return this.page.addXsrfToken(buffer.toString());
    }

    private String encode(String data) {
        try {
            return URLEncoder.encode(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private long getFilterIdAfterEdit() {
        URL url = this.tester.getDialog().getResponse().getURL();
        if (url.getQuery() == null) {
            Assert.fail((String)"Unable to save filter: Not redirected to navigator.");
        } else if (url.getPath() == null || !url.getPath().contains("/issues")) {
            Assert.fail((String)"Unable to save filter: Not redirected to navigator.");
        } else {
            Matcher matcher = FILTER_PATTERN.matcher(url.getQuery());
            if (matcher.find()) {
                return Long.parseLong(matcher.group(1));
            }
            Assert.fail((String)"Unable to save filter: Not redirected to navigator.");
        }
        return Long.MIN_VALUE;
    }

    void assertSearchEditCorrectly(long filter, String user, SharedEntityInfo info, NavigatorSearch expectedSearch, Set<? extends TestSharingPermission> expectedPermissions) {
        this.issueTableAssertions.assertSimpleSearch(user, filter, expectedSearch);
        this.issueTableAssertions.assertSearchInfo(filter, info);
        this.tester.gotoPage("secure/EditFilter!default.jspa");
        Assert.assertEquals((String)"Expected and actual permissions did not match.", expectedPermissions, this.parsePermissions());
    }

    void assertEditScreenCorrect(SharedEntityInfo expectedInfo, Set<? extends TestSharingPermission> expectedPermissions) {
        this.tester.assertFormElementEquals("filterName", expectedInfo.getName());
        this.tester.assertFormElementEquals("filterDescription", expectedInfo.getDescription());
        this.tester.assertFormElementEquals("favourite", String.valueOf(expectedInfo.isFavourite()));
        Assert.assertEquals(expectedPermissions, this.parsePermissions());
    }

    private Set<TestSharingPermission> parsePermissions() {
        XPathLocator xpath = new XPathLocator(this.tester, "//span[@id='shares_data_editors']");
        String value = xpath.getText();
        try {
            return TestSharingPermissionUtils.parsePermissions(value);
        }
        catch (JSONException e) {
            Assert.fail((String)("Unable to parse shares: " + e.getMessage()));
            return null;
        }
    }

    abstract String getRestoreDataXmlName();

    static {
        GROUP_SHARE = new GroupTestSharingPermission("jira-users");
        NavigatorSearchBuilder builder = new NavigatorSearchBuilder();
        builder.addIssueType(IssueTypeCondition.IssueType.BUG).addIssueType(IssueTypeCondition.IssueType.IMPROVEMENT);
        builder.addQueryString("SimpleTest");
        SHARE_SEARCH = builder.createSearch();
        builder = new NavigatorSearchBuilder();
        builder.addIssueType(IssueTypeCondition.IssueType.BUG).addProject("deleteme (DEL)");
        NOSHARE_SEARCH = builder.createSearch();
    }
}

