/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter.edit;

import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.sharing.GlobalTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.GroupTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.ProjectTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.SharedEntityInfo;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermission;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import com.atlassian.jira.webtests.ztests.filter.edit.TestEditFilter;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.FILTERS})
public class TestEditFilterInvalidShares
extends TestEditFilter {
    FeatureFlag SER_ALLOW_SHARE_WITH_NON_MEMBER = FeatureFlag.featureFlag((String)"com.atlassian.jira.serAllowShareWithNonMember");

    @Override
    String getRestoreDataXmlName() {
        return "sharedfilters/TestInvalidFilterSharing.xml";
    }

    @Test
    public void testEditFilterRemoveGroup() {
        try {
            this.backdoor.darkFeatures().disableForSite(this.SER_ALLOW_SHARE_WITH_NON_MEMBER);
            this.navigation.login("user_can_share_filters");
            this.navigation.issueNavigator().editFilter(10020L);
            this.textAssertions.assertRegexMatch(new WebPageLocator(this.tester), "Group\\: '.+'\\ does not exist, or you do not have permission to share it.");
            this.tester.submit("Save");
            this.textAssertions.assertRegexMatch(new WebPageLocator(this.tester), "Group\\: '.+'\\ does not exist, or you do not have permission to share it.");
            this.assertEditScreenCorrect(GROUP_FILTER_INFO, (Set<? extends TestSharingPermission>)ImmutableSet.of((Object)new GroupTestSharingPermission("group_delete_me")));
            long id = this.editFilter(10020L, GROUP_FILTER_INFO, Collections.emptySet());
            Assert.assertEquals((long)10020L, (long)id);
            this.assertSearchEditCorrectly(id, "user_can_share_filters", GROUP_FILTER_INFO, SHARE_SEARCH, Collections.emptySet());
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(this.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        }
    }

    @Test
    public void testEditFilterRemoveGroup_works() {
        try {
            this.backdoor.darkFeatures().enableForSite(this.SER_ALLOW_SHARE_WITH_NON_MEMBER);
            this.navigation.login("user_can_share_filters");
            this.navigation.issueNavigator().editFilter(10020L);
            this.textAssertions.assertRegexNoMatch(new WebPageLocator(this.tester), "You do not have permission to share with Group\\: '.+'\\.");
            this.tester.submit("Save");
            this.textAssertions.assertRegexNoMatch(new WebPageLocator(this.tester), "You do not have permission to share with Group\\: '.+'\\.");
            long id = this.editFilter(10020L, GROUP_FILTER_INFO, Collections.emptySet());
            Assert.assertEquals((long)10020L, (long)id);
            this.assertSearchEditCorrectly(id, "user_can_share_filters", GROUP_FILTER_INFO, SHARE_SEARCH, Collections.emptySet());
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(this.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEditFilterRemoveBrowse() {
        try {
            this.backdoor.darkFeatures().disableForSite(this.SER_ALLOW_SHARE_WITH_NON_MEMBER);
            this.navigation.login("user_can_share_filters");
            this.navigation.issueNavigator().editFilter(10021L);
            this.textAssertions.assertRegexMatch(new WebPageLocator(this.tester), "You do not have permission to share with Project: \\[Unknown Project\\].");
            this.tester.submit("Save");
            this.textAssertions.assertRegexMatch(new WebPageLocator(this.tester), "You do not have permission to share with Project: \\[Unknown Project\\].");
            this.assertEditScreenCorrect(PROJECT_FILTER_INFO, (Set<? extends TestSharingPermission>)ImmutableSet.of((Object)new ProjectTestSharingPermission(10002L)));
            ImmutableSet pub = ImmutableSet.of((Object)GlobalTestSharingPermission.GLOBAL_PERMISSION);
            long id = this.editFilter(10021L, PROJECT_FILTER_INFO, (Set<? extends TestSharingPermission>)pub);
            Assert.assertEquals((long)10021L, (long)id);
            this.assertSearchEditCorrectly(id, "user_can_share_filters", PROJECT_FILTER_INFO, SHARE_SEARCH, (Set<? extends TestSharingPermission>)pub);
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(this.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEditFilterRemoveBrowse_works() {
        try {
            this.backdoor.darkFeatures().enableForSite(this.SER_ALLOW_SHARE_WITH_NON_MEMBER);
            this.navigation.login("user_can_share_filters");
            this.navigation.issueNavigator().editFilter(10021L);
            this.textAssertions.assertRegexNoMatch(new WebPageLocator(this.tester), "You do not have permission to share with Project: \\[Unknown Project\\].");
            this.tester.submit("Save");
            this.textAssertions.assertRegexNoMatch(new WebPageLocator(this.tester), "You do not have permission to share with Project: \\[Unknown Project\\].");
            ImmutableSet pub = ImmutableSet.of((Object)GlobalTestSharingPermission.GLOBAL_PERMISSION);
            long id = this.editFilter(10021L, PROJECT_FILTER_INFO, (Set<? extends TestSharingPermission>)pub);
            Assert.assertEquals((long)10021L, (long)id);
            this.assertSearchEditCorrectly(id, "user_can_share_filters", PROJECT_FILTER_INFO, SHARE_SEARCH, (Set<? extends TestSharingPermission>)pub);
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(this.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEditFilterRemoveRole() {
        try {
            this.backdoor.darkFeatures().disableForSite(this.SER_ALLOW_SHARE_WITH_NON_MEMBER);
            HashSet<ProjectTestSharingPermission> rolePerms = new HashSet<ProjectTestSharingPermission>();
            rolePerms.add(new ProjectTestSharingPermission(10000L, 10002L));
            rolePerms.add(new ProjectTestSharingPermission(10000L, 10001L));
            this.navigation.login("user_can_share_filters");
            this.navigation.issueNavigator().editFilter(10022L);
            this.textAssertions.assertRegexMatch(new WebPageLocator(this.tester), "You do not have permission to share with Project\\: '.+'\\ Role: \\[Unknown Role\\]");
            this.tester.submit("Save");
            this.textAssertions.assertRegexMatch(new WebPageLocator(this.tester), "You do not have permission to share with Project\\: '.+'\\ Role: \\[Unknown Role\\]");
            this.assertEditScreenCorrect(ROLE_FILTER_INFO, rolePerms);
            long id = this.editFilter(10022L, ROLE_FILTER_INFO, (Set<? extends TestSharingPermission>)ImmutableSet.of((Object)GROUP_SHARE));
            Assert.assertEquals((long)10022L, (long)id);
            this.assertSearchEditCorrectly(id, "user_can_share_filters", ROLE_FILTER_INFO, SHARE_SEARCH, (Set<? extends TestSharingPermission>)ImmutableSet.of((Object)GROUP_SHARE));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(this.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEditFilterRemoveRole_works() {
        try {
            this.backdoor.darkFeatures().enableForSite(this.SER_ALLOW_SHARE_WITH_NON_MEMBER);
            HashSet<ProjectTestSharingPermission> rolePerms = new HashSet<ProjectTestSharingPermission>();
            rolePerms.add(new ProjectTestSharingPermission(10000L, 10002L));
            rolePerms.add(new ProjectTestSharingPermission(10000L, 10001L));
            this.navigation.login("user_can_share_filters");
            this.navigation.issueNavigator().editFilter(10022L);
            this.textAssertions.assertRegexNoMatch(new WebPageLocator(this.tester), "You do not have permission to share with Project\\: '.+'\\ Role: \\[Unknown Role\\]");
            this.tester.submit("Save");
            this.textAssertions.assertRegexNoMatch(new WebPageLocator(this.tester), "You do not have permission to share with Project\\: '.+'\\ Role: \\[Unknown Role\\]");
            long id = this.editFilter(10022L, ROLE_FILTER_INFO, (Set<? extends TestSharingPermission>)ImmutableSet.of((Object)GROUP_SHARE));
            Assert.assertEquals((long)10022L, (long)id);
            this.assertSearchEditCorrectly(id, "user_can_share_filters", ROLE_FILTER_INFO, SHARE_SEARCH, (Set<? extends TestSharingPermission>)ImmutableSet.of((Object)GROUP_SHARE));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(this.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        }
    }

    @Test
    public void testEditFilterGlobalShareRemove() {
        this.navigation.login("user_cant_share_filters");
        this.navigation.issueNavigator().editFilter(10023L);
        this.textAssertions.assertTextPresent(new WebPageLocator(this.tester), "You do not have permission to share. All shares are invalid.");
        this.tester.submit("Save");
        this.textAssertions.assertTextPresent(new WebPageLocator(this.tester), "You do not have permission to share. All shares are invalid.");
        this.assertEditScreenCorrect(REMOVE_FILTER_INFO, (Set<? extends TestSharingPermission>)ImmutableSet.of((Object)GlobalTestSharingPermission.GLOBAL_PERMISSION));
        long id = this.editFilter(10023L, REMOVE_FILTER_INFO, Collections.emptySet());
        Assert.assertEquals((long)10023L, (long)id);
        this.assertSearchEditCorrectly(id, "user_cant_share_filters", REMOVE_FILTER_INFO, NOSHARE_SEARCH, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEditFilterMultipleProblems() {
        try {
            this.backdoor.darkFeatures().disableForSite(this.SER_ALLOW_SHARE_WITH_NON_MEMBER);
            this.navigation.login("user_can_share_filters");
            LinkedList<TestSharingPermission> shares = new LinkedList<TestSharingPermission>();
            shares.add(new GroupTestSharingPermission("group_delete_me"));
            shares.add(new ProjectTestSharingPermission(10000L, 10001L));
            shares.add(new ProjectTestSharingPermission(10000L));
            SharedEntityInfo testinfo = new SharedEntityInfo("testEditFilterMultipleProblems", "description", false, null);
            this.navigation.issueNavigator().editFilter(10024L);
            this.textAssertions.assertAtLeastOneTextPresent(new WebPageLocator(this.tester), "Group: 'group_delete_me' does not exist, or you do not have permission to share it.", "You do not have permission to share");
            this.tester.submit("Save");
            this.textAssertions.assertAtLeastOneTextPresent(new WebPageLocator(this.tester), "Group: 'group_delete_me' does not exist, or you do not have permission to share it.", "You do not have permission to share");
            this.assertEditScreenCorrect(MULTIPLE_FILTER_INFO, new HashSet(shares));
            shares.remove(0);
            this.editFilterNoId(10024L, testinfo, new HashSet(shares));
            this.textAssertions.assertTextPresent(new WebPageLocator(this.tester), "You do not have permission to share");
            this.assertEditScreenCorrect(testinfo, new HashSet(shares));
            shares.remove(0);
            long id = this.editFilter(10024L, MULTIPLE_FILTER_INFO, new HashSet(shares));
            Assert.assertEquals((long)10024L, (long)id);
            this.assertSearchEditCorrectly(id, "user_can_share_filters", MULTIPLE_FILTER_INFO, SHARE_SEARCH, new HashSet(shares));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(this.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEditFilterMultipleShares() {
        try {
            this.backdoor.darkFeatures().enableForSite(this.SER_ALLOW_SHARE_WITH_NON_MEMBER);
            this.navigation.login("user_can_share_filters");
            LinkedList<TestSharingPermission> shares = new LinkedList<TestSharingPermission>();
            shares.add(new GroupTestSharingPermission("group_delete_me"));
            shares.add(new ProjectTestSharingPermission(10000L, 10001L));
            shares.add(new ProjectTestSharingPermission(10000L));
            SharedEntityInfo testinfo = new SharedEntityInfo("testEditFilterMultipleProblems", "description", false, null);
            this.navigation.issueNavigator().editFilter(10024L);
            this.textAssertions.assertTextNotPresent(new WebPageLocator(this.tester), "Group: 'group_delete_me' does not exist, or you do not have permission to share it");
            this.tester.submit("Save");
            this.textAssertions.assertTextNotPresent(new WebPageLocator(this.tester), "Group: 'group_delete_me' does not exist, or you do not have permission to share it");
            long id = this.editFilter(10024L, MULTIPLE_FILTER_INFO, new HashSet(shares));
            Assert.assertEquals((long)10024L, (long)id);
            this.assertSearchEditCorrectly(id, "user_can_share_filters", MULTIPLE_FILTER_INFO, SHARE_SEARCH, new HashSet(shares));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(this.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        }
    }
}

