/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter.management;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.FunctTestConstants;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.parser.filter.FilterItem;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.FILTERS})
@LoginAs(user="admin")
@Restore(value="TestChangeSharedFilterOwnerByAdmins.xml")
public class TestChangeSharedFilterOwnerByAdmins
extends BaseJiraFuncTest {
    private static final String DEV1 = "developer";
    private static final String DEV2 = "anotherdev";
    private static final String USER = "Fred";
    @Inject
    private Administration administration;

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=811000)
    public void testAnAdminIsAbleToChangeOwnersOfFiltersSharedWithAGroupHeDoesNotBelongTo() {
        ImmutableList expectedFilterItems = ImmutableList.of((Object)new FilterItem.Builder().id(10006L).name("Shared Filter With Group jira-developers owned by developer").owner("Another Developer").build());
        List<FilterItem> actualFilterItems = this.administration.sharedFilters().goTo().searchAll().changeFilterOwner(10006L, DEV2).filters().list();
        Assert.assertNotNull(actualFilterItems);
        Assert.assertTrue((actualFilterItems.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Iterables.all((Iterable)expectedFilterItems, (Predicate)Predicates.in(actualFilterItems)));
    }

    @Test
    public void testAnAdminIsAbleToChangeOwnerOfFiltersSharedWithAGroupHeBelongsTo() {
        ImmutableList expectedFilterItems = ImmutableList.of((Object)new FilterItem.Builder().id(10002L).name("Shared Filter With Group jira-users owned by fred").owner("Developer").build());
        List<FilterItem> actualFilterItems = this.administration.sharedFilters().goTo().searchAll().changeFilterOwner(10002L, DEV1).filters().list();
        Assert.assertNotNull(actualFilterItems);
        Assert.assertTrue((actualFilterItems.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Iterables.all((Iterable)expectedFilterItems, (Predicate)Predicates.in(actualFilterItems)));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=811000)
    public void testAnAdminIsAbleToChangeOwnerOfFiltersSharedWithARoleHeIsNotPartOf() {
        ImmutableList expectedFilterItems = ImmutableList.of((Object)new FilterItem.Builder().id(10004L).name("Shared Filter With Role Developers on homosapien owned by developer").owner("Another Developer").build());
        List<FilterItem> actualFilterItems = this.administration.sharedFilters().goTo().searchAll().changeFilterOwner(10004L, DEV2).filters().list();
        Assert.assertNotNull(actualFilterItems);
        Assert.assertTrue((actualFilterItems.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Iterables.all((Iterable)expectedFilterItems, (Predicate)Predicates.in(actualFilterItems)));
    }

    @Test
    public void testAnAdminIsAbleToChangeOwnerOfFiltersSharedWithARoleHeIsPartOf() {
        ImmutableList expectedFilterItems = ImmutableList.of((Object)new FilterItem.Builder().id(10001L).name("Shared Filter With Role Users on homosapien owned by fred").owner("Developer").build());
        List<FilterItem> actualFilterItems = this.administration.sharedFilters().goTo().searchAll().changeFilterOwner(10001L, DEV1).filters().list();
        Assert.assertNotNull(actualFilterItems);
        Assert.assertTrue((actualFilterItems.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Iterables.all((Iterable)expectedFilterItems, (Predicate)Predicates.in(actualFilterItems)));
    }

    @Test
    public void testAnAdminCannotChangeOwnerOfFiltersWhenNewOwnerDoesNotHaveSharePermission() {
        try {
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
            ImmutableList expectedFilterItems = ImmutableList.of((Object)new FilterItem.Builder().id(10004L).name("Shared Filter With Role Developers on homosapien owned by developer").owner("Fred Normal").build());
            List<FilterItem> actualFilterItems = this.administration.sharedFilters().goTo().searchAll().changeFilterOwner(10004L, USER).filters().list();
            Assert.assertNotNull(actualFilterItems);
            Assert.assertTrue((actualFilterItems.size() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)Iterables.all((Iterable)expectedFilterItems, (Predicate)Predicates.not((Predicate)Predicates.in(actualFilterItems))));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        }
    }

    @Test
    public void testAnAdminCanChangeOwnerOfFiltersWhenNewOwnerDoesNotHaveSharePermission() {
        try {
            this.backdoor.darkFeatures().enableForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
            ImmutableList expectedFilterItems = ImmutableList.of((Object)new FilterItem.Builder().id(10004L).name("Shared Filter With Role Developers on homosapien owned by developer").owner("Fred Normal").build());
            List<FilterItem> actualFilterItems = this.administration.sharedFilters().goTo().searchAll().changeFilterOwner(10004L, USER).filters().list();
            Assert.assertNotNull(actualFilterItems);
            Assert.assertTrue((actualFilterItems.size() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)Iterables.all((Iterable)expectedFilterItems, (Predicate)Predicates.in(actualFilterItems)));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.SER_ALLOW_SHARE_WITH_NON_MEMBER);
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=811000)
    public void testAnAdminIsAbleToChangeOwnerOfPrivateFilters() {
        ImmutableList expectedFilterItems = ImmutableList.of((Object)new FilterItem.Builder().id(10000L).name("Private Filter Owned by fred").owner("Developer").build());
        List<FilterItem> actualFilterItems = this.administration.sharedFilters().goTo().searchAll().changeFilterOwner(10000L, DEV1).filters().list();
        Assert.assertNotNull(actualFilterItems);
        Assert.assertTrue((actualFilterItems.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Iterables.all((Iterable)expectedFilterItems, (Predicate)Predicates.in(actualFilterItems)));
    }
}

