/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.help;

import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.backdoor.HelpUrlsControl;
import com.atlassian.jira.functest.framework.backdoor.application.ApplicationControl;
import com.atlassian.jira.functest.framework.backdoor.application.PlatformApplicationBean;
import com.atlassian.jira.functest.framework.backdoor.application.PluginApplicationBean;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.LicenseKeys;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.LICENSING})
public class TestCoreHelpLinks
extends BaseJiraRestTest {
    private static final String TESTUSER = "klimero";
    private static final String TEST_DEFAULT_GROUP_NAME = "jira-test-group";
    private static final String USER_LINK = "jira101";
    private static final String ADMIN_LINK = "embedded.crowd.directory.configure";
    private String testApplicationHelpServerSpaceURI;
    private String coreHelpServerSpaceURI;

    @Test
    public void helpUrlsForUserWithAccessToSingleApplication() {
        MatcherAssert.assertThat((String)"Anonymous user gets url with core help space", (Object)this.getHelpLinkForAnonymous(USER_LINK), (Matcher)Matchers.containsString((String)this.coreHelpServerSpaceURI));
        MatcherAssert.assertThat((String)"Application user with access to only one application gets url with application help space", (Object)this.getHelpLinkForUser(USER_LINK), (Matcher)Matchers.containsString((String)this.testApplicationHelpServerSpaceURI));
        MatcherAssert.assertThat((String)"Admin help links have the same url (core) for user and anonymous", (Object)this.getHelpLinkForAnonymous(ADMIN_LINK), (Matcher)Matchers.equalTo((Object)this.getHelpLinkForUser(ADMIN_LINK)));
    }

    @Before
    public void setUp() {
        this.backdoor.restoreBlankInstance(LicenseKeys.TEST_ROLE_DC);
        ApplicationControl applicationControl = this.backdoor.getApplicationControl();
        PluginApplicationBean testApp = applicationControl.getPlugin("jira-func-test");
        this.testApplicationHelpServerSpaceURI = testApp.getProductHelpServerSpaceURI();
        PlatformApplicationBean core = applicationControl.getCore();
        this.coreHelpServerSpaceURI = core.getProductHelpServerSpaceURI();
        this.backdoor.usersAndGroups().addUser(TESTUSER);
        this.backdoor.usersAndGroups().addUserToGroup(TESTUSER, TEST_DEFAULT_GROUP_NAME);
    }

    @After
    public void tearDown() {
        this.backdoor.usersAndGroups().deleteUser(TESTUSER);
    }

    private String getHelpLinkForUser(String key) {
        return ((HelpUrlsControl)this.backdoor.helpUrls().loginAs(TESTUSER)).getHelpUrl(key);
    }

    private String getHelpLinkForAnonymous(String key) {
        return ((HelpUrlsControl)this.backdoor.helpUrls().anonymous()).getHelpUrl(key);
    }
}

