/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.i18n;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.TableCellLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.I18N})
@LoginAs(user="admin")
public class TestI18n500Page
extends BaseJiraFuncTest {
    public static final String USERNAME_NON_SYS_ADMIN = "admin_non_sysadmin";
    public static final String PASSWORD_NON_SYS_ADMIN = "admin_non_sysadmin";
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreI18nData("TestI18n.xml");
    }

    @After
    public void tearDownTest() {
        this.administration.generalConfiguration().setJiraLocaleToSystemDefault();
    }

    @Test
    public void testShowsLanguageListInDefaultLanguage() {
        this.administration.restoreData("TestUserProfileI18n.xml");
        this.administration.generalConfiguration().setJiraLocale("Deutsch (Deutschland)");
        this.tester.gotoPage("/internal-error");
        int lastRow = this.page.getHtmlTable("language-info").getRowCount() - 1;
        this.textAssertions.assertTextPresent(new TableCellLocator(this.tester, "language-info", lastRow, 1), "Deutsch (Deutschland)");
    }

    @Test
    public void testShowsLanguageListInTheUsersLanguage() {
        this.administration.restoreData("TestUserProfileI18n.xml");
        this.administration.generalConfiguration().setJiraLocale("Deutsch (Deutschland)");
        this.navigation.login("fred");
        this.tester.gotoPage("/internal-error");
        int lastRow = this.page.getHtmlTable("language-info").getRowCount() - 1;
        this.textAssertions.assertTextPresent(new TableCellLocator(this.tester, "language-info", lastRow, 1), "alem\u00e1n (Alemania)");
        this.textAssertions.assertTextPresent(new TableCellLocator(this.tester, "language-info", lastRow - 1, 0), "sueco (Suecia)");
    }
}

