/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.i18n.terminology;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.backdoor.TerminologyClient;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.v2.i18n.terminology.TerminologyRequestBean;
import com.atlassian.jira.rest.v2.i18n.terminology.TerminologyResponseBean;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import com.atlassian.jira.webtests.LicenseKeys;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST})
@LoginAs(user="admin")
public class TestTerminologyResource
extends BaseJiraFuncTest {
    private static final FeatureFlag TERMINOLOGY_CHANGES = FeatureFlag.featureFlag((String)JiraFeatureFlagRegistrar.TERMINOLOGY_CHANGES.featureKey());
    private static final String TERMINOLOGY_ANALYTICS_EVENT_NAME = "jira.terminology.changed";
    private TerminologyClient client;

    @Before
    public void setup() {
        this.client = this.backdoor.getTerminologyClient();
        this.backdoor.restoreBlankInstance(LicenseKeys.COMMERCIAL_CORE_ACTIVE_DC);
        this.backdoor.darkFeatures().enableForSite(TERMINOLOGY_CHANGES);
    }

    @After
    public void tearDown() {
        this.backdoor.darkFeatures().resetForSite(TERMINOLOGY_CHANGES);
    }

    @Test
    public void shouldReturnProperEntries() {
        ImmutableList inputEpicToTooth = ImmutableList.of((Object)new TerminologyRequestBean(" EpIC  ", "  tOOth ", " \t teETH"));
        ImmutableList inputSprintToPotato = ImmutableList.of((Object)new TerminologyRequestBean(" Sprint ", " poTAto", "  potatOES  "));
        TerminologyResponseBean expectedEpicToTooth = new TerminologyResponseBean("epic", "epics", "tooth", "teeth", false);
        TerminologyResponseBean expectedSprintToPotato = new TerminologyResponseBean("sprint", "sprints", "potato", "potatoes", false);
        this.client.setTerminologyEntries((Collection<TerminologyRequestBean>)inputEpicToTooth);
        this.client.setTerminologyEntries((Collection<TerminologyRequestBean>)inputSprintToPotato);
        Collection allEntries = (Collection)this.client.getAllTerminologyEntries().readEntity((GenericType)new GenericType<Collection<TerminologyResponseBean>>(){});
        Assert.assertThat((Object)allEntries, (Matcher)Matchers.containsInAnyOrder((Object[])new TerminologyResponseBean[]{expectedSprintToPotato, expectedEpicToTooth}));
    }

    @Test
    public void shouldReturnDefaultEntriesIfNoneSet() {
        TerminologyResponseBean expectedDefaultSprintBean = new TerminologyResponseBean("sprint", "sprints", "sprint", "sprints", true);
        TerminologyResponseBean expectedDefaultEpicBean = new TerminologyResponseBean("epic", "epics", "epic", "epics", true);
        Collection allEntries = (Collection)this.client.getAllTerminologyEntries().readEntity((GenericType)new GenericType<Collection<TerminologyResponseBean>>(){});
        Assert.assertThat((Object)allEntries, (Matcher)Matchers.containsInAnyOrder((Object[])new TerminologyResponseBean[]{expectedDefaultSprintBean, expectedDefaultEpicBean}));
    }

    @Test
    public void shouldReturnDefaultEntryForUnchangedNames() {
        ImmutableList inputSprintToPotato = ImmutableList.of((Object)new TerminologyRequestBean(" Sprint ", " poTAto", "  potatOES  "));
        TerminologyResponseBean expectedSprintToPotato = new TerminologyResponseBean("sprint", "sprints", "potato", "potatoes", false);
        TerminologyResponseBean expectedDefaultEpicBean = new TerminologyResponseBean("epic", "epics", "epic", "epics", true);
        this.client.setTerminologyEntries((Collection<TerminologyRequestBean>)inputSprintToPotato);
        Collection allEntries = (Collection)this.client.getAllTerminologyEntries().readEntity((GenericType)new GenericType<Collection<TerminologyResponseBean>>(){});
        Assert.assertThat((Object)allEntries, (Matcher)Matchers.containsInAnyOrder((Object[])new TerminologyResponseBean[]{expectedSprintToPotato, expectedDefaultEpicBean}));
    }

    @Test
    public void shouldReturnProperSingleEntries() {
        TerminologyResponseBean expectedEpicToTooth = new TerminologyResponseBean("epic", "epics", "tooth", "teeth", false);
        TerminologyResponseBean expectedSprintToPotato = new TerminologyResponseBean("sprint", "sprints", "potato", "potatoes", false);
        ImmutableList epicToTooth = ImmutableList.of((Object)new TerminologyRequestBean("epic", "tooth", "teeth"));
        ImmutableList sprintToPotato = ImmutableList.of((Object)new TerminologyRequestBean("sprint", "potato", "potatoes"));
        this.client.setTerminologyEntries((Collection<TerminologyRequestBean>)epicToTooth);
        this.client.setTerminologyEntries((Collection<TerminologyRequestBean>)sprintToPotato);
        TerminologyResponseBean singleEntryForSprint = (TerminologyResponseBean)this.client.getTerminologyEntryForOriginalName("Sprint").readEntity(TerminologyResponseBean.class);
        TerminologyResponseBean singleEntryForEpic = (TerminologyResponseBean)this.client.getTerminologyEntryForOriginalName("Epic").readEntity(TerminologyResponseBean.class);
        Assert.assertThat((Object)singleEntryForSprint, (Matcher)Matchers.equalTo((Object)expectedSprintToPotato));
        Assert.assertThat((Object)singleEntryForEpic, (Matcher)Matchers.equalTo((Object)expectedEpicToTooth));
    }

    @Test
    public void testSetTerminologyEntry() {
        ImmutableList bean = ImmutableList.of((Object)new TerminologyRequestBean("Sprint", "Potato", "Potatoes"));
        Response response = this.client.setTerminologyEntries((Collection<TerminologyRequestBean>)bean);
        Assert.assertThat((Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)Response.Status.OK.getStatusCode()));
    }

    @Test
    public void testSetTerminologyEntryForInvalidOriginalName() {
        ImmutableList bean = ImmutableList.of((Object)new TerminologyRequestBean("Szprint", "Potato", "Potatoes"));
        Response response = this.client.setTerminologyEntries((Collection<TerminologyRequestBean>)bean);
        Assert.assertThat((Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)Response.Status.BAD_REQUEST.getStatusCode()));
    }

    @Test
    public void testSetInvalidTerminologyEntry() {
        ImmutableList bean = ImmutableList.of((Object)new TerminologyRequestBean("Sprint", "<>Diamond<>", "<>Diamonds<>"));
        Response response = this.client.setTerminologyEntries((Collection<TerminologyRequestBean>)bean);
        Assert.assertThat((Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)Response.Status.BAD_REQUEST.getStatusCode()));
    }

    @Test
    public void testSetTerminologyEntryWithoutPermission() {
        ImmutableList bean = ImmutableList.of((Object)new TerminologyRequestBean("Sprint", "Potato", "Potatoes"));
        Response response = ((TerminologyClient)this.client.loginAs("fred")).setTerminologyEntries((Collection<TerminologyRequestBean>)bean);
        Assert.assertThat((Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)Response.Status.FORBIDDEN.getStatusCode()));
    }

    @Test
    public void testSetTerminologyEntryBulk() {
        ImmutableList bean = ImmutableList.of((Object)new TerminologyRequestBean("Sprint", "Potato", "Potatoes"), (Object)new TerminologyRequestBean("Epic", "Pony", "Ponies"));
        Response response = this.client.setTerminologyEntries((Collection<TerminologyRequestBean>)bean);
        Assert.assertThat((Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)Response.Status.OK.getStatusCode()));
    }

    @Test
    public void testSetTerminologyEntryForInvalidOriginalNameBulk() {
        ImmutableList bean = ImmutableList.of((Object)new TerminologyRequestBean("Epic", "Pony", "Ponies"), (Object)new TerminologyRequestBean("Szprint", "Potato", "Potatoes"));
        Response response = this.client.setTerminologyEntries((Collection<TerminologyRequestBean>)bean);
        Assert.assertThat((Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)Response.Status.BAD_REQUEST.getStatusCode()));
    }

    @Test
    public void testSetInvalidTerminologyEntryBulk() {
        ImmutableList bean = ImmutableList.of((Object)new TerminologyRequestBean("Epic", "Pony", "Ponies"), (Object)new TerminologyRequestBean("Sprint", "<>Diamond<>", "<>Diamonds<>"));
        Response response = this.client.setTerminologyEntries((Collection<TerminologyRequestBean>)bean);
        Assert.assertThat((Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)Response.Status.BAD_REQUEST.getStatusCode()));
    }

    @Test
    public void testSetMultipleTerminologyEntriesForOneOriginalNameBulk() {
        ImmutableList beans = ImmutableList.of((Object)new TerminologyRequestBean("Sprint", "Pony", "Ponies"), (Object)new TerminologyRequestBean("Sprint", "Potato", "Potatoes"));
        Response response = this.client.setTerminologyEntries((Collection<TerminologyRequestBean>)beans);
        Assert.assertThat((Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)Response.Status.BAD_REQUEST.getStatusCode()));
    }

    @Test
    public void testSetTerminologyEntryWithoutPermissionBulk() {
        ImmutableList bean = ImmutableList.of((Object)new TerminologyRequestBean("Epic", "Pony", "Ponies"), (Object)new TerminologyRequestBean("Sprint", "Potato", "Potatoes"));
        Response response = ((TerminologyClient)this.client.loginAs("fred")).setTerminologyEntries((Collection<TerminologyRequestBean>)bean);
        Assert.assertThat((Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)Response.Status.FORBIDDEN.getStatusCode()));
    }

    @Test
    public void testGetNonExistingTerminologyEntry() {
        Response response = this.client.getTerminologyEntryForOriginalName("Sepulka");
        Assert.assertThat((Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)Response.Status.NOT_FOUND.getStatusCode()));
    }

    @Test
    public void testCannotChangeTerminologyWhenFeatureFlagDisabled() {
        this.backdoor.darkFeatures().disableForSite(TERMINOLOGY_CHANGES);
        ImmutableList bean = ImmutableList.of((Object)new TerminologyRequestBean("Sprint", "<>Diamond<>", "<>Diamonds<>"));
        Response response = this.client.setTerminologyEntries((Collection<TerminologyRequestBean>)bean);
        Assert.assertThat((Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)Response.Status.NOT_FOUND.getStatusCode()));
    }

    @Test
    public void testAnalyticsSentWhenEntryChangedToNewName() {
        this.backdoor.analyticsEventsControl().enable();
        this.backdoor.analyticsEventsControl().clear();
        MatcherAssert.assertThat(this.backdoor.analyticsEventsControl().matchEvents(TERMINOLOGY_ANALYTICS_EVENT_NAME), (Matcher)Matchers.hasSize((int)0));
        ImmutableList bean = ImmutableList.of((Object)new TerminologyRequestBean("Sprint", "Orange", "Oranges"));
        this.client.setTerminologyEntries((Collection<TerminologyRequestBean>)bean);
        List<Map<?, ?>> terminologyAnalyticsEvents = this.backdoor.analyticsEventsControl().matchEvents(TERMINOLOGY_ANALYTICS_EVENT_NAME);
        MatcherAssert.assertThat(terminologyAnalyticsEvents, (Matcher)Matchers.hasSize((int)1));
        this.verifyAnalytics(terminologyAnalyticsEvents, "sprint", false);
        this.backdoor.analyticsEventsControl().disable();
    }

    @Test
    public void testAnalyticsNotSentWhenErrorsDuringUpdate() {
        this.backdoor.analyticsEventsControl().enable();
        this.backdoor.analyticsEventsControl().clear();
        MatcherAssert.assertThat(this.backdoor.analyticsEventsControl().matchEvents(TERMINOLOGY_ANALYTICS_EVENT_NAME), (Matcher)Matchers.hasSize((int)0));
        ImmutableList bean = ImmutableList.of((Object)new TerminologyRequestBean("Epic", "Sprint", "Sprints"));
        this.client.setTerminologyEntries((Collection<TerminologyRequestBean>)bean);
        MatcherAssert.assertThat(this.backdoor.analyticsEventsControl().matchEvents(TERMINOLOGY_ANALYTICS_EVENT_NAME), (Matcher)Matchers.hasSize((int)0));
        this.backdoor.analyticsEventsControl().disable();
    }

    @Test
    public void testAnalyticsSentForAllEntries() {
        TerminologyRequestBean sprintBeanDifferentThanDefault = new TerminologyRequestBean("Sprint", "Iteration", "Iterations");
        this.client.setTerminologyEntries((Collection<TerminologyRequestBean>)ImmutableList.of((Object)sprintBeanDifferentThanDefault));
        this.backdoor.analyticsEventsControl().enable();
        this.backdoor.analyticsEventsControl().clear();
        MatcherAssert.assertThat(this.backdoor.analyticsEventsControl().matchEvents(TERMINOLOGY_ANALYTICS_EVENT_NAME), (Matcher)Matchers.hasSize((int)0));
        TerminologyRequestBean applesBean = new TerminologyRequestBean("Epic", "Apple", "Apples");
        TerminologyRequestBean pearsBean = new TerminologyRequestBean("Sprint", "Sprint", "Sprints");
        this.client.setTerminologyEntries((Collection<TerminologyRequestBean>)ImmutableList.of((Object)applesBean, (Object)pearsBean));
        List<Map<?, ?>> terminologyAnalyticsEvents = this.backdoor.analyticsEventsControl().matchEvents(TERMINOLOGY_ANALYTICS_EVENT_NAME);
        MatcherAssert.assertThat(terminologyAnalyticsEvents, (Matcher)Matchers.hasSize((int)2));
        this.verifyAnalytics(terminologyAnalyticsEvents, "epic", false);
        this.verifyAnalytics(terminologyAnalyticsEvents, "sprint", true);
        this.backdoor.analyticsEventsControl().disable();
    }

    private void verifyAnalytics(List<Map<?, ?>> events, String originalName, Boolean changedToOriginal) {
        boolean result = events.stream().map(event -> (Map)event.get("properties")).anyMatch(properties -> originalName.equals(properties.get("originalName")) && changedToOriginal.equals(properties.get("changedToOriginal")));
        Assert.assertTrue((boolean)result);
    }
}

