/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.imports.project;

import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.imports.project.BaseJiraProjectImportFuncTest;
import com.opensymphony.util.TextUtils;
import java.io.File;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.PROJECT_IMPORT})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestProjectImportSelectBackup
extends BaseJiraProjectImportFuncTest {
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testValidationInvalidPaths() {
        this.administration.attachments().enable();
        this.navigation.gotoAdminSection(Navigation.AdminSection.ATTACHMENTS);
        this.tester.clickLinkWithText("Edit Settings");
        this.tester.checkCheckbox("attachmentsEnabled", "true");
        this.tester.submit("Save");
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_IMPORT);
        this.tester.setWorkingForm("project-import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupPath", "");
        this.tester.submit();
        this.tester.assertTextPresent("You must provide a path to the Jira backup zip file.");
        this.tester.setWorkingForm("project-import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupPath", "/iamafilethatwillneverexisthahahahaha/bak.xml");
        this.tester.submit();
        this.tester.assertTextPresent("The path to the Jira backup zip file is not valid.");
        this.tester.setWorkingForm("project-import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupPath", System.getProperty("java.io.tmpdir"));
        this.tester.submit();
        this.tester.assertTextPresent("The path to the Jira backup zip file is not valid.");
    }

    @Test
    public void testValidationInvalidbackupAttachmentsNotEnabled() {
        this.administration.attachments().disable();
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_IMPORT);
        this.tester.setWorkingForm("project-import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupPath", "");
        this.tester.submit();
        this.tester.assertTextPresent("You must provide a path to the Jira backup zip file.");
        this.tester.setWorkingForm("project-import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupPath", "/iamafilethatwillneverexisthahahahaha/bak.xml");
        this.tester.submit();
        this.tester.assertTextPresent("The path to the Jira backup zip file is not valid.");
        this.tester.setWorkingForm("project-import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupPath", System.getProperty("java.io.tmpdir"));
        this.tester.submit();
        this.tester.assertTextPresent("The path to the Jira backup zip file is not valid.");
    }

    @Test
    public void testJumpToProgressScreen() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_IMPORT);
        this.tester.gotoPage("/secure/admin/ProjectImportBackupOverviewProgress.jspa");
        this.tester.assertTextPresent("Can not find any running task information. Perhaps your session has timed out, please restart the project import wizard.");
        this.tester.assertTextNotPresent("Refresh");
        this.tester.assertTextPresent("Cancel");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParseExceptionInJIRAData() throws Exception {
        File file = this.importAndExportBackupAndSetupCurrentInstance("TestProjectImportParseExceptionScreen1.xml", "blankprojects.xml");
        try {
            this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_IMPORT);
            this.tester.setWorkingForm("project-import");
            this.tester.assertTextPresent("Project Import: Select Backup File");
            this.tester.setFormElement("backupPath", file.getAbsolutePath());
            this.tester.submit();
            this.advanceThroughWaitingPage();
            this.tester.assertTextPresent("Project Import: Select Backup File");
            String errorMsgStart = "There was a problem parsing the backup XML file at " + file.getAbsolutePath();
            String errorMsgException = ": com.atlassian.jira.exception.ParseException";
            String errorMsgEnd = ": No 'key' field for Issue 10022.";
            String java8message = TextUtils.htmlEncode((String)(errorMsgStart + errorMsgEnd), (boolean)false);
            String java11message = TextUtils.htmlEncode((String)(errorMsgStart + errorMsgException + errorMsgEnd), (boolean)false);
            this.textAssertions.assertAtLeastOneTextPresent(null, java8message, java11message);
        }
        finally {
            file.delete();
        }
    }
}

