/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.imports.project;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.ProjectImportTypeFix;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.imports.project.BaseJiraProjectImportFuncTest;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.WebTable;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.PROJECT_IMPORT})
@LoginAs(user="admin")
@Restore(value="TestProjectImportUsersDoNotExist.xml")
public class TestProjectImportUsersDoNotExistPage
extends BaseJiraProjectImportFuncTest {
    private File tempFile;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUp() {
        this.tempFile = this.administration.exportDataToFile("TestProjectImportUsersDoNotExist_out.xml");
        ProjectImportTypeFix fix = new ProjectImportTypeFix(this.backdoor);
        fix.rewriteProjectTypes(this.tempFile);
        File jiraImportDirectory = new File(this.administration.getJiraHomeDirectory(), "import");
        try {
            FileUtils.copyFileToDirectory((File)this.tempFile, (File)jiraImportDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not copy file " + this.tempFile.getAbsolutePath() + " to the import directory in jira home " + jiraImportDirectory, e);
        }
        this.administration.project().deleteProject(10001L);
        long projectId = this.administration.project().addProject("monkey", "MKY", "admin");
        this.administration.project().editProject(projectId, null, "existing monk thing", "http://www.kingkong.net");
    }

    @Test
    public void testProjectImportMissingOptionalUsersExtMgmt() throws Exception {
        this.backdoor.usersAndGroups().addUser("barney");
        this.administration.generalConfiguration().setExternalUserManagement(true);
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_IMPORT);
        this.tester.setWorkingForm("project-import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupPath", this.tempFile.getAbsolutePath());
        this.tester.submit();
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("Project Import: Select Project to Import");
        this.tester.selectOption("projectKey", "monkey");
        this.tester.submit("Next");
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("The results of automatic mapping are displayed below");
        this.textAssertions.assertTextPresentHtmlEncoded("There are '1' user(s) referenced that Jira can not automatically create.");
        this.textAssertions.assertTextPresentHtmlEncoded("You may want to create these users before performing the import.");
        HttpUnitOptions.setScriptingEnabled((boolean)true);
        this.tester.clickLinkWithText("View Details");
        this.tester.assertTextPresent("Missing Optional Users");
        this.tester.assertTextPresent("There are 1 optional user(s) that do not currently exist in Jira and the import cannot create them.");
        this.tester.assertTextPresent("We are unable to automatically create them because their details do not exist in the backup XML data. The user(s) are not required to exist for the import to proceed, however you may wish to create them.");
        WebTable table = this.tester.getDialog().getWebTableBySummaryOrId("usersdonotexist");
        Assert.assertEquals((long)2L, (long)table.getRowCount());
        boolean condition = table.getTableCell(0, 0).asText().indexOf("Username") != -1;
        Assert.assertTrue((boolean)condition);
        Assert.assertEquals((Object)"betty", (Object)table.getTableCell(1, 0).asText());
        Assert.assertEquals((Object)"", (Object)table.getTableCell(1, 1).asText());
        Assert.assertEquals((Object)"", (Object)table.getTableCell(1, 2).asText());
        this.tester.clickLink("back-link");
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        this.tester.assertTextPresent("The results of automatic mapping are displayed below");
        this.textAssertions.assertTextPresentHtmlEncoded("There are '1' user(s) referenced that Jira can not automatically create.");
    }

    @Test
    public void testProjectImportMissingMandatoryUsersExtMgmt() throws Exception {
        this.backdoor.usersAndGroups().addUser("betty");
        this.administration.generalConfiguration().setExternalUserManagement(true);
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_IMPORT);
        this.tester.setWorkingForm("project-import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupPath", this.tempFile.getAbsolutePath());
        this.tester.submit();
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("Project Import: Select Project to Import");
        this.tester.selectOption("projectKey", "monkey");
        this.tester.submit("Next");
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("The results of automatic mapping are displayed below");
        this.textAssertions.assertTextPresentHtmlEncoded("There are '1' required user(s) that Jira can not automatically create.");
        HttpUnitOptions.setScriptingEnabled((boolean)true);
        this.tester.clickLinkWithText("View Details");
        this.tester.assertTextPresent("Missing Mandatory Users");
        this.tester.assertTextPresent("There are 1 required user(s) that do not currently exist in Jira and the import cannot create them.");
        this.tester.assertTextPresent("These user(s) need to exist for the import to proceed and we are unable to automatically create them because their details do not exist in the backup XML data.");
        this.tester.assertTextNotPresent("To see all the users, use the export link.");
        WebTable table = this.tester.getDialog().getWebTableBySummaryOrId("usersdonotexist");
        Assert.assertEquals((long)2L, (long)table.getRowCount());
        boolean condition = table.getTableCell(0, 0).asText().indexOf("Username") != -1;
        Assert.assertTrue((boolean)condition);
        Assert.assertEquals((Object)"barney", (Object)table.getTableCell(1, 0).asText());
        Assert.assertEquals((Object)"", (Object)table.getTableCell(1, 1).asText());
        Assert.assertEquals((Object)"", (Object)table.getTableCell(1, 2).asText());
        this.tester.clickLink("back-link");
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        this.tester.assertTextPresent("The results of automatic mapping are displayed below");
        this.textAssertions.assertTextPresentHtmlEncoded("There are '1' required user(s) that Jira can not automatically create.");
    }

    @Test
    public void testProjectImportMissingMandatoryUsersCantAutoCreate() throws Exception {
        this.backdoor.usersAndGroups().addUser("betty");
        this.administration.generalConfiguration().setExternalUserManagement(false);
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_IMPORT);
        this.tester.setWorkingForm("project-import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupPath", this.tempFile.getAbsolutePath());
        this.tester.submit();
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("Project Import: Select Project to Import");
        this.tester.selectOption("projectKey", "monkey");
        this.tester.submit("Next");
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("The results of automatic mapping are displayed below");
        this.textAssertions.assertTextPresentHtmlEncoded("There are '1' required user(s) that Jira can not automatically create.");
        HttpUnitOptions.setScriptingEnabled((boolean)true);
        this.tester.clickLinkWithText("View Details");
        this.assertions.getTextAssertions().assertTextPresentHtmlEncoded("There are 1 required user(s) that do not currently exist in Jira and the import cannot create them. These user(s) need to exist for the import to proceed and we are unable to automatically create them because their details do not exist in the backup XML data.");
        this.tester.assertTextNotPresent("To see all the users, use the export link.");
        WebTable table = this.tester.getDialog().getWebTableBySummaryOrId("usersdonotexist");
        Assert.assertEquals((long)2L, (long)table.getRowCount());
        boolean condition = table.getTableCell(0, 0).asText().indexOf("Username") != -1;
        Assert.assertTrue((boolean)condition);
        Assert.assertEquals((Object)"barney", (Object)table.getTableCell(1, 0).asText());
        Assert.assertEquals((Object)"", (Object)table.getTableCell(1, 1).asText());
        Assert.assertEquals((Object)"", (Object)table.getTableCell(1, 2).asText());
        this.tester.clickLink("back-link");
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        this.tester.assertTextPresent("The results of automatic mapping are displayed below");
        this.textAssertions.assertTextPresentHtmlEncoded("There are '1' required user(s) that Jira can not automatically create.");
    }

    @Test
    public void testProjectImportMissingOptionalUsersCantAutoCreate() throws Exception {
        this.backdoor.usersAndGroups().addUser("barney");
        this.administration.generalConfiguration().setExternalUserManagement(false);
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_IMPORT);
        this.tester.setWorkingForm("project-import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupPath", this.tempFile.getAbsolutePath());
        this.tester.submit();
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("Project Import: Select Project to Import");
        this.tester.selectOption("projectKey", "monkey");
        this.tester.submit("Next");
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("The results of automatic mapping are displayed below");
        this.textAssertions.assertTextPresentHtmlEncoded("There are '1' user(s) referenced that Jira can not automatically create. You may want to create these users before performing the import.");
        HttpUnitOptions.setScriptingEnabled((boolean)true);
        this.tester.clickLinkWithText("View Details");
        this.assertions.getTextAssertions().assertTextPresentHtmlEncoded("There are 1 optional user(s) that do not currently exist in Jira and the import cannot create them. We are unable to automatically create them because their details do not exist in the backup XML data. The user(s) are not required to exist for the import to proceed, however you may wish to create them.");
        this.tester.assertTextNotPresent("To see all the users, use the export link.");
        WebTable table = this.tester.getDialog().getWebTableBySummaryOrId("usersdonotexist");
        Assert.assertEquals((long)2L, (long)table.getRowCount());
        boolean condition = table.getTableCell(0, 0).asText().indexOf("Username") != -1;
        Assert.assertTrue((boolean)condition);
        Assert.assertEquals((Object)"betty", (Object)table.getTableCell(1, 0).asText());
        Assert.assertEquals((Object)"", (Object)table.getTableCell(1, 1).asText());
        Assert.assertEquals((Object)"", (Object)table.getTableCell(1, 2).asText());
        this.tester.clickLink("back-link");
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        this.tester.assertTextPresent("The results of automatic mapping are displayed below");
        this.textAssertions.assertTextPresentHtmlEncoded("There are '1' user(s) referenced that Jira can not automatically create. You may want to create these users before performing the import.");
    }

    @Test
    public void testProjectImportUsersToAutoCreate() throws Exception {
        this.backdoor.usersAndGroups().addUser("barney");
        this.backdoor.usersAndGroups().addUser("betty");
        this.backdoor.usersAndGroups().deleteUser("fred");
        this.backdoor.usersAndGroups().deleteUser("wilma");
        this.administration.generalConfiguration().setExternalUserManagement(false);
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_IMPORT);
        this.tester.setWorkingForm("project-import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupPath", this.tempFile.getAbsolutePath());
        this.tester.submit();
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("Project Import: Select Project to Import");
        this.tester.selectOption("projectKey", "monkey");
        this.tester.submit("Next");
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("The results of automatic mapping are displayed below");
        this.textAssertions.assertTextPresentHtmlEncoded("There are '2' users that will be automatically created if the import continues.");
        HttpUnitOptions.setScriptingEnabled((boolean)true);
        this.tester.clickLinkWithText("View Details");
        this.assertions.getTextAssertions().assertTextPresentHtmlEncoded("There are 2 user(s) referenced in the data you are trying to import that do not currently exist in Jira. The project import will automatically create these user(s).");
        this.tester.assertTextNotPresent("To see all the users, use the export link.");
        WebTable table = this.tester.getDialog().getWebTableBySummaryOrId("usersdonotexist");
        Assert.assertEquals((long)3L, (long)table.getRowCount());
        boolean condition = table.getTableCell(0, 0).asText().indexOf("Username") != -1;
        Assert.assertTrue((boolean)condition);
        Assert.assertEquals((Object)"fred", (Object)table.getTableCell(1, 0).asText());
        Assert.assertEquals((Object)"Fred Normal", (Object)table.getTableCell(1, 1).asText());
        Assert.assertEquals((Object)"fred@example.com", (Object)table.getTableCell(1, 2).asText());
        Assert.assertEquals((Object)"wilma", (Object)table.getTableCell(2, 0).asText());
        Assert.assertEquals((Object)"Wilma O'Flinstone", (Object)table.getTableCell(2, 1).asText());
        Assert.assertEquals((Object)"wilma@example.com", (Object)table.getTableCell(2, 2).asText());
        this.tester.clickLink("back-link");
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        this.tester.assertTextPresent("The results of automatic mapping are displayed below");
        this.textAssertions.assertTextPresentHtmlEncoded("There are '2' users that will be automatically created if the import continues.");
    }

    @Test
    public void testProjectImportUsersToAutoCreateWithUserCountLimit() throws Exception {
        this.backdoor.usersAndGroups().addUser("barney");
        this.backdoor.usersAndGroups().addUser("betty");
        this.backdoor.usersAndGroups().deleteUser("fred");
        this.backdoor.usersAndGroups().deleteUser("wilma");
        this.administration.generalConfiguration().setExternalUserManagement(false);
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_IMPORT);
        this.tester.setWorkingForm("project-import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupPath", this.tempFile.getAbsolutePath());
        this.tester.submit();
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("Project Import: Select Project to Import");
        this.tester.selectOption("projectKey", "monkey");
        this.tester.submit("Next");
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("The results of automatic mapping are displayed below");
        this.textAssertions.assertTextPresentHtmlEncoded("There are '2' users that will be automatically created if the import continues.");
        HttpUnitOptions.setScriptingEnabled((boolean)true);
        this.tester.gotoPage("/secure/admin/ProjectImportMissingUsersAutoCreate.jspa?userCountLimit=1");
        this.tester.assertTextPresent("There are 2 user(s) referenced in the data you are trying to import that do not currently exist in Jira. The project import will automatically create these user(s).");
        this.tester.assertTextPresent("Displaying the first 1 users. To see all the users, use the export link.");
        WebTable table = this.tester.getDialog().getWebTableBySummaryOrId("usersdonotexist");
        Assert.assertEquals((long)2L, (long)table.getRowCount());
        boolean condition = table.getTableCell(0, 0).asText().indexOf("Username") != -1;
        Assert.assertTrue((boolean)condition);
        Assert.assertEquals((Object)"fred", (Object)table.getTableCell(1, 0).asText());
        Assert.assertEquals((Object)"Fred Normal", (Object)table.getTableCell(1, 1).asText());
        Assert.assertEquals((Object)"fred@example.com", (Object)table.getTableCell(1, 2).asText());
        this.tester.clickLink("back-link");
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        this.tester.assertTextPresent("The results of automatic mapping are displayed below");
        this.textAssertions.assertTextPresentHtmlEncoded("There are '2' users that will be automatically created if the import continues.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testXmlExport() throws IOException, SAXException, ParserConfigurationException, TransformerException {
        try {
            this.backdoor.usersAndGroups().addUser("barney");
            this.backdoor.usersAndGroups().addUser("betty");
            this.backdoor.usersAndGroups().deleteUser("fred");
            this.backdoor.usersAndGroups().deleteUser("wilma");
            this.administration.generalConfiguration().setExternalUserManagement(false);
            this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_IMPORT);
            this.tester.setWorkingForm("project-import");
            this.tester.assertTextPresent("Project Import: Select Backup File");
            this.tester.setFormElement("backupPath", this.tempFile.getAbsolutePath());
            this.tester.submit();
            this.advanceThroughWaitingPage();
            this.tester.assertTextPresent("Project Import: Select Project to Import");
            this.tester.selectOption("projectKey", "monkey");
            this.tester.submit("Next");
            this.advanceThroughWaitingPage();
            this.tester.assertTextPresent("The results of automatic mapping are displayed below");
            this.textAssertions.assertTextPresentHtmlEncoded("There are '2' users that will be automatically created if the import continues.");
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.tester.gotoPage("/secure/admin/ProjectImportMissingUsersAutoCreate.jspa?userCountLimit=1");
            this.tester.assertTextPresent("There are 2 user(s) referenced in the data you are trying to import that do not currently exist in Jira. The project import will automatically create these user(s).");
            this.tester.assertTextPresent("Displaying the first 1 users. To see all the users, use the export link.");
            WebTable table = this.tester.getDialog().getWebTableBySummaryOrId("usersdonotexist");
            Assert.assertEquals((long)2L, (long)table.getRowCount());
            boolean condition = table.getTableCell(0, 0).asText().indexOf("Username") != -1;
            Assert.assertTrue((boolean)condition);
            Assert.assertEquals((Object)"fred", (Object)table.getTableCell(1, 0).asText());
            Assert.assertEquals((Object)"Fred Normal", (Object)table.getTableCell(1, 1).asText());
            Assert.assertEquals((Object)"fred@example.com", (Object)table.getTableCell(1, 2).asText());
            this.tester.clickLinkWithText("Export to XML");
            String responseText = this.tester.getDialog().getResponseText();
            String expected = "\n<users>\n        <user>\n            <name>fred</name>\n            <fullname>Fred Normal</fullname>\n            <email>fred@example.com</email>\n            <properties>\n                <property>\n                <key>bspropertykey</key>\n                    <value>&lt;/value&gt;</value>\n                </property>\n            </properties>\n        </user>\n        <user>\n            <name>wilma</name>\n            <fullname>Wilma O&apos;Flinstone</fullname>\n            <email>wilma@example.com</email>\n            <properties>\n            </properties>\n        </user>\n</users>";
            Assert.assertEquals((Object)expected, (Object)responseText);
        }
        finally {
            this.tester.gotoPage("/secure/admin/ProjectImportSelectBackup!default.jspa");
        }
    }
}

