/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.imports.properties;

import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import javax.xml.parsers.ParserConfigurationException;
import org.custommonkey.xmlunit.XMLUnit;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.IMPORT_EXPORT})
@LoginAs(user="admin")
public class TestImportExportExcludedEntities
extends BaseJiraFuncTest {
    private static final String BS_BACKUP_TEST_FILE_XML = "BS_BackupTestFile.xml";
    private final String originalFileName = "TestImportExport.xml";
    private final String mutatedFileName = "TestImportExportMutated.xml";
    private String originalFileFullPath;
    private String mutatedFileFullPath;
    private String excludedEntity = "<EntityPropertyIndexDocument id=\"10000\" pluginKey=\"com.atlassian.jira.dev.reference-plugin-decoy\" moduleKey=\"IssuePropertyDecoy\" entityKey=\"IssuePropertyDecoy\" updated=\"2014-01-24 19:47:41.887\"><document><![CDATA[<?xml version=\"1.0\" encoding=\"UTF-8\"?><index-document-configuration entity-key=\"IssuePropertyDecoy\"><key property-key=\"foo.bar\"><extract path=\"foo1.bar2\" type=\"STRING\"/></key><key property-key=\"foo.bar\"><extract path=\"foo1.bar2\" type=\"DATE\"/></key></index-document-configuration>]]></document></EntityPropertyIndexDocument>";
    @Inject
    private Administration administration;

    @Before
    public void prepareXMLWithExcludedEntity() throws ParserConfigurationException, SAXException, IOException, DocumentException {
        this.originalFileFullPath = this.environmentData.getXMLDataLocation().getAbsolutePath() + File.separator + "TestImportExport.xml";
        this.mutatedFileFullPath = this.environmentData.getXMLDataLocation().getAbsolutePath() + File.separator + "TestImportExportMutated.xml";
        File file = new File(this.originalFileFullPath);
        SAXReader reader = new SAXReader();
        Document document = reader.read(file);
        Document excludedEntityDocument = reader.read((Reader)new StringReader(this.excludedEntity));
        Element element = document.getRootElement();
        element.add(excludedEntityDocument.getRootElement());
        FileWriter fileWriter = new FileWriter(this.mutatedFileFullPath);
        XMLWriter xmlWriter = new XMLWriter((Writer)fileWriter);
        xmlWriter.write(document);
        xmlWriter.flush();
        xmlWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExcludedEntityNotImported() throws IOException, ParserConfigurationException, SAXException {
        try (InputStreamReader reader = null;){
            reader = new FileReader(new File(this.mutatedFileFullPath));
            org.w3c.dom.Document doc = XMLUnit.buildControlDocument((InputSource)new InputSource(reader));
            NodeList entityPropertyIndexDocument = doc.getElementsByTagName("EntityPropertyIndexDocument");
            Assert.assertThat((Object)entityPropertyIndexDocument.getLength(), (Matcher)Matchers.is((Object)1));
            this.administration.restoreData("TestImportExportMutated.xml");
            Assert.assertThat(this.backdoor.getPluginIndexConfigurationControl().getDocumentsForEntity(EntityPropertyType.ISSUE_PROPERTY.getDbEntityName()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"com.atlassian.jira.dev.func-test-plugin:index-doc-conf", "com.atlassian.jira.dev.reference-plugin:IssueProperty"}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExcludedEntityNotExported() throws IOException, ParserConfigurationException, SAXException {
        File backupFile = null;
        try {
            this.backdoor.getPluginIndexConfigurationControl().putDocumentConfiguration("pluginKey", "moduleKey", this.getConfiguration());
            Assert.assertThat(this.backdoor.getPluginIndexConfigurationControl().getDocumentsForEntity(EntityPropertyType.ISSUE_PROPERTY.getDbEntityName()), (Matcher)Matchers.hasItem((Object)"pluginKey:moduleKey"));
            this.deleteBackupFileIfPresent(BS_BACKUP_TEST_FILE_XML);
            backupFile = this.administration.exportDataToFile(BS_BACKUP_TEST_FILE_XML);
            Assert.assertTrue((String)"The backup file must exist", (boolean)backupFile.exists());
            org.w3c.dom.Document doc = XMLUnit.buildControlDocument((InputSource)new InputSource(new ZipFile(backupFile).getInputStream(new ZipEntry("entities.xml"))));
            NodeList entityPropertyIndexDocument = doc.getElementsByTagName("EntityPropertyIndexDocument");
            Assert.assertThat((Object)entityPropertyIndexDocument.getLength(), (Matcher)Matchers.is((Object)0));
        }
        finally {
            if (backupFile != null) {
                backupFile.delete();
            }
        }
    }

    private void deleteBackupFileIfPresent(String fileName) {
        File backupFile = new File(this.getEnvironmentData().getXMLDataLocation().getAbsolutePath() + "/" + fileName);
        if (backupFile.exists()) {
            backupFile.delete();
        }
    }

    @After
    public void tearDownTest() {
        this.backdoor.plugins().enablePlugin("com.atlassian.jira.dev.reference-plugin");
    }

    private String getConfiguration() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<index-document-configuration entity-key=\"IssueProperty\"><key property-key=\"foo.bar\"><extract path=\"foo1.bar2\" type=\"STRING\"/></key><key property-key=\"foo.bar\"><extract path=\"foo1.bar2\" type=\"DATE\"/></key></index-document-configuration>";
    }
}

