/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.indexing;

import com.atlassian.jira.database.DatabaseUtil;
import com.atlassian.jira.functest.framework.backdoor.EntityVersioningControl;
import java.time.LocalDateTime;
import java.util.Objects;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

class EntityVersion
extends TypeSafeDiagnosingMatcher<EntityVersioningControl.EntityVersionBean> {
    private static final int DATE_COMPARISON_TOLERANCE_SECONDS = 60;
    static final String ENTITY_TYPE_ISSUE = "issue";
    static final String ENTITY_TYPE_COMMENT = "comment";
    static final String ENTITY_TYPE_WORKLOG = "worklog";
    final long entity;
    final String entityType;
    final Long parentIssueId;
    final LocalDateTime dateTime;
    final long version;
    final boolean deleted;

    public EntityVersion(long entity, Long parentIssueId, String entityType, LocalDateTime dateTime, long version, boolean deleted) {
        this.entity = entity;
        this.parentIssueId = parentIssueId;
        this.entityType = entityType;
        this.dateTime = dateTime;
        this.version = version;
        this.deleted = deleted;
    }

    protected boolean matchesSafely(EntityVersioningControl.EntityVersionBean item, Description mismatchDescription) {
        boolean matches;
        boolean bl = matches = Objects.equals(this.entity, item.entityId) && Objects.equals(this.entityType, item.entityType) && Objects.equals(this.version, item.entityVersion) && Objects.equals(this.deleted, item.deleted) && (this.entityType.equals(ENTITY_TYPE_ISSUE) || Objects.equals(this.parentIssueId, item.parentIssueId)) && item.updateTime.toLocalDateTime().minusSeconds(60L).isBefore(this.dateTime) && item.updateTime.toLocalDateTime().plusSeconds(60L).isAfter(this.dateTime);
        if (!matches) {
            mismatchDescription.appendValue((Object)item);
        }
        return matches;
    }

    public void describeTo(Description description) {
        description.appendText(this.toString());
    }

    public String toString() {
        return "EntityVersion{entity=" + this.entity + ", parentIssueId=" + this.parentIssueId + ", dateTime=" + this.dateTime + "\u00b1" + 60 + "s, version=" + this.version + ", deleted=" + DatabaseUtil.booleanToChar1((Boolean)this.deleted) + '}';
    }
}

