/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.indexing;

import com.atlassian.jira.rest.v2.index.ReindexRequestBean;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class ReindexRequestClient
extends RestApiClient {
    private final JIRAEnvironmentData environmentData;

    public ReindexRequestClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
        this.environmentData = environmentData;
    }

    public long[] performReindex() {
        ParsedResponse response = this.toResponse(() -> {
            WebTarget reindexResource = this.getReindexResource();
            return (Response)reindexResource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(null, Response.class);
        }, long[].class);
        return (long[])response.body;
    }

    public ReindexRequestBean getReindexRequest(long id) {
        return (ReindexRequestBean)this.getReindexResource().path(String.valueOf(id)).request().get(ReindexRequestBean.class);
    }

    private WebTarget getReindexResource() {
        return this.resourceRoot(this.environmentData.getBaseUrl().toExternalForm()).path("rest").path("api").path("2").path("reindex").path("request");
    }
}

