/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.indexing;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.google.common.util.concurrent.MoreExecutors;
import com.jayway.awaitility.Awaitility;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.INDEXING, Category.PERFORMANCE})
@RestoreBlankInstance
public class TestReindexConcurrentModificationsServer
extends BaseJiraFuncTest {
    private static final String PROJECT_NAME = "Homosapiens";
    private static final String PROJECT_KEY = "HSP";
    private static final int DEFAULT_TIMEOUT = 30;
    private ExecutorService executorService;

    @Before
    public void setUp() throws Exception {
        this.executorService = Executors.newSingleThreadExecutor();
    }

    @After
    public void tearDown() {
        MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.executorService, (long)30L, (TimeUnit)TimeUnit.SECONDS);
    }

    @SinceBuildRule.SinceBuild(buildNumber=812000)
    @Test
    public void concurrentIssueEditAndDeleteShouldNotLeaveTheIssueInIndex() throws Exception {
        String cfName = "ACF1";
        String cfDescription = "Test ACF 1";
        String cfType = "com.atlassian.jira.plugin.system.customfieldtypes:textfield";
        String cfSearcherKey = "com.atlassian.jira.dev.func-test-plugin:slowtextsearcher";
        String fieldId = this.backdoor.customFields().createCustomField("ACF1", "Test ACF 1", "com.atlassian.jira.plugin.system.customfieldtypes:textfield", "com.atlassian.jira.dev.func-test-plugin:slowtextsearcher");
        this.backdoor.screens().addFieldToScreen("Default Screen", "ACF1");
        this.backdoor.fieldConfiguration().associateCustomFieldWithProject(fieldId, PROJECT_NAME);
        String issueKey = this.backdoor.issues().createIssue(PROJECT_KEY, "Issue 1").key();
        Awaitility.await().until(() -> this.backdoor.search().getSearch((SearchRequest)new SearchRequest()).total == 1);
        AtomicReference editFuture = new AtomicReference();
        this.backdoor.barrier().raiseBarrierAndRun("SlowFieldIndexer", () -> {
            String updatedDescription = "Issue 1 - updated";
            editFuture.set(this.executorService.submit(() -> this.backdoor.issues().setDescription(issueKey, "Issue 1 - updated")));
            Awaitility.await().until(() -> "Issue 1 - updated".equals(this.backdoor.issues().getIssue((String)issueKey).fields.description));
            this.backdoor.issues().deleteIssue(issueKey, false);
            Awaitility.await().until(() -> this.backdoor.search().getSearch((SearchRequest)new SearchRequest()).total == 0);
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(13L));
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        });
        ((Future)editFuture.get()).get(30L, TimeUnit.SECONDS);
        Awaitility.await().atMost(40L, TimeUnit.SECONDS).until(() -> this.backdoor.search().getSearch((SearchRequest)new SearchRequest()).total == 0);
    }
}

