/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.backdoor.EventClient;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.testkit.beans.CustomFieldResponse;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.webtests.ztests.workflow.ExpectedChangeHistoryItem;
import com.atlassian.jira.webtests.ztests.workflow.ExpectedChangeHistoryRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
public class TestArchiveIssue
extends BaseJiraFuncTest {
    private static final String PROJECT = "PROJ";
    private static final String ARCHIVE_PERMISSION_ERROR = "You must have global administrator rights or the archive issue project permission to archive this issue.";
    private static final String RESTORE_PERMISSION_MESSAGE = "You must have global administrator rights or the restore issue project permission to restore this issue.";
    private final String CUSTOM_FIELD_NAME = "ReferencePluginPreArchiveIssuesEventListener";
    private int ISSUES_COUNT = 3;
    private List<String> keys;
    @Inject
    private Assertions assertions;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() {
        this.restoreInstance();
        this.keys = this.createIssues(this.ISSUES_COUNT);
    }

    private void restoreInstance() {
        this.backdoor.restoreBlankInstance();
        this.backdoor.project().addProject("Project", PROJECT, "admin");
    }

    @Test
    public void testHappyPath() {
        this.backdoor.issues().archiveIssue(this.keys.get(0));
        MatcherAssert.assertThat((Object)this.getIssues(PROJECT).size(), (Matcher)CoreMatchers.is((Object)(this.ISSUES_COUNT - 1)));
        MatcherAssert.assertThat(this.getIssues(PROJECT).stream().map(issue -> issue.key).collect(Collectors.toList()), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)this.keys.get(0))));
        this.backdoor.issues().restoreIssue(this.keys.get(0));
        MatcherAssert.assertThat((Object)this.getIssues(PROJECT).size(), (Matcher)CoreMatchers.is((Object)this.ISSUES_COUNT));
        MatcherAssert.assertThat(this.getIssues(PROJECT).stream().map(issue -> issue.key).collect(Collectors.toList()), (Matcher)CoreMatchers.hasItem((Object)this.keys.get(0)));
    }

    private List<String> createIssues(int count) {
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            keys.add(this.backdoor.issues().createIssue(PROJECT, "issue in archived project").key());
        }
        return keys;
    }

    private List<Issue> getIssues(String projectKey) {
        return this.backdoor.search().getSearch((SearchRequest)new SearchRequest().jql((String)new StringBuilder().append((String)"project=").append((String)projectKey).toString())).issues;
    }

    @Test
    public void testArchiveResourceUserNotLoggedIn() {
        this.backdoor.issues().anonymous();
        Response response = this.backdoor.issues().archiveIssue(this.keys.get(0));
        MatcherAssert.assertThat((Object)response.getStatusInfo(), (Matcher)CoreMatchers.is((Object)Response.Status.UNAUTHORIZED));
        response = this.backdoor.issues().restoreIssue(this.keys.get(0));
        MatcherAssert.assertThat((Object)response.getStatusInfo(), (Matcher)CoreMatchers.is((Object)Response.Status.UNAUTHORIZED));
        this.backdoor.project().loginAs("admin", "admin");
    }

    @Test
    public void testArchiveResourceArchiveAlreadyArchived() {
        Response firstResponse = this.backdoor.issues().archiveIssue(this.keys.get(0));
        Response secondResponse = this.backdoor.issues().archiveIssue(this.keys.get(0));
        MatcherAssert.assertThat((Object)firstResponse.getStatusInfo(), (Matcher)CoreMatchers.is((Object)Response.Status.NO_CONTENT));
        MatcherAssert.assertThat((Object)secondResponse.getStatusInfo(), (Matcher)CoreMatchers.is((Object)Response.Status.FORBIDDEN));
    }

    @Test
    public void testArchiveResourceRestoreOnlyForArchived() {
        this.backdoor.issues().loginAs("admin");
        this.backdoor.issues().archiveIssue(this.keys.get(0));
        Response firstResponse = this.backdoor.issues().restoreIssue(this.keys.get(0));
        Response secondResponse = this.backdoor.issues().restoreIssue(this.keys.get(0));
        MatcherAssert.assertThat((Object)firstResponse.getStatusInfo(), (Matcher)CoreMatchers.is((Object)Response.Status.NO_CONTENT));
        MatcherAssert.assertThat((Object)secondResponse.getStatusInfo(), (Matcher)CoreMatchers.is((Object)Response.Status.FORBIDDEN));
    }

    @Test
    public void testArchiveResourceUserHasNoPermission() {
        this.backdoor.issues().loginAs("fred", "fred");
        Response response = this.backdoor.issues().archiveIssue(this.keys.get(0));
        MatcherAssert.assertThat((Object)response.getStatusInfo(), (Matcher)CoreMatchers.is((Object)Response.Status.FORBIDDEN));
        response = this.backdoor.issues().restoreIssue(this.keys.get(0));
        MatcherAssert.assertThat((Object)response.getStatusInfo(), (Matcher)CoreMatchers.is((Object)Response.Status.FORBIDDEN));
        this.backdoor.issues().loginAs("admin", "admin");
    }

    @Test
    public void testArchiveResourceUserHasProjectPermission() {
        this.backdoor.issues().loginAs("fred", "fred");
        this.backdoor.permissionSchemes().addUserPermission(0L, ProjectPermissions.ARCHIVE_ISSUES, "fred");
        Response response = this.backdoor.issues().archiveIssue(this.keys.get(0));
        MatcherAssert.assertThat((Object)response.getStatusInfo(), (Matcher)CoreMatchers.is((Object)Response.Status.NO_CONTENT));
        response = this.backdoor.issues().restoreIssue(this.keys.get(0));
        MatcherAssert.assertThat((Object)response.getStatusInfo(), (Matcher)CoreMatchers.is((Object)Response.Status.FORBIDDEN));
        this.backdoor.permissionSchemes().addUserPermission(0L, ProjectPermissions.RESTORE_ISSUES, "fred");
        MatcherAssert.assertThat((Object)response.getStatusInfo(), (Matcher)CoreMatchers.is((Object)Response.Status.FORBIDDEN));
        this.backdoor.issues().loginAs("admin", "admin");
    }

    @Test
    public void testArchiveResourceProjectDoesntExist() {
        Response response = this.backdoor.issues().archiveIssue("SOMETHING");
        MatcherAssert.assertThat((Object)response.getStatusInfo(), (Matcher)CoreMatchers.is((Object)Response.Status.NOT_FOUND));
        response = this.backdoor.issues().restoreIssue("SOMETHING");
        MatcherAssert.assertThat((Object)response.getStatusInfo(), (Matcher)CoreMatchers.is((Object)Response.Status.NOT_FOUND));
    }

    @Test
    public void testAddCommentToArchivedIssue() {
        this.backdoor.issues().archiveIssue(this.keys.get(0));
        ParsedResponse response = this.backdoor.issues().commentIssue(this.keys.get(0), "I've just added comment to the archived issue!");
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)CoreMatchers.is((Object)Response.Status.BAD_REQUEST.getStatusCode()));
    }

    @Test
    @LoginAs(user="admin")
    public void testEditArchivedIssue() {
        this.expectedException.expectMessage("Unable to find link with id [edit-issue]");
        this.backdoor.issues().archiveIssue(this.keys.get(0));
        this.navigation.issue().gotoEditIssue(this.keys.get(0));
    }

    @Test
    @LoginAs(user="admin")
    public void testAssignArchivedIssue() {
        this.expectedException.expectMessage("Unable to find link with id [assign-issue]");
        this.backdoor.issues().archiveIssue(this.keys.get(0));
        this.navigation.issue().assignIssue(this.keys.get(0), "", "Administrator");
    }

    @Test
    public void testArchivedIssuesEventTriggered() {
        EventClient.EventPoller poller = this.backdoor.events().createPoller();
        this.backdoor.issues().archiveIssue(this.keys.get(0));
        MatcherAssert.assertThat(poller.events(), (Matcher)Matchers.hasItem((Object)"com.atlassian.jira.event.issue.IssuesArchivedEvent"));
        this.backdoor.events().stopAllPollers();
    }

    @Test
    public void testPreArchivedIssuesEventTriggeredBeforeArchiving() {
        String issueId = this.backdoor.issues().getIssue((String)this.keys.get((int)0)).id;
        this.backdoor.issues().archiveIssue(this.keys.get(0));
        String[] parsedDesc = this.getResponseFromReferencePlugin();
        MatcherAssert.assertThat((Object)parsedDesc[0], (Matcher)CoreMatchers.equalTo((Object)issueId));
        MatcherAssert.assertThat((Object)parsedDesc[1], (Matcher)CoreMatchers.equalTo((Object)"0"));
        MatcherAssert.assertThat((Object)parsedDesc[2], (Matcher)CoreMatchers.equalTo((Object)"1"));
    }

    private String[] getResponseFromReferencePlugin() {
        Optional<CustomFieldResponse> first = this.backdoor.customFields().getCustomFields().stream().filter(cf -> cf.getName().equals("ReferencePluginPreArchiveIssuesEventListener")).findFirst();
        MatcherAssert.assertThat((Object)first.isPresent(), (Matcher)CoreMatchers.equalTo((Object)true));
        String cfDesc = first.get().description;
        return cfDesc.split(" ");
    }

    @Test
    public void testRestoredIssuesEventTriggered() {
        EventClient.EventPoller poller = this.backdoor.events().createPoller();
        this.backdoor.issues().archiveIssue(this.keys.get(0));
        this.backdoor.issues().restoreIssue(this.keys.get(0));
        MatcherAssert.assertThat(poller.events(), (Matcher)Matchers.hasItem((Object)"com.atlassian.jira.event.issue.IssuesRestoredEvent"));
        MatcherAssert.assertThat(poller.events(), (Matcher)CoreMatchers.not((Matcher)Matchers.hasItem((Object)"com.atlassian.jira.event.issue.IssuesPreArchiveEvent")));
        this.backdoor.events().stopAllPollers();
    }

    @Test
    public void testArchivedIssueIsNotIndexed() {
        this.backdoor.issues().archiveIssue(this.keys.get(0));
        MatcherAssert.assertThat((Object)this.getIssues(PROJECT).size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(this.getIssues(PROJECT).stream().map(issue -> issue.key).collect(Collectors.toList()), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)this.keys.get(0))));
    }

    @Test
    public void testArchiveIssueDoesntChangeUpdateDate() {
        String originalUpdateDate = this.backdoor.issues().getIssue((String)this.keys.get((int)0)).fields.updated;
        this.backdoor.issues().archiveIssue(this.keys.get(0));
        MatcherAssert.assertThat((Object)this.backdoor.issues().getIssue((String)this.keys.get((int)0)).fields.updated, (Matcher)CoreMatchers.equalTo((Object)originalUpdateDate));
    }

    @Test
    public void testRestoreIssueDoesntChangeUpdateDate() {
        String originalUpdateDate = this.backdoor.issues().getIssue((String)this.keys.get((int)0)).fields.updated;
        this.backdoor.issues().archiveIssue(this.keys.get(0));
        this.backdoor.issues().restoreIssue(this.keys.get(0));
        MatcherAssert.assertThat((Object)this.backdoor.issues().getIssue((String)this.keys.get((int)0)).fields.updated, (Matcher)CoreMatchers.equalTo((Object)originalUpdateDate));
    }

    @Test
    @LoginAs(user="admin")
    public void testArchiveIssueLinkPresent() {
        this.navigation.issue().gotoIssue(this.keys.get(0));
        this.tester.assertLinkPresent("archive-issue");
        this.tester.clickLink("archive-issue");
        this.tester.assertSubmitButtonPresent("archive");
    }

    @Test
    public void testArchiveIssueLinkUserHasNoPermission() {
        this.navigation.login("fred", "fred");
        this.navigation.issue().gotoIssue(this.keys.get(0));
        this.tester.assertLinkNotPresent("archive-issue");
        this.navigation.gotoPage("/secure/ArchiveIssue!default.jspa?id=10000");
        this.tester.assertTextPresent(ARCHIVE_PERMISSION_ERROR);
        this.tester.assertSubmitButtonNotPresent("archive");
    }

    @Test
    public void testArchiveIssueLinkUserHasProjectPermission() {
        this.navigation.login("fred", "fred");
        this.verifyArchivingAction(ProjectPermissions.ARCHIVE_ISSUES, "archive-issue", "archive", "ArchiveIssue", this.keys.get(0), ARCHIVE_PERMISSION_ERROR);
    }

    @Test
    public void testRestoreIssueLinkUserHasProjectPermission() {
        this.navigation.login("fred", "fred");
        this.backdoor.issues().archiveIssue(this.keys.get(0));
        this.verifyArchivingAction(ProjectPermissions.RESTORE_ISSUES, "restore-issue", "restore", "RestoreIssue", this.keys.get(0), RESTORE_PERMISSION_MESSAGE);
    }

    private void verifyArchivingAction(ProjectPermissionKey permission, String linkId, String buttonName, String actionName, String issueKey, String errorMessage) {
        this.backdoor.permissionSchemes().addUserPermission(0L, permission, "fred");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.assertLinkPresent(linkId);
        this.navigation.gotoPage("/secure/" + actionName + "!default.jspa?id=10000");
        this.tester.assertTextNotPresent(errorMessage);
        this.tester.assertSubmitButtonPresent(buttonName);
        this.backdoor.permissionSchemes().removeUserPermission(0L, permission, "fred");
        this.navigation.gotoPage("/secure/" + actionName + "!default.jspa?id=10000");
        this.tester.assertTextPresent(errorMessage);
        this.tester.assertSubmitButtonNotPresent(buttonName);
    }

    @Test
    @LoginAs(user="admin")
    public void testArchiveIssueLinkIssueIsArchived() {
        this.backdoor.issues().archiveIssue(this.keys.get(0));
        this.navigation.issue().gotoIssue(this.keys.get(0));
        this.tester.assertLinkNotPresent("archive-issue");
    }

    @Test
    @LoginAs(user="admin")
    public void testArchiveIssueLinkIssueAlreadyArchived() {
        this.navigation.issue().gotoIssue(this.keys.get(0));
        this.backdoor.issues().archiveIssue(this.keys.get(0));
        this.tester.clickLink("archive-issue");
        this.tester.assertTextPresent("We couldn&#39;t archive an already archived issue.");
    }

    @Test
    @LoginAs(user="admin")
    public void testRestoreIssueLinkActiveIssue() {
        this.navigation.issue().gotoIssue(this.keys.get(0));
        this.tester.assertLinkNotPresent("restore-issue");
    }

    @Test
    @LoginAs(user="admin")
    public void testRestoreIssueInArchivedProject() {
        this.backdoor.issues().archiveIssue(this.keys.get(0));
        this.backdoor.project().archiveProject(PROJECT);
        this.navigation.issue().gotoIssue(this.keys.get(0));
        this.tester.assertLinkNotPresent("restore-issue");
    }

    @Test
    @LoginAs(user="admin")
    public void testRestoreIssueLinkPresent() {
        this.backdoor.issues().archiveIssue(this.keys.get(0));
        this.navigation.issue().gotoIssue(this.keys.get(0));
        this.tester.assertLinkPresent("restore-issue");
        this.tester.clickLink("restore-issue");
        this.tester.assertSubmitButtonPresent("restore");
    }

    @Test
    public void testRestoreIssueLinkUserHasNoPermission() {
        this.navigation.login("fred", "fred");
        this.backdoor.issues().archiveIssue(this.keys.get(0));
        this.navigation.issue().gotoIssue(this.keys.get(0));
        this.tester.assertLinkNotPresent("restore-issue");
        this.navigation.gotoPage("/secure/RestoreIssue!default.jspa?id=10000");
        this.tester.assertTextPresent(RESTORE_PERMISSION_MESSAGE);
        this.tester.assertSubmitButtonNotPresent("restore");
    }

    @Test
    @LoginAs(user="admin")
    public void testRestoreIssueLinkIssueAlreadyRestored() {
        this.backdoor.issues().archiveIssue(this.keys.get(0));
        this.navigation.issue().gotoIssue(this.keys.get(0));
        this.backdoor.issues().restoreIssue(this.keys.get(0));
        this.tester.clickLink("restore-issue");
        this.tester.assertTextPresent("We couldn&#39;t restore an active issue.");
    }

    @Test
    @LoginAs(user="admin")
    public void testRedirectAfterIssueRestore() {
        this.backdoor.issues().archiveIssue(this.keys.get(0));
        this.navigation.gotoPage("/secure/RestoreIssue!default.jspa?id=10000");
        this.tester.setWorkingForm("restore-issue-form");
        this.tester.clickButton("restore-issue-submit");
        MatcherAssert.assertThat((Object)this.tester.getDialog().getWebClient().getCurrentPage().getURL().getPath(), (Matcher)CoreMatchers.endsWith((String)"/browse/PROJ-1"));
    }

    @Test
    @LoginAs(user="admin")
    public void testArchiveSubTask() {
        this.backdoor.subtask().enable();
        IssueCreateResponse subTask = this.backdoor.issues().createSubtask(this.backdoor.project().getProjectId(PROJECT).toString(), this.keys.get(0), "It's a subtask");
        Response archiveSubTaskResponse = this.backdoor.issues().archiveIssue(subTask.key);
        MatcherAssert.assertThat((Object)archiveSubTaskResponse.getStatusInfo(), (Matcher)CoreMatchers.is((Object)Response.Status.FORBIDDEN));
        this.navigation.issue().gotoIssue(subTask.key);
        this.tester.assertButtonNotPresent("archive-issue");
    }

    @Test
    @LoginAs(user="admin")
    public void testRestoreSubTask() {
        this.backdoor.subtask().enable();
        IssueCreateResponse subTask = this.backdoor.issues().createSubtask(this.backdoor.project().getProjectId(PROJECT).toString(), this.keys.get(0), "It's a subtask");
        this.backdoor.issues().archiveIssue(this.keys.get(0));
        Response restoreSubTaskResponse = this.backdoor.issues().restoreIssue(subTask.key);
        MatcherAssert.assertThat((Object)restoreSubTaskResponse.getStatusInfo(), (Matcher)CoreMatchers.is((Object)Response.Status.FORBIDDEN));
        this.navigation.issue().gotoIssue(subTask.key);
        this.tester.assertButtonNotPresent("restore-issue");
    }

    @Test
    @LoginAs(user="admin")
    public void testArchiveIssueShouldArchiveSubTask() {
        this.backdoor.subtask().enable();
        IssueCreateResponse subTask = this.backdoor.issues().createSubtask(this.backdoor.project().getProjectId(PROJECT).toString(), this.keys.get(0), "It's a subtask");
        this.backdoor.issues().archiveIssue(this.keys.get(0));
        this.navigation.issue().gotoIssue(subTask.key);
        this.tester.assertTextPresent("This issue is archived");
    }

    @Test
    @LoginAs(user="admin")
    public void testRestoreIssueShouldRestoreSubTask() {
        this.backdoor.subtask().enable();
        IssueCreateResponse subTask = this.backdoor.issues().createSubtask(this.backdoor.project().getProjectId(PROJECT).toString(), this.keys.get(0), "It's a subtask");
        this.backdoor.issues().archiveIssue(this.keys.get(0));
        this.backdoor.issues().restoreIssue(this.keys.get(0));
        this.navigation.issue().gotoIssue(this.keys.get(0));
        this.tester.assertTextNotPresent("This issue is archived");
        this.navigation.issue().gotoIssue(subTask.key);
        this.tester.assertTextNotPresent("This issue is archived");
    }

    @Test
    @LoginAs(user="admin")
    public void testArchiveIssueChangeHistoryItemPresent() {
        this.navigation.issue().gotoIssue(this.keys.get(2));
        this.assertions.assertLastChangeHistoryRecords(this.keys.get(2), Collections.emptyList());
        this.backdoor.issues().archiveIssue(this.keys.get(2));
        this.assertions.assertLastChangeHistoryRecords(this.keys.get(2), new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Archived", "", "Issue archived")));
    }

    @Test
    @LoginAs(user="admin")
    public void testRestoreIssueChangeHistoryItemPresent() {
        this.navigation.issue().gotoIssue(this.keys.get(2));
        this.assertions.assertLastChangeHistoryRecords(this.keys.get(2), Collections.emptyList());
        this.backdoor.issues().archiveIssue(this.keys.get(2));
        this.backdoor.issues().restoreIssue(this.keys.get(2));
        this.navigation.issue().gotoIssue(this.keys.get(2));
        this.assertions.assertNewestChangeHistoryRecord(this.keys.get(2), "admin", Collections.singletonList(new ExpectedChangeHistoryItem("Restored", "", "Issue restored")));
    }

    @Test
    public void testVotingIsNotVisibleOnIssuePage() {
        this.navigation.login("fred");
        this.navigation.issue().gotoIssue(this.keys.get(0));
        this.tester.assertLinkPresent("vote-toggle");
        this.tester.assertLinkPresent("toggle-vote-issue");
        this.tester.assertTextPresent("Votes");
        this.backdoor.issues().archiveIssue(this.keys.get(0));
        this.navigation.issue().gotoIssue(this.keys.get(0));
        this.tester.assertLinkNotPresent("vote-toggle");
        this.tester.assertLinkNotPresent("toggle-vote-issue");
        this.tester.assertTextNotPresent("Votes");
    }

    @Test
    public void testVotingIsDisabled() {
        this.expectedException.expectMessage("HTTP 404 Not Found");
        this.navigation.login("fred");
        this.backdoor.issues().archiveIssue(this.keys.get(0));
        this.backdoor.issueNavControl().vote(this.keys.get(0));
    }

    @Test
    public void testWatchingIssueIsNotVisibleOnIssuePage() {
        this.navigation.login("fred");
        this.navigation.issue().gotoIssue(this.keys.get(0));
        this.tester.assertLinkPresent("toggle-watch-issue");
        this.tester.assertTextPresent("Start watching this issue");
        this.tester.assertTextPresent("Watchers:");
        this.backdoor.issues().archiveIssue(this.keys.get(0));
        this.navigation.issue().gotoIssue(this.keys.get(0));
        this.tester.assertLinkNotPresent("toggle-watch-issue");
        this.tester.assertTextNotPresent("Start watching this issue");
        this.tester.assertTextNotPresent("Watchers:");
    }

    @Test
    public void testWatchingIsDisabled() {
        this.expectedException.expectMessage("HTTP 404 Not Found");
        this.navigation.login("fred");
        this.backdoor.issues().archiveIssue(this.keys.get(0));
        this.backdoor.issueNavControl().watch(this.keys.get(0));
    }
}

