/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.webtests.LicenseKeys;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
@LoginAs(user="admin")
public class TestArchivedIssueExportPermission
extends BaseJiraFuncTest {
    @Before
    public void setUp() {
        this.backdoor.restoreBlankInstance(LicenseKeys.COMMERCIAL);
        this.backdoor.usersAndGroups().addGroup("admin-group");
        this.backdoor.permissions().addGlobalPermission(0, "admin-group");
        this.backdoor.usersAndGroups().addUser("ordinary_admin");
        this.backdoor.usersAndGroups().addUserToGroup("ordinary_admin", "admin-group");
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=801000)
    public void testIfSysAdminCanDownloadCsv() {
        this.navigation.login("admin");
        String csvExport = this.getCsvExportOfAllArchivedItems();
        Assert.assertTrue((boolean)csvExport.startsWith("Id,"));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=801000)
    public void testIfAdminCannotDownloadCsv() {
        this.navigation.login("ordinary_admin");
        try {
            this.getCsvExportOfAllArchivedItems();
        }
        catch (Exception ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"Server returned HTTP response code: 403 for URL:"));
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=801000)
    public void testAnonymousExport() {
        this.navigation.logout();
        String csvExport = this.getCsvExportOfAllArchivedItems();
        Assert.assertTrue((boolean)csvExport.contains("<status-code>401</status-code>"));
    }

    private String getCsvExportOfAllArchivedItems() {
        this.tester.gotoPage("/rest/internal/2/archiving");
        return this.tester.getDialog().getResponseText();
    }
}

