/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.SearchClient;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.testkit.client.restclient.SearchResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
@LoginAs(user="admin")
public class TestCreateConcurrentIssues
extends BaseJiraFuncTest {
    private final String USERNAME_PREFIX = "Tester_";
    private final AtomicInteger USER_SEQUENCE = new AtomicInteger(0);
    private final ThreadLocal<Backdoor> THREAD_BACKDOOR = new ThreadLocal<Backdoor>(){

        @Override
        protected Backdoor initialValue() {
            return new Backdoor(TestCreateConcurrentIssues.this.getEnvironmentData());
        }
    };
    private final ThreadLocal<String> THREAD_USER = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return "Tester_" + TestCreateConcurrentIssues.this.USER_SEQUENCE.getAndIncrement();
        }
    };

    @Test
    public void testCreateIssues() throws Exception {
        int THREADS = 50;
        this.backdoor.restoreBlankInstance();
        this.backdoor.usersAndGroups().addUsers("Tester_", "Tester_", 50);
        SearchClient searchClient = new SearchClient((JIRAEnvironmentData)this.getEnvironmentData());
        final CountDownLatch startLatch = new CountDownLatch(1);
        final CountDownLatch completeLatch = new CountDownLatch(50);
        ExecutorService execService = Executors.newFixedThreadPool(50);
        Callable<Void> task = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String reporter = (String)TestCreateConcurrentIssues.this.THREAD_USER.get();
                try {
                    startLatch.await();
                    ((Backdoor)TestCreateConcurrentIssues.this.THREAD_BACKDOOR.get()).issues().loginAs(reporter).createIssue(10000L, "Simple Issue by " + reporter);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error creating issue as: " + reporter, e);
                }
                finally {
                    completeLatch.countDown();
                }
                return null;
            }
        };
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        for (int i = 0; i < 50; ++i) {
            futures.add(execService.submit(task));
        }
        startLatch.countDown();
        for (Future future : futures) {
            future.get();
        }
        SearchResult hspResults = ((SearchClient)searchClient.loginAs("admin")).postSearch(new SearchRequest().jql("project = HSP"));
        Assert.assertThat((Object)hspResults.total, (Matcher)CoreMatchers.equalTo((Object)50));
        Assert.assertThat((Object)hspResults.issues.size(), (Matcher)CoreMatchers.equalTo((Object)50));
        this.assertNoDuplicateKeys(hspResults.issues);
    }

    private void assertNoDuplicateKeys(List<Issue> issues) {
        Collections.sort(issues, new Comparator<Issue>(){

            @Override
            public int compare(Issue issue, Issue issue1) {
                return issue.key.compareTo(issue1.key);
            }
        });
        boolean foundDuplicate = false;
        String key = issues.get((int)0).key;
        for (Issue issue : issues.subList(1, issues.size())) {
            foundDuplicate = issue.key.equals(key);
            key = issue.key;
            if (!foundDuplicate) continue;
            break;
        }
        Assert.assertFalse((boolean)foundDuplicate);
    }
}

