/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.restclient.Component;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestCreateIssueForEnterprise
extends BaseJiraFuncTest {
    public static final String THE_OTHER_COMPONENT = "The other component";
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUp() {
        this.backdoor.darkFeatures().enableForSite("no.frother.assignee.field");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.backdoor.usersAndGroups().addUser("bob", "bob", "Bob The Builder", "bob@stuff.com.com");
    }

    @Test
    public void createIssueWithComponentLeadAssignee() {
        this.backdoor.usersAndGroups().addUserToGroup("bob", "jira-developers");
        Component component = this.backdoor.components().create(new Component().project("HSP").name(THE_OTHER_COMPONENT).leadUserName("bob").assigneeType(Component.AssigneeType.COMPONENT_LEAD));
        String issue = this.navigation.issue().createIssue("homosapien", "Bug", "test component lead", (Map<String, String[]>)ImmutableMap.of((Object)"components", (Object)new String[]{component.id.toString()}));
        this.navigation.issue().gotoIssue(issue);
        this.tester.assertTextPresent("test component lead");
        this.tester.assertTextPresent("Bug");
        this.tester.assertTextPresent("Bob The Builder");
    }

    @Test
    public void createIssueWithProjectLeadAssignee() {
        this.administration.usersAndGroups().addUserToGroup("bob", "jira-developers");
        this.administration.project().setProjectLead("homosapien", "bob");
        Component component = this.backdoor.components().create(new Component().project("HSP").name(THE_OTHER_COMPONENT).assigneeType(Component.AssigneeType.PROJECT_LEAD));
        String issue = this.navigation.issue().createIssue("homosapien", "Bug", "test project lead", (Map<String, String[]>)ImmutableMap.of((Object)"components", (Object)new String[]{component.id.toString()}));
        this.navigation.issue().gotoIssue(issue);
        this.tester.assertTextPresent("test project lead");
        this.tester.assertTextPresent("Bug");
        this.tester.assertTextPresent("Bob The Builder");
    }

    @Test
    public void createIssueWithUnassignedComponentLeadAssignee() {
        this.administration.generalConfiguration().setAllowUnassignedIssues(true);
        Component component = this.backdoor.components().create(new Component().project("HSP").name(THE_OTHER_COMPONENT).assigneeType(Component.AssigneeType.UNASSIGNED));
        String issue = this.navigation.issue().createIssue("homosapien", "Bug", "test unassigned", (Map<String, String[]>)ImmutableMap.of((Object)"components", (Object)new String[]{component.id.toString()}));
        this.navigation.issue().gotoIssue(issue);
        this.tester.assertTextPresent("test unassigned");
        this.tester.assertTextPresent("Bug");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Assignee:", "Unassigned");
    }
}

