/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.integrationtesting.runner.restore.RestoreOnce;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
@LoginAs(user="admin")
@RestoreOnce(value="TestCreateIssueViaDirectLink.xml")
public class TestCreateIssueViaDirectLink
extends BaseJiraFuncTest {
    private static final String PROJECT_STD_NAME = "standardProject";
    private static final String PROJECT_ANY_NAME = "anyone";
    private static final String PROJECT_DEV_NAME = "developerProject";
    private static final String ERROR_MSG_NO_PERM_AND_NOT_LOGGED_IN = "You are not logged in, and do not have the permissions required to create an issue in this project as a guest.";
    private static final String ERROR_MSG_NO_PERMISSION_TO_CREATE_ISSUE = "You do not have permission to create issues in this project.";
    private static final String SUMMARY_PREFIX = "test create issue via direct link";
    private static final String CUSTOM_FIELD_TEXTAREA_ID = "10000";
    private static final String CUSTOM_FIELD_DATEPICKER_ID = "10001";
    private static final String CUSTOM_FIELD_MULTICHECKBOX_ID = "10002";
    private static final String CUSTOM_FIELD_USERPICKER_ID = "10003";
    private static final String CUSTOM_FIELD_FLOAT_ID = "10004";
    private static final String CUSTOM_FIELD_TEXTAREA = "textarea";
    private static final String CUSTOM_FIELD_DATEPICKER = "datepicker";
    private static final String CUSTOM_FIELD_MULTICHECKBOX = "multicheckbox";
    private static final String CUSTOM_FIELD_USERPICKER = "userpicker";
    private static final String CUSTOM_FIELD_FLOAT = "numberfield";
    private static final String LOGIN = "log in";
    private static final String CREATE_BUTTON = "Create";
    private static final String DESCRIPTION = "description";
    private static final Map<String, String> issueIdToName = ImmutableMap.of((Object)"1", (Object)"Bug", (Object)"2", (Object)"New Feature", (Object)"3", (Object)"Task", (Object)"4", (Object)"Improvement");
    private static final Map<String, String> pidToName = ImmutableMap.of((Object)"10000", (Object)"standardProject", (Object)"10001", (Object)"developerProject", (Object)"10002", (Object)"anyone");
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUp() {
        this.backdoor.darkFeatures().enableForSite("no.frother.assignee.field");
        this.backdoor.darkFeatures().enableForSite("jira.no.frother.userpicker.field");
    }

    @After
    public void tearDown() {
        this.backdoor.darkFeatures().disableForSite("no.frother.assignee.field");
        this.backdoor.darkFeatures().disableForSite("jira.no.frother.userpicker.field");
        this.navigation.login("admin", "admin");
    }

    @Test
    public void testDirectIssueCreationNotLoggedInGuestPerm() {
        this.navigation.logout();
        Map<String, String> outputParams = this.createIssueViaDirectLink(CUSTOM_FIELD_MULTICHECKBOX_ID, "2", "test create issue via direct link1", true);
        this.tester.submit(CREATE_BUTTON);
        this.assertCreatedIssueDetails(outputParams);
    }

    @Test
    public void testDirectIssueCreationNotLoggedInNoPid() {
        this.navigation.logout();
        this.createIssueViaDirectLink(null, "1", "test create issue via direct link2");
        this.tester.assertTextPresent(ERROR_MSG_NO_PERM_AND_NOT_LOGGED_IN);
    }

    @Test
    public void testDirectIssueCreationNotLoggedInInvalidPid() {
        this.navigation.logout();
        this.createIssueViaDirectLink("invalid", "2", "test create issue via direct link3");
        this.tester.assertTextPresent(ERROR_MSG_NO_PERM_AND_NOT_LOGGED_IN);
    }

    @Test
    public void testDirectIssueCreationNotLoggedInNoGuestPerm() {
        this.navigation.logout();
        Map<String, String> outputParams = this.createIssueViaDirectLink(CUSTOM_FIELD_DATEPICKER_ID, "4", "test create issue via direct link4");
        this.tester.assertTextPresent("You are not logged in, and do not have the permissions required to create an issue in this project as a guest");
        this.tester.assertLinkPresentWithText(LOGIN);
        this.tester.clickLinkWithText(LOGIN);
        this.tester.setFormElement("os_username", "admin");
        this.tester.checkCheckbox("os_password", "admin");
        this.tester.setWorkingForm("login-form");
        this.tester.submit();
        this.assertCreateIssueDetailsForm(this.getInputParamsForAssertion(CUSTOM_FIELD_DATEPICKER_ID, "4", "test create issue via direct link4"));
        this.tester.submit(CREATE_BUTTON);
        this.assertCreatedIssueDetails(outputParams);
    }

    @Test
    public void testDirectIssueCreationLoggedInNoPerm() {
        this.navigation.login("bob", "bob");
        this.createIssueViaDirectLink(CUSTOM_FIELD_DATEPICKER_ID, "3", "test create issue via direct link5");
        this.tester.assertTextPresent(ERROR_MSG_NO_PERMISSION_TO_CREATE_ISSUE);
    }

    @Test
    public void testDirectIssueCreationLoggedInInvalidPid() {
        this.navigation.login("admin", "admin");
        this.createIssueViaDirectLink("invalid", "2", "test create issue via direct link6");
        this.tester.assertTextPresent(ERROR_MSG_NO_PERMISSION_TO_CREATE_ISSUE);
    }

    @Test
    public void testDirectIssueCreationLoggedInNoPid() {
        this.navigation.login("admin", "admin");
        this.createIssueViaDirectLink(null, "4", "test create issue via direct link7");
        this.tester.assertTextPresent(ERROR_MSG_NO_PERMISSION_TO_CREATE_ISSUE);
    }

    @Test
    public void testDirectIssueCreationLoggedInValidParams() {
        this.navigation.login("admin", "admin");
        Map<String, String> outputParams = this.createIssueViaDirectLink(CUSTOM_FIELD_TEXTAREA_ID, "1", "test create issue via direct link8", true);
        this.tester.submit(CREATE_BUTTON);
        this.assertCreatedIssueDetails(outputParams);
    }

    private Map<String, String> createIssueViaDirectLink(String pid, String issuetypeId, String summary) {
        return this.createIssueViaDirectLink(pid, issuetypeId, summary, false);
    }

    private Map<String, String> createIssueViaDirectLink(String pid, String issuetypeId, String summary, boolean assertParams) {
        Map<String, String> inputParams = this.getInputParams(pid, issuetypeId, summary);
        Map<String, String> inputParamsForAssertion = this.getInputParamsForAssertion(pid, issuetypeId, summary);
        this.createIssueViaDirectLink(inputParams, inputParamsForAssertion, assertParams);
        return this.getOutputParams(pid, summary, issuetypeId);
    }

    private Map<String, String> getInputParams(String pid, String issuetypeId, String summary) {
        HashMap<String, String> inputParams = new HashMap<String, String>();
        inputParams.put("pid", pid);
        inputParams.put("issuetype", issuetypeId);
        inputParams.put("summary", summary);
        inputParams.put("reporter", "admin");
        inputParams.put("assignee", "admin");
        inputParams.put(DESCRIPTION, DESCRIPTION);
        inputParams.put("customfield_10000", "this is a textarea");
        inputParams.put("customfield_10001", "6/Dec/05");
        inputParams.put("customfield_10002", CUSTOM_FIELD_TEXTAREA_ID);
        inputParams.put("customfield_10003", "bob");
        inputParams.put("customfield_10004", "123456789");
        return inputParams;
    }

    private Map<String, String> getInputParamsForAssertion(String pid, String issuetypeId, String summary) {
        Map<String, String> inputParams = this.getInputParams(pid, issuetypeId, summary);
        inputParams.put(DESCRIPTION, "\ndescription");
        inputParams.put("customfield_10000", "\nthis is a textarea");
        return inputParams;
    }

    private Map<String, String> getOutputParams(String pid, String summary, String issuetypeId) {
        HashMap<String, String> outputParams = new HashMap<String, String>();
        outputParams.put(pidToName.get(pid), summary);
        outputParams.put("Type", issueIdToName.get(issuetypeId));
        outputParams.put("Reporter", "admin");
        outputParams.put("Description", DESCRIPTION);
        outputParams.put(CUSTOM_FIELD_TEXTAREA, "this is a textarea");
        outputParams.put(CUSTOM_FIELD_DATEPICKER, "06/Dec/05");
        outputParams.put(CUSTOM_FIELD_MULTICHECKBOX, "1");
        outputParams.put(CUSTOM_FIELD_USERPICKER, "Bob The Builder");
        outputParams.put(CUSTOM_FIELD_FLOAT, "123,456,789");
        return outputParams;
    }

    private void createIssueViaDirectLink(Map<String, String> inputParams, Map<String, String> inputParamsForAssertion, boolean assertParams) {
        String url = this.getEnvironmentData().getContext() + "/secure/CreateIssueDetails!init.jspa?" + inputParams.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("&"));
        this.tester.gotoPage(url);
        if (assertParams) {
            this.assertCreateIssueDetailsForm(inputParamsForAssertion);
        }
    }

    private void assertCreateIssueDetailsForm(Map<String, String> inputParams) {
        inputParams.forEach((field, value) -> {
            if ("pid".equals(field)) {
                this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Project", pidToName.get(value));
            } else if ("issuetype".equals(field)) {
                this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Issue Type", issueIdToName.get(value));
            } else {
                this.tester.assertFormElementEquals(field, value);
            }
        });
    }

    private void assertCreatedIssueDetails(Map<String, String> outputParams) {
        this.tester.assertTextPresent("Details");
        outputParams.forEach((key, value) -> this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), (String)key, (String)value));
    }
}

