/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.FIELDS})
@LoginAs(user="admin")
public class TestDefaultTextRenderer
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;

    @Test
    public void testIssueLinksWithMultipleKeysInsideUrl() throws Exception {
        this.administration.restoreBlankInstance();
        String linkKey = this.navigation.issue().createIssue("homosapien", "Bug", "Test issue to link to");
        String badUrl = "http://example/" + linkKey + "/" + linkKey;
        String testKey = this.navigation.issue().createIssue("homosapien", "Bug", "Test issue to test");
        this.navigation.issue().viewIssue(testKey);
        this.tester.clickLink("edit-issue");
        this.tester.setFormElement("environment", "Some bad stuff " + badUrl + " and more");
        this.tester.submit("Update");
        this.assertions.getLinkAssertions().assertLinkLocationEndsWith(badUrl, badUrl);
    }
}

