/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.EditIssueFieldVisibility;
import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.Indexing;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Parser;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.assertions.IssueTableAssertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.parser.issue.ViewIssueDetails;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.rest.api.issue.TimeTracking;
import com.atlassian.jira.testkit.beans.Priority;
import com.atlassian.jira.testkit.client.IssueTypeControl;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.restclient.Component;
import com.atlassian.jira.webtests.ztests.workflow.ExpectedChangeHistoryItem;
import com.atlassian.jira.webtests.ztests.workflow.ExpectedChangeHistoryRecord;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.meterware.httpunit.WebForm;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
public class TestEditIssue
extends BaseJiraFuncTest {
    private static final String COMMENT_1 = "This issue is resolved now.";
    private static final String COMMENT_2 = "Viewable by developers group.";
    private static final String COMMENT_3 = "Viewable by Developers role.";
    private static final String HSP_1 = "HSP-1";
    private static final String MKY_2 = "MKY-2";
    private static final String ADDED_COMPONENT = "oracle component";
    private static final String DEFAULT_FIELD_CONFIG = "Default Field Configuration";
    @Inject
    private IssueTableAssertions issueTableAssertions;
    @Inject
    private FuncTestLogger logger;
    @Inject
    private com.atlassian.jira.functest.framework.admin.TimeTracking timeTracking;
    @Inject
    private Indexing indexing;
    @Inject
    private Assertions assertions;
    @Inject
    private Parser parse;
    @Inject
    private Form form;
    @Inject
    private HtmlPage htmlPage;
    @Inject
    private EditIssueFieldVisibility editIssueFieldVisibility;
    private String issueKeyNormal;
    private String issueKeyWithNoComponents;
    private String issueKeyWithTimeTracking;
    @Inject
    private TextAssertions textAssertions;
    @Inject
    private WorkflowUtil workflowUtil;

    @Before
    public void setUp() {
        this.backdoor.darkFeatures().enableForSite("jira.no.frother.reporter.field");
        this.backdoor.darkFeatures().enableForSite("jira.no.frother.userpicker.field");
        this.backdoor.darkFeatures().enableForSite(JiraFeatureFlagRegistrar.NO_FROTHER_MULTIUSERPICKER.featureKey());
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
    }

    @After
    public void tearDown() {
        this.backdoor.darkFeatures().disableForSite("jira.no.frother.reporter.field");
        this.backdoor.darkFeatures().disableForSite("jira.no.frother.userpicker.field");
        this.backdoor.darkFeatures().disableForSite(JiraFeatureFlagRegistrar.NO_FROTHER_MULTIUSERPICKER.featureKey());
    }

    @Test
    @Restore(value="TestEditIssue.xml")
    @LoginAs(user="admin")
    public void testUpdateIssueWithVersionCF() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.gotoAdmin();
        this.navigation.gotoCustomFields();
        this.tester.clickLink("add_custom_fields");
        this.tester.checkCheckbox("fieldType", "com.atlassian.jira.plugin.system.customfieldtypes:multiversion");
        this.tester.submit("nextBtn");
        this.tester.setFormElement("fieldName", "CF-A");
        this.tester.submit("nextBtn");
        this.tester.checkCheckbox("associatedScreens", "1");
        this.tester.checkCheckbox("associatedScreens", "3");
        this.tester.checkCheckbox("associatedScreens", "2");
        this.tester.submit("Update");
        this.navigation.issue().gotoIssue(HSP_1);
        this.tester.clickLink("edit-issue");
        this.tester.selectOption("customfield_10000", "New Version 1");
        this.tester.submit("Update");
        this.issueTableAssertions.assertSearchWithResults("project=homosapien AND CF-A=\"New Version 1\"", HSP_1);
        this.navigation.issue().gotoIssue(HSP_1);
        this.tester.clickLink("edit-issue");
        this.tester.getDialog().setFormParameter("customfield_10000", "-1");
        this.tester.submit("Update");
        this.issueTableAssertions.assertSearchWithResults("project=homosapien AND CF-A=\"New Version 1\"", new String[0]);
    }

    @Test
    @Restore(value="TestEditIssue.xml")
    @LoginAs(user="admin")
    public void testEditIssueUnknownReporter() throws Exception {
        this.navigation.issue().gotoIssue(MKY_2);
        this.tester.clickLink("edit-issue");
        this.tester.submit("Update");
        this.tester.assertTextPresent("The reporter specified is not a user.");
        this.tester.setFormElement("assignee", "admin");
        this.tester.setFormElement("reporter", "admin");
        this.tester.submit("Update");
    }

    @Test
    @RestoreBlankInstance
    @LoginAs(user="admin")
    public void editIssueWithoutSummary() {
        this.prepareIssuesForEditIssueTests();
        this.logger.log((Object)"Edit Issue: omitting summary");
        this.indexing.assertIndexedFieldCorrect("//item", (Map<String, String>)ImmutableMap.of((Object)"summary", (Object)"test with components"), null, this.issueKeyNormal);
        this.navigation.issue().gotoIssue(this.issueKeyNormal);
        this.tester.clickLink("edit-issue");
        this.tester.setFormElement("summary", "");
        this.tester.submit();
        this.tester.assertTextPresent("You must specify a summary of the issue.");
        this.tester.setFormElement("summary", "test if index is updated");
        this.tester.submit();
        this.indexing.assertIndexedFieldCorrect("//item", (Map<String, String>)ImmutableMap.of((Object)"summary", (Object)"test if index is updated"), (Map<String, String>)ImmutableMap.of((Object)"summary", (Object)"test with components"), this.issueKeyNormal);
    }

    @Test
    @RestoreBlankInstance
    @LoginAs(user="admin")
    public void editIssueWithRequiredFields() {
        this.prepareIssuesForEditIssueTests();
        this.editIssueFieldVisibility.setRequiredFields();
        this.logger.log((Object)"Edit Issue: Editing issue with required fields.");
        this.navigation.issue().gotoIssue(this.issueKeyWithNoComponents);
        this.tester.clickLink("edit-issue");
        this.tester.assertTextPresent("Edit Issue");
        this.tester.submit("Update");
        this.tester.assertTextPresent("Edit Issue");
        this.tester.assertTextPresent("Component/s is required");
        this.tester.assertTextPresent("Affects Version/s is required");
        this.tester.assertTextPresent("Fix Version/s is required");
        this.editIssueFieldVisibility.resetFields();
    }

    @Test
    @RestoreBlankInstance
    @LoginAs(user="admin")
    public void editIssueWithHiddenFields() {
        this.prepareIssuesForEditIssueTests();
        this.editIssueFieldVisibility.setHiddenFields("Component/s");
        this.editIssueFieldVisibility.setHiddenFields("Affects Version/s");
        this.editIssueFieldVisibility.setHiddenFields("Fix Version/s");
        this.logger.log((Object)"Edit Issue: Editing issue with Hidden fields.");
        this.navigation.issue().gotoIssue(this.issueKeyWithNoComponents);
        this.tester.clickLink("edit-issue");
        this.tester.assertTextPresent("Edit Issue");
        this.tester.assertLinkNotPresent("components");
        this.tester.assertLinkNotPresent("versions");
        this.tester.assertLinkNotPresent("fixVersions");
        this.editIssueFieldVisibility.resetFields();
    }

    @Test
    @RestoreBlankInstance
    @LoginAs(user="admin")
    public void editIssueWithInvalidDueDate() {
        this.prepareIssuesForEditIssueTests();
        this.logger.log((Object)"Edit Issue: Editing issue with invalid due date");
        this.navigation.issue().gotoIssue(this.issueKeyWithNoComponents);
        this.tester.clickLink("edit-issue");
        this.tester.assertTextPresent("Edit Issue");
        this.tester.setFormElement("duedate", "stuff");
        this.tester.submit();
        this.tester.assertTextPresent("Edit Issue");
        this.tester.assertTextPresent("You did not enter a valid date. Please enter the date in the format &quot;d/MMM/yy&quot;");
    }

    @Test
    @RestoreBlankInstance
    @LoginAs(user="admin")
    public void editIssueWithEditPermission() {
        this.prepareIssuesForEditIssueTests();
        this.logger.log((Object)"Edit Issue: Test availability of 'Edit Issue' link with 'Edit Issue' permission.");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.EDIT_ISSUES, "jira-developers");
        this.navigation.issue().gotoIssue(this.issueKeyNormal);
        this.tester.assertLinkNotPresent("edit-issue");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.EDIT_ISSUES, "jira-developers");
        this.navigation.issue().gotoIssue(this.issueKeyNormal);
        this.tester.assertLinkPresent("edit-issue");
    }

    @Test
    @RestoreBlankInstance
    @LoginAs(user="admin")
    public void editIssueWithSchedulePermission() {
        this.prepareIssuesForEditIssueTests();
        this.logger.log((Object)"Edit Issue: Test prescence of 'Due Date' field with 'Schedule Issue' permission.");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.SCHEDULE_ISSUES, "jira-developers");
        this.navigation.issue().gotoIssue(this.issueKeyNormal);
        this.tester.clickLink("edit-issue");
        this.tester.assertTextNotPresent("Due Date");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.SCHEDULE_ISSUES, "jira-developers");
        this.navigation.issue().gotoIssue(this.issueKeyNormal);
        this.tester.clickLink("edit-issue");
        this.tester.assertTextPresent("Due Date");
    }

    @Test
    @RestoreBlankInstance
    @LoginAs(user="admin")
    public void editIssueWithAssignPermission() {
        this.prepareIssuesForEditIssueTests();
        this.logger.log((Object)"Edit Issue: Test ability to specify assignee with 'Assign Issue' permission.");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.ASSIGN_ISSUES, "jira-developers");
        this.navigation.issue().gotoIssue(this.issueKeyNormal);
        this.tester.clickLink("edit-issue");
        this.tester.assertFormElementNotPresent("assignee");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.ASSIGN_ISSUES, "jira-developers");
        this.navigation.issue().gotoIssue(this.issueKeyNormal);
        this.tester.clickLink("edit-issue");
        this.tester.assertFormElementPresent("assignee");
    }

    @Test
    @RestoreBlankInstance
    @LoginAs(user="admin")
    public void editIssueWithModifyReporterPermission() {
        this.prepareIssuesForEditIssueTests();
        this.logger.log((Object)"Edit Issue: Test availability of Reporter with 'Modify Reporter' permission.");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, 30, "jira-administrators");
        this.navigation.issue().gotoIssue(this.issueKeyNormal);
        this.tester.clickLink("edit-issue");
        this.tester.assertFormElementNotPresent("reporter");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), 30, "jira-administrators");
        this.navigation.issue().gotoIssue(this.issueKeyNormal);
        this.tester.clickLink("edit-issue");
        this.tester.assertFormElementPresent("reporter");
    }

    @Test
    @RestoreBlankInstance
    @LoginAs(user="admin")
    public void editIssueWithAddCommentsPermission() {
        this.prepareIssuesForEditIssueTests();
        this.logger.log((Object)"Edit Issue: Test availability of Comment field with 'Add Comments' permission.");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.ADD_COMMENTS, "jira-users");
        this.navigation.issue().gotoIssue(this.issueKeyNormal);
        this.tester.assertLinkNotPresent("comment-issue");
        this.tester.assertLinkNotPresent("footer-comment-button");
        this.tester.clickLink("edit-issue");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.ADD_COMMENTS, "jira-users");
        this.navigation.issue().gotoIssue(this.issueKeyNormal);
        this.tester.assertLinkPresent("comment-issue");
        this.tester.assertLinkPresent("footer-comment-button");
        this.tester.clickLink("edit-issue");
    }

    @Test
    @RestoreBlankInstance
    @LoginAs(user="admin")
    public void editIssueWithTimeTracking() {
        this.prepareIssuesForEditIssueTests();
        this.logger.log((Object)"Edit Issue: Test availability of time tracking related fields");
        this.timeTracking.enable(TimeTracking.Mode.LEGACY);
        this.navigation.issue().gotoIssue(this.issueKeyWithTimeTracking);
        this.tester.clickLink("edit-issue");
        this.tester.assertFormElementPresent("timetracking");
        this.timeTracking.disable();
        this.timeTracking.enable(TimeTracking.Mode.LEGACY);
        this.logWorkOnIssue(this.issueKeyWithTimeTracking, "1d");
        this.navigation.issue().gotoIssue(this.issueKeyWithTimeTracking);
        this.tester.clickLink("edit-issue");
        this.tester.assertTextPresent("Remaining Estimate");
        this.tester.assertFormElementPresent("timetracking");
        this.tester.assertFormElementEquals("timetracking", "6d");
        this.timeTracking.switchFormat(TimeTracking.Format.DAYS);
        this.navigation.issue().gotoIssue(this.issueKeyWithTimeTracking);
        this.tester.clickLink("edit-issue");
        this.tester.assertTextPresent("Remaining Estimate");
        this.tester.assertFormElementPresent("timetracking");
        this.tester.assertFormElementEquals("timetracking", "6d");
        this.timeTracking.switchFormat(TimeTracking.Format.HOURS);
        this.navigation.issue().gotoIssue(this.issueKeyWithTimeTracking);
        this.tester.clickLink("edit-issue");
        this.tester.assertTextPresent("Remaining Estimate");
        this.tester.assertFormElementPresent("timetracking");
        this.tester.assertFormElementEquals("timetracking", "144h");
        this.logWorkOnIssue(this.issueKeyWithTimeTracking, "11m");
        this.timeTracking.switchFormat(TimeTracking.Format.PRETTY);
        this.navigation.issue().gotoIssue(this.issueKeyWithTimeTracking);
        this.tester.clickLink("edit-issue");
        this.tester.assertTextPresent("Remaining Estimate");
        this.tester.assertFormElementPresent("timetracking");
        this.tester.assertFormElementEquals("timetracking", "5d 23h 49m");
        this.timeTracking.switchFormat(TimeTracking.Format.DAYS);
        this.navigation.issue().gotoIssue(this.issueKeyWithTimeTracking);
        this.tester.clickLink("edit-issue");
        this.tester.assertTextPresent("Remaining Estimate");
        this.tester.assertFormElementPresent("timetracking");
        this.tester.assertFormElementEquals("timetracking", "5d 23h 49m");
        this.timeTracking.switchFormat(TimeTracking.Format.HOURS);
        this.navigation.issue().gotoIssue(this.issueKeyWithTimeTracking);
        this.tester.clickLink("edit-issue");
        this.tester.assertTextPresent("Remaining Estimate");
        this.tester.assertFormElementPresent("timetracking");
        this.tester.assertFormElementEquals("timetracking", "143h 49m");
        this.logWorkOnIssue(this.issueKeyWithTimeTracking, "19m");
        this.timeTracking.switchFormat(TimeTracking.Format.PRETTY);
        this.navigation.issue().gotoIssue(this.issueKeyWithTimeTracking);
        this.tester.clickLink("edit-issue");
        this.tester.assertTextPresent("Remaining Estimate");
        this.tester.assertFormElementPresent("timetracking");
        this.tester.assertFormElementEquals("timetracking", "5d 23h 30m");
        this.timeTracking.switchFormat(TimeTracking.Format.DAYS);
        this.navigation.issue().gotoIssue(this.issueKeyWithTimeTracking);
        this.tester.clickLink("edit-issue");
        this.tester.assertTextPresent("Remaining Estimate");
        this.tester.assertFormElementPresent("timetracking");
        this.tester.assertFormElementEquals("timetracking", "5d 23.5h");
        this.timeTracking.switchFormat(TimeTracking.Format.HOURS);
        this.navigation.issue().gotoIssue(this.issueKeyWithTimeTracking);
        this.tester.clickLink("edit-issue");
        this.tester.assertTextPresent("Remaining Estimate");
        this.tester.assertFormElementPresent("timetracking");
        this.tester.assertFormElementEquals("timetracking", "143.5h");
        this.logWorkOnIssue(this.issueKeyWithTimeTracking, "11h 48m");
        this.timeTracking.switchFormat(TimeTracking.Format.PRETTY);
        this.navigation.issue().gotoIssue(this.issueKeyWithTimeTracking);
        this.tester.clickLink("edit-issue");
        this.tester.assertTextPresent("Remaining Estimate");
        this.tester.assertFormElementPresent("timetracking");
        this.tester.assertFormElementEquals("timetracking", "5d 11h 42m");
        this.timeTracking.switchFormat(TimeTracking.Format.DAYS);
        this.navigation.issue().gotoIssue(this.issueKeyWithTimeTracking);
        this.tester.clickLink("edit-issue");
        this.tester.assertTextPresent("Remaining Estimate");
        this.tester.assertFormElementPresent("timetracking");
        this.tester.assertFormElementEquals("timetracking", "5d 11.7h");
        this.timeTracking.switchFormat(TimeTracking.Format.HOURS);
        this.navigation.issue().gotoIssue(this.issueKeyWithTimeTracking);
        this.tester.clickLink("edit-issue");
        this.tester.assertTextPresent("Remaining Estimate");
        this.tester.assertFormElementPresent("timetracking");
        this.tester.assertFormElementEquals("timetracking", "131.7h");
        this.timeTracking.disable();
    }

    @Test
    @Restore(value="TestEditIssue.xml")
    @LoginAs(user="admin")
    public void testEditClosedIssue() {
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.EDIT_ISSUES, "jira-users");
        this.navigation.issue().gotoIssue(HSP_1);
        this.tester.assertLinkPresent("edit-issue");
        this.workflowUtil.clickAction("action_id_2");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
        this.tester.assertLinkNotPresentWithText("edit-issue");
        this.navigation.gotoPage("/secure/EditIssue!default.jspa?id=10000");
        this.tester.assertTextPresent("You are not allowed to edit this issue due to its current status in the workflow.");
    }

    @Test
    @Restore(value="TestEditIssue.xml")
    @LoginAs(user="admin")
    public void testEditIssueWithEditPermissionManualNavigation() {
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.EDIT_ISSUES, "jira-developers");
        this.navigation.gotoPage("/secure/EditIssue!default.jspa?id=10000");
        this.tester.assertTextPresent("You do not have permission to edit issues in this project.");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.EDIT_ISSUES, "jira-users");
        this.navigation.gotoPage("/secure/EditIssue!default.jspa?id=10000");
        this.tester.assertTextNotPresent("You do not have permission to edit issues in this project.");
    }

    @Test
    @Restore(value="TestEditIssue.xml")
    public void testEditIssueWhileLoggedOut() {
        this.navigation.gotoPage("/secure/EditIssue!default.jspa?id=10000");
        this.tester.assertTextPresent("You are not logged in");
    }

    @Test
    @Restore(value="TestEditIssue.xml")
    public void testEditIssueWithPermissionWhileLoggedOut() {
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.BROWSE_PROJECTS);
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.EDIT_ISSUES);
        this.navigation.gotoPage("secure/Dashboard.jspa");
        this.navigation.issue().gotoIssue(HSP_1);
        this.tester.assertLinkPresent("edit-issue");
    }

    @Test
    @Restore(value="TestEditIssue.xml")
    @LoginAs(user="admin")
    public void testEditWithCommentVisibility() {
        this.navigation.comment().enableCommentGroupVisibility(true);
        this.indexing.assertIndexedFieldCorrect("//item/comments", null, (Map<String, String>)ImmutableMap.of((Object)"comment", (Object)COMMENT_1), HSP_1);
        this.navigation.issue().gotoIssue(HSP_1);
        this.tester.clickLink("edit-issue");
        this.tester.setFormElement("comment", COMMENT_1);
        this.tester.submit("Update");
        this.indexing.assertIndexedFieldCorrect("//item/comments", (Map<String, String>)ImmutableMap.of((Object)"comment", (Object)COMMENT_1), null, HSP_1);
        this.indexing.assertIndexedFieldCorrect("//item/comments", null, (Map<String, String>)ImmutableMap.of((Object)"comment", (Object)COMMENT_2), HSP_1);
        this.navigation.issue().gotoIssue(HSP_1);
        this.tester.clickLink("edit-issue");
        this.tester.setFormElement("comment", COMMENT_2);
        this.tester.selectOption("commentLevel", "jira-developers");
        this.tester.submit("Update");
        this.indexing.assertIndexedFieldCorrect("//item/comments", (Map<String, String>)ImmutableMap.of((Object)"comment", (Object)COMMENT_2), null, HSP_1);
        this.indexing.assertIndexedFieldCorrect("//item/comments", null, (Map<String, String>)ImmutableMap.of((Object)"comment", (Object)COMMENT_3), HSP_1);
        this.navigation.issue().gotoIssue(HSP_1);
        this.tester.clickLink("edit-issue");
        this.tester.setFormElement("comment", COMMENT_3);
        this.tester.selectOption("commentLevel", "Developers");
        this.tester.submit("Update");
        this.indexing.assertIndexedFieldCorrect("//item/comments", (Map<String, String>)ImmutableMap.of((Object)"comment", (Object)COMMENT_3), null, HSP_1);
        this.navigation.login("fred", "fred");
        this.navigation.issue().gotoIssue(HSP_1);
        this.tester.assertTextPresent(COMMENT_1);
        this.tester.assertTextNotPresent(COMMENT_2);
        this.tester.assertTextNotPresent(COMMENT_3);
        this.navigation.login("admin", "admin");
        this.navigation.issue().gotoIssue(HSP_1);
        this.tester.assertTextPresent(COMMENT_1);
        this.tester.assertTextPresent(COMMENT_2);
        this.tester.assertTextPresent(COMMENT_3);
    }

    @Test
    @Restore(value="TestEditIssueWithNoChanges.xml")
    @LoginAs(user="admin")
    public void testEditNewComponentAndIssueWithNoChanges() {
        this.backdoor.components().create(new Component().name(ADDED_COMPONENT).project("HSP"));
        String issueKey = this.backdoor.issues().createIssue("HSP", "edit issue test summary", "admin", this.getIdOfPriority("Blocker"), this.getIdOfIssueType("New Feature")).key();
        this.backdoor.issues().setIssueFields(issueKey, new IssueFields().components(new ResourceRef[]{ResourceRef.withName((String)ADDED_COMPONENT)}).versions(new ResourceRef[]{ResourceRef.withName((String)"New Version 2")}).fixVersions(new ResourceRef[]{ResourceRef.withName((String)"New Version 1"), ResourceRef.withName((String)"New Version 3")}).description("edit issue description").environment("edit environment").timeTracking(new TimeTracking("5d", null)).dueDate("2007-02-14"));
        this.navigation.issue().gotoIssue(issueKey);
        this.assertNewComponentAndIssueViewPage();
        this.tester.clickLink("edit-issue");
        WebForm form = this.form.switchTo("issue-edit");
        Assert.assertThat((Object)form.getParameterValue("summary"), (Matcher)Matchers.equalTo((Object)"edit issue test summary"));
        Assert.assertThat((Object)form.getParameterValue("environment").trim(), (Matcher)Matchers.equalTo((Object)"edit environment"));
        Assert.assertThat((Object)form.getParameterValue("description").trim(), (Matcher)Matchers.equalTo((Object)"edit issue description"));
        this.assertions.getProjectFieldsAssertions().assertIssueTypeIsSelected("New Feature");
        this.assertions.getJiraFormAssertions().assertSelectElementByIdHasOptionSelected("priority", "Blocker");
        Assert.assertThat((Object)form.getParameterValue("duedate"), (Matcher)Matchers.equalTo((Object)"14/Feb/07"));
        this.assertions.getJiraFormAssertions().assertSelectElementByIdHasOptionSelected("components", ADDED_COMPONENT);
        this.assertions.getJiraFormAssertions().assertSelectElementByIdHasOptionSelected("fixVersions", "New Version 1");
        this.assertions.getJiraFormAssertions().assertSelectElementByIdHasOptionSelected("fixVersions", "New Version 3");
        this.assertions.getJiraFormAssertions().assertSelectElementByIdHasOptionSelected("versions", "New Version 2");
        this.assertions.getJiraFormAssertions().assertSelectElementByIdHasOptionSelected("assignee", "Administrator");
        Assert.assertThat((Object)form.getParameterValue("reporter"), (Matcher)Matchers.equalTo((Object)"admin"));
        Assert.assertThat((Object)form.getParameterValue("timetracking"), (Matcher)Matchers.equalTo((Object)"5d"));
        this.tester.submit("Update");
        this.assertNewComponentAndIssueViewPage();
    }

    private void assertNewComponentAndIssueViewPage() {
        this.tester.assertLinkPresentWithText("homosapien");
        this.textAssertions.assertTextSequence(this.htmlPage.asString(), "Type", "New Feature");
        this.tester.assertTextPresent("edit issue test summary");
        this.textAssertions.assertTextSequence(this.htmlPage.asString(), "Priority", "Blocker");
        this.textAssertions.assertTextSequence(this.htmlPage.asString(), "Due", "14/Feb/07");
        this.textAssertions.assertTextSequence(this.htmlPage.asString(), "Component/s", ADDED_COMPONENT);
        this.textAssertions.assertTextSequence(this.htmlPage.asString(), "Affects Version/s", "New Version 2");
        this.textAssertions.assertTextSequence(this.htmlPage.asString(), "Fix Version/s", "New Version 1");
        this.textAssertions.assertTextSequence(this.htmlPage.asString(), "Fix Version/s", "New Version 3");
        this.textAssertions.assertTextSequence(this.htmlPage.asString(), "Assignee", "Administrator");
        this.textAssertions.assertTextSequence(this.htmlPage.asString(), "Reporter", "Administrator");
        this.textAssertions.assertTextSequence(this.htmlPage.asString(), "Environment", "edit environment");
        this.textAssertions.assertTextSequence(this.htmlPage.asString(), "Description", "edit issue description");
    }

    @Test
    @Restore(value="TestEditIssueWithNoChanges.xml")
    @LoginAs(user="admin")
    public void testEditIssueWithCustomFieldsAndNoChanges() {
        this.navigation.issue().gotoIssue(HSP_1);
        this.assertInitialViewIssueFieldValues();
        this.tester.clickLink("edit-issue");
        this.assertInitialEditIssueFieldValues();
        this.tester.setWorkingForm("issue-edit");
        this.tester.submit();
        this.assertInitialViewIssueFieldValues();
    }

    @Test
    @Restore(value="TestEditIssueWithNoChanges.xml")
    @LoginAs(user="admin")
    public void testEditIssueWithCustomFieldsAndRemoveValues() {
        this.navigation.issue().gotoIssue(HSP_1);
        this.assertInitialViewIssueFieldValues();
        this.assertions.assertLastChangeHistoryRecords(HSP_1, Collections.emptyList());
        this.tester.clickLink("edit-issue");
        this.assertInitialEditIssueFieldValues();
        this.navigation.issue().selectIssueType("Task", "issuetype");
        this.tester.selectOption("priority", "Critical");
        this.tester.selectOption("components", "Unknown");
        this.tester.selectOption("versions", "Unknown");
        this.tester.selectOption("fixVersions", "Unknown");
        this.tester.setFormElement("description", "");
        this.tester.setFormElement("environment", "");
        this.tester.setFormElement("reporter", "admin");
        this.tester.setFormElement("timetracking", "");
        this.tester.selectOption("customfield_10000", "None");
        this.tester.selectOption("customfield_10000:1", "None");
        this.tester.setFormElement("customfield_10001", "");
        this.tester.setFormElement("customfield_10002", "");
        this.tester.setFormElement("customfield_10003", "");
        this.tester.setFormElement("customfield_10004", "");
        this.tester.uncheckCheckbox("customfield_10006", "10008");
        this.tester.setFormElement("customfield_10007", "");
        this.tester.selectOption("customfield_10008", "None");
        this.tester.setFormElement("customfield_10009", "");
        this.tester.setFormElement("customfield_10010", "");
        this.tester.selectOption("customfield_10011", "None");
        this.tester.checkCheckbox("customfield_10012", "-1");
        this.tester.selectOption("customfield_10014", "None");
        this.tester.selectOption("customfield_10015", "Unknown");
        this.tester.setFormElement("customfield_10016", "");
        this.tester.setFormElement("customfield_10017", "");
        this.tester.setFormElement("customfield_10018", "");
        this.tester.selectOption("customfield_10019", "Unknown");
        this.tester.setWorkingForm("issue-edit");
        this.tester.submit("Update");
        this.assertions.assertLastChangeHistoryRecords(HSP_1, new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Issue Type", "Improvement", "Task"), new ExpectedChangeHistoryItem("Text Field", "text field", ""), new ExpectedChangeHistoryItem("Environment", "test environment 1", ""), new ExpectedChangeHistoryItem("Project Picker", "monkey", ""), new ExpectedChangeHistoryItem("Group Picker", "jira-users", ""), new ExpectedChangeHistoryItem("Multi Select", (Iterable<String>)ImmutableList.of((Object)"value 1", (Object)"value 2"), Collections.emptyList()), new ExpectedChangeHistoryItem("Number Field", "12345", ""), new ExpectedChangeHistoryItem("Component/s", "New Component 1", ""), new ExpectedChangeHistoryItem("Component/s", "New Component 3", ""), new ExpectedChangeHistoryItem("Fix Version/s", "New Version 2", ""), new ExpectedChangeHistoryItem("Free Text Field", "this is a free text", ""), new ExpectedChangeHistoryItem("Multi User Picker", "admin", ""), new ExpectedChangeHistoryItem("Affects Version/s", "New Version 1", ""), new ExpectedChangeHistoryItem("Affects Version/s", "New Version 3", ""), new ExpectedChangeHistoryItem("User Picker", "admin", ""), new ExpectedChangeHistoryItem("Priority", "Trivial", "Critical"), new ExpectedChangeHistoryItem("URL Field", "http://www.atlassian.com", ""), new ExpectedChangeHistoryItem("Version Picker", (Iterable<String>)ImmutableList.of((Object)"New Version 1", (Object)"New Version 3"), Collections.emptyList()), new ExpectedChangeHistoryItem("Single Version Picker", "New Version 3", ""), new ExpectedChangeHistoryItem("Date Picker", "13/Feb/07", ""), new ExpectedChangeHistoryItem("Radio Buttons", "value 3", ""), new ExpectedChangeHistoryItem("Multi Group Picker", (Iterable<String>)ImmutableList.of((Object)"jira-developers", (Object)"jira-users"), Collections.emptyList()), new ExpectedChangeHistoryItem("Cascading Select", (Iterable<String>)ImmutableList.of((Object)"Parent values: value 1", (Object)"Level 1 values: value 1.2"), Collections.emptyList()), new ExpectedChangeHistoryItem("Remaining Estimate", "3 days", ""), new ExpectedChangeHistoryItem("Select List", "value 3", ""), new ExpectedChangeHistoryItem("Description", "test editing issue without any changes", ""), new ExpectedChangeHistoryItem("Date Time", "12/Feb/07 11:26 AM", ""), new ExpectedChangeHistoryItem("Multi Checkboxes", "value 3", "")));
    }

    @Test
    @Restore(value="TestEditIssueWithNoChanges.xml")
    @LoginAs(user="admin")
    public void testEditIssueWithInvalidMultiUserCustomField() {
        this.editIssueFieldVisibility.setRequiredFieldsOnEnterprise(DEFAULT_FIELD_CONFIG, "Multi User Picker");
        this.navigation.issue().gotoIssue(HSP_1);
        this.tester.clickLink("edit-issue");
        this.tester.assertTextPresent("Edit Issue");
        this.tester.setFormElement("customfield_10009", ",,   , ,,");
        this.tester.submit("Update");
        this.tester.assertTextPresent("Edit Issue");
        this.tester.assertTextPresent("Multi User Picker is required");
        this.editIssueFieldVisibility.resetFields();
    }

    @Test
    @Restore(value="TestEditIssueWithNoChanges.xml")
    @LoginAs(user="admin")
    public void testEditIssueWithCustomFieldsAndChangeValues() {
        this.navigation.issue().gotoIssue(HSP_1);
        this.assertInitialViewIssueFieldValues();
        this.assertions.assertLastChangeHistoryRecords(HSP_1, Collections.emptyList());
        this.tester.clickLink("edit-issue");
        this.assertInitialEditIssueFieldValues();
        this.tester.setFormElement("summary", "new summary");
        this.tester.setFormElement("description", "new description");
        this.tester.setFormElement("environment", "new environment");
        this.navigation.issue().selectIssueType("Bug", "issuetype");
        this.tester.selectOption("priority", "Minor");
        this.tester.selectOption("components", "New Component 2");
        this.tester.selectOption("versions", "New Version 2");
        this.tester.selectOption("fixVersions", "New Version 1");
        this.tester.selectOption("fixVersions", "New Version 1");
        this.tester.setFormElement("timetracking", "1d");
        this.tester.selectOption("customfield_10000", "value 2");
        this.tester.selectOption("customfield_10000:1", "value 2.1");
        this.tester.setFormElement("customfield_10001", "21/Feb/07");
        this.tester.setFormElement("customfield_10002", "21/Feb/07 11:30 AM");
        this.tester.setFormElement("customfield_10003", "new free text field");
        this.tester.setFormElement("customfield_10004", "jira-developers");
        this.tester.checkCheckbox("customfield_10006", "10007");
        this.tester.setFormElement("customfield_10007", "jira-administrators, jira-users");
        this.form.selectOptionsByDisplayName("customfield_10008", new String[]{"value 3", "value 2"});
        this.tester.setFormElement("customfield_10009", "fred");
        this.tester.setFormElement("customfield_10010", "54321");
        this.tester.selectOption("customfield_10011", "homosapien");
        this.tester.checkCheckbox("customfield_10012", "10012");
        this.tester.selectOption("customfield_10014", "value 2");
        this.tester.selectOption("customfield_10015", "New Version 2");
        this.tester.setFormElement("customfield_10016", "text field modified");
        this.tester.setFormElement("customfield_10017", "http://www.atlassian.com/software/jira");
        this.tester.setFormElement("customfield_10018", "fred");
        this.tester.selectOption("customfield_10019", "New Version 2");
        this.tester.submit("Update");
        this.assertions.assertLastChangeHistoryRecords(HSP_1, new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Issue Type", "Improvement", "Bug"), new ExpectedChangeHistoryItem("Text Field", "text field", "text field modified"), new ExpectedChangeHistoryItem("Environment", "test environment 1", "new environment"), new ExpectedChangeHistoryItem("Project Picker", "monkey", "homosapien"), new ExpectedChangeHistoryItem("Group Picker", "jira-users", "jira-developers"), new ExpectedChangeHistoryItem("Multi Select", (Iterable<String>)ImmutableList.of((Object)"value 1", (Object)"value 2"), (Iterable<String>)ImmutableList.of((Object)"value 2", (Object)"value 3")), new ExpectedChangeHistoryItem("Number Field", "12345", "54321"), new ExpectedChangeHistoryItem("Component/s", "New Component 1", ""), new ExpectedChangeHistoryItem("Component/s", "New Component 3", ""), new ExpectedChangeHistoryItem("Component/s", "", "New Component 2"), new ExpectedChangeHistoryItem("Fix Version/s", "New Version 2", ""), new ExpectedChangeHistoryItem("Fix Version/s", "", "New Version 1"), new ExpectedChangeHistoryItem("Free Text Field", "this is a free text", "new free text field"), new ExpectedChangeHistoryItem("Multi User Picker", "admin", "fred"), new ExpectedChangeHistoryItem("Affects Version/s", "New Version 1", ""), new ExpectedChangeHistoryItem("Affects Version/s", "New Version 3", ""), new ExpectedChangeHistoryItem("Affects Version/s", "", "New Version 2"), new ExpectedChangeHistoryItem("User Picker", "admin", "fred"), new ExpectedChangeHistoryItem("Priority", "Trivial", "Minor"), new ExpectedChangeHistoryItem("Summary", "test edit issue with no changes", "new summary"), new ExpectedChangeHistoryItem("URL Field", "http://www.atlassian.com", "http://www.atlassian.com/software/jira"), new ExpectedChangeHistoryItem("Date Picker", "13/Feb/07", "21/Feb/07"), new ExpectedChangeHistoryItem("Radio Buttons", "value 3", "value 1"), new ExpectedChangeHistoryItem("Multi Group Picker", (Iterable<String>)ImmutableList.of((Object)"jira-developers", (Object)"jira-users"), (Iterable<String>)ImmutableList.of((Object)"jira-administrators", (Object)"jira-users")), new ExpectedChangeHistoryItem("Cascading Select", (Iterable<String>)ImmutableList.of((Object)"Parent values: value 1", (Object)"Level 1 values: value 1.2"), (Iterable<String>)ImmutableList.of((Object)"Parent values: value 2", (Object)"Level 1 values: value 2.1")), new ExpectedChangeHistoryItem("Remaining Estimate", "3 days", "1 day"), new ExpectedChangeHistoryItem("Single Version Picker", "New Version 3", "New Version 2"), new ExpectedChangeHistoryItem("Version Picker", (Iterable<String>)ImmutableList.of((Object)"New Version 1", (Object)"New Version 3"), Collections.singletonList("New Version 2")), new ExpectedChangeHistoryItem("Select List", "value 3", "value 2"), new ExpectedChangeHistoryItem("Description", "test editing issue without any changes", "new description"), new ExpectedChangeHistoryItem("Date Time", "12/Feb/07 11:26 AM", "21/Feb/07 11:30 AM"), new ExpectedChangeHistoryItem("Multi Checkboxes", "value 3", "value 2")));
    }

    private void assertInitialViewIssueFieldValues() {
        this.tester.assertLinkPresentWithText("homosapien");
        this.textAssertions.assertTextSequence(this.htmlPage.asString(), "Type", "Improvement");
        this.tester.assertTextPresent("test edit issue with no changes");
        this.textAssertions.assertTextSequence(this.htmlPage.asString(), "Priority", "Trivial");
        this.textAssertions.assertTextSequence(this.htmlPage.asString(), "Due", "14/Feb/07");
        this.textAssertions.assertTextSequence(this.htmlPage.asString(), "Component/s", "New Component 1");
        this.textAssertions.assertTextSequence(this.htmlPage.asString(), "Component/s", "New Component 3");
        this.textAssertions.assertTextSequence(this.htmlPage.asString(), "Affects Version/s", "New Version 1");
        this.textAssertions.assertTextSequence(this.htmlPage.asString(), "Affects Version/s", "New Version 3");
        this.textAssertions.assertTextSequence(this.htmlPage.asString(), "Fix Version/s", "New Version 2");
        this.textAssertions.assertTextSequence(this.htmlPage.asString(), "Assignee", "Administrator");
        this.textAssertions.assertTextSequence(this.htmlPage.asString(), "Reporter", "Administrator");
        this.textAssertions.assertTextSequence(this.htmlPage.asString(), "Environment", "test environment 1");
        this.textAssertions.assertTextSequence(this.htmlPage.asString(), "Description", "test editing issue without any changes");
        TreeMap<String, Object> fieldValues = new TreeMap<String, Object>();
        fieldValues.put("Cascading Select", new String[]{"value 1", "value 1.2"});
        fieldValues.put("Date Picker", "13/Feb/07");
        fieldValues.put("Date Time", "12/Feb/07 11:26 AM");
        fieldValues.put("Free Text Field", "this is a free text");
        fieldValues.put("Group Picker", "jira-users");
        fieldValues.put("Multi Checkboxes", "value 3");
        fieldValues.put("Multi Group Picker", new String[]{"jira-developers", "jira-users"});
        fieldValues.put("Multi Select", new String[]{"value 1", "value 2"});
        fieldValues.put("Multi User Picker", "Administrator");
        fieldValues.put("Number Field", "12,345");
        fieldValues.put("Project Picker", "monkey");
        fieldValues.put("Radio Buttons", "value 3");
        fieldValues.put("Select List", "value 3");
        fieldValues.put("Single Version Picker", "New Version 3");
        fieldValues.put("Text Field", "text field");
        fieldValues.put("URL Field", "http://www.atlassian.com");
        fieldValues.put("User Picker", "Administrator");
        fieldValues.put("Version Picker", new String[]{"New Version 1", "New Version 3"});
        ViewIssueDetails details = this.parse.issue().parseViewIssuePage();
        for (Map.Entry entry : fieldValues.entrySet()) {
            String actualValue = details.getCustomFields().get(entry.getKey());
            if (actualValue == null) {
                Assert.fail((String)("Unable to find a value for field '" + (String)entry.getKey() + "'."));
                continue;
            }
            if (entry.getValue() instanceof String[]) {
                for (String v : (String[])entry.getValue()) {
                    this.textAssertions.assertTextPresent(actualValue, v);
                }
                continue;
            }
            this.textAssertions.assertTextPresent(actualValue, entry.getValue().toString());
        }
    }

    private void assertInitialEditIssueFieldValues() {
        WebForm form = this.form.switchTo("issue-edit");
        Assert.assertEquals((Object)"test edit issue with no changes", (Object)form.getParameterValue("summary"));
        this.assertions.getProjectFieldsAssertions().assertIssueTypeIsSelected("Improvement");
        this.assertions.getJiraFormAssertions().assertSelectElementByIdHasOptionSelected("priority", "Trivial");
        Assert.assertThat((Object)form.getParameterValue("duedate"), (Matcher)Matchers.equalTo((Object)"14/Feb/07"));
        this.assertions.getJiraFormAssertions().assertSelectElementByIdHasOptionSelected("components", "New Component 1");
        this.assertions.getJiraFormAssertions().assertSelectElementByIdHasOptionSelected("components", "New Component 3");
        this.assertions.getJiraFormAssertions().assertSelectElementByIdHasOptionSelected("versions", "New Version 1");
        this.assertions.getJiraFormAssertions().assertSelectElementByIdHasOptionSelected("versions", "New Version 3");
        this.assertions.getJiraFormAssertions().assertSelectElementByIdHasOptionSelected("fixVersions", "New Version 2");
        this.assertions.getJiraFormAssertions().assertSelectElementByIdHasOptionSelected("assignee", "Administrator");
        Assert.assertThat((Object)form.getParameterValue("reporter"), (Matcher)Matchers.equalTo((Object)"admin"));
        Assert.assertThat((Object)form.getParameterValue("environment").trim(), (Matcher)Matchers.equalTo((Object)"test environment 1"));
        Assert.assertThat((Object)form.getParameterValue("description").trim(), (Matcher)Matchers.equalTo((Object)"test editing issue without any changes"));
        Assert.assertThat((Object)form.getParameterValue("timetracking"), (Matcher)Matchers.equalTo((Object)"3d"));
        this.assertions.getJiraFormAssertions().assertSelectElementByIdHasOptionSelected("customfield_10000", "value 1");
        this.assertions.getJiraFormAssertions().assertSelectElementByIdHasOptionSelected("customfield_10000:1", "value 1.2");
        Assert.assertThat((Object)form.getParameterValue("customfield_10001"), (Matcher)Matchers.equalTo((Object)"13/Feb/07"));
        Assert.assertThat((Object)form.getParameterValue("customfield_10002"), (Matcher)Matchers.equalTo((Object)"12/Feb/07 11:26 AM"));
        Assert.assertThat((Object)form.getParameterValue("customfield_10003").trim(), (Matcher)Matchers.equalTo((Object)"this is a free text"));
        Assert.assertThat((Object)form.getParameterValue("customfield_10004"), (Matcher)Matchers.equalTo((Object)"jira-users"));
        this.tester.checkCheckbox("customfield_10006", "10008");
        Assert.assertThat((Object)form.getParameterValue("customfield_10007"), (Matcher)Matchers.equalTo((Object)"jira-developers, jira-users"));
        this.assertions.getJiraFormAssertions().assertSelectElementByIdHasOptionSelected("customfield_10008", "value 1");
        this.assertions.getJiraFormAssertions().assertSelectElementByIdHasOptionSelected("customfield_10008", "value 2");
        Assert.assertThat((Object)form.getParameterValue("customfield_10009").trim(), (Matcher)Matchers.equalTo((Object)"admin"));
        Assert.assertThat((Object)form.getParameterValue("customfield_10010"), (Matcher)Matchers.equalTo((Object)"12345"));
        this.assertions.getJiraFormAssertions().assertSelectElementByIdHasOptionSelected("customfield_10011", "monkey");
        this.assertions.getJiraFormAssertions().assertSelectElementByIdHasOptionSelectedById("customfield_10012", "10014");
        this.assertions.getJiraFormAssertions().assertSelectElementByIdHasOptionSelected("customfield_10014", "value 3");
        this.assertions.getJiraFormAssertions().assertSelectElementByIdHasOptionSelected("customfield_10015", "New Version 3");
        Assert.assertThat((Object)form.getParameterValue("customfield_10016"), (Matcher)Matchers.equalTo((Object)"text field"));
        Assert.assertThat((Object)form.getParameterValue("customfield_10017"), (Matcher)Matchers.equalTo((Object)"http://www.atlassian.com"));
        Assert.assertThat((Object)form.getParameterValue("customfield_10018"), (Matcher)Matchers.equalTo((Object)"admin"));
        this.assertions.getJiraFormAssertions().assertSelectElementByIdHasOptionSelected("customfield_10019", "New Version 1");
        this.assertions.getJiraFormAssertions().assertSelectElementByIdHasOptionSelected("customfield_10019", "New Version 3");
    }

    private void logWorkOnIssue(String issueKey, String timeLogged) {
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("log-work");
        this.tester.setFormElement("timeLogged", timeLogged);
        this.tester.submit();
    }

    private void prepareIssuesForEditIssueTests() {
        Map<String, Priority> priorityMap = this.getPriorityNameToObjectMap();
        Map<String, IssueTypeControl.IssueType> issueTypeMap = this.getIssueTypeNameToObjectMap();
        this.issueKeyNormal = this.backdoor.issues().createIssue("HSP", "test with components", "admin", priorityMap.get("Minor").getId(), issueTypeMap.get("Bug").getId()).key();
        this.backdoor.issues().setIssueFields(this.issueKeyNormal, new IssueFields().components(new ResourceRef[]{ResourceRef.withName((String)"New Component 1")}).versions(new ResourceRef[]{ResourceRef.withName((String)"New Version 1")}).fixVersions(new ResourceRef[]{ResourceRef.withName((String)"New Version 1")}).description("test description normal issue for editing").environment("test environment 1"));
        this.issueKeyWithNoComponents = this.backdoor.issues().createIssue("HSP", "test without components or versions", "admin", priorityMap.get("Minor").getId(), issueTypeMap.get("Bug").getId()).key();
        this.backdoor.issues().setIssueFields(this.issueKeyWithNoComponents, new IssueFields().description("test description issue with components").environment("test environment 2"));
        this.timeTracking.enable(TimeTracking.Mode.LEGACY);
        this.issueKeyWithTimeTracking = this.backdoor.issues().createIssue("HSP", "test with time tracking", "admin", priorityMap.get("Critical").getId(), issueTypeMap.get("New Feature").getId()).key();
        this.backdoor.issues().setIssueFields(this.issueKeyWithTimeTracking, new IssueFields().description("test description issue with time tracking").environment("test environment 3").timeTracking(new TimeTracking("1w", null)));
        this.timeTracking.disable();
    }

    private Map<String, Priority> getPriorityNameToObjectMap() {
        return this.backdoor.getTestkit().priorities().getPriorities().stream().collect(Collectors.toMap(Priority::getName, Function.identity()));
    }

    private String getIdOfPriority(String priorityName) {
        return this.backdoor.getTestkit().priorities().getPriorities().stream().filter(c -> c.getName().equals(priorityName)).map(Priority::getId).findAny().orElseThrow(AssertionError::new);
    }

    private Map<String, IssueTypeControl.IssueType> getIssueTypeNameToObjectMap() {
        return this.backdoor.getTestkit().issueType().getIssueTypesForProject("HSP").stream().collect(Collectors.toMap(IssueTypeControl.IssueType::getName, Function.identity()));
    }

    private String getIdOfIssueType(String issueTypeName) {
        return this.backdoor.getTestkit().issueType().getIssueTypesForProject("HSP").stream().filter(t -> t.getName().equals(issueTypeName)).map(IssueTypeControl.IssueType::getId).findAny().orElseThrow(AssertionError::new);
    }
}

