/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.FIELDS})
@LoginAs(user="admin")
public class TestEnvironmentField
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestEnvironmentField.xml");
    }

    @Test
    public void testEnvironmentFieldNeverHidden() throws Exception {
        this.assertEnvironmentFieldShownOnViewIssue(true);
        this.backdoor.screens().removeFieldFromScreen("Default Screen", "Environment");
        this.assertEnvironmentFieldShownOnViewIssue(false);
    }

    @Test
    public void testHideShowToggleButton() throws Exception {
        this.navigation.issue().viewIssue("HSP-1");
        this.textAssertions.assertTextNotPresent(new IdLocator(this.tester, "environment-val"), "Hide");
        this.tester.assertElementNotPresent("field-environment");
        this.navigation.issue().viewIssue("HSP-2");
        this.textAssertions.assertTextNotPresent(new IdLocator(this.tester, "environment-val"), "Hide");
        this.navigation.issue().setEnvironment("HSP-2", "A long description that is over 255 characters that will case teh twixie to appear. A long description that is over 255 characters that will case teh twixie to appear. A long description that is over 255 characters that will case teh twixie to appear. A long description that is over 255 characters that will case teh twixie to appear.");
        this.navigation.issue().viewIssue("HSP-2");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "environment-val"), "Hide");
        this.tester.assertElementPresent("field-environment");
    }

    private void assertEnvironmentFieldShownOnViewIssue(boolean shouldBeOnEdit) {
        this.navigation.issue().viewIssue("HSP-1");
        IdLocator locator = new IdLocator(this.tester, "environment-val");
        this.textAssertions.assertTextPresent(locator, "this is the Environment Field");
        this.tester.clickLink("edit-issue");
        if (shouldBeOnEdit) {
            this.tester.assertTextPresent("Environment");
        } else {
            this.tester.assertTextNotPresent("Environment");
        }
    }
}

