/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.backdoor.ProjectControlExt;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.env.EnvironmentUtils;
import com.atlassian.jira.functest.matcher.CsvMatcher;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
@LoginAs(user="admin")
public class TestExportArchivedIssues
extends BaseJiraFuncTest {
    private static final FeatureFlag ISSUE_ARCHIVING_FEATURE_FLAG = FeatureFlag.featureFlag((String)"com.atlassian.jira.issues.archiving");
    private static final String ARCHIVED_DF = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    @Inject
    private EnvironmentUtils environmentUtils;

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=804000)
    public void testIfAllFieldsExportIsTheSameAsModelFile() throws IOException {
        this.backdoor.restoreDataFromResource("TestArchivedIssueExport.xml");
        String csvExport = this.getCsvExportOfAllArchivedItems("");
        String expectedCsvFilename = this.environmentUtils.isMySQL() ? "ArchivingExport-mysql.csv" : "ArchivingExport.csv";
        String expectedCsv = this.getExportModelContent(expectedCsvFilename);
        Assert.assertThat((Object)expectedCsv, CsvMatcher.isTheSameCSVFile(csvExport));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=801000)
    public void testIssueVsProjectArchiving() throws InterruptedException {
        this.prepareArchive();
        IssueExport csvExport = new IssueExport();
        Assert.assertThat(csvExport.keys, (Matcher)Matchers.contains((Object[])new String[]{"AC-4", "AC-3", "AC-2", "AC-1", "AB-1", "AB-2", "AB-3", "AB-4", "AB-5", "AA-2", "AA-3", "AA-4", "AA-5", "AA-1"}));
        Assert.assertThat(csvExport.archivedBys, (Matcher)Matchers.everyItem((Matcher)Matchers.equalTo((Object)"admin")));
        String stIA = "Issue archived";
        String stPA = "Project archived";
        Assert.assertThat(csvExport.archivedStates, (Matcher)Matchers.contains((Object[])new String[]{"Issue archived", "Issue archived", "Issue archived", "Issue archived", "Project archived", "Project archived", "Project archived", "Project archived", "Project archived", "Project archived", "Project archived", "Project archived", "Project archived", "Issue archived"}));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=801000)
    public void testFilters_project() throws InterruptedException {
        this.prepareArchive();
        IssueExport csvExport = new IssueExport("projectKey=AA");
        Assert.assertThat(csvExport.keys, (Matcher)Matchers.contains((Object[])new String[]{"AA-2", "AA-3", "AA-4", "AA-5", "AA-1"}));
        Assert.assertThat(csvExport.archivedBys, (Matcher)Matchers.everyItem((Matcher)Matchers.equalTo((Object)"admin")));
        String stIA = "Issue archived";
        String stPA = "Project archived";
        Assert.assertThat(csvExport.archivedStates, (Matcher)Matchers.contains((Object[])new String[]{"Project archived", "Project archived", "Project archived", "Project archived", "Issue archived"}));
        Assert.assertThat((TestExportArchivedIssues)this.new IssueExport((String)"projectKey=AC").keys, (Matcher)Matchers.contains((Object[])new String[]{"AC-4", "AC-3", "AC-2", "AC-1"}));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=801000)
    public void testFilters_archivedDate() throws InterruptedException, ParseException {
        this.prepareArchive();
        IssueExport fullExport = new IssueExport();
        long smallArchivedTs = DATE_FORMAT.parse(fullExport.archivedDates.get(1)).getTime();
        long largeArchivedStartTs = DATE_FORMAT.parse(fullExport.archivedDates.get(3)).getTime();
        long largeArchivedEndTs = DATE_FORMAT.parse(fullExport.archivedDates.get(8)).getTime();
        String queryParamsOne = "archivedAfter=" + smallArchivedTs + "&archivedBefore=" + (smallArchivedTs + 999L);
        String queryParamsProject = "archivedAfter=" + largeArchivedEndTs + "&archivedBefore=" + (largeArchivedStartTs + 999L);
        IssueExport csvExport = new IssueExport(queryParamsOne);
        Assert.assertThat(csvExport.keys, (Matcher)Matchers.contains((Object[])new String[]{"AC-3"}));
        Assert.assertThat(csvExport.archivedBys, (Matcher)Matchers.everyItem((Matcher)Matchers.equalTo((Object)"admin")));
        Assert.assertThat(csvExport.archivedStates, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Issue archived"}));
        csvExport = new IssueExport(queryParamsProject);
        Assert.assertThat(csvExport.keys, (Matcher)Matchers.contains((Object[])new String[]{"AC-1", "AB-1", "AB-2", "AB-3", "AB-4", "AB-5"}));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=801000)
    public void testFilters_reporter() {
        this.backdoor.restoreBlankInstance();
        this.backdoor.darkFeatures().enableForSite(ISSUE_ARCHIVING_FEATURE_FLAG);
        this.backdoor.project().addProject("TST", "TST", "admin");
        this.backdoor.project().addProject("PRA", "PRA", "fred");
        this.backdoor.usersAndGroups().addUserToGroup("fred", "jira-developers");
        this.backdoor.issues().loginAs("fred", "fred").createIssue("PRA", "fred issue");
        this.backdoor.issues().loginAs("fred", "fred").createIssue("TST", "fred issue");
        this.backdoor.issues().loginAs("admin", "admin").createIssue("TST", "admin issue");
        this.backdoor.project().archiveProject("PRA");
        this.backdoor.issues().archiveIssue("TST-1");
        this.backdoor.issues().archiveIssue("TST-2");
        long referenceTime = 1000L * (System.currentTimeMillis() / 1000L);
        this.backdoor.project().changeArchivedDate("PRA", referenceTime - 2000L);
        this.backdoor.issueNavControl().changeArchivedDate("TST-1", new Date(referenceTime - 1000L));
        this.backdoor.issueNavControl().changeArchivedDate("TST-2", new Date(referenceTime));
        String queryParams = "archivedAfter=" + (referenceTime - 2500L) + "&reporter=fred";
        IssueExport csvExport = new IssueExport(queryParams);
        Assert.assertThat(csvExport.keys, (Matcher)Matchers.contains((Object[])new String[]{"TST-1", "PRA-1"}));
        Assert.assertThat(csvExport.reporters, (Matcher)Matchers.everyItem((Matcher)Matchers.equalTo((Object)"fred")));
        Assert.assertThat(csvExport.archivedStates, (Matcher)Matchers.contains((Object[])new String[]{"Issue archived", "Project archived"}));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=801000)
    public void testFilters_archivedBy() {
        this.backdoor.restoreBlankInstance();
        this.backdoor.darkFeatures().enableForSite(ISSUE_ARCHIVING_FEATURE_FLAG);
        this.backdoor.project().addProject("TST", "TST", "admin");
        this.backdoor.project().addProject("PRA", "PRA", "fred");
        this.backdoor.usersAndGroups().addUserToGroup("fred", "jira-developers");
        this.backdoor.usersAndGroups().addUserToGroup("fred", "jira-administrators");
        this.backdoor.issues().createIssue("PRA", "fred issue");
        this.backdoor.issues().createIssue("TST", "fred issue");
        this.backdoor.issues().createIssue("TST", "admin issue");
        ((ProjectControlExt)this.backdoor.project().loginAs("fred", "fred")).archiveProject("PRA");
        this.backdoor.issues().loginAs("fred", "fred").archiveIssue("TST-1");
        this.backdoor.issues().loginAs("admin", "admin").archiveIssue("TST-2");
        long referenceTime = 1000L * (System.currentTimeMillis() / 1000L);
        this.backdoor.project().changeArchivedDate("PRA", referenceTime - 2000L);
        this.backdoor.issueNavControl().changeArchivedDate("TST-1", new Date(referenceTime - 1000L));
        this.backdoor.issueNavControl().changeArchivedDate("TST-2", new Date(referenceTime));
        String queryParams = "archivedAfter=" + (referenceTime - 2500L) + "&archivedBy=fred";
        IssueExport csvExport = new IssueExport(queryParams);
        Assert.assertThat(csvExport.keys, (Matcher)Matchers.contains((Object[])new String[]{"TST-1", "PRA-1"}));
        Assert.assertThat(csvExport.reporters, (Matcher)Matchers.everyItem((Matcher)Matchers.equalTo((Object)"admin")));
        Assert.assertThat(csvExport.archivedBys, (Matcher)Matchers.everyItem((Matcher)Matchers.equalTo((Object)"fred")));
        Assert.assertThat(csvExport.archivedStates, (Matcher)Matchers.contains((Object[])new String[]{"Issue archived", "Project archived"}));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=801000)
    public void testAnonymousExport() {
        this.navigation.logout();
        String csvExport = this.getCsvExportOfAllArchivedItems("");
        Assert.assertTrue((boolean)csvExport.contains("<status-code>401</status-code>"));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=804000)
    public void testExportForbiddenForUsers() {
        this.backdoor.restoreBlankInstance();
        this.backdoor.darkFeatures().enableForSite(ISSUE_ARCHIVING_FEATURE_FLAG);
        this.backdoor.usersAndGroups().addUserToGroup("fred", "jira-developers");
        this.navigation.login("fred");
        try {
            this.getCsvExportOfAllArchivedItems("");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("Server returned HTTP response code: 403 for URL:"));
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=804000)
    public void testExportForbiddenForAdmins() {
        this.backdoor.restoreBlankInstance();
        this.backdoor.darkFeatures().enableForSite(ISSUE_ARCHIVING_FEATURE_FLAG);
        this.backdoor.usersAndGroups().addUserToGroup("fred", "jira-administrators");
        this.navigation.login("fred");
        try {
            this.getCsvExportOfAllArchivedItems("");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("Server returned HTTP response code: 403 for URL:"));
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=804000)
    public void testMultipleFilters_projects() throws InterruptedException {
        this.prepareArchive();
        IssueExport allProjectsExport = new IssueExport("projectKey=AA&projectKey=AB&projectKey=AC");
        IssueExport defaultExport = new IssueExport();
        Assert.assertThat(allProjectsExport.keys, (Matcher)Matchers.equalTo(defaultExport.keys));
        IssueExport specifiedProjectsExport = new IssueExport("projectKey=AB&projectKey=AC");
        Assert.assertThat(specifiedProjectsExport.keys, (Matcher)Matchers.contains((Object[])new String[]{"AC-4", "AC-3", "AC-2", "AC-1", "AB-1", "AB-2", "AB-3", "AB-4", "AB-5"}));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=804000)
    public void testMultipleFilters_reporters() throws InterruptedException {
        this.prepareArchive();
        this.backdoor.project().addProject("TST", "TST", "admin");
        this.backdoor.project().addProject("PRA", "PRA", "fred");
        String FredMotherKey = this.backdoor.usersAndGroups().addUser("MotherOfFred", "fred", "MotherOfFred", "mof@example.com").getUserByName("MotherOfFred").getKey();
        this.backdoor.usersAndGroups().addUserToGroup("MotherOfFred", "jira-developers");
        this.backdoor.usersAndGroups().addUserToGroup("MotherOfFred", "jira-administrators");
        this.backdoor.usersAndGroups().addUserToGroup("fred", "jira-developers");
        this.backdoor.usersAndGroups().addUserToGroup("fred", "jira-administrators");
        this.backdoor.issues().loginAs("fred", "fred").createIssue("PRA", "fred issue");
        this.backdoor.issues().loginAs("fred", "fred").createIssue("PRA", "fred issue");
        this.backdoor.issues().loginAs("fred", "fred").archiveIssue("PRA-1");
        this.backdoor.issues().loginAs("MotherOfFred", "fred").createIssue("TST", "mother issue");
        this.backdoor.issues().loginAs("MotherOfFred", "fred").createIssue("TST", "mother issue");
        this.backdoor.issues().loginAs("MotherOfFred", "fred").archiveIssue("TST-1");
        long referenceTime = System.currentTimeMillis();
        this.backdoor.issueNavControl().changeArchivedDate("TST-1", new Date(referenceTime - 1000L));
        this.backdoor.issueNavControl().changeArchivedDate("PRA-1", new Date(referenceTime));
        IssueExport allIssuesExport = new IssueExport();
        IssueExport adminIssuesExport = new IssueExport("reporter=admin");
        IssueExport fredFamilyExport = new IssueExport("reporter=fred&reporter=" + FredMotherKey);
        IssueExport allUsersExport = new IssueExport("reporter=fred&reporter=admin&reporter=" + FredMotherKey);
        Assert.assertThat(fredFamilyExport.keys, (Matcher)Matchers.contains((Object[])new String[]{"PRA-1", "TST-1"}));
        Assert.assertThat(allIssuesExport.keys, (Matcher)Matchers.equalTo(allUsersExport.keys));
        Assert.assertThat(adminIssuesExport.keys, (Matcher)Matchers.equalTo((Object)ListUtils.removeAll(allIssuesExport.keys, fredFamilyExport.keys)));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=804000)
    public void testMultipleFilters_archivedBy() throws InterruptedException {
        this.prepareArchive();
        this.backdoor.project().addProject("TST", "TST", "admin");
        this.backdoor.project().addProject("PRA", "PRA", "fred");
        String FredMotherKey = this.backdoor.usersAndGroups().addUser("MotherOfFred", "fred", "MotherOfFred", "mof@example.com").getUserByName("MotherOfFred").getKey();
        this.backdoor.usersAndGroups().addUserToGroup("MotherOfFred", "jira-developers");
        this.backdoor.usersAndGroups().addUserToGroup("MotherOfFred", "jira-administrators");
        this.backdoor.usersAndGroups().addUserToGroup("fred", "jira-developers");
        this.backdoor.usersAndGroups().addUserToGroup("fred", "jira-administrators");
        this.backdoor.issues().loginAs("fred", "fred").createIssue("PRA", "fred issue");
        this.backdoor.issues().loginAs("fred", "fred").createIssue("PRA", "fred issue");
        this.backdoor.issues().loginAs("fred", "fred").archiveIssue("PRA-1");
        this.backdoor.issues().loginAs("MotherOfFred", "fred").createIssue("TST", "mother issue");
        this.backdoor.issues().loginAs("MotherOfFred", "fred").createIssue("TST", "mother issue");
        this.backdoor.issues().loginAs("MotherOfFred", "fred").archiveIssue("TST-1");
        long referenceTime = System.currentTimeMillis();
        this.backdoor.issueNavControl().changeArchivedDate("TST-1", new Date(referenceTime - 1000L));
        this.backdoor.issueNavControl().changeArchivedDate("PRA-1", new Date(referenceTime));
        IssueExport allIssuesExport = new IssueExport();
        IssueExport adminIssuesExport = new IssueExport("archivedBy=admin");
        IssueExport fredFamilyExport = new IssueExport("archivedBy=fred&archivedBy=" + FredMotherKey);
        IssueExport allUsersExport = new IssueExport("archivedBy=fred&archivedBy=admin&archivedBy=" + FredMotherKey);
        Assert.assertThat(fredFamilyExport.keys, (Matcher)Matchers.contains((Object[])new String[]{"PRA-1", "TST-1"}));
        Assert.assertThat(allIssuesExport.keys, (Matcher)Matchers.equalTo(allUsersExport.keys));
        Assert.assertThat(adminIssuesExport.keys, (Matcher)Matchers.equalTo((Object)ListUtils.removeAll(allIssuesExport.keys, fredFamilyExport.keys)));
    }

    @Test
    @LoginAs(user="admin")
    @SinceBuildRule.SinceBuild(buildNumber=804000)
    public void testMultipleFilters_issueTypes() throws InterruptedException {
        this.prepareArchive();
        String newFeatureKey = this.backdoor.issues().createIssue((String)"AC", (String)"2 - New Feature", null, null, (String)"Minor", (String)"New Feature").key;
        String taskKey = this.backdoor.issues().createIssue((String)"AC", (String)"3 - Task", null, null, (String)"Minor", (String)"Task").key;
        String improvementKey = this.backdoor.issues().createIssue((String)"AC", (String)"4 - Improvement", null, null, (String)"Minor", (String)"Improvement").key;
        this.backdoor.issues().archiveIssue(newFeatureKey);
        this.backdoor.issues().archiveIssue(improvementKey);
        this.backdoor.issues().archiveIssue(taskKey);
        long refTime = System.currentTimeMillis();
        this.backdoor.issueNavControl().changeArchivedDate(newFeatureKey, new Date(refTime - 3000L));
        this.backdoor.issueNavControl().changeArchivedDate(improvementKey, new Date(refTime - 2000L));
        this.backdoor.issueNavControl().changeArchivedDate(taskKey, new Date(refTime - 1000L));
        IssueExport archivedIssues = new IssueExport();
        IssueExport bugIssues = new IssueExport("issueType=1");
        IssueExport noBugIssues = new IssueExport("issueType=2&issueType=3&issueType=4");
        Assert.assertThat(noBugIssues.keys, (Matcher)Matchers.contains((Object[])new String[]{taskKey, improvementKey, newFeatureKey}));
        Assert.assertThat(bugIssues.keys, (Matcher)Matchers.equalTo((Object)ListUtils.removeAll(archivedIssues.keys, noBugIssues.keys)));
    }

    @Test
    @LoginAs(user="admin")
    public void testContentSecurityPolicyHeader() throws InterruptedException {
        this.prepareArchive();
        String export = this.getCsvExportOfAllArchivedItems("");
        Assert.assertFalse((boolean)export.isEmpty());
        Assert.assertEquals((Object)"sandbox", (Object)this.tester.getDialog().getResponse().getHeaderField("Content-Security-Policy"));
    }

    private void prepareArchive() throws InterruptedException {
        int i;
        this.backdoor.restoreBlankInstance();
        this.backdoor.darkFeatures().enableForSite(ISSUE_ARCHIVING_FEATURE_FLAG);
        this.backdoor.project().addProject("A1", "AA", "admin");
        this.backdoor.project().addProject("A2", "AB", "admin");
        this.backdoor.project().addProject("A3", "AC", "admin");
        for (i = 0; i < 5; ++i) {
            this.backdoor.issues().createIssue("AA", "AA" + i);
            this.backdoor.issues().createIssue("AB", "AB" + i);
            this.backdoor.issues().createIssue("AC", "AC" + i);
        }
        this.backdoor.issues().archiveIssue("AA-1");
        Thread.sleep(1000L);
        this.backdoor.project().archiveProject("AA");
        Thread.sleep(1000L);
        this.backdoor.project().archiveProject("AB");
        for (i = 1; i < 5; ++i) {
            Thread.sleep(1000L);
            this.backdoor.issues().archiveIssue("AC-" + i);
        }
    }

    private String getCsvExportOfAllArchivedItems(String queryString) {
        this.tester.gotoPage("/rest/internal/2/archiving?" + queryString);
        return this.tester.getDialog().getResponseText();
    }

    private String getExportModelContent(String filename) throws IOException {
        String filePath = this.environmentData.getXMLDataLocation().getPath() + System.getProperty("file.separator") + filename;
        String csv = FileUtils.readFileToString((File)new File(filePath));
        return csv.replace("<instance-url>", this.environmentData.getBaseUrl().toString());
    }

    private class IssueExport {
        final List<String> lines;
        final List<String> content;
        final List<String> header;
        int keyIdx;
        int archivedByIdx;
        int archivedDateIdx;
        int archivedStateIdx;
        int reporterIdx;
        final List<String> keys;
        final List<String> archivedBys;
        final List<String> archivedDates;
        final List<String> archivedStates;
        final List<String> reporters;

        IssueExport() {
            this("");
        }

        IssueExport(String queryParams) {
            String csvExport = TestExportArchivedIssues.this.getCsvExportOfAllArchivedItems(queryParams);
            this.lines = Arrays.asList(csvExport.split("\n"));
            this.content = this.lines.subList(1, this.lines.size());
            this.header = Arrays.asList(this.lines.get(0).split(","));
            this.keyIdx = this.header.indexOf("Key");
            this.archivedByIdx = this.header.indexOf("Archived by");
            this.archivedDateIdx = this.header.indexOf("Archived date");
            this.archivedStateIdx = this.header.indexOf("Archived state");
            this.reporterIdx = this.header.indexOf("Reporter");
            this.keys = this.content.stream().map(line -> line.split(",")[this.keyIdx]).collect(Collectors.toList());
            this.archivedBys = this.content.stream().map(line -> line.split(",")[this.archivedByIdx]).collect(Collectors.toList());
            this.archivedDates = this.content.stream().map(line -> line.split(",")[this.archivedDateIdx]).collect(Collectors.toList());
            this.archivedStates = this.content.stream().map(line -> line.split(",")[this.archivedStateIdx]).collect(Collectors.toList());
            this.reporters = this.content.stream().map(line -> line.split(",")[this.reporterIdx]).collect(Collectors.toList());
        }
    }
}

