/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.util.issue.IssueInlineEdit;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
@LoginAs(user="admin")
public class TestInlineEditIssueFields
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestEditIssueVersion.xml");
        this.navigation.login("admin", "admin");
    }

    @Test
    public void testInlineEditIssueType() throws Exception {
        this.testInlineEditField("issuetype", "type-val", "Bug", "4", "Improvement");
    }

    @Test
    public void testInlineEditPriority() throws Exception {
        this.testInlineEditField("priority", "priority-val", "Major", "4", "Minor");
    }

    @Test
    public void testInlineEditDescription() throws Exception {
        this.testInlineEditField("description", "description-val", "oneoneoneoneoneoneoneoneone", "blablabla", "blablabla");
    }

    private void testInlineEditField(String fieldName, String fieldId, String oldValue, String newFormValue, String newTextValue) throws Exception {
        this.navigation.issue().gotoIssue("MK-1");
        this.assertions.assertNodeByIdHasText(fieldId, oldValue);
        IssueInlineEdit inlineEdit = new IssueInlineEdit(this.locator, this.tester, this.environmentData);
        inlineEdit.inlineEditField("10020", fieldName, newFormValue);
        this.navigation.issue().gotoIssue("MK-1");
        this.assertions.assertNodeByIdDoesNotHaveText(fieldId, oldValue);
        this.assertions.assertNodeByIdHasText(fieldId, newTextValue);
    }
}

