/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.admin.IssueSecurityLevel;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestInlineIssueLinking
extends BaseJiraFuncTest {
    String summary1;
    String summary2;
    String issueKey1;
    String issueKey2;
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUp() {
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        if (this.administration.project().projectWithKeyExists("HSP")) {
            this.logger.log((Object)"Project: homosapien exists");
        } else {
            this.administration.project().addProject("homosapien", "HSP", "admin");
        }
        this.administration.issueSecuritySchemes().newScheme("admin_only_scheme", "").newLevel("admin_only", "").addIssueSecurity(IssueSecurityLevel.IssueSecurity.GROUP, "jira-administrators");
        this.administration.project().associateIssueLevelSecurityScheme("homosapien", "admin_only_scheme");
        this.administration.usersAndGroups().addUser("link_user", "link_user", "link_user", "link_user@local");
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.BROWSE_PROJECTS);
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.SET_ISSUE_SECURITY);
        this.summary1 = "summary1";
        this.summary2 = "summary2";
        this.issueKey1 = this.backdoor.issues().createIssue("HSP", this.summary1, "admin", "Minor", "Bug").key();
        this.backdoor.issues().setIssueFields(this.issueKey1, new IssueFields().environment("test environment 1").description("test description to clone 1").securityLevel(ResourceRef.withName((String)"admin_only")));
        this.issueKey2 = this.backdoor.issues().createIssue("HSP", this.summary2, "admin", "Minor", "Bug").key();
        this.backdoor.issues().setIssueFields(this.issueKey2, new IssueFields().environment("test environment 1").description(this.issueKey1));
    }

    @Test
    public void testSummaryOnLink() throws SAXException {
        this.checkForUserWithPerm();
        this.checkForNoUser();
        this.checkForUserNoPerm();
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.setFieldConfigurationFieldToRenderer("Default Field Configuration", "description", "Wiki Style Renderer");
        this.checkForUserWithPerm();
        this.checkForNoUser();
        this.checkForUserNoPerm();
    }

    private void checkForUserNoPerm() throws SAXException {
        this.navigation.logout();
        this.navigation.login("link_user", "link_user");
        this.navigation.issue().gotoIssue(this.issueKey2);
        this.tester.assertTextPresent("Log Out");
        this.tester.assertTextNotPresent("title=\"" + this.summary1 + "\"");
        Assert.assertNull((String)"Link should not be there", (Object)this.tester.getDialog().getResponse().getLinkWith(this.issueKey1));
    }

    private void checkForNoUser() throws SAXException {
        this.navigation.logout();
        this.navigation.issue().gotoIssue(this.issueKey2);
        this.tester.assertTextPresent("Log In");
        this.tester.assertTextNotPresent("title=\"" + this.summary1 + "\"");
        Assert.assertNull((String)"Link should not be there", (Object)this.tester.getDialog().getResponse().getLinkWith(this.issueKey1));
    }

    private void checkForUserWithPerm() {
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.navigation.issue().gotoIssue(this.issueKey2);
        this.tester.assertTextPresent("title=\"" + this.summary1 + "\"");
        this.tester.assertTextPresent("/browse/" + this.issueKey1);
    }

    private void setFieldConfigurationFieldToRenderer(String configuration, String fieldId, String renderer) {
        this.navigation.gotoPage(Navigation.AdminSection.FIELD_CONFIGURATION.getUrl());
        this.textAssertions.assertTextPresent("View Field Configurations");
        this.tester.clickLink("configure-" + configuration);
        this.textAssertions.assertTextPresent(configuration);
        this.tester.clickLink("renderer_" + fieldId);
        this.tester.assertTextPresent("Edit Field Renderer");
        this.tester.selectOption("selectedRendererType", renderer);
        this.tester.submit("Update");
        this.tester.assertTextPresent("Edit Field Renderer Confirmation");
        this.tester.assertTextPresent(renderer);
        this.tester.submit("Update");
        this.logger.log((Object)("Set " + fieldId + " to renderer type " + renderer + " in the " + configuration + " configuration."));
    }
}

