/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
@LoginAs(user="admin")
public class TestIssueActionErrors
extends BaseJiraFuncTest {
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestIssueActionErrors.xml");
    }

    @Test
    public void testOperations() {
        this.assertOperationErrors("Attach Files", "secure/AttachFile!default.jspa?id=10000", "secure/AttachFile!default.jspa?id=999", "You do not have permission to create attachments for this issue.", true);
        this.assertOperationErrors("Assign", "secure/AssignIssue!default.jspa?id=10000", "secure/AssignIssue!default.jspa?id=999", "It seems that you have tried to perform an operation which you are not permitted to perform.", true);
        this.assertOperationErrors("Log Work", "secure/CreateWorklog!default.jspa?id=10000", "secure/CreateWorklog!default.jspa?id=999", "It seems that you have tried to perform an operation which you are not permitted to perform.", true);
        this.assertOperationErrors("Delete", "secure/DeleteIssue!default.jspa?id=10000", "secure/DeleteIssue!default.jspa?id=999", "It seems that you have tried to perform an operation which you are not permitted to perform.", true);
        this.assertOperationErrors("Link", "secure/LinkJiraIssue!default.jspa?id=10000", "secure/LinkJiraIssue!default.jspa?id=999", "It seems that you have tried to perform an operation which you are not permitted to perform.", true);
        this.assertOperationErrors("Clone", "secure/CloneIssueDetails!default.jspa?id=10000", "secure/CloneIssueDetails!default.jspa?id=999", "It seems that you have tried to perform an operation which you are not permitted to perform.", false);
    }

    private void assertOperationErrors(String operationTitle, String goodUrl, String invalidUrl, String operationError, boolean hasTargetIssue) {
        this.logger.log((Object)("Testing '" + operationTitle + "'"));
        this.navigation.login("admin", "admin");
        this.navigation.gotoPage(goodUrl);
        CssLocator locator = new CssLocator(this.tester, "#page div.form-body h2.dialog-title");
        this.textAssertions.assertTextPresent(locator, operationTitle);
        this.navigation.gotoPage(invalidUrl);
        this.assertions.getJiraMessageAssertions().assertHasTitle("Error");
        this.assertions.getJiraMessageAssertions().assertHasMessage("The issue no longer exists.");
        this.navigation.logout();
        this.navigation.gotoPage(goodUrl);
        this.assertions.getJiraMessageAssertions().assertHasTitle("Error");
        this.assertions.getJiraMessageAssertions().assertHasMessage("You do not have the permission to see the specified issue");
        this.tester.assertLinkPresentWithText("log in");
        if (hasTargetIssue) {
            this.tester.assertTextPresent("login.jsp?os_destination=%2Fbrowse%2FHSP-1");
        } else {
            this.tester.assertTextPresent("login.jsp?os_destination=%2Fbrowse");
        }
        this.tester.assertLinkPresentWithText("sign up");
        this.navigation.login("fred", "fred");
        this.navigation.gotoPage(goodUrl);
        this.assertions.getJiraMessageAssertions().assertHasTitle("Error");
        this.assertions.getJiraMessageAssertions().assertHasMessage(operationError);
        this.tester.assertLinkNotPresentWithText("log in");
        this.tester.assertLinkNotPresentWithText("sign up");
    }
}

