/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.REFERENCE_PLUGIN})
@LoginAs(user="admin")
public class TestIssueOperationsCustomFieldTypeWithNoValidation
extends BaseJiraFuncTest {
    public static final String CUSTOM_FIELD_WITHOUT_LENGTH_VALIDATION_ID = "customfield_10100";
    private static final int LIMIT = 255;
    private static final String SOME_LONG_TEXT = StringUtils.repeat((String)"yaddi yaddi yadda ", (int)15);
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestCreateIssueWithDegeneratedCustomFieldType.xml");
        this.backdoor.advancedSettings().setTextFieldCharacterLengthLimit(255L);
    }

    @Test
    public void testCreateIssueFailsWhenBrokenCustomFieldExceedsCharacterLimit() {
        this.navigation.issue().goToCreateIssueForm("homosapien", null);
        this.tester.setFormElement("summary", "Test Bug 202020");
        this.tester.setFormElement(CUSTOM_FIELD_WITHOUT_LENGTH_VALIDATION_ID, SOME_LONG_TEXT);
        this.tester.submit("Create");
        this.assertErrorTextPresent();
    }

    @Test
    public void testEditIssueFailsWhenBrokenCustomFieldExceedsCharacterLimit() {
        this.navigation.issue().gotoEditIssue("HSP-3");
        this.tester.setFormElement("summary", "Test Bug 202020");
        this.tester.setFormElement(CUSTOM_FIELD_WITHOUT_LENGTH_VALIDATION_ID, SOME_LONG_TEXT);
        this.tester.submit("Update");
        this.assertErrorTextPresent();
    }

    @Test
    public void testResolveIssueFailsWhenBrokenCustomFieldExceedsCharacterLimit() {
        this.navigation.issue().gotoIssue("HSP-3");
        this.navigation.issue().resolveIssue("HSP-3", "Fixed", (Map<String, String>)ImmutableMap.of((Object)CUSTOM_FIELD_WITHOUT_LENGTH_VALIDATION_ID, (Object)SOME_LONG_TEXT));
        this.assertErrorTextPresent();
    }

    private void assertErrorTextPresent() {
        this.tester.assertTextPresent("The entered text is too long. It exceeds the allowed limit of 255 characters.");
    }
}

