/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.integrationtesting.runner.restore.RestoreOnce;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.matchers.LangMatchers;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.testkit.client.IssueSecuritySchemesControl;
import com.atlassian.jira.testkit.client.IssuesControl;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.IssueSubTaskClient;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.PERMISSIONS})
@RestoreOnce(value="TestIssueOperationsWithLimitedPermissionsProEnt.xml")
public class TestIssueOperationsWithLimitedPermissions
extends BaseJiraFuncTest {
    private static final String RESTRICTED_ISSUE_ID = "10000";
    private static final String RESTRICTED_ISSUE_KEY = "HSP-1";
    private static final String CLOSED_ISSUE_ID = "10020";
    private static final long PROJECT_ID = 10000L;
    private static final String ERROR_MSG_NO_PERM_AND_NOT_LOGGED_IN = "You are not logged in, and do not have the permissions required to create an issue in this project as a guest.";
    private static final String ERROR_MSG_NO_PERMISSION_TO_CREATE_ISSUE = "You do not have permission to create issues in this project.";
    private static final String PERMISSION_ERROR_DESC_ANONYMOUS = "You are not logged in, and do not have the permissions required to act on the selected issue as a guest.";
    private static final String PERMISSION_ERROR_DESC_USER = "You do not have permission to act on this issue.";
    private static final String PERMISSION_ERROR_BROWSE_PROJECTS = "You're not allowed to browse projects";
    private static final String PERMISSION_ERROR = "You do not have the permission to see the specified issue.";
    private static final String ISSUE_CANT_BE_DISPLAYED_MESSAGE = "You can&#39;t view this issue";
    private static final String LOGIN = "log in";
    private static final String SIGNUP = "sign up";
    private static final String YOU_MUST_LOG_IN_TO_ACCESS_THIS_PAGE = "You must log in to access this page.";
    private static final String PERMISSION_VIOLATION_MESSAGE = "It seems that you have tried to perform an operation which you are not permitted to perform.";
    private static final String BROWSE_URL = "/browse/";
    private static final String NEW_TEST_ISSUE = "new test issue";
    private static final String NOT_LOGGED_IN_ERROR = "You're not logged in";
    private static final String TOGGLE_UNVOTE_ISSUE = "toggle-unvote-issue";
    private static final String TOGGLE_VOTE_ISSUE = "toggle-vote-issue";
    private static final String TOGGLE_UNWATCH_ISSUE = "toggle-unwatch-issue";
    private static final String TOGGLE_WATCH_ISSUE = "toggle-watch-issue";
    private static final String RESOLVE_ISSUE = "Resolve Issue";
    private static final String ASSIGN_ISSUE_SUBMIT = "assign-issue-submit";
    private static final String EDIT_ISSUE = "Edit Issue";
    private static final String SUMMARY = "Summary";
    private static final String WATCH_ISSUE = "Watch Issue";
    private static final String STOP_WATCHING = "Stop Watching";
    private static final String EDIT_WORK_LOG = "Edit Work Log";
    private static final String DELETE_WORKLOG = "Delete Worklog";
    private static final String IGNORE = "ignoreMeAndSeeAssertBelow";
    private static final String COMMENT_PERMISSION_ERROR_MSG = "you do not have the permission to comment on this issue.";
    private static final String COMPONENT_S = "Component/s";
    private static final String ISSUE_TYPE = "Issue Type";
    private static final String CREATE_SUB_TASK = "Create Sub-Task";
    private static final String ATL_TOKEN = "atl_token=";
    private static final String SECURE_URL = "/secure/";
    private static final String SECURITY_SCHEME = "scheme";
    private static final String SECURITY_LEVEL = "level";
    @Inject
    private HtmlPage page;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testViewIssue() {
        this.assertActionIsInaccessibleToAnonymousUser(BROWSE_URL, NEW_TEST_ISSUE, YOU_MUST_LOG_IN_TO_ACCESS_THIS_PAGE, true);
        this.assertActionIsInaccessibleToUser(BROWSE_URL, NEW_TEST_ISSUE, ISSUE_CANT_BE_DISPLAYED_MESSAGE);
        this.assertActionIsAccessibleToAdmin(BROWSE_URL, NEW_TEST_ISSUE, YOU_MUST_LOG_IN_TO_ACCESS_THIS_PAGE);
    }

    @Test
    public void testViewIssueVote() {
        String url = "VoteOrWatchIssue.jspa?vote=vote&";
        this.assertActionIsInaccessibleToAnonymousUser(url, NEW_TEST_ISSUE, YOU_MUST_LOG_IN_TO_ACCESS_THIS_PAGE, true);
        this.assertActionIsInaccessibleToUser(url, NEW_TEST_ISSUE, PERMISSION_VIOLATION_MESSAGE);
        this.assertActionIsAccessibleToAdmin(url, NEW_TEST_ISSUE, YOU_MUST_LOG_IN_TO_ACCESS_THIS_PAGE);
        this.tester.assertLinkPresent(TOGGLE_UNVOTE_ISSUE);
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, TOGGLE_UNVOTE_ISSUE), "Remove vote");
        this.textAssertions.assertTextNotPresent(new IdLocator(this.tester, TOGGLE_UNVOTE_ISSUE), "Add vote");
        this.assertActionIsInaccessibleToAdminForClosedIssue(url, "An issue that will be closed!", "You cannot vote or change your vote on resolved issues.");
    }

    @Test
    public void testViewIssueUnvote() {
        String url = "VoteOrWatchIssue.jspa?vote=unvote&";
        this.assertActionIsInaccessibleToAnonymousUser(url, NEW_TEST_ISSUE, YOU_MUST_LOG_IN_TO_ACCESS_THIS_PAGE, true);
        this.assertActionIsInaccessibleToUser(url, NEW_TEST_ISSUE, PERMISSION_VIOLATION_MESSAGE);
        this.assertActionIsAccessibleToAdmin(url, NEW_TEST_ISSUE, YOU_MUST_LOG_IN_TO_ACCESS_THIS_PAGE);
        this.tester.assertLinkPresent(TOGGLE_VOTE_ISSUE);
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, TOGGLE_VOTE_ISSUE), "Add vote");
        this.textAssertions.assertTextNotPresent(new IdLocator(this.tester, TOGGLE_VOTE_ISSUE), "Remove vote");
        this.assertActionIsInaccessibleToAdminForClosedIssue(url, "An issue that will be closed!", "You cannot vote or change your vote on resolved issues.");
    }

    @Test
    public void testViewIssueStartWatching() {
        String url = "VoteOrWatchIssue.jspa?watch=watch&";
        this.assertActionIsInaccessibleToAnonymousUser(url, NEW_TEST_ISSUE, YOU_MUST_LOG_IN_TO_ACCESS_THIS_PAGE, true);
        this.assertActionIsInaccessibleToUser(url, NEW_TEST_ISSUE, PERMISSION_VIOLATION_MESSAGE);
        this.assertActionIsAccessibleToAdmin(url, NEW_TEST_ISSUE, YOU_MUST_LOG_IN_TO_ACCESS_THIS_PAGE);
        this.tester.assertLinkPresent(TOGGLE_UNWATCH_ISSUE);
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, TOGGLE_UNWATCH_ISSUE), "Stop watching");
        this.textAssertions.assertTextNotPresent(new IdLocator(this.tester, TOGGLE_WATCH_ISSUE), "Watch issue");
    }

    @Test
    public void testViewIssueStopWatching() {
        String url = "VoteOrWatchIssue.jspa?watch=unwatch&";
        this.assertActionIsInaccessibleToAnonymousUser(url, NEW_TEST_ISSUE, YOU_MUST_LOG_IN_TO_ACCESS_THIS_PAGE, true);
        this.assertActionIsInaccessibleToUser(url, NEW_TEST_ISSUE, PERMISSION_VIOLATION_MESSAGE);
        this.assertActionIsAccessibleToAdmin(url, NEW_TEST_ISSUE, YOU_MUST_LOG_IN_TO_ACCESS_THIS_PAGE);
        this.tester.assertLinkPresent(TOGGLE_WATCH_ISSUE);
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, TOGGLE_WATCH_ISSUE), "Watch issue");
        this.textAssertions.assertTextNotPresent(new IdLocator(this.tester, TOGGLE_UNWATCH_ISSUE), "Stop watching");
    }

    @Test
    public void testWorkflowUIDispatcher() {
        String url = "WorkflowUIDispatcher.jspa?action=5&";
        this.assertActionIsInaccessibleToAnonymousUser(url, RESOLVE_ISSUE, YOU_MUST_LOG_IN_TO_ACCESS_THIS_PAGE, true);
        this.assertActionIsInaccessibleToUser(url, RESOLVE_ISSUE, PERMISSION_VIOLATION_MESSAGE);
        this.assertActionIsAccessibleToAdmin(url, RESOLVE_ISSUE, YOU_MUST_LOG_IN_TO_ACCESS_THIS_PAGE);
    }

    @Test
    public void testAssignIssue() {
        String url = "AssignIssue!default.jspa?";
        this.assertActionIsInaccessibleToAnonymousUser(url, ASSIGN_ISSUE_SUBMIT, PERMISSION_ERROR, true);
        this.assertActionIsInaccessibleToUser(url, ASSIGN_ISSUE_SUBMIT, PERMISSION_ERROR);
        this.assertActionIsAccessibleToAdmin(url, ASSIGN_ISSUE_SUBMIT, PERMISSION_ERROR);
        this.assertActionIsInaccessibleToAdminForClosedIssue(url, ASSIGN_ISSUE_SUBMIT, PERMISSION_VIOLATION_MESSAGE);
    }

    @Test
    public void testCommentAssignIssue() {
        String url = "CommentAssignIssue!default.jspa?action=5&";
        this.assertActionIsInaccessibleToAnonymousUser(url, RESOLVE_ISSUE, PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser(url, RESOLVE_ISSUE, PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin(url, RESOLVE_ISSUE, PERMISSION_ERROR);
    }

    @Test
    public void testEditIssue() {
        String url = "EditIssue!default.jspa?";
        this.assertActionIsInaccessibleToAnonymousUser(url, EDIT_ISSUE, PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser(url, EDIT_ISSUE, PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin(url, EDIT_ISSUE, PERMISSION_ERROR);
        this.assertActionIsInaccessibleToAdminForClosedIssue(url, null, "You are not allowed to edit this issue due to its current status in the workflow.");
    }

    @Test
    public void testLabels() {
        String url = "EditLabels!default.jspa?";
        this.assertActionIsInaccessibleToAnonymousUser(url, null, PERMISSION_ERROR, true);
        this.assertActionIsInaccessibleToUser(url, null, PERMISSION_ERROR);
        this.assertActionIsAccessibleToAdmin(url, "Labels", PERMISSION_ERROR);
        this.assertActionIsInaccessibleToAdminForClosedIssue(url, null, PERMISSION_VIOLATION_MESSAGE);
    }

    @Test
    public void testCloneIssueDetails() {
        String url = "CloneIssueDetails!default.jspa?";
        this.assertActionIsInaccessibleToAnonymousUser(url, SUMMARY, PERMISSION_ERROR, false);
        this.assertActionIsInaccessibleToUser(url, SUMMARY, PERMISSION_ERROR);
        this.assertActionIsAccessibleToAdmin(url, SUMMARY, PERMISSION_ERROR);
    }

    @Test
    public void testMoveIssue() {
        String url = "MoveIssue!default.jspa?";
        this.assertActionIsInaccessibleToAnonymousUser(url, "Current Project", NOT_LOGGED_IN_ERROR, true);
        this.assertActionIsInaccessibleToUser(url, "Current Project", PERMISSION_ERROR_BROWSE_PROJECTS);
        this.assertActionIsAccessibleToAdmin(url, "homosapien", NOT_LOGGED_IN_ERROR);
    }

    @Test
    public void testViewVoters() {
        String noVotersDescription = "There are no voters for this issue";
        String addVoteUrl = "ViewVoters!addVote.jspa?";
        this.assertActionIsInaccessibleToAnonymousUser("ViewVoters!addVote.jspa?", "There are no voters for this issue", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("ViewVoters!addVote.jspa?", "There are no voters for this issue", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("ViewVoters!addVote.jspa?", "Remove your vote", PERMISSION_ERROR);
        String removeVoteUrl = "ViewVoters!removeVote.jspa?";
        this.assertActionIsInaccessibleToAnonymousUser("ViewVoters!removeVote.jspa?", "There are no voters for this issue", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("ViewVoters!removeVote.jspa?", "There are no voters for this issue", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("ViewVoters!removeVote.jspa?", "There are no voters for this issue", PERMISSION_ERROR);
        String defaultUrl = "ViewVoters!default.jspa?";
        this.assertActionIsInaccessibleToAnonymousUser("ViewVoters!default.jspa?", "There are no voters for this issue", PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("ViewVoters!default.jspa?", "There are no voters for this issue", PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("ViewVoters!default.jspa?", "There are no voters for this issue", PERMISSION_ERROR);
    }

    @Test
    public void testManageWatchers() {
        String url = "ManageWatchers!default.jspa?";
        this.assertActionIsInaccessibleToAnonymousUser(url, WATCH_ISSUE, PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser(url, WATCH_ISSUE, PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin(url, WATCH_ISSUE, PERMISSION_ERROR);
    }

    @Test
    public void testManageWatchersStartStopWatching() {
        String startWatchingUrl = "ManageWatchers!startWatching.jspa?";
        this.assertActionIsInaccessibleToAnonymousUser("ManageWatchers!startWatching.jspa?", WATCH_ISSUE, PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("ManageWatchers!startWatching.jspa?", WATCH_ISSUE, PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("ManageWatchers!startWatching.jspa?", STOP_WATCHING, PERMISSION_ERROR);
        String stopWatchingUrl = "ManageWatchers!stopWatching.jspa?";
        this.assertActionIsInaccessibleToAnonymousUser("ManageWatchers!stopWatching.jspa?", WATCH_ISSUE, PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("ManageWatchers!stopWatching.jspa?", WATCH_ISSUE, PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("ManageWatchers!stopWatching.jspa?", WATCH_ISSUE, PERMISSION_ERROR);
    }

    @Test
    public void testManageWatchersStartStopWatchers() {
        String startWatchersUrl = "ManageWatchers!startWatchers.jspa?userNames=admin&";
        this.assertActionIsInaccessibleToAnonymousUser("ManageWatchers!startWatchers.jspa?userNames=admin&", WATCH_ISSUE, PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("ManageWatchers!startWatchers.jspa?userNames=admin&", WATCH_ISSUE, PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("ManageWatchers!startWatchers.jspa?userNames=admin&", STOP_WATCHING, PERMISSION_ERROR);
        String stopWatchersUrl = "ManageWatchers!stopWatchers.jspa?userNames=admin&";
        this.assertActionIsInaccessibleToAnonymousUser("ManageWatchers!stopWatchers.jspa?userNames=admin&", WATCH_ISSUE, PERMISSION_ERROR_DESC_ANONYMOUS, true);
        this.assertActionIsInaccessibleToUser("ManageWatchers!stopWatchers.jspa?userNames=admin&", WATCH_ISSUE, PERMISSION_ERROR_DESC_USER);
        this.assertActionIsAccessibleToAdmin("ManageWatchers!stopWatchers.jspa?userNames=admin&", STOP_WATCHING, PERMISSION_ERROR);
    }

    @Test
    public void testCreateWorklog() {
        String url = "CreateWorklog!default.jspa?";
        this.assertActionIsInaccessibleToAnonymousUser(url, null, PERMISSION_ERROR, true);
        this.assertActionIsInaccessibleToUser(url, null, PERMISSION_VIOLATION_MESSAGE);
        this.assertActionIsAccessibleToAdmin(url, "Log work", PERMISSION_ERROR);
        this.assertActionIsInaccessibleToAdminForClosedIssue(url, null, PERMISSION_VIOLATION_MESSAGE);
    }

    @Test
    public void testUpdateWorklogDefault() {
        String url = "UpdateWorklog!default.jspa?worklogId=10000&";
        this.assertActionIsInaccessibleToAnonymousUser(url, EDIT_WORK_LOG, YOU_MUST_LOG_IN_TO_ACCESS_THIS_PAGE, false);
        this.assertActionIsInaccessibleToUser(url, EDIT_WORK_LOG, PERMISSION_VIOLATION_MESSAGE);
        this.assertActionIsAccessibleToAdmin(url, EDIT_WORK_LOG, PERMISSION_VIOLATION_MESSAGE);
    }

    @Test
    public void testDeleteWorklogDefault() {
        String url = "DeleteWorklog!default.jspa?worklogId=10000&";
        this.assertActionIsInaccessibleToAnonymousUser(url, DELETE_WORKLOG, YOU_MUST_LOG_IN_TO_ACCESS_THIS_PAGE, false);
        this.assertActionIsInaccessibleToUser(url, DELETE_WORKLOG, PERMISSION_VIOLATION_MESSAGE);
        this.assertActionIsAccessibleToAdmin(url, DELETE_WORKLOG, PERMISSION_VIOLATION_MESSAGE);
    }

    @Test
    public void testEditComment() {
        String url = "EditComment!default.jspa?commentId=10000&";
        this.assertActionIsInaccessibleToAnonymousUser(url, IGNORE, "You do not have the permission to comment on this issue.", false);
        this.assertActionIsInaccessibleToUser(url, IGNORE, COMMENT_PERMISSION_ERROR_MSG);
        this.assertActionIsAccessibleToAdmin(url, "Edit Comment", COMMENT_PERMISSION_ERROR_MSG);
    }

    @Test
    public void testDeleteComment() {
        String url = "DeleteComment!default.jspa?commentId=10000&";
        this.assertActionIsInaccessibleToAnonymousUser(url, IGNORE, "You do not have the permission to comment on this issue.", false);
        this.assertActionIsInaccessibleToUser(url, IGNORE, COMMENT_PERMISSION_ERROR_MSG);
        this.assertActionIsAccessibleToAdmin(url, "Delete Comment", "You do not have permission to delete comment with id: 10000");
    }

    @Test
    public void testCreateSubTaskIssueDefault() {
        String url = "CreateSubTaskIssue!default.jspa?parentIssueId=10000&";
        this.assertActionIsInaccessibleToAnonymousUser(url, COMPONENT_S, NOT_LOGGED_IN_ERROR, true);
        this.assertActionIsInaccessibleToUser(url, COMPONENT_S, PERMISSION_ERROR_BROWSE_PROJECTS);
        this.assertActionIsAccessibleToAdmin(url, COMPONENT_S, PERMISSION_ERROR);
    }

    @Test
    public void testCreateSubTaskIssue() {
        String url = "CreateSubTaskIssue.jspa?parentIssueId=10000&";
        this.assertActionIsInaccessibleToAnonymousUser(url, ISSUE_TYPE, NOT_LOGGED_IN_ERROR, true);
        this.assertActionIsInaccessibleToUser(url, ISSUE_TYPE, PERMISSION_ERROR_BROWSE_PROJECTS);
        this.assertActionIsAccessibleToAdmin(url, ISSUE_TYPE, PERMISSION_ERROR);
    }

    @Test
    public void testCreateSubTaskIssueDetails() {
        String url = "CreateSubTaskIssueDetails.jspa?parentIssueId=10000&issuetype=5&pid=10000&";
        this.assertActionIsInaccessibleToAnonymousUser(url, CREATE_SUB_TASK, ERROR_MSG_NO_PERM_AND_NOT_LOGGED_IN, false);
        this.assertActionIsInaccessibleToUser(url, CREATE_SUB_TASK, ERROR_MSG_NO_PERMISSION_TO_CREATE_ISSUE);
        this.assertActionIsAccessibleToAdmin(url, CREATE_SUB_TASK, PERMISSION_ERROR);
    }

    @Test
    public void testCreateSubTaskIssueDetailsNoParentIssueId() {
        String url = "CreateSubTaskIssueDetails.jspa?issuetype=5&pid=10000&";
        this.assertActionIsInaccessibleToAnonymousUser(url, CREATE_SUB_TASK, ERROR_MSG_NO_PERM_AND_NOT_LOGGED_IN, false);
        this.assertActionIsInaccessibleToUser(url, CREATE_SUB_TASK, ERROR_MSG_NO_PERMISSION_TO_CREATE_ISSUE);
        this.assertActionIsAccessibleToAdmin(url, CREATE_SUB_TASK, PERMISSION_ERROR);
    }

    @Test
    public void testCreateSubTaskIssueDetailsInvalidPid() {
        String url = "CreateSubTaskIssueDetails.jspa?parentIssueId=10000&issuetype=5&pid=666&";
        this.assertActionIsInaccessibleToAnonymousUser(url, CREATE_SUB_TASK, ERROR_MSG_NO_PERM_AND_NOT_LOGGED_IN, false);
        this.assertActionIsInaccessibleToUser(url, CREATE_SUB_TASK, ERROR_MSG_NO_PERMISSION_TO_CREATE_ISSUE);
        this.assertActionIsAccessibleToAdmin(url, ERROR_MSG_NO_PERMISSION_TO_CREATE_ISSUE, CREATE_SUB_TASK);
    }

    @Test
    public void testCreateSubTaskIssueDetailsDefault() {
        String url = "CreateSubTaskIssueDetails!default.jspa?parentIssueId=10000&issuetype=5&pid=10000&";
        this.assertActionIsInaccessibleToAnonymousUser(url, CREATE_SUB_TASK, ERROR_MSG_NO_PERM_AND_NOT_LOGGED_IN, false);
        this.assertActionIsInaccessibleToUser(url, CREATE_SUB_TASK, ERROR_MSG_NO_PERMISSION_TO_CREATE_ISSUE);
        this.assertActionIsAccessibleToAdmin(url, CREATE_SUB_TASK, PERMISSION_ERROR);
    }

    @Test
    public void testCreateSubTaskIssueDetailsDefaultNoParentIssueId() {
        String url = "CreateSubTaskIssueDetails!default.jspa?issuetype=5&pid=10000&";
        this.assertActionIsInaccessibleToAnonymousUser(url, CREATE_SUB_TASK, ERROR_MSG_NO_PERM_AND_NOT_LOGGED_IN, false);
        this.assertActionIsInaccessibleToUser(url, CREATE_SUB_TASK, ERROR_MSG_NO_PERMISSION_TO_CREATE_ISSUE);
        this.assertActionIsAccessibleToAdmin(url, CREATE_SUB_TASK, PERMISSION_ERROR);
    }

    @Test
    public void testCreateSubTaskIssueDetailsIfParentIsRestricted() {
        IssueSubTaskClient issueSubTaskClient = new IssueSubTaskClient(this.environmentData);
        this.createSecuritySchemeAndAssignToProject();
        IssueCreateResponse createdIssue = this.createIssueWithSecurityLevel();
        String issueId = createdIssue.id();
        String issueKey = createdIssue.key();
        this.navigation.login("bob", "bob");
        String url = "/secure/CreateSubTaskIssueDetails.jspa?issuetype=5&pid=10000&summary=test&parentIssueId=" + issueId + "&" + ATL_TOKEN + this.page.getXsrfToken();
        this.tester.gotoPage(url);
        this.textAssertions.assertTextPresent(PERMISSION_ERROR);
        MatcherAssert.assertThat(issueSubTaskClient.get(issueKey), (Matcher)LangMatchers.isEmptyCollection());
    }

    private void assertActionIsInaccessibleToAnonymousUser(String actionUrl, String textNotPresent, String errorDesc, boolean hasLoginLink) {
        this.navigation.logout();
        this.page.getFreshXsrfToken();
        if (actionUrl.equals(BROWSE_URL)) {
            this.tester.gotoPage("/browse/HSP-1?atl_token=" + this.page.getXsrfToken());
        } else {
            this.tester.gotoPage(SECURE_URL + actionUrl + "id=" + RESTRICTED_ISSUE_ID + "&" + ATL_TOKEN + this.page.getXsrfToken());
        }
        if (hasLoginLink) {
            this.tester.assertTextPresent(errorDesc);
            this.tester.assertLinkPresentWithText(SIGNUP);
        } else {
            this.tester.assertTextPresent(errorDesc);
        }
        if (textNotPresent != null) {
            this.assertActionNotPresent(textNotPresent);
        }
    }

    private void assertActionIsInaccessibleToUser(String actionUrl, String textNotPresent, String errorDesc) {
        this.navigation.login("fred", "fred");
        if (actionUrl.equals(BROWSE_URL)) {
            this.tester.gotoPage("/browse/HSP-1?atl_token=" + this.page.getXsrfToken());
        } else {
            this.tester.gotoPage(SECURE_URL + actionUrl + "id=" + RESTRICTED_ISSUE_ID + "&" + ATL_TOKEN + this.page.getXsrfToken());
        }
        this.tester.assertTextPresent(errorDesc);
        this.tester.assertLinkNotPresentWithText(LOGIN);
        this.tester.assertLinkNotPresentWithText(SIGNUP);
        if (textNotPresent != null) {
            this.assertActionNotPresent(textNotPresent);
        }
    }

    private void assertActionIsAccessibleToAdmin(String actionUrl, String textPresent, String textNotPresent) {
        this.navigation.login("admin", "admin");
        if (actionUrl.equals(BROWSE_URL)) {
            this.tester.gotoPage("/browse/HSP-1?atl_token=" + this.page.getXsrfToken());
        } else {
            this.tester.gotoPage(SECURE_URL + actionUrl + "id=" + RESTRICTED_ISSUE_ID + "&" + ATL_TOKEN + this.page.getXsrfToken());
        }
        this.assertActionNotPresent(textNotPresent);
        this.tester.assertLinkNotPresentWithText(LOGIN);
        this.tester.assertLinkNotPresentWithText(SIGNUP);
        this.tester.assertTextPresent(textPresent);
    }

    private void assertActionIsInaccessibleToAdminForClosedIssue(String actionUrl, String textNotPresent, String errorDesc) {
        this.navigation.login("admin", "admin");
        this.tester.gotoPage(SECURE_URL + actionUrl + "id=" + CLOSED_ISSUE_ID + "&" + ATL_TOKEN + this.page.getXsrfToken());
        this.tester.assertTextPresent(errorDesc);
        this.tester.assertLinkNotPresentWithText(LOGIN);
        this.tester.assertLinkNotPresentWithText(SIGNUP);
        this.assertActionNotPresent(textNotPresent);
    }

    private void assertActionNotPresent(String textNotPresent) {
        if (this.tester.getDialog().getElement("stalker") != null) {
            Assert.assertFalse((boolean)this.tester.getDialog().getElement("stalker").getTextContent().contains(textNotPresent));
        }
    }

    private void createSecuritySchemeAndAssignToProject() {
        this.backdoor.permissionSchemes().addUserPermission(0L, ProjectPermissions.SET_ISSUE_SECURITY, "admin");
        IssueSecuritySchemesControl issueSecuritySchemesControl = this.backdoor.issueSecuritySchemesControl();
        Long schemeId = issueSecuritySchemesControl.createScheme(SECURITY_SCHEME, "desc");
        Long levelId = issueSecuritySchemesControl.addSecurityLevel(schemeId.longValue(), SECURITY_LEVEL, "desc");
        issueSecuritySchemesControl.addUserToSecurityLevel(schemeId.longValue(), levelId.longValue(), "admin");
        this.backdoor.project().setIssueSecurityScheme(10000L, schemeId);
    }

    private IssueCreateResponse createIssueWithSecurityLevel() {
        IssueFields issueFields = new IssueFields().securityLevel(ResourceRef.withName((String)SECURITY_LEVEL));
        IssuesControl issuesControl = this.backdoor.issues();
        IssueCreateResponse issue = issuesControl.createIssue("HSP", "summary");
        issuesControl.setIssueFields(issue.key(), issueFields);
        return issue;
    }
}

