/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.FIELDS, Category.ISSUES, Category.SECURITY})
@LoginAs(user="admin")
public class TestIssueSecurityWithCustomFields
extends BaseJiraFuncTest {
    private static final String GROUP_CUSTOM_FIELD_ID = "customfield_10001";
    private static final String USER_CUSTOM_FIELD_ID = "customfield_10010";
    private static final String GROUP_CF_ISSUE_ID = "HSP-1";
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestIssueSecurityWithCustomFields.xml");
        this.navigation.login("admin");
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testIssueSecurityWithCustomField() {
        this.navigation.issueNavigator().displayAllIssues();
        this.textAssertions.assertTextPresent(GROUP_CF_ISSUE_ID);
        this.navigation.issue().gotoIssue(GROUP_CF_ISSUE_ID);
        this.assertions.getViewIssueAssertions().assertOnViewIssuePage(GROUP_CF_ISSUE_ID);
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.navigation.issueNavigator().displayAllIssues();
        this.textAssertions.assertTextNotPresent(GROUP_CF_ISSUE_ID);
        this.navigation.issue().gotoIssue(GROUP_CF_ISSUE_ID);
        this.assertions.getViewIssueAssertions().assertIssueNotFound();
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testViewIssueWithGroupCustomFieldDeleted() {
        this.deleteCustomField(GROUP_CUSTOM_FIELD_ID);
        this.textAssertions.assertTextPresent("Custom field cannot be deleted because it is used in the following Issue Level Security Scheme(s): My Issue Security Scheme");
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testViewIssueWithUserCustomFieldDeleted() {
        this.deleteCustomField(USER_CUSTOM_FIELD_ID);
        this.textAssertions.assertTextPresent("Custom field cannot be deleted because it is used in the following Issue Level Security Scheme(s): My Issue Security Scheme");
    }

    private void deleteCustomField(String fieldId) {
        this.administration.customFields().removeCustomField(fieldId);
    }
}

