/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.IssueSecurityLevel;
import com.atlassian.jira.functest.framework.admin.Project;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.ROLES, Category.SECURITY, Category.USERS_AND_GROUPS})
@LoginAs(user="admin")
@Restore(value="TestIssueSecurityWithGroupsAndRoles.xml")
public class TestIssueSecurityWithGroupsAndRoles
extends BaseJiraFuncTest {
    private static final String[] EXPECTED_SECURITY_LEVEL_NONE = new String[]{"None"};
    private static final String[] EXPECTED_SECURITY_LEVEL_RED = new String[]{"None", "Red"};
    private static final String[] EXPECTED_SECURITY_LEVEL_GREEN = new String[]{"None", "Green"};
    private static final String NEW_PROJECT_NAME = "New Project";
    private static final String NEW_GROUP_NAME = "securityGroup";
    private static final String NEW_SECURITY_SCHEME_NAME = "security scheme copy";
    @Inject
    private Administration administration;

    @Test
    public void testAddingAndRemovingUserFromGroupFlushesSecurityCache() {
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.addGroupToProjectRole("jira-developers");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_RED);
        this.administration.usersAndGroups().removeUserFromGroup("admin", "jira-developers");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.administration.usersAndGroups().addUserToGroup("admin", "jira-developers");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_RED);
    }

    private void addGroupToProjectRole(String group) {
        this.backdoor.projectRole().addActors("HSP", "Administrators", new String[]{group}, null);
    }

    @Test
    public void testAddingAndRemovingUserFromRolesFlushesIssueSecurityCache() {
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.backdoor.projectRole().addActors("HSP", "Administrators", null, new String[]{"admin"});
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_RED);
        this.backdoor.projectRole().deleteUser("HSP", "Administrators", "admin");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
    }

    @Test
    public void testAddingAndRemovingGroupRolesFromProjectFlushesIssueSecurityCache() {
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.addGroupToProjectRole("jira-users");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_RED);
        this.backdoor.projectRole().deleteGroup("HSP", "Administrators", "jira-users");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
    }

    @Test
    public void testRemovingRoleFlushesIssueSecurityCache() {
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.addGroupToProjectRole("jira-users");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_RED);
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_ROLE_BROWSER);
        this.tester.clickLink("delete_Administrators");
        this.tester.submit("Delete");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
    }

    @Test
    public void testRemovingGroupFlushesIssueSecurityCache() {
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.administration.usersAndGroups().addGroup(NEW_GROUP_NAME);
        this.administration.issueSecuritySchemes().getScheme("New Security Scheme").getLevel("Red").addIssueSecurity(IssueSecurityLevel.IssueSecurity.GROUP, NEW_GROUP_NAME);
        this.administration.usersAndGroups().addUserToGroup("admin", NEW_GROUP_NAME);
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_RED);
        this.administration.usersAndGroups().deleteGroup(NEW_GROUP_NAME);
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
    }

    @Test
    public void testNewProjectsWithDefaultRolesHaveCorrectSecurityLevel1() {
        this.administration.project().addProject(NEW_PROJECT_NAME, "NEW", "admin");
        this.administration.project().associateIssueLevelSecurityScheme(NEW_PROJECT_NAME, "New Security Scheme");
        this._testNewProjectsWithDefaultRolesHaveCorrectSecurityLevel();
    }

    @Test
    public void testNewProjectsWithDefaultRolesHaveCorrectSecurityLevel2() {
        Project project = this.administration.project();
        project.addProject(NEW_PROJECT_NAME, "NEW", "admin");
        this.administration.project().associateIssueLevelSecurityScheme(NEW_PROJECT_NAME, "New Security Scheme");
        this._testNewProjectsWithDefaultRolesHaveCorrectSecurityLevel();
    }

    @Test
    public void testRenamingSecuritySchemeFlushesCache() {
        this.addGroupToProjectRole("jira-users");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_RED);
        this.navigation.gotoAdminSection(Navigation.AdminSection.SECURITY_SCHEMES);
        this.tester.clickLink("edit_10000");
        this.tester.setFormElement("name", "New Security Schemeedited");
        this.tester.submit("Update");
        this.tester.assertLinkPresentWithText("New Security Schemeedited");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_RED);
    }

    @Test
    public void testAddingAndRemovingSecuritySchemeFromProject() {
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.administration.project().removeAssociationOfIssueLevelSecurityScheme("homosapien");
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.getDialog().setWorkingForm("issue-create");
        this.tester.assertFormElementNotPresent("security");
        this.administration.project().associateIssueLevelSecurityScheme("homosapien", "New Security Scheme");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
    }

    @Test
    public void testSwappingSecuritySchemeFlushesCache() {
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.administration.issueSecuritySchemes().newScheme(NEW_SECURITY_SCHEME_NAME, "new scheme for testing").newLevel("Orange", "Middle Level").addIssueSecurity(IssueSecurityLevel.IssueSecurity.GROUP, "jira-users");
        this.administration.issueSecuritySchemes().getScheme(NEW_SECURITY_SCHEME_NAME).newLevel("Green", "Lowest Level").addIssueSecurity(IssueSecurityLevel.IssueSecurity.GROUP, "jira-developers");
        this.administration.project().associateIssueLevelSecurityScheme("homosapien", NEW_SECURITY_SCHEME_NAME);
        this.assertIssueSecurityLevelOptions(new String[]{"None", "Green", "Orange"});
        this.administration.project().associateIssueLevelSecurityScheme("homosapien", "New Security Scheme");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
    }

    @Test
    public void testAddingAndRemovingSecurityLevelFlushesCache() {
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.administration.issueSecuritySchemes().getScheme("New Security Scheme").newLevel("Green", "Lowest Level");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.administration.issueSecuritySchemes().getScheme("New Security Scheme").getLevel("Green").addIssueSecurity(IssueSecurityLevel.IssueSecurity.GROUP, "jira-users");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_GREEN);
        this.administration.issueSecuritySchemes().getScheme("New Security Scheme").newLevel("Orange", "Middle Level");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_GREEN);
        this.administration.issueSecuritySchemes().getScheme("New Security Scheme").getLevel("Green").addRole("Administrators");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_GREEN);
        this.administration.issueSecuritySchemes().getScheme("New Security Scheme").getLevel("Green").delete();
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.administration.issueSecuritySchemes().getScheme("New Security Scheme").getLevel("Orange").delete();
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
    }

    private void _testNewProjectsWithDefaultRolesHaveCorrectSecurityLevel() {
        this.assertIssueSecurityLevelOptions(NEW_PROJECT_NAME, "Bug", EXPECTED_SECURITY_LEVEL_RED);
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.assertIssueSecurityLevelOptions(NEW_PROJECT_NAME, "Bug", EXPECTED_SECURITY_LEVEL_NONE);
    }

    private void assertIssueSecurityLevelOptions(String[] expectedSecurityLevels) {
        this.assertIssueSecurityLevelOptions("homosapien", "Bug", expectedSecurityLevels);
    }

    private void assertIssueSecurityLevelOptions(String projectName, String issueType, String[] expectedSecurityLevels) {
        this.navigation.issue().goToCreateIssueForm(projectName, issueType);
        this.tester.getDialog().setWorkingForm("issue-create");
        this.tester.assertOptionsEqual("security", expectedSecurityLevels);
        this.assertions.getJiraFormAssertions().assertSelectElementByIdHasOptionSelected("security", "None");
    }
}

