/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
@LoginAs(user="admin")
@Restore(value="TestIssueViews.xml")
public class TestIssueViews
extends BaseJiraFuncTest {
    private String exportsContent;
    @Inject
    private Administration administration;

    @Test
    public void testViewLinksChangeForModifiedFilter() {
        this.getViewsOption(null, "10000", null);
        this.assertTextPresentInExportsContent("/sr/jira.issueviews:searchrequest-xml/10000/SearchRequest-10000.xml");
        this.assertTextPresentInExportsContent("/sr/jira.issueviews:searchrequest-rss/10000/SearchRequest-10000.xml");
        this.assertTextPresentInExportsContent("/sr/jira.issueviews:searchrequest-comments-rss/10000/SearchRequest-10000.xml");
        this.assertTextPresentInExportsContent("/sr/jira.issueviews:searchrequest-printable/10000/SearchRequest-10000.html");
        this.assertTextPresentInExportsContent("/sr/jira.issueviews:searchrequest-word/10000/SearchRequest-10000.doc");
        this.assertTextPresentInExportsContent("/sr/jira.issueviews:searchrequest-fullcontent/10000/SearchRequest-10000.html");
        this.assertTextNotPresentInExportsContent("/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?");
        this.assertTextNotPresentInExportsContent("/sr/jira.issueviews:searchrequest-rss/temp/SearchRequest.xml?");
        this.assertTextNotPresentInExportsContent("/sr/jira.issueviews:searchrequest-comments-rss/temp/SearchRequest.xml?");
        this.assertTextNotPresentInExportsContent("/sr/jira.issueviews:searchrequest-printable/temp/SearchRequest.xml?");
        this.assertTextNotPresentInExportsContent("/sr/jira.issueviews:searchrequest-word/temp/SearchRequest.xml?");
        this.assertTextNotPresentInExportsContent("/sr/jira.issueviews:searchrequest-fullcontent/temp/SearchRequest.xml?");
        this.getViewsOption("ORDER BY key DESC", "10000", "true");
        this.assertTextNotPresentInExportsContent("/sr/jira.issueviews:searchrequest-xml/10000/SearchRequest-10000.xml");
        this.assertTextNotPresentInExportsContent("/sr/jira.issueviews:searchrequest-rss/10000/SearchRequest-10000.xml");
        this.assertTextNotPresentInExportsContent("/sr/jira.issueviews:searchrequest-comments-rss/10000/SearchRequest-10000.xml");
        this.assertTextNotPresentInExportsContent("/sr/jira.issueviews:searchrequest-printable/10000/SearchRequest-10000.html");
        this.assertTextNotPresentInExportsContent("/sr/jira.issueviews:searchrequest-word/10000/SearchRequest-10000.doc");
        this.assertTextNotPresentInExportsContent("/sr/jira.issueviews:searchrequest-fullcontent/10000/SearchRequest-10000.html");
        this.assertTextPresentInExportsContent("/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?");
        this.assertTextPresentInExportsContent("/sr/jira.issueviews:searchrequest-rss/temp/SearchRequest.xml?");
        this.assertTextPresentInExportsContent("/sr/jira.issueviews:searchrequest-comments-rss/temp/SearchRequest.xml?");
        this.assertTextPresentInExportsContent("/sr/jira.issueviews:searchrequest-printable/temp/SearchRequest.html?");
        this.assertTextPresentInExportsContent("/sr/jira.issueviews:searchrequest-word/temp/SearchRequest.doc?");
        this.assertTextPresentInExportsContent("/sr/jira.issueviews:searchrequest-fullcontent/temp/SearchRequest.html?");
    }

    @Test
    public void testCsvExportDisplayDependingOnDarkFeatures() {
        String CSV_LINK = "sr/jira.issueviews:searchrequest-csv-all-fields/10000/SearchRequest-10000.csv";
        String DISABLE_CSV = "jira.export.csv.disabled";
        this.backdoor.darkFeatures().enableForSite("jira.export.csv.disabled");
        this.getViewsOption(null, "10000", null);
        this.assertTextNotPresentInExportsContent("sr/jira.issueviews:searchrequest-csv-all-fields/10000/SearchRequest-10000.csv");
        this.backdoor.darkFeatures().disableForSite("jira.export.csv.disabled");
        this.getViewsOption(null, "10000", null);
        this.assertTextPresentInExportsContent("sr/jira.issueviews:searchrequest-csv-all-fields/10000/SearchRequest-10000.csv");
    }

    @Test
    public void testPermissionErrorWithGzipEnabled() {
        this.administration.generalConfiguration().turnOnGZipCompression();
        this.navigation.issue().viewIssue("HSP-1");
        this.navigation.logout();
        this.navigation.gotoPage("/si/jira.issueviews:issue-html/HSP-1/HSP-1.html");
        this.tester.assertTextPresent("You must log in to access this page.");
    }

    @Test
    public void testEnableDisableIssueViewsPlugin() {
        this.getViewsOption();
        this.assertViewsLinkPresent("printable");
        this.assertViewsLinkPresent("fullContent");
        this.assertViewsLinkPresent("xml");
        this.assertViewsLinkPresent("rssIssues");
        this.assertViewsLinkPresent("rssComments");
        this.assertViewsLinkPresent("word");
        this.togglePluginModule(false, "printable");
        this.getViewsOption();
        this.assertViewsLinkNotPresent("printable");
        this.assertViewsLinkPresent("fullContent");
        this.assertViewsLinkPresent("xml");
        this.assertViewsLinkPresent("rssIssues");
        this.assertViewsLinkPresent("rssComments");
        this.assertViewsLinkPresent("word");
        this.togglePluginModule(true, "printable");
        this.togglePluginModule(false, "fullcontent");
        this.getViewsOption();
        this.assertViewsLinkPresent("printable");
        this.assertViewsLinkNotPresent("fullContent");
        this.assertViewsLinkPresent("xml");
        this.assertViewsLinkPresent("rssIssues");
        this.assertViewsLinkPresent("rssComments");
        this.assertViewsLinkPresent("word");
        this.togglePluginModule(true, "fullcontent");
        this.togglePluginModule(false, "xml");
        this.getViewsOption();
        this.assertViewsLinkPresent("printable");
        this.assertViewsLinkPresent("fullContent");
        this.assertViewsLinkNotPresent("xml");
        this.assertViewsLinkPresent("rssIssues");
        this.assertViewsLinkPresent("rssComments");
        this.assertViewsLinkPresent("word");
        this.togglePluginModule(true, "xml");
        this.togglePluginModule(false, "rss");
        this.getViewsOption();
        this.assertViewsLinkPresent("printable");
        this.assertViewsLinkPresent("fullContent");
        this.assertViewsLinkPresent("xml");
        this.assertViewsLinkNotPresent("rssIssues");
        this.assertViewsLinkPresent("rssComments");
        this.assertViewsLinkPresent("word");
        this.togglePluginModule(true, "rss");
        this.togglePluginModule(false, "comments-rss");
        this.getViewsOption();
        this.assertViewsLinkPresent("printable");
        this.assertViewsLinkPresent("fullContent");
        this.assertViewsLinkPresent("xml");
        this.assertViewsLinkPresent("rssIssues");
        this.assertViewsLinkNotPresent("rssComments");
        this.assertViewsLinkPresent("word");
        this.togglePluginModule(true, "comments-rss");
        this.togglePluginModule(false, "word");
        this.getViewsOption();
        this.assertViewsLinkPresent("printable");
        this.assertViewsLinkPresent("fullContent");
        this.assertViewsLinkPresent("xml");
        this.assertViewsLinkPresent("rssIssues");
        this.assertViewsLinkPresent("rssComments");
        this.assertViewsLinkNotPresent("word");
        this.togglePluginModule(true, "word");
        this.togglePluginModule(false, "rss");
        this.togglePluginModule(false, "comments-rss");
        this.getViewsOption();
        this.assertViewsLinkPresent("printable");
        this.assertViewsLinkPresent("fullContent");
        this.assertViewsLinkPresent("xml");
        this.assertTextNotPresentInExportsContent("| RSS");
        this.assertViewsLinkNotPresent("rssIssues");
        this.assertViewsLinkNotPresent("rssComments");
        this.assertViewsLinkPresent("word");
        this.togglePluginModule(true, "rss");
        this.togglePluginModule(true, "comments-rss");
    }

    private void getViewsOption() {
        this.getViewsOption("", null, null);
    }

    private void getViewsOption(String jql, String filterId, String modified) {
        this.exportsContent = this.backdoor.issueNavControl().getExportOptions(jql, filterId, modified);
    }

    public void assertTextPresentInExportsContent(String text) {
        Assert.assertTrue((boolean)this.exportsContent.contains(text));
    }

    public void assertTextNotPresentInExportsContent(String text) {
        Assert.assertFalse((boolean)this.exportsContent.contains(text));
    }

    private void assertViewsLinkPresent(String id) {
        this.assertTextPresentInExportsContent("\"" + id + "\"");
    }

    private void assertViewsLinkNotPresent(String id) {
        this.assertTextNotPresentInExportsContent("\"" + id + "\"");
    }

    private void togglePluginModule(boolean enable, String module) {
        if (enable) {
            this.administration.plugins().enablePluginModule("jira.issueviews", "jira.issueviews:searchrequest-" + module);
        } else {
            this.administration.plugins().disablePluginModule("jira.issueviews", "jira.issueviews:searchrequest-" + module);
        }
    }
}

