/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.FIELDS, Category.CUSTOM_FIELDS})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestLabelSuggestions
extends BaseJiraFuncTest {
    private static final String PROJECT_KEY = "HSP";
    private static final String UPPERCASE_LABEL = "Android";
    private static final String LOWERCASE_LABEL = "android";
    private static final String OTHER_LABEL = "other";
    private static final String LOWERCASE_PREFIX = "and";
    private static final String UPPERCASE_PREFIX = "And";
    private static final String EMPTY_SUGGESTIONS_RESPONSE = "\"suggestions\":[]";
    private static final String CUSTOM_LABEL_FIELD_NAME = "custom-label";
    private static final String CUSTOM_LABEL_FIELD_DESC = "Custom label field";
    private static final String DEFAULT_FIELD_SCREEN_NAME = "Default Screen";
    private static final String LABELS_TYPE_KEY = "com.atlassian.jira.plugin.system.customfieldtypes:labels";
    private static final String LABELS_SEARCHER_KEY = "com.atlassian.jira.plugin.system.customfieldtypes:labelsearcher";
    private static final String UPPERCASE_PREFIX_RESPONSE = "{\"label\":\"Android\",\"html\":\"<b>And</b>roid\"},{\"label\":\"android\",\"html\":\"<b>and</b>roid\"}";
    private static final String LOWERCASE_PREFIX_RESPONSE = "{\"label\":\"android\",\"html\":\"<b>and</b>roid\"},{\"label\":\"Android\",\"html\":\"<b>And</b>roid\"}";
    private static final String UPPERCASE_PREFIX_JQL_RESPONSE = "{\"value\":\"android\",\"displayName\":\"<b>and</b>roid\"},{\"value\":\"Android\",\"displayName\":\"<b>And</b>roid\"}";
    private static final String LOWERCASE_PREFIX_JQL_RESPONSE = "{\"value\":\"Android\",\"displayName\":\"<b>And</b>roid\"},{\"value\":\"android\",\"displayName\":\"<b>and</b>roid\"}";
    private IssueCreateResponse existingIssue;
    private IssueCreateResponse existingIssueWithCustomField;
    private Long customFieldId;

    @Before
    public void setUp() {
        this.existingIssue = this.createIssueWithLabels((Set<String>)ImmutableSet.of((Object)UPPERCASE_LABEL, (Object)LOWERCASE_LABEL), "Base test issue");
        this.customFieldId = this.createCustomField();
    }

    private Long createCustomField() {
        String customField = this.backdoor.customFields().createCustomField(CUSTOM_LABEL_FIELD_NAME, CUSTOM_LABEL_FIELD_DESC, LABELS_TYPE_KEY, LABELS_SEARCHER_KEY);
        this.backdoor.screens().addFieldToScreen(DEFAULT_FIELD_SCREEN_NAME, CUSTOM_LABEL_FIELD_NAME);
        return CustomFieldUtils.getCustomFieldId((String)customField);
    }

    private void createIssueWithCustomFields(Set<String> labelValues) {
        this.existingIssueWithCustomField = this.createIssueWithLabels(Collections.emptySet(), "Issue with custom fields");
        this.backdoor.issues().setIssueFields(this.existingIssueWithCustomField.key, new IssueFields().customField(this.customFieldId, labelValues));
    }

    @Test
    public void testLabelSuggestionsCaseSensitivity() {
        IssueCreateResponse newIssue = this.createIssueWithLabels((Set<String>)ImmutableSet.of((Object)OTHER_LABEL), "Case sensitivity test");
        this.tester.gotoPage(this.createSuggestionQueryUrl(newIssue, LOWERCASE_LABEL));
        this.tester.assertTextPresent(this.createLabelAssertionString(UPPERCASE_LABEL));
        this.tester.gotoPage(this.createSuggestionQueryUrl(newIssue, UPPERCASE_LABEL));
        this.tester.assertTextPresent(this.createLabelAssertionString(LOWERCASE_LABEL));
    }

    @Test
    public void testSkippingExisitingLabels() {
        this.tester.gotoPage(this.createSuggestionQueryUrl(this.existingIssue, OTHER_LABEL));
        this.tester.assertTextPresent(EMPTY_SUGGESTIONS_RESPONSE);
    }

    @Test
    public void testSuggestionsSortOrder() {
        IssueCreateResponse issue = this.createIssueWithLabels((Set<String>)ImmutableSet.of((Object)OTHER_LABEL), "Sort order test");
        this.tester.gotoPage(this.createSuggestionQueryUrl(issue, UPPERCASE_PREFIX));
        this.tester.assertTextPresent(UPPERCASE_PREFIX_RESPONSE);
        this.tester.gotoPage(this.createSuggestionQueryUrl(issue, LOWERCASE_PREFIX));
        this.tester.assertTextPresent(LOWERCASE_PREFIX_RESPONSE);
    }

    @Test
    public void testCustomFieldSuggestions() {
        this.createIssueWithCustomFields((Set<String>)ImmutableSet.of((Object)UPPERCASE_LABEL));
        this.tester.gotoPage(this.createCustomFieldSuggestionQueryUrl(this.existingIssueWithCustomField, LOWERCASE_LABEL));
        this.tester.assertTextPresent(this.createLabelAssertionString(UPPERCASE_LABEL));
        this.createIssueWithCustomFields((Set<String>)ImmutableSet.of((Object)LOWERCASE_LABEL));
        this.tester.gotoPage(this.createCustomFieldSuggestionQueryUrl(this.existingIssueWithCustomField, UPPERCASE_LABEL));
        this.tester.assertTextPresent(this.createLabelAssertionString(LOWERCASE_LABEL));
    }

    @Test
    public void testCustomFieldSuggestionsSortOrder() {
        this.createIssueWithCustomFields((Set<String>)ImmutableSet.of((Object)LOWERCASE_LABEL, (Object)UPPERCASE_LABEL));
        IssueCreateResponse issue = this.createIssueWithLabels(Collections.emptySet(), "Another issue with custom fields");
        this.backdoor.issues().setIssueFields(issue.key, new IssueFields().customField(this.customFieldId, (Object)ImmutableSet.of((Object)OTHER_LABEL)));
        this.tester.gotoPage(this.createCustomFieldSuggestionQueryUrl(issue, LOWERCASE_PREFIX));
        this.tester.assertTextPresent(LOWERCASE_PREFIX_RESPONSE);
        this.tester.gotoPage(this.createCustomFieldSuggestionQueryUrl(issue, UPPERCASE_PREFIX));
        this.tester.assertTextPresent(UPPERCASE_PREFIX_RESPONSE);
    }

    @Test
    public void testJqlLabelSuggestions() {
        this.tester.gotoPage(this.createJqlLabelsSuggestionUrl(LOWERCASE_PREFIX));
        this.tester.assertTextPresent(UPPERCASE_PREFIX_JQL_RESPONSE);
        this.tester.gotoPage(this.createJqlLabelsSuggestionUrl(UPPERCASE_PREFIX));
        this.tester.assertTextPresent(LOWERCASE_PREFIX_JQL_RESPONSE);
    }

    private IssueCreateResponse createIssueWithLabels(Set<String> labels, String summary) {
        IssueCreateResponse issue = this.backdoor.issues().createIssue(PROJECT_KEY, summary);
        labels.forEach(label -> this.backdoor.issues().addLabel(issue.key, label));
        return issue;
    }

    private String createLabelAssertionString(String uppercaseLabel) {
        return String.format("\"label\":\"%s\"", uppercaseLabel);
    }

    private String createSuggestionQueryUrl(IssueCreateResponse issue, String query) {
        return String.format("/rest/api/1.0/labels/%s/suggest?query=%s", issue.id, query);
    }

    private String createCustomFieldSuggestionQueryUrl(IssueCreateResponse issue, String query) {
        return String.format("/rest/api/1.0/labels/%s/suggest?customFieldId=10000&query=%s", issue.id, query);
    }

    private String createJqlLabelsSuggestionUrl(String query) {
        return String.format("/rest/api/2/jql/autocompletedata/suggestions?fieldName=labels&fieldValue=%s", query);
    }
}

